/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.test;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import org.xvolks.jnative.Convention;
import org.xvolks.jnative.JNative;
import org.xvolks.jnative.Type;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.logging.JNativeLogger;
import org.xvolks.jnative.misc.MSG;
import org.xvolks.jnative.misc.basicStructures.HWND;
import org.xvolks.jnative.pointers.NullPointer;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.MemoryBlockFactory;
import org.xvolks.jnative.pointers.memory.NativeMemoryBlock;
import org.xvolks.jnative.util.Kernel32;
import org.xvolks.jnative.util.User32;
import org.xvolks.test.KillProcess;
import org.xvolks.test.callbacks.TestCallback;
import org.xvolks.test.callbacks.linux.LinuxCallback;

public class JNativeTester {
    private static File searchFile(final String pattern, String root) {
        System.out.print("Searching " + pattern + " in " + root);
        for (File f : new File(root).listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return Pattern.matches(pattern, pathname.getName());
            }
        })) {
            if (!f.isFile()) continue;
            System.out.println("... found " + f);
            return f;
        }
        System.out.println("... Not found, sorry cannot demonstrate JNative with " + pattern);
        return null;
    }

    public static void main(String[] args) throws NativeException, IllegalAccessException, InterruptedException, IOException {
        System.getProperties().put("jnative.loadNative", "manual");
        JNativeTester.loadLib();
        if (System.getProperty("os.name").toLowerCase().indexOf("linux") != -1) {
            JNative.setDefaultCallingConvention(Convention.STDCALL);
            Pointer p_asm = new Pointer(MemoryBlockFactory.createMemoryBlock(16));
            int cpt = 0;
            cpt += p_asm.setByteAt(cpt, (byte)85);
            cpt += p_asm.setByteAt(cpt, (byte)84);
            cpt += p_asm.setIntAt(cpt, 203703437);
            cpt += p_asm.setByteAt(cpt, (byte)49);
            cpt += p_asm.setByteAt(cpt, (byte)-64);
            cpt += p_asm.setByteAt(cpt, (byte)102);
            cpt += p_asm.setByteAt(cpt, (byte)64);
            cpt += p_asm.setByteAt(cpt, (byte)92);
            cpt += p_asm.setByteAt(cpt, (byte)93);
            p_asm.setByteAt(cpt++, (byte)-61);
            JNative n_asm = new JNative(p_asm.getPointer(), Convention.STDCALL);
            n_asm.setRetVal(Type.INT);
            n_asm.invoke();
            System.err.println("n_asm returned : " + Integer.toString(n_asm.getRetValAsInt(), 16));
            System.err.println(System.getProperty("java.library.path"));
            JNative strcpy = new JNative("/lib/libc.so.6", "strcpy", false);
            strcpy.setRetVal(Type.INT);
            Pointer p = new Pointer(MemoryBlockFactory.createMemoryBlock(100));
            p.zeroMemory();
            p.setStringAt(0, "Toto was not here, but ");
            System.err.println("Before strcat");
            System.err.println("Get string from pointer p: " + p.getAsString());
            strcpy.setParameter(0, p);
            strcpy.setParameter(1, Type.STRING, "strcat was used from /lib/libc.so.6");
            strcpy.invoke();
            System.err.println("After strcat");
            System.err.println("Get string from pointer p : " + p.getAsString());
            JNative strcat = new JNative("/lib/libc.so.6", "strcat", false);
            strcat.setRetVal(Type.INT);
            Pointer p0 = new Pointer(MemoryBlockFactory.createMemoryBlock(100));
            p0.zeroMemory();
            p0.setStringAt(0, "Toto was not here, but ");
            System.err.println("Before strcat");
            System.err.println("Get string from pointer p: " + p0.getAsString());
            strcat.setParameter(0, p0);
            strcat.setParameter(1, Type.STRING, "strcat was used from /lib/libc.so.6");
            strcat.invoke();
            System.err.println("After strcat");
            System.err.println("Get string from pointer p : " + p0.getAsString());
            File f = JNativeTester.searchFile("libglib-.*", "/usr/lib");
            if (f == null) {
                System.err.println("Cannot demonstrate glib");
            } else {
                JNative b = new JNative(f.getCanonicalPath(), "g_random_int_range", false);
                b.setRetVal(Type.INT);
                b.setParameter(0, 0);
                b.setParameter(1, 255);
                b.invoke();
                System.err.println("Random number from g_random_int in /usr/lib/libglib-2.0.so: " + b.getRetVal());
                b.dispose();
            }
            f = JNativeTester.searchFile("libparted.*", "/usr/lib");
            if (f == null) {
                f = JNativeTester.searchFile("libparted.*", "/lib");
            }
            JNative ped_device_get = new JNative(f.toString(), "ped_device_get");
            ped_device_get.setRetVal(Type.INT);
            ped_device_get.setParameter(0, Type.STRING, "/dev/hda");
            ped_device_get.invoke();
            Pointer devicePointer = new Pointer(new NativeMemoryBlock(ped_device_get.getRetValAsInt(), 76));
            System.err.format("DevicePointer = %x\n", devicePointer.getPointer());
            if (devicePointer.getPointer() != 0) {
                JNative ped_device_open = new JNative(f.toString(), "ped_device_open");
                ped_device_open.setRetVal(Type.INT);
                ped_device_open.setParameter(0, devicePointer);
                ped_device_open.invoke();
                int ret = ped_device_open.getRetValAsInt();
                if (ret != 0) {
                    System.err.println(JNative.getMemoryAsString(devicePointer.getAsInt(4), 64));
                    JNativeTester.MessageBoxGnome("Your /dev/hda is " + JNative.getMemoryAsString(devicePointer.getAsInt(4), 64), "info", new String[]{"Welcome to JNative", "Ok"});
                    JNative ped_device_close = new JNative(f.toString(), "ped_device_close");
                    ped_device_close.setRetVal(Type.INT);
                    ped_device_close.setParameter(0, devicePointer);
                    ped_device_close.invoke();
                } else {
                    System.err.println("Can't open device!");
                }
            }
            f = JNativeTester.searchFile("libglib-.*", "/usr/lib");
            int numThreads = 10;
            class Inline
            extends Thread {
                final File f;

                public Inline(File f, int id) {
                    this.f = f;
                    this.setName("Inline " + id);
                }

                public void run() {
                    try {
                        JNative b = new JNative(this.f.getCanonicalPath(), "g_random_int_range", false);
                        b.setRetVal(Type.INT);
                        b.setParameter(0, 0);
                        b.setParameter(1, 255);
                        for (int i = 0; i < 1000; ++i) {
                            b.invoke();
                            System.err.println(Thread.currentThread().getName() + " : Random number from g_random_int in /usr/lib/libglib-2.0.so: " + b.getRetVal());
                            Inline.yield();
                        }
                        b.dispose();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            ArrayList<Inline> threads = new ArrayList<Inline>();
            for (int i = 0; i < numThreads; ++i) {
                threads.add(new Inline(f, i));
            }
            LinuxCallback.runit();
        } else if (System.getProperty("os.name").toLowerCase().indexOf("windows") != -1) {
            User32.MessageBox(0, "Demonstrates JNative in action with many Win32 calls", "Welcome to JNative", 0);
            User32.MessageBox(0, "Demarrage de la calculatrice,\nATTENTION : ne cliquez pas sur OK\nsi vous avez ouvert la calculatrice\navec des donnees non sauvegardees : elles seraient perdues", "Tuer un precessus par son nom", 0);
            User32.MessageBox(0, "Starting calculator,\nCAUTION : DO NOT click OK\nif you have calc open\nwith unsaved data : they will be lost", "Kill a process by name", 0);
            try {
                Runtime.getRuntime().exec("calc.exe");
                Runtime.getRuntime().exec("calc.exe");
                Runtime.getRuntime().exec("calc.exe");
                Runtime.getRuntime().exec("calc.exe");
                Thread.sleep(3000L);
                if (0 != new KillProcess("calc.exe", true).killProcess()) {
                    User32.MessageBox(0, "Process not found", "Error", 0);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                User32.MessageBox(0, e.getMessage(), "Error launching notepad", 0);
            }
            Pointer p = new Pointer(MemoryBlockFactory.createMemoryBlock(500));
            p.setStringAt(0, "This is a test");
            System.err.println("Serching in >" + p.getAsString() + "<");
            System.err.println("Java    found test at offset " + p.getAsString().indexOf("test"));
            System.err.println("JNative found test at offset " + JNative.searchNativePattern(p, "test".getBytes(), 500));
            if (JNative.searchNativePattern(p, "toto".getBytes(), 50) < 0) {
                System.err.println("toto not found");
            }
            try {
                User32.MessageBox(0, Kernel32.GlobalMemoryStatusEx().toString(), "GlobalMemoryStatusEx", 0);
                System.out.println();
                String[] ss = JNative.getDLLFileExports(System.getenv("WINDIR") + "\\system32\\user32.dll");
                String me = "";
                for (String s : ss) {
                    if (s.toLowerCase().indexOf("proc") == -1) continue;
                    me = me + s + "\n";
                }
                User32.MessageBox(0, me, "Exported functions of User32.dll containing the word proc", 0);
                try {
                    for (String s : ss = JNative.getDLLFileExports("c:/windows/twain_32.dll")) {
                        System.err.println(s);
                    }
                }
                catch (NativeException e) {
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                User32.MessageBox(0, "Error #" + Kernel32.GetLastError(), "GlobalMemoryStatusEx failed", 0);
            }
            System.err.println(User32.MessageBox(0, Kernel32.GetDiskFreeSpaceEx("c:").toString(), "Free space on " + Kernel32.GetComputerName(), 51));
            System.err.println("Module : " + JNative.getCurrentModule());
            HWND hwnd = new HWND(User32.CreateWindowEx(0, "Button", "TATA", 0xCF0000, 20, 30, 200, 300, 0, 0, JNative.getCurrentModule(), 0));
            User32.ShowWindow(hwnd, 5);
            User32.UpdateWindow(hwnd);
            MSG msg = new MSG();
            boolean lQuit = false;
            while (!lQuit) {
                switch (User32.GetMessage(msg, hwnd, 0, 0)) {
                    case -1: {
                        System.err.println("Error occured");
                        lQuit = true;
                        break;
                    }
                    case 0: {
                        System.err.println("WM_QUIT received");
                        lQuit = true;
                        break;
                    }
                }
                User32.TranslateMessage(msg);
                User32.DispatchMessage(msg);
            }
            System.err.println(hwnd.getValue());
            System.err.println(Kernel32.GetLastError());
            Thread.sleep(6000L);
            try {
                TestCallback.runIt();
            }
            catch (Exception e) {
                User32.MessageBox(0, e.toString(), e.getClass().getName(), 0);
            }
        }
        System.exit(0);
    }

    public static void loadLib() throws IOException {
        File f;
        if (JNative.isLinux()) {
            f = new File("libJNativeCpp.so");
        } else if (JNative.isWindows()) {
            f = new File("JNativeCpp.dll");
        } else {
            throw new IllegalStateException("This OS is acctually not supported, please contact jnative@free.fr if you want it supported!");
        }
        if (f.exists()) {
            JNative.getLogger().log(JNativeLogger.SEVERITY.INFO, "Loading native lib " + f.getAbsolutePath());
            System.load(f.getCanonicalPath());
        } else {
            JFileChooser jfc = new JFileChooser(new File("."));
            jfc.addChoosableFileFilter(new javax.swing.filechooser.FileFilter(){

                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().toLowerCase().endsWith(JNative.isWindows() ? ".dll" : ".so");
                }

                public String getDescription() {
                    return JNative.isWindows() ? "DLL : Dynamic Link Library" : " .so : Shared library";
                }
            });
            if (0 == jfc.showOpenDialog(null)) {
                JNative.getLogger().log(JNativeLogger.SEVERITY.INFO, "Loading native lib " + jfc.getSelectedFile().getCanonicalPath());
                System.load(jfc.getSelectedFile().getCanonicalPath());
            } else {
                return;
            }
        }
    }

    private static void MessageBoxGnome(String text, String type, String[] buttons) throws NativeException, IllegalAccessException {
        JNative MessageBox = new JNative("/usr/lib/libgnomeui-2.so.0", "gnome_message_box_new");
        MessageBox.setRetVal(Type.INT);
        MessageBox.setParameter(0, text);
        MessageBox.setParameter(1, type);
        int i = 2;
        for (String button : buttons) {
            MessageBox.setParameter(i++, button);
        }
        MessageBox.setParameter(i, NullPointer.NULL);
        MessageBox.invoke();
        int gtkWidget = MessageBox.getRetValAsInt();
        JNative gtk_widget_show = new JNative("/usr/lib/libgnomeui-2.so.0", "gtk_widget_show");
        gtk_widget_show.setParameter(0, gtkWidget);
        gtk_widget_show.invoke();
        MessageBox.dispose();
        gtk_widget_show.dispose();
    }
}

