/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.test.windows.trayicon;

import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import org.xvolks.jnative.JNative;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.POINT;
import org.xvolks.jnative.util.Callback;
import org.xvolks.jnative.util.User32;
import org.xvolks.jnative.util.constants.winuser.WM;
import org.xvolks.test.windows.trayicon.TrayIcon;

public class TrayIconCallback
implements Callback {
    private int myAddress = -1;
    private TrayIcon owner;
    private POINT lpPoint = null;
    private int WM_TASKBAR_CREATED = 0;

    private TrayIconCallback() {
    }

    public TrayIconCallback(TrayIcon owner) {
        this.owner = owner;
        try {
            this.lpPoint = new POINT();
            this.WM_TASKBAR_CREATED = User32.RegisterWindowMessage("TaskbarCreated");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int callback(long[] values) {
        if (values != null && values.length == 4 && (Integer)this.owner.getHwnd().getValue() == (int)values[0]) {
            try {
                int message = (int)values[1];
                int wParam = (int)values[2];
                int lParam = (int)values[3];
                if (message == this.WM_TASKBAR_CREATED) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            try {
                                TrayIconCallback.this.owner.setVisible(true);
                            }
                            catch (Throwable ex) {
                                ex.printStackTrace();
                            }
                        }
                    });
                } else if (message != WM.WM_COMMAND.getValue()) {
                    if (message == WM.WM_ACTIVATEAPP.getValue()) {
                        if (wParam == 0 && this.owner.isMenuVisible()) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    TrayIconCallback.this.owner.setMenuVisible(false, 0, 0);
                                }
                            });
                        }
                    } else if (message == this.owner.getCallbackMsg()) {
                        if (lParam == WM.WM_LBUTTONUP.getValue()) {
                            if (this.owner.hasMouseListener() && User32.GetCursorPos(this.lpPoint)) {
                                final int x = this.lpPoint.getX();
                                final int y = this.lpPoint.getY();
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        TrayIconCallback.this.owner.getMouseListener().mouseClicked(new MouseEvent(TrayIconCallback.this.owner.getMsgWindow(), 500, System.currentTimeMillis(), 16, x, y, 1, false));
                                    }
                                });
                            }
                        } else if (lParam == WM.WM_RBUTTONUP.getValue()) {
                            if (this.owner.hasMouseListener() && User32.GetCursorPos(this.lpPoint)) {
                                final int x = this.lpPoint.getX();
                                final int y = this.lpPoint.getY();
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        TrayIconCallback.this.owner.getMouseListener().mouseClicked(new MouseEvent(TrayIconCallback.this.owner.getMsgWindow(), 500, System.currentTimeMillis(), 4, x, y, 1, true));
                                    }
                                });
                            }
                        } else if (lParam == WM.WM_LBUTTONDBLCLK.getValue()) {
                            if (this.owner.hasMouseListener() && User32.GetCursorPos(this.lpPoint)) {
                                final int x = this.lpPoint.getX();
                                final int y = this.lpPoint.getY();
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        TrayIconCallback.this.owner.getMouseListener().mouseClicked(new MouseEvent(TrayIconCallback.this.owner.getMsgWindow(), 500, System.currentTimeMillis(), 16, x, y, 2, false));
                                    }
                                });
                            }
                        } else if (lParam == WM.WM_RBUTTONDBLCLK.getValue()) {
                            if (this.owner.hasMouseListener() && User32.GetCursorPos(this.lpPoint)) {
                                final int x = this.lpPoint.getX();
                                final int y = this.lpPoint.getY();
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        TrayIconCallback.this.owner.getMouseListener().mouseClicked(new MouseEvent(TrayIconCallback.this.owner.getMsgWindow(), 500, System.currentTimeMillis(), 4, x, y, 2, false));
                                    }
                                });
                            }
                        } else if (lParam == 1026) {
                            if (this.owner.hasBallonTooltipListener()) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        TrayIconCallback.this.owner.getBallonTooltipListener().balloonShow(TrayIconCallback.this.owner);
                                    }
                                });
                            }
                        } else if (lParam == 1029) {
                            if (this.owner.hasBallonTooltipListener()) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        TrayIconCallback.this.owner.getBallonTooltipListener().balloonClick(TrayIconCallback.this.owner);
                                    }
                                });
                            }
                        } else if (lParam == 1027) {
                            if (this.owner.hasBallonTooltipListener()) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        TrayIconCallback.this.owner.getBallonTooltipListener().balloonHide(TrayIconCallback.this.owner);
                                    }
                                });
                            }
                        } else if (lParam == 1028 && this.owner.hasBallonTooltipListener()) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    TrayIconCallback.this.owner.getBallonTooltipListener().balloonClose(TrayIconCallback.this.owner);
                                }
                            });
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            return User32.CallWindowProc(this.owner.getPrevWindowProc(), (int)values[0], (int)values[1], (int)values[2], (int)values[3]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int getCallbackAddress() throws NativeException {
        if (this.myAddress == -1) {
            this.myAddress = JNative.createCallback(4, this);
        }
        return this.myAddress;
    }
}

