/*
 * Decompiled with CFR 0.152.
 */
package com.zk.util;

import com.zk.conn.Conn;
import com.zk.util.ConfigFile;
import com.zk.util.EncrypAESUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URI;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;

public class BaseDBBackupUtil {
    private static String type;
    private static String host;
    private static String port;
    private static String db_name;
    private static String db_user;
    private static String db_pass;
    private static String backupName;
    private static String backupPath;
    public static String PATH_NOT_FIND_TIP;
    public static final int SYS_PATH_NOT_FIND = -1;
    public static final int BACKUP_PATH_NOT_FIND = -2;
    public static final int BACKUP_FILE_NOT_FIND = -3;
    public static final int BACKUP_FILE_WRITE_ERROR = -4;
    public static final int BACKUP_ERROR = -5;
    private static final String MYSQL = "mysql";
    private static final String SQLSERVER = "sqlserver";
    private static final String ORACLE = "oracle";
    private static StringBuilder logSb;

    static {
        PATH_NOT_FIND_TIP = "";
        logSb = null;
        String dbparam = "database_";
        String iniType = ConfigFile.getValue(0, "options", "dbtype");
        if (iniType.equals(MYSQL)) {
            dbparam = String.valueOf(dbparam) + MYSQL;
            type = MYSQL;
        } else if (iniType.equals(SQLSERVER)) {
            dbparam = String.valueOf(dbparam) + SQLSERVER;
            type = SQLSERVER;
        } else if (iniType.equals(ORACLE)) {
            dbparam = String.valueOf(dbparam) + ORACLE;
            type = ORACLE;
        }
        db_user = ConfigFile.getValue(0, dbparam, "user");
        db_pass = ConfigFile.getValue(0, dbparam, "password");
        host = ConfigFile.getValue(0, dbparam, "host");
        port = ConfigFile.getValue(0, dbparam, "port");
        db_name = ConfigFile.getValue(0, dbparam, "name");
    }

    private static boolean isSystemEvnExist() {
        String systemPath = "";
        Map<String, String> systemEnv = System.getenv();
        for (Map.Entry<String, String> entry : systemEnv.entrySet()) {
            if (!entry.getKey().toLowerCase().equals("path")) continue;
            systemPath = entry.getValue();
            break;
        }
        boolean result = false;
        if (systemPath != null && !"".equals(systemPath)) {
            String[] stringArray = systemPath.split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file;
                File file2;
                File file1;
                String str = stringArray[n2];
                if (type.equals(MYSQL) && str.toLowerCase().contains("\\bin")) {
                    file1 = new File(String.valueOf(str) + "\\mysql.exe");
                    file2 = new File(String.valueOf(str) + "\\mysqldump.exe");
                    if (file1.exists() && file2.exists()) {
                        result = true;
                        break;
                    }
                }
                if (type.equals(SQLSERVER) && str.toLowerCase().contains("tools\\binn") && (file = new File(String.valueOf(str) + "\\SQLCMD.EXE")).exists()) {
                    result = true;
                    break;
                }
                if (type.equals(ORACLE) && str.toLowerCase().contains("\\bin")) {
                    file1 = new File(String.valueOf(str) + "\\impdp.exe");
                    file2 = new File(String.valueOf(str) + "\\expdp.exe");
                    if (file1.exists() && file2.exists()) {
                        result = true;
                        break;
                    }
                }
                ++n2;
            }
        }
        return systemPath != null && result;
    }

    public static boolean dbReduction(String backupName) throws Exception {
        try {
            logSb = new StringBuilder();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            logSb.append("\n").append(sdf.format(new Date()));
            if (type.equals(MYSQL)) {
                boolean bl = BaseDBBackupUtil.restoreMySql(host, port, db_user, db_pass, db_name, "", backupName);
                return bl;
            }
            if (type.equals(SQLSERVER)) {
                boolean bl = BaseDBBackupUtil.restroeSQLServer(host, port, db_user, db_pass, db_name, "", backupName);
                return bl;
            }
            if (type.equals(ORACLE)) {
                boolean bl = BaseDBBackupUtil.restroeOracle(db_user, db_pass, db_name, "", backupName);
                return bl;
            }
            return false;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            BaseDBBackupUtil.writeLog(logSb.toString());
        }
    }

    public static int dbBackup() throws Exception {
        try {
            logSb = new StringBuilder();
            if (!BaseDBBackupUtil.isSystemEvnExist()) {
                return -1;
            }
            backupPath = BaseDBBackupUtil.getPath();
            if (backupPath == null) {
                return -2;
            }
            String separatorChar = File.separator;
            if (!backupPath.endsWith(separatorChar)) {
                backupPath = String.valueOf(backupPath) + separatorChar;
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            logSb.append("\n").append(sdf.format(new Date()));
            String sysVersion = BaseDBBackupUtil.getSystemVersion();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            backupName = "db_" + simpleDateFormat.format(new Date()) + "_restore";
            if (type.equals(MYSQL)) {
                backupName = String.valueOf(backupName) + ".sql";
                String tempName = BaseDBBackupUtil.setPathAndName(String.valueOf(backupPath) + backupName);
                if (!BaseDBBackupUtil.backupMysql(host, port, db_user, db_pass, db_name, tempName)) {
                    return -5;
                }
            } else if (type.equals(SQLSERVER)) {
                backupName = String.valueOf(backupName) + ".bak";
                String tempName = BaseDBBackupUtil.setPathAndName(String.valueOf(backupPath) + backupName);
                if (!BaseDBBackupUtil.backupSqlServer(host, db_user, db_pass, db_name, tempName)) {
                    return -5;
                }
            } else if (type.equals(ORACLE)) {
                backupName = String.valueOf(backupName) + "_" + sysVersion;
                if (!BaseDBBackupUtil.backupOracle(db_user, db_pass, db_name, backupPath, backupName = String.valueOf(backupName) + ".dmp")) {
                    return -5;
                }
            }
            if (!type.equals(ORACLE)) {
                int n = BaseDBBackupUtil.storeVersion(sysVersion);
                return n;
            }
            return 1;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            BaseDBBackupUtil.writeLog(logSb.toString());
        }
    }

    public static String setPathAndName(String str) {
        String result = str;
        if (result.contains(" ")) {
            result = "\"" + result + "\"";
        }
        return result;
    }

    private static boolean backupMysql(String host, String port, String dbUser, String dbPass, String dbName, String pathAndName) {
        String cmd = "mysqldump -h" + host + " -P" + port + " -u" + dbUser + " -p" + dbPass + " " + dbName + " > " + pathAndName;
        logSb.append(" [").append(cmd).append("] ");
        try {
            Process p = Runtime.getRuntime().exec("cmd /c " + cmd);
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                logSb.append(line).append("\n");
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean backupSqlServer(String host, String dbUser, String dbPass, String dbName, String pathAndName) {
        String cmd = "sqlcmd -S " + host + " -U " + dbUser + " -P " + dbPass + " -Q \"backup database [" + dbName + "] to disk='" + pathAndName + "'\"";
        logSb.append(" [").append(cmd).append("] ");
        try {
            Process p = Runtime.getRuntime().exec("cmd /c " + cmd);
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                logSb.append(line).append("\n");
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static boolean backupOracle(String dbUser, String dbPass, String dbName, String path, String name) throws Exception {
        try {
            Conn con = new Conn(type);
            Connection conn = Conn.getConn("0", "");
            Statement statement = conn.createStatement();
            statement.execute("create or replace directory directory_inbio as '" + path + "'");
            String logName = name.replaceAll(".dmp", ".log");
            Runtime rt = Runtime.getRuntime();
            String temp = "expdp " + dbUser + "/" + dbPass + "@" + dbName + " schemas=" + dbUser + " dumpfile=" + name + " logfile=" + logName + " directory=directory_inbio";
            logSb.append(" [").append(temp).append("] ");
            Process p = rt.exec("cmd /c " + temp);
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                logSb.append(line).append("\n");
            }
            reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = reader.readLine()) != null) {
                logSb.append(line).append("\n");
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
        finally {
            Conn.close();
        }
    }

    public static int storeVersion(String versionValue) {
        if (versionValue == null || "".equals(versionValue)) {
            return 1;
        }
        String path = String.valueOf(backupPath) + backupName;
        File file = new File(path);
        if (path.contains(" ")) {
            URI uri = file.toURI();
            file = new File(uri);
        }
        int sleepCount = 0;
        while (!file.exists()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (++sleepCount > 5) break;
        }
        if (!file.exists()) {
            return -3;
        }
        boolean state = false;
        while (!state) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            state = file.renameTo(file);
        }
        String versionInfo = "-- Database version   " + versionValue;
        String addInfo = "\n" + versionInfo;
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(path, true);
            OutputStreamWriter osw = new OutputStreamWriter(os);
            osw.write(addInfo);
            osw.close();
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -4;
        }
    }

    public static final String getSystemVersion() {
        try {
            String result = "";
            String sql = "select * from base_sysparam where param_name='databaseVersion'";
            String type = ConfigFile.getValue(0, "options", "dbtype");
            Conn con = new Conn(type);
            Connection conn = Conn.getConn("0", "");
            Statement stateMent = conn.createStatement();
            ResultSet resultSet = stateMent.executeQuery(sql);
            if (resultSet.next()) {
                result = resultSet.getString("param_value");
            }
            if (result != null && !"".equals(result)) {
                result = EncrypAESUtil.decryptToString(result);
            }
            String string = result;
            return string;
        }
        catch (Exception exception) {
        }
        finally {
            Conn.close();
        }
        return null;
    }

    private static boolean restoreMySql(String HOST, String PORT, String DB_USER, String DB_PASS, String DB_NAME, String DB_BACKUP_PATH, String BACKUP_NAME) {
        try {
            Runtime rt = Runtime.getRuntime();
            String mysql = "mysql -h" + HOST + " -P" + PORT + " -u" + DB_USER + " -p" + DB_PASS + " " + DB_NAME + " < " + DB_BACKUP_PATH + BACKUP_NAME;
            logSb.append(" [").append(mysql).append("] ");
            Process p = rt.exec("cmd /c " + mysql);
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                logSb.append(line).append("\n");
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean restroeSQLServer(String HOST, String PORT, String DB_USER, String DB_PASS, String DB_NAME, String DB_BACKUP_PATH, String BACKUP_NAME) {
        String cmd = "sqlcmd -S " + HOST + "," + PORT + " -U " + DB_USER + " -P " + DB_PASS + " -Q \"alter database " + DB_NAME + " set offline with rollback immediate;" + "restore database [" + DB_NAME + "] from disk='" + DB_BACKUP_PATH + BACKUP_NAME + "' with replace;" + "alter database " + DB_NAME + " set online;\"";
        logSb.append(" [").append(cmd).append("] ");
        try {
            Runtime rt = Runtime.getRuntime();
            Process p = rt.exec("cmd.exe /c " + cmd);
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                logSb.append(line).append("\n");
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean restroeOracle(String db_user, String db_pass, String db_name, String db_backup_path, String backup_name) throws SQLException {
        try {
            Conn con = new Conn(type);
            Connection conn = Conn.getConn("0", "");
            String path = backup_name.substring(0, backup_name.lastIndexOf("\\"));
            String name = backup_name.substring(backup_name.lastIndexOf("\\") + 1);
            Statement statement = conn.createStatement();
            statement.execute("create or replace directory directory_inbio as '" + path + "'");
            Runtime rt = Runtime.getRuntime();
            String temp = "impdp " + db_user + "/" + db_pass + "@" + db_name + " dumpfile=" + name + " directory=directory_inbio TABLE_EXISTS_ACTION=REPLACE schemas=" + db_user;
            logSb.append(" [").append(temp).append("] ");
            Process p = rt.exec("cmd /c " + temp);
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                logSb.append(line).append("\n");
            }
            reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = reader.readLine()) != null) {
                logSb.append(line).append("\n");
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        finally {
            Conn.close();
        }
    }

    private static String getPath() {
        String path = ConfigFile.getValue(0, "Options", "backup_path");
        return path;
    }

    private static void writeLog(String content) {
        try {
            File restoreFile = new File("..//Config//restore.log");
            if (!restoreFile.exists()) {
                restoreFile.createNewFile();
            }
            if (restoreFile.length() >= 1000000L) {
                File restoreFile1 = new File("..//Config//restore1.log");
                if (restoreFile1.exists()) {
                    restoreFile1.delete();
                }
                restoreFile.renameTo(restoreFile1);
                restoreFile.createNewFile();
            }
            FileOutputStream os = null;
            os = new FileOutputStream(restoreFile, true);
            OutputStreamWriter osw = new OutputStreamWriter(os);
            osw.write(content);
            osw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isServer() {
        try {
            String dbIPStr = host;
            if (dbIPStr.contains("localhost") || dbIPStr.contains("127.0.0.1")) {
                return true;
            }
            ArrayList<String> ips = new ArrayList<String>();
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress ip = null;
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface ni = netInterfaces.nextElement();
                Enumeration<InetAddress> address = ni.getInetAddresses();
                while (address.hasMoreElements()) {
                    ip = address.nextElement();
                    ips.add(ip.getHostAddress());
                }
            }
            for (String s : ips) {
                if (!dbIPStr.contains(s)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void main(String[] args) {
    }
}

