/*
 * Decompiled with CFR 0.152.
 */
package com.zk.util;

import com.zk.util.ConfigFile;
import com.zk.util.ReplaceChar;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;

public class CheckProperties
extends ArrayList {
    private static final long serialVersionUID = -7984472357161300236L;
    private static String code = "UTF-8";
    private String fileName;

    public static void main(String[] args) throws Exception {
    }

    public static void updateValue(String path) {
        String[] strv = new String[2];
        String[] strn = new String[2];
        CheckProperties proper = new CheckProperties(path, code);
        strv[0] = proper.getValue("shiro.casService", path);
        strv[1] = proper.getValue("esb.port", path);
        strn[0] = "shiro.casService";
        strn[1] = "esb.port";
        int i = 0;
        while (i < strv.length) {
            strv[i] = ReplaceChar.replace(strv[i], ConfigFile.getValue(0, "options", "port_old"), ConfigFile.getValue(0, "options", "port"));
            proper.setProperties(strn[i], strv[i]);
            ++i;
        }
        try {
            proper.saveFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void updateDB(String path, String dbtype, String host, String dbName, String port, String uname, String pwd) {
        String ipAddr;
        CheckProperties proper = new CheckProperties(path, code);
        String[] strn = new String[7];
        String[] strv = new String[7];
        strn[0] = "datasource.driverClassName";
        strn[1] = "datasource.url";
        strn[2] = "hibernate.dialect";
        strn[3] = "datasource.username";
        strn[4] = "datasource.password";
        strn[5] = "hibernate.hbm2ddl.auto";
        strn[6] = "system.alreadyInitData";
        strv[0] = proper.getValue("datasource.driverClassName", path);
        strv[1] = proper.getValue("datasource.url", path);
        strv[2] = proper.getValue("hibernate.dialect", path);
        strv[3] = proper.getValue("datasource.username", path);
        strv[4] = proper.getValue("datasource.password", path);
        strv[5] = "update";
        strv[6] = "false";
        StringBuilder temp = new StringBuilder();
        if (dbtype.equalsIgnoreCase("database_mysql")) {
            strv[0] = "com.mysql.jdbc.Driver";
            ipAddr = host.equals("localhost") ? "127.0.0.1" : host;
            temp.append("jdbc:mysql://");
            temp.append(ipAddr).append(":");
            temp.append(port).append("/");
            temp.append(dbName).append("?useUnicode=true&characterEncoding=utf-8&useFastDateParsing=false&autoReconnect=true");
            strv[1] = temp.toString();
            strv[2] = "org.hibernate.dialect.MySQL5InnoDBDialect";
            strv[3] = uname;
            strv[4] = pwd;
        } else if (dbtype.equalsIgnoreCase("database_sqlserver")) {
            strv[0] = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
            ipAddr = host.equals("localhost") ? "127.0.0.1" : host;
            temp.append("jdbc:sqlserver://");
            temp.append(ipAddr).append(":");
            temp.append(port).append(";DatabaseName=");
            temp.append(dbName).append(";useLOBs=false");
            strv[1] = temp.toString();
            strv[2] = "com.zk.common.util.SqlServerDialect";
            strv[3] = uname;
            strv[4] = pwd;
        } else if (dbtype.equalsIgnoreCase("database_oracle")) {
            strv[0] = "oracle.jdbc.driver.OracleDriver";
            ipAddr = host.equals("localhost") ? "127.0.0.1" : host;
            temp.append("jdbc:oracle:thin:@");
            temp.append(ipAddr).append(":");
            temp.append(port).append(":");
            temp.append(dbName);
            strv[1] = temp.toString();
            strv[2] = "org.hibernate.dialect.OracleDialect";
            strv[3] = uname;
            strv[4] = pwd;
        }
        int i = 0;
        while (i < strv.length) {
            proper.setProperties(strn[i], strv[i]);
            ++i;
        }
        try {
            proper.saveFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    private void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public CheckProperties(String fileName, String code) {
        try {
            this.setFileName(fileName);
            this.setCharacterEncoding(code);
            if (!CheckProperties.isExist(fileName)) {
                this.writeFile("");
            }
            this.addAll(Arrays.asList(CheckProperties.readFile(fileName, code).split("\n")));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void setCharacterEncoding(String code) throws UnsupportedEncodingException {
        new String("".getBytes("iso8859_1"), code);
        CheckProperties.code = code;
    }

    public static boolean isExist(String fileName) {
        return new File(fileName).isFile();
    }

    public static String readFile(String fileName, String code) throws IOException {
        StringBuffer sb = new StringBuffer();
        BufferedReader in = new BufferedReader(new FileReader(fileName));
        String str = null;
        while ((str = in.readLine()) != null) {
            sb.append(str);
            sb.append("\n");
        }
        in.close();
        return sb.toString();
    }

    public void writeFile(String proper) throws IOException {
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(this.fileName)));
        out.print(proper);
        out.close();
    }

    public void saveFile() throws IOException {
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(this.fileName)));
        int i = 0;
        while (i < this.size()) {
            String tmp = "" + this.get(i);
            out.println(tmp);
            ++i;
        }
        out.close();
    }

    public void setProperties(String key, String val) {
        int pro = this.lookForKey(key);
        if (pro >= 0) {
            this.set(pro, String.valueOf(key) + "=" + val);
        } else {
            this.add(String.valueOf(key) + "=" + val);
        }
    }

    public int lookForKey(String key) {
        try {
            int i = 0;
            while (i < this.size()) {
                String temp = "" + this.get(i);
                if ((temp = new String(temp.getBytes("iso8859_1"), code)).indexOf(key) == 0) {
                    return i;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return -1;
    }

    public void setNotes(String key, String memo) {
        if ("".equals(key)) {
            this.add("#" + memo);
            return;
        }
        String temp = null;
        int result = this.lookForKey(key);
        if (result == -1) {
            this.add("#" + memo);
            this.add(String.valueOf(key) + "=");
        } else {
            int position = result - 1;
            if (position < 0) {
                this.add(position, "#" + memo);
            } else {
                temp = this.get(position) + " ";
                if ("#".equals(temp.substring(0, 1))) {
                    this.set(position, "#" + memo);
                } else {
                    this.add(position + 1, "#" + memo);
                }
            }
        }
    }

    public void setTitle(String title) {
        String tmp = "" + this.get(0);
        tmp = tmp == null || tmp.length() == 0 ? "" : tmp.substring(0, 1);
        if ("#".equals(tmp)) {
            this.set(0, "#" + title);
        } else {
            this.add(0, "");
            this.add(0, "#" + title);
        }
    }

    public String getProperties(String key) {
        return this.getProperties(key, "");
    }

    public String getProperties(String key, String defaultStr) {
        String temp = null;
        String result = null;
        try {
            int i = 0;
            while (i < this.size()) {
                temp = "" + this.get(i);
                if ((temp = new String(temp.getBytes("iso8859_1"), code)).indexOf(key) == 0) {
                    result = temp.substring(key.length() + 1);
                    return result;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return defaultStr;
    }

    public String getValue(String str, String path) {
        String temp = "";
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(path));
            Properties p = new Properties();
            p.load(in);
            String s = (String)p.get(str);
            if (s != null) {
                temp = new String(s.getBytes("iso8859_1"), code);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return temp;
    }
}

