/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.misc.registry;

import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.basicStructures.LONG;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.MemoryBlockFactory;

public abstract class BasicRegData {
    private int errorCode = -1;
    private Pointer lpData;
    private LONG lpcbData;

    protected BasicRegData(int sizeData) throws NativeException {
        if (sizeData < 4) {
            sizeData = 4;
        }
        this.lpcbData = new LONG(sizeData);
        this.lpData = new Pointer(MemoryBlockFactory.createMemoryBlock(sizeData));
    }

    public LONG getLpcbData() {
        return this.lpcbData;
    }

    public Pointer getLpData() {
        return this.lpData;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public String toString() {
        try {
            return "lpData : " + this.lpData.getAsString() + "\n" + "lpcbData : " + this.lpcbData.getValue() + "\n";
        }
        catch (NativeException e) {
            e.printStackTrace();
            return e.toString();
        }
    }
}

