/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.peer.ComponentPeer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.ListIterator;
import sun.awt.DisplayChangedListener;
import sun.awt.Win32GraphicsDevice;
import sun.awt.windows.WToolkit;
import sun.java2d.SunGraphicsEnvironment;
import sun.java2d.SurfaceManagerFactory;
import sun.java2d.WindowsSurfaceManagerFactory;
import sun.java2d.d3d.D3DGraphicsDevice;
import sun.java2d.windows.WindowsFlags;

public class Win32GraphicsEnvironment
extends SunGraphicsEnvironment {
    private static boolean displayInitialized;
    private ArrayList<WeakReference<Win32GraphicsDevice>> oldDevices;
    private static volatile boolean isDWMCompositionEnabled;

    private static native void initDisplay();

    public static void initDisplayWrapper() {
        if (!displayInitialized) {
            displayInitialized = true;
            Win32GraphicsEnvironment.initDisplay();
        }
    }

    @Override
    protected native int getNumScreens();

    protected native int getDefaultScreen();

    @Override
    public GraphicsDevice getDefaultScreenDevice() {
        return this.getScreenDevices()[this.getDefaultScreen()];
    }

    public native int getXResolution();

    public native int getYResolution();

    @Override
    public void displayChanged() {
        int n;
        GraphicsDevice[] graphicsDeviceArray = new GraphicsDevice[this.getNumScreens()];
        GraphicsDevice[] graphicsDeviceArray2 = this.screens;
        if (graphicsDeviceArray2 != null) {
            for (n = 0; n < graphicsDeviceArray2.length; ++n) {
                if (!(this.screens[n] instanceof Win32GraphicsDevice)) {
                    assert (false) : graphicsDeviceArray2[n];
                    continue;
                }
                Win32GraphicsDevice win32GraphicsDevice = (Win32GraphicsDevice)graphicsDeviceArray2[n];
                if (!win32GraphicsDevice.isValid()) {
                    if (this.oldDevices == null) {
                        this.oldDevices = new ArrayList();
                    }
                    this.oldDevices.add(new WeakReference<Win32GraphicsDevice>(win32GraphicsDevice));
                    continue;
                }
                if (n >= graphicsDeviceArray.length) continue;
                graphicsDeviceArray[n] = win32GraphicsDevice;
            }
            graphicsDeviceArray2 = null;
        }
        for (n = 0; n < graphicsDeviceArray.length; ++n) {
            if (graphicsDeviceArray[n] != null) continue;
            graphicsDeviceArray[n] = this.makeScreenDevice(n);
        }
        for (GraphicsDevice graphicsDevice : this.screens = graphicsDeviceArray) {
            if (!(graphicsDevice instanceof DisplayChangedListener)) continue;
            ((DisplayChangedListener)((Object)graphicsDevice)).displayChanged();
        }
        if (this.oldDevices != null) {
            int n2 = this.getDefaultScreen();
            ListIterator<WeakReference<Win32GraphicsDevice>> listIterator = this.oldDevices.listIterator();
            while (listIterator.hasNext()) {
                Win32GraphicsDevice win32GraphicsDevice = (Win32GraphicsDevice)listIterator.next().get();
                if (win32GraphicsDevice != null) {
                    win32GraphicsDevice.invalidate(n2);
                    win32GraphicsDevice.displayChanged();
                    continue;
                }
                listIterator.remove();
            }
        }
        WToolkit.resetGC();
        this.displayChanger.notifyListeners();
    }

    @Override
    protected GraphicsDevice makeScreenDevice(int n) {
        Win32GraphicsDevice win32GraphicsDevice = null;
        if (WindowsFlags.isD3DEnabled()) {
            win32GraphicsDevice = D3DGraphicsDevice.createDevice(n);
        }
        if (win32GraphicsDevice == null) {
            win32GraphicsDevice = new Win32GraphicsDevice(n);
        }
        return win32GraphicsDevice;
    }

    @Override
    public boolean isDisplayLocal() {
        return true;
    }

    @Override
    public boolean isFlipStrategyPreferred(ComponentPeer componentPeer) {
        GraphicsDevice graphicsDevice;
        GraphicsConfiguration graphicsConfiguration;
        if (componentPeer != null && (graphicsConfiguration = componentPeer.getGraphicsConfiguration()) != null && (graphicsDevice = graphicsConfiguration.getDevice()) instanceof D3DGraphicsDevice) {
            return ((D3DGraphicsDevice)graphicsDevice).isD3DEnabledOnDevice();
        }
        return false;
    }

    public static boolean isDWMCompositionEnabled() {
        return isDWMCompositionEnabled;
    }

    private static void dwmCompositionChanged(boolean bl) {
        isDWMCompositionEnabled = bl;
    }

    public static native boolean isVistaOS();

    static {
        WToolkit.loadLibraries();
        WindowsFlags.initFlags();
        Win32GraphicsEnvironment.initDisplayWrapper();
        SurfaceManagerFactory.setInstance(new WindowsSurfaceManagerFactory());
    }
}

