'use strict';const ELLIPSIS='\u2026';const NBSP='\xa0';const PASS_THRESHOLD=0.9;const RATINGS={PASS:{label:'pass',minScore:PASS_THRESHOLD},AVERAGE:{label:'average',minScore:0.5},FAIL:{label:'fail'},ERROR:{label:'error'},};class Util{static get PASS_THRESHOLD(){return PASS_THRESHOLD;}
static get MS_DISPLAY_VALUE(){return`%10d${NBSP}ms`;}
static prepareReportResult(result){const clone=(JSON.parse(JSON.stringify(result)));if(!clone.configSettings.locale){clone.configSettings.locale='en';}
Util.setNumberDateLocale(clone.configSettings.locale);if(clone.i18n&&clone.i18n.rendererFormattedStrings){Util.updateAllUIStrings(clone.i18n.rendererFormattedStrings);}
if(typeof clone.categories!=='object')throw new Error('No categories provided.');clone.reportCategories=Object.values(clone.categories);for(const audit of Object.values(clone.audits)){if(audit.scoreDisplayMode==='not_applicable'||audit.scoreDisplayMode==='not-applicable'){audit.scoreDisplayMode='notApplicable';}}
for(const category of clone.reportCategories){category.auditRefs.forEach(auditMeta=>{const result=clone.audits[auditMeta.id];auditMeta.result=result;});}
return clone;}
static updateAllUIStrings(rendererFormattedStrings){for(const[key,value]of Object.entries(rendererFormattedStrings)){Util.UIStrings[key]=value;}}
static formatDisplayValue(displayValue){if(typeof displayValue==='string')return displayValue;if(!displayValue)return'';const replacementRegex=/%([0-9]*(\.[0-9]+)?d|s)/;const template=(displayValue[0]);if(typeof template!=='string'){return'UNKNOWN';}
let output=template;for(const replacement of displayValue.slice(1)){if(!replacementRegex.test(output)){console.warn('Too many replacements given');break;}
output=output.replace(replacementRegex,match=>{const granularity=Number(match.match(/[0-9.]+/))||1;return match==='%s'?replacement.toLocaleString():(Math.round(Number(replacement)/granularity)*granularity).toLocaleString();});}
if(replacementRegex.test(output)){console.warn('Not enough replacements given');}
return output;}
static showAsPassed(audit){switch(audit.scoreDisplayMode){case'manual':case'notApplicable':return true;case'error':case'informative':return false;case'numeric':case'binary':default:return Number(audit.score)>=RATINGS.PASS.minScore;}}
static calculateRating(score,scoreDisplayMode){if(scoreDisplayMode==='manual'||scoreDisplayMode==='notApplicable'){return RATINGS.PASS.label;}else if(scoreDisplayMode==='error'){return RATINGS.ERROR.label;}else if(score===null){return RATINGS.FAIL.label;}
let rating=RATINGS.FAIL.label;if(score>=RATINGS.PASS.minScore){rating=RATINGS.PASS.label;}else if(score>=RATINGS.AVERAGE.minScore){rating=RATINGS.AVERAGE.label;}
return rating;}
static formatNumber(number,granularity=0.1){const coarseValue=Math.round(number/granularity)*granularity;return coarseValue.toLocaleString(Util.numberDateLocale);}
static formatBytesToKB(size,granularity=0.1){const kbs=(Math.round(size/1024/granularity)*granularity).toLocaleString(Util.numberDateLocale);return`${kbs}${NBSP}KB`;}
static formatMilliseconds(ms,granularity=10){const coarseTime=Math.round(ms/granularity)*granularity;return`${coarseTime.toLocaleString(Util.numberDateLocale)}${NBSP}ms`;}
static formatSeconds(ms,granularity=0.1){const coarseTime=Math.round(ms/1000/granularity)*granularity;return`${coarseTime.toLocaleString(Util.numberDateLocale)}${NBSP}s`;}
static formatDateTime(date){const options={month:'short',day:'numeric',year:'numeric',hour:'numeric',minute:'numeric',timeZoneName:'short',};let formatter=new Intl.DateTimeFormat(Util.numberDateLocale,options);const tz=formatter.resolvedOptions().timeZone;if(!tz||tz.toLowerCase()==='etc/unknown'){options.timeZone='UTC';formatter=new Intl.DateTimeFormat(Util.numberDateLocale,options);}
return formatter.format(new Date(date));}
static formatDuration(timeInMilliseconds){let timeInSeconds=timeInMilliseconds/1000;if(Math.round(timeInSeconds)===0){return'None';}
const parts=[];const unitLabels=({d:60*60*24,h:60*60,m:60,s:1,});Object.keys(unitLabels).forEach(label=>{const unit=unitLabels[label];const numberOfUnits=Math.floor(timeInSeconds/unit);if(numberOfUnits>0){timeInSeconds-=numberOfUnits*unit;parts.push(`${numberOfUnits}\xa0${label}`);}});return parts.join(' ');}
static getURLDisplayName(parsedUrl,options){options=options||{numPathParts:undefined,preserveQuery:undefined,preserveHost:undefined};const numPathParts=options.numPathParts!==undefined?options.numPathParts:2;const preserveQuery=options.preserveQuery!==undefined?options.preserveQuery:true;const preserveHost=options.preserveHost||false;let name;if(parsedUrl.protocol==='about:'||parsedUrl.protocol==='data:'){name=parsedUrl.href;}else{name=parsedUrl.pathname;const parts=name.split('/').filter(part=>part.length);if(numPathParts&&parts.length>numPathParts){name=ELLIPSIS+parts.slice(-1*numPathParts).join('/');}
if(preserveHost){name=`${parsedUrl.host}/${name.replace(/^\//, '')}`;}
if(preserveQuery){name=`${name}${parsedUrl.search}`;}}
const MAX_LENGTH=64;name=name.replace(/([a-f0-9]{7})[a-f0-9]{13}[a-f0-9]*/g,`$1${ELLIPSIS}`);name=name.replace(/([a-zA-Z0-9-_]{9})(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9])[a-zA-Z0-9-_]{10,}/g,`$1${ELLIPSIS}`);name=name.replace(/(\d{3})\d{6,}/g,`$1${ELLIPSIS}`);name=name.replace(/\u2026+/g,ELLIPSIS);if(name.length>MAX_LENGTH&&name.includes('?')){name=name.replace(/\?([^=]*)(=)?.*/,`?$1$2${ELLIPSIS}`);if(name.length>MAX_LENGTH){name=name.replace(/\?.*/,`?${ELLIPSIS}`);}}
if(name.length>MAX_LENGTH){const dotIndex=name.lastIndexOf('.');if(dotIndex>=0){name=name.slice(0,MAX_LENGTH-1-(name.length-dotIndex))+`${ELLIPSIS}${name.slice(dotIndex)}`;}else{name=name.slice(0,MAX_LENGTH-1)+ELLIPSIS;}}
return name;}
static parseURL(url){const parsedUrl=new URL(url);return{file:Util.getURLDisplayName(parsedUrl),hostname:parsedUrl.hostname,origin:parsedUrl.origin,};}
static getEnvironmentDisplayValues(settings){const emulationDesc=Util.getEmulationDescriptions(settings);return[{name:'Device',description:emulationDesc.deviceEmulation,},{name:'Network throttling',description:emulationDesc.networkThrottling,},{name:'CPU throttling',description:emulationDesc.cpuThrottling,},];}
static getEmulationDescriptions(settings){let cpuThrottling;let networkThrottling;let summary;const throttling=settings.throttling;switch(settings.throttlingMethod){case'provided':cpuThrottling='Provided by environment';networkThrottling='Provided by environment';summary='No throttling applied';break;case'devtools':{const{cpuSlowdownMultiplier,requestLatencyMs}=throttling;cpuThrottling=`${Util.formatNumber(cpuSlowdownMultiplier)}x slowdown (DevTools)`;networkThrottling=`${Util.formatNumber(requestLatencyMs)}${NBSP}ms HTTP RTT, `+`${Util.formatNumber(throttling.downloadThroughputKbps)}${NBSP}Kbps down, `+`${Util.formatNumber(throttling.uploadThroughputKbps)}${NBSP}Kbps up (DevTools)`;summary='Throttled Slow 4G network';break;}
case'simulate':{const{cpuSlowdownMultiplier,rttMs,throughputKbps}=throttling;cpuThrottling=`${Util.formatNumber(cpuSlowdownMultiplier)}x slowdown (Simulated)`;networkThrottling=`${Util.formatNumber(rttMs)}${NBSP}ms TCP RTT, `+`${Util.formatNumber(throughputKbps)}${NBSP}Kbps throughput (Simulated)`;summary='Simulated Slow 4G network';break;}
default:cpuThrottling='Unknown';networkThrottling='Unknown';summary='Unknown';}
let deviceEmulation='No emulation';if(!settings.disableDeviceEmulation){if(settings.emulatedFormFactor==='mobile')deviceEmulation='Emulated Nexus 5X';if(settings.emulatedFormFactor==='desktop')deviceEmulation='Emulated Desktop';}
return{deviceEmulation,cpuThrottling,networkThrottling,summary:`${deviceEmulation}, ${summary}`,};}
static setNumberDateLocale(locale){Util.numberDateLocale=locale;if(Util.numberDateLocale==='en-XA')Util.numberDateLocale='de';}}
Util.numberDateLocale='en';Util.UIStrings={varianceDisclaimer:'Values are estimated and may vary.',opportunityResourceColumnLabel:'Opportunity',opportunitySavingsColumnLabel:'Estimated Savings',errorMissingAuditInfo:'Report error: no audit information',errorLabel:'Error!',warningHeader:'Warnings: ',auditGroupExpandTooltip:'Show audits',warningAuditsGroupTitle:'Passed audits but with warnings',passedAuditsGroupTitle:'Passed audits',notApplicableAuditsGroupTitle:'Not applicable',manualAuditsGroupTitle:'Additional items to manually check',toplevelWarningsMessage:'There were issues affecting this run of Lighthouse:',scorescaleLabel:'Score scale:',crcInitialNavigation:'Initial Navigation',crcLongestDurationLabel:'Maximum critical path latency:',lsPerformanceCategoryDescription:'[Lighthouse](https://developers.google.com/web/tools/lighthouse/) analysis of the current page on an emulated mobile network. Values are estimated and may vary.',labDataTitle:'Lab Data',};if(typeof module!=='undefined'&&module.exports){module.exports=Util;}else{self.Util=Util;};'use strict';class DOM{constructor(document){this._document=document;}
createElement(name,className,attrs={}){const element=this._document.createElement(name);if(className){element.className=className;}
Object.keys(attrs).forEach(key=>{const value=attrs[key];if(typeof value!=='undefined'){element.setAttribute(key,value);}});return element;}
createFragment(){return this._document.createDocumentFragment();}
createChildOf(parentElem,elementName,className,attrs){const element=this.createElement(elementName,className,attrs);parentElem.appendChild(element);return element;}
cloneTemplate(selector,context){const template=(context.querySelector(selector));if(!template){throw new Error(`Template not found: template${selector}`);}
const clone=this._document.importNode(template.content,true);if(template.hasAttribute('data-stamped')){this.findAll('style',clone).forEach(style=>style.remove());}
template.setAttribute('data-stamped','true');return clone;}
resetTemplates(){this.findAll('template[data-stamped]',this._document).forEach(t=>{t.removeAttribute('data-stamped');});}
convertMarkdownLinkSnippets(text){const element=this.createElement('span');const parts=text.split(/\[([^\]]*?)\]\((https?:\/\/.*?)\)/g);while(parts.length){const[preambleText,linkText,linkHref]=parts.splice(0,3);element.appendChild(this._document.createTextNode(preambleText));if(linkText&&linkHref){const a=this.createElement('a');a.rel='noopener';a.target='_blank';a.textContent=linkText;a.href=(new URL(linkHref)).href;element.appendChild(a);}}
return element;}
convertMarkdownCodeSnippets(text){const element=this.createElement('span');const parts=text.split(/`(.*?)`/g);while(parts.length){const[preambleText,codeText]=parts.splice(0,2);element.appendChild(this._document.createTextNode(preambleText));if(codeText){const pre=this.createElement('code');pre.textContent=codeText;element.appendChild(pre);}}
return element;}
document(){return this._document;}
isDevTools(){return!!this._document.querySelector('.lh-devtools');}
find(query,context){const result=context.querySelector(query);if(result===null){throw new Error(`query ${query} not found`);}
return result;}
findAll(query,context){return Array.from(context.querySelectorAll(query));}}
if(typeof module!=='undefined'&&module.exports){module.exports=DOM;}else{self.DOM=DOM;};'use strict';class CategoryRenderer{constructor(dom,detailsRenderer){this.dom=dom;this.detailsRenderer=detailsRenderer;this.templateContext=this.dom.document();this.detailsRenderer.setTemplateContext(this.templateContext);}
get _clumpTitles(){return{warning:Util.UIStrings.warningAuditsGroupTitle,manual:Util.UIStrings.manualAuditsGroupTitle,passed:Util.UIStrings.passedAuditsGroupTitle,notApplicable:Util.UIStrings.notApplicableAuditsGroupTitle,};}
renderAudit(audit,index){const tmpl=this.dom.cloneTemplate('#tmpl-lh-audit',this.templateContext);return this.populateAuditValues(audit,index,tmpl);}
populateAuditValues(audit,index,tmpl){const auditEl=this.dom.find('.lh-audit',tmpl);auditEl.id=audit.result.id;const scoreDisplayMode=audit.result.scoreDisplayMode;if(audit.result.displayValue){const displayValue=Util.formatDisplayValue(audit.result.displayValue);this.dom.find('.lh-audit__display-text',auditEl).textContent=displayValue;}
const titleEl=this.dom.find('.lh-audit__title',auditEl);titleEl.appendChild(this.dom.convertMarkdownCodeSnippets(audit.result.title));this.dom.find('.lh-audit__description',auditEl).appendChild(this.dom.convertMarkdownLinkSnippets(audit.result.description));const header=(this.dom.find('details',auditEl));if(audit.result.details&&audit.result.details.type){const elem=this.detailsRenderer.render(audit.result.details);elem.classList.add('lh-details');header.appendChild(elem);}
this.dom.find('.lh-audit__index',auditEl).textContent=`${index + 1}`;this.dom.find('.lh-chevron-container',auditEl).appendChild(this._createChevron());this._setRatingClass(auditEl,audit.result.score,scoreDisplayMode);if(audit.result.scoreDisplayMode==='error'){auditEl.classList.add(`lh-audit--error`);const textEl=this.dom.find('.lh-audit__display-text',auditEl);textEl.textContent=Util.UIStrings.errorLabel;textEl.classList.add('tooltip-boundary');const tooltip=this.dom.createChildOf(textEl,'div','tooltip tooltip--error');tooltip.textContent=audit.result.errorMessage||Util.UIStrings.errorMissingAuditInfo;}else if(audit.result.explanation){const explEl=this.dom.createChildOf(titleEl,'div','lh-audit-explanation');explEl.textContent=audit.result.explanation;}
const warnings=audit.result.warnings;if(!warnings||warnings.length===0)return auditEl;const warningsEl=this.dom.createChildOf(titleEl,'div','lh-warnings');if(warnings.length===1){warningsEl.textContent=`${Util.UIStrings.warningHeader} ${warnings.join('')}`;}else{warningsEl.textContent=Util.UIStrings.warningHeader;const warningsUl=this.dom.createChildOf(warningsEl,'ul');for(const warning of warnings){const item=this.dom.createChildOf(warningsUl,'li');item.textContent=warning;}}
return auditEl;}
_createChevron(){const chevronTmpl=this.dom.cloneTemplate('#tmpl-lh-chevron',this.templateContext);const chevronEl=this.dom.find('.lh-chevron',chevronTmpl);return chevronEl;}
_setRatingClass(element,score,scoreDisplayMode){const rating=Util.calculateRating(score,scoreDisplayMode);element.classList.add(`lh-audit--${rating}`,`lh-audit--${scoreDisplayMode.toLowerCase()}`);return element;}
renderCategoryHeader(category,groupDefinitions){const tmpl=this.dom.cloneTemplate('#tmpl-lh-category-header',this.templateContext);const gaugeContainerEl=this.dom.find('.lh-score__gauge',tmpl);const gaugeEl=this.renderScoreGauge(category,groupDefinitions);gaugeContainerEl.appendChild(gaugeEl);this.dom.find('.lh-category-header__title',tmpl).appendChild(this.dom.convertMarkdownCodeSnippets(category.title));if(category.description){const descEl=this.dom.convertMarkdownLinkSnippets(category.description);this.dom.find('.lh-category-header__description',tmpl).appendChild(descEl);}
return(tmpl.firstElementChild);}
renderAuditGroup(group){const groupEl=this.dom.createElement('div','lh-audit-group');const summaryEl=this.dom.createChildOf(groupEl,'div');const summaryInnerEl=this.dom.createChildOf(summaryEl,'div','lh-audit-group__summary');const headerEl=this.dom.createChildOf(summaryInnerEl,'div','lh-audit-group__header');if(group.description){const auditGroupDescription=this.dom.createElement('div','lh-audit-group__description');auditGroupDescription.appendChild(this.dom.convertMarkdownLinkSnippets(group.description));groupEl.appendChild(auditGroupDescription);}
headerEl.textContent=group.title;return groupEl;}
_renderGroupedAudits(auditRefs,groupDefinitions){const grouped=new Map();const notAGroup='NotAGroup';grouped.set(notAGroup,[]);for(const auditRef of auditRefs){const groupId=auditRef.group||notAGroup;const groupAuditRefs=grouped.get(groupId)||[];groupAuditRefs.push(auditRef);grouped.set(groupId,groupAuditRefs);}
const auditElements=[];let index=0;for(const[groupId,groupAuditRefs]of grouped){if(groupId===notAGroup){for(const auditRef of groupAuditRefs){auditElements.push(this.renderAudit(auditRef,index++));}
continue;}
const groupDef=groupDefinitions[groupId];const auditGroupElem=this.renderAuditGroup(groupDef);for(const auditRef of groupAuditRefs){auditGroupElem.appendChild(this.renderAudit(auditRef,index++));}
auditGroupElem.classList.add(`lh-audit-group--${groupId}`);auditElements.push(auditGroupElem);}
return auditElements;}
renderUnexpandableClump(auditRefs,groupDefinitions){const clumpElement=this.dom.createElement('div');const elements=this._renderGroupedAudits(auditRefs,groupDefinitions);elements.forEach(elem=>clumpElement.appendChild(elem));return clumpElement;}
renderClump(clumpId,{auditRefs,description}){const clumpTmpl=this.dom.cloneTemplate('#tmpl-lh-clump',this.templateContext);const clumpElement=this.dom.find('.lh-clump',clumpTmpl);if(clumpId==='warning'){clumpElement.setAttribute('open','');}
const summaryInnerEl=this.dom.find('.lh-audit-group__summary',clumpElement);const chevronEl=summaryInnerEl.appendChild(this._createChevron());chevronEl.title=Util.UIStrings.auditGroupExpandTooltip;const headerEl=this.dom.find('.lh-audit-group__header',clumpElement);const title=this._clumpTitles[clumpId];headerEl.textContent=title;if(description){const markdownDescriptionEl=this.dom.convertMarkdownLinkSnippets(description);const auditGroupDescription=this.dom.createElement('div','lh-audit-group__description');auditGroupDescription.appendChild(markdownDescriptionEl);clumpElement.appendChild(auditGroupDescription);}
const itemCountEl=this.dom.find('.lh-audit-group__itemcount',clumpElement);itemCountEl.textContent=`${auditRefs.length} audits`;const auditElements=auditRefs.map(this.renderAudit.bind(this));clumpElement.append(...auditElements);clumpElement.classList.add(`lh-clump--${clumpId.toLowerCase()}`);return clumpElement;}
setTemplateContext(context){this.templateContext=context;this.detailsRenderer.setTemplateContext(context);}
renderScoreGauge(category,groupDefinitions){const tmpl=this.dom.cloneTemplate('#tmpl-lh-gauge',this.templateContext);const wrapper=(this.dom.find('.lh-gauge__wrapper',tmpl));wrapper.href=`#${category.id}`;wrapper.classList.add(`lh-gauge__wrapper--${Util.calculateRating(category.score)}`);const numericScore=Number(category.score);const gauge=this.dom.find('.lh-gauge',tmpl);const gaugeArc=gauge.querySelector('.lh-gauge-arc');if(gaugeArc){gaugeArc.style.strokeDasharray=`${numericScore * 329} 329`;}
const scoreOutOf100=Math.round(numericScore*100);const percentageEl=this.dom.find('.lh-gauge__percentage',tmpl);percentageEl.textContent=scoreOutOf100.toString();if(category.score===null){percentageEl.textContent='?';percentageEl.title=Util.UIStrings.errorLabel;}
this.dom.find('.lh-gauge__label',tmpl).textContent=category.title;return tmpl;}
_auditHasWarning(audit){return Boolean(audit.result.warnings&&audit.result.warnings.length);}
_getClumpIdForAuditRef(auditRef){const scoreDisplayMode=auditRef.result.scoreDisplayMode;if(scoreDisplayMode==='manual'||scoreDisplayMode==='notApplicable'){return scoreDisplayMode;}
if(Util.showAsPassed(auditRef.result)){if(this._auditHasWarning(auditRef)){return'warning';}else{return'passed';}}else{return'failed';}}
render(category,groupDefinitions={}){const element=this.dom.createElement('div','lh-category');this.createPermalinkSpan(element,category.id);element.appendChild(this.renderCategoryHeader(category,groupDefinitions));const clumps=new Map();clumps.set('failed',[]);clumps.set('warning',[]);clumps.set('manual',[]);clumps.set('passed',[]);clumps.set('notApplicable',[]);for(const auditRef of category.auditRefs){const clumpId=this._getClumpIdForAuditRef(auditRef);const clump=(clumps.get(clumpId));clump.push(auditRef);clumps.set(clumpId,clump);}
for(const[clumpId,auditRefs]of clumps){if(auditRefs.length===0)continue;if(clumpId==='failed'){const clumpElem=this.renderUnexpandableClump(auditRefs,groupDefinitions);clumpElem.classList.add(`lh-clump--failed`);element.appendChild(clumpElem);continue;}
const description=clumpId==='manual'?category.manualDescription:undefined;const clumpElem=this.renderClump(clumpId,{auditRefs,description});element.appendChild(clumpElem);}
return element;}
createPermalinkSpan(element,id){const permalinkEl=this.dom.createChildOf(element,'span','lh-permalink');permalinkEl.id=id;}}
if(typeof module!=='undefined'&&module.exports){module.exports=CategoryRenderer;}else{self.CategoryRenderer=CategoryRenderer;};'use strict';class PerformanceCategoryRenderer extends CategoryRenderer{_renderMetric(audit){const tmpl=this.dom.cloneTemplate('#tmpl-lh-metric',this.templateContext);const element=this.dom.find('.lh-metric',tmpl);element.id=audit.result.id;const rating=Util.calculateRating(audit.result.score,audit.result.scoreDisplayMode);element.classList.add(`lh-metric--${rating}`);const titleEl=this.dom.find('.lh-metric__title',tmpl);titleEl.textContent=audit.result.title;const valueEl=this.dom.find('.lh-metric__value',tmpl);valueEl.textContent=Util.formatDisplayValue(audit.result.displayValue);const descriptionEl=this.dom.find('.lh-metric__description',tmpl);descriptionEl.appendChild(this.dom.convertMarkdownLinkSnippets(audit.result.description));if(audit.result.scoreDisplayMode==='error'){descriptionEl.textContent='';valueEl.textContent='Error!';const tooltip=this.dom.createChildOf(descriptionEl,'span');tooltip.textContent=audit.result.errorMessage||'Report error: no metric information';}
return element;}
_renderOpportunity(audit,index,scale){const oppTmpl=this.dom.cloneTemplate('#tmpl-lh-opportunity',this.templateContext);const element=this.populateAuditValues(audit,index,oppTmpl);element.id=audit.result.id;if(!audit.result.details||audit.result.scoreDisplayMode==='error'){return element;}
const details=(audit.result.details);if(details.type!=='opportunity'){return element;}
const displayEl=this.dom.find('.lh-audit__display-text',element);const sparklineWidthPct=`${details.overallSavingsMs / scale * 100}%`;this.dom.find('.lh-sparkline__bar',element).style.width=sparklineWidthPct;displayEl.textContent=Util.formatSeconds(details.overallSavingsMs,0.01);if(audit.result.displayValue){const displayValue=Util.formatDisplayValue(audit.result.displayValue);this.dom.find('.lh-load-opportunity__sparkline',element).title=displayValue;displayEl.title=displayValue;}
return element;}
_getWastedMs(audit){if(audit.result.details&&audit.result.details.type==='opportunity'){const details=(audit.result.details);if(typeof details.overallSavingsMs!=='number'){throw new Error('non-opportunity details passed to _getWastedMs');}
return details.overallSavingsMs;}else{return Number.MIN_VALUE;}}
render(category,groups,environment){const element=this.dom.createElement('div','lh-category');if(environment==='PSI'){const gaugeEl=this.dom.createElement('div','lh-score__gauge');gaugeEl.appendChild(this.renderScoreGauge(category,groups));element.appendChild(gaugeEl);}else{this.createPermalinkSpan(element,category.id);element.appendChild(this.renderCategoryHeader(category,groups));}
const metricAudits=category.auditRefs.filter(audit=>audit.group==='metrics');const metricAuditsEl=this.renderAuditGroup(groups.metrics);const keyMetrics=metricAudits.filter(a=>a.weight>=3);const otherMetrics=metricAudits.filter(a=>a.weight<3);const metricsBoxesEl=this.dom.createChildOf(metricAuditsEl,'div','lh-columns');const metricsColumn1El=this.dom.createChildOf(metricsBoxesEl,'div','lh-column');const metricsColumn2El=this.dom.createChildOf(metricsBoxesEl,'div','lh-column');keyMetrics.forEach(item=>{metricsColumn1El.appendChild(this._renderMetric(item));});otherMetrics.forEach(item=>{metricsColumn2El.appendChild(this._renderMetric(item));});if(environment!=='PSI'){const estValuesEl=this.dom.createChildOf(metricsColumn2El,'div','lh-metrics__disclaimer lh-metrics__disclaimer');estValuesEl.textContent=Util.UIStrings.varianceDisclaimer;}
metricAuditsEl.classList.add('lh-audit-group--metrics');element.appendChild(metricAuditsEl);const timelineEl=this.dom.createChildOf(element,'div','lh-filmstrip-container');const thumbnailAudit=category.auditRefs.find(audit=>audit.id==='screenshot-thumbnails');const thumbnailResult=thumbnailAudit&&thumbnailAudit.result;if(thumbnailResult&&thumbnailResult.details){timelineEl.id=thumbnailResult.id;const filmstripEl=this.detailsRenderer.render(thumbnailResult.details);timelineEl.appendChild(filmstripEl);}
const opportunityAudits=category.auditRefs.filter(audit=>audit.group==='load-opportunities'&&!Util.showAsPassed(audit.result)).sort((auditA,auditB)=>this._getWastedMs(auditB)-this._getWastedMs(auditA));if(opportunityAudits.length){const minimumScale=2000;const wastedMsValues=opportunityAudits.map(audit=>this._getWastedMs(audit));const maxWaste=Math.max(...wastedMsValues);const scale=Math.max(Math.ceil(maxWaste/1000)*1000,minimumScale);const groupEl=this.renderAuditGroup(groups['load-opportunities']);const tmpl=this.dom.cloneTemplate('#tmpl-lh-opportunity-header',this.templateContext);this.dom.find('.lh-load-opportunity__col--one',tmpl).textContent=Util.UIStrings.opportunityResourceColumnLabel;this.dom.find('.lh-load-opportunity__col--two',tmpl).textContent=Util.UIStrings.opportunitySavingsColumnLabel;const headerEl=this.dom.find('.lh-load-opportunity__header',tmpl);groupEl.appendChild(headerEl);opportunityAudits.forEach((item,i)=>groupEl.appendChild(this._renderOpportunity(item,i,scale)));groupEl.classList.add('lh-audit-group--load-opportunities');element.appendChild(groupEl);}
const diagnosticAudits=category.auditRefs.filter(audit=>audit.group==='diagnostics'&&!Util.showAsPassed(audit.result)).sort((a,b)=>{const scoreA=a.result.scoreDisplayMode==='informative'?100:Number(a.result.score);const scoreB=b.result.scoreDisplayMode==='informative'?100:Number(b.result.score);return scoreA-scoreB;});if(diagnosticAudits.length){const groupEl=this.renderAuditGroup(groups['diagnostics']);diagnosticAudits.forEach((item,i)=>groupEl.appendChild(this.renderAudit(item,i)));groupEl.classList.add('lh-audit-group--diagnostics');element.appendChild(groupEl);}
const passedAudits=category.auditRefs.filter(audit=>(audit.group==='load-opportunities'||audit.group==='diagnostics')&&Util.showAsPassed(audit.result));if(!passedAudits.length)return element;const clumpOpts={auditRefs:passedAudits,groupDefinitions:groups,};const passedElem=this.renderClump('passed',clumpOpts);element.appendChild(passedElem);return element;}}
if(typeof module!=='undefined'&&module.exports){module.exports=PerformanceCategoryRenderer;}else{self.PerformanceCategoryRenderer=PerformanceCategoryRenderer;};'use strict';class PwaCategoryRenderer extends CategoryRenderer{render(category,groupDefinitions={}){const categoryElem=this.dom.createElement('div','lh-category');this.createPermalinkSpan(categoryElem,category.id);categoryElem.appendChild(this.renderCategoryHeader(category,groupDefinitions));const auditRefs=category.auditRefs;const regularAuditRefs=auditRefs.filter(ref=>ref.result.scoreDisplayMode!=='manual');const auditsElem=this._renderAudits(regularAuditRefs,groupDefinitions);categoryElem.appendChild(auditsElem);const manualAuditRefs=auditRefs.filter(ref=>ref.result.scoreDisplayMode==='manual');const manualElem=this.renderClump('manual',{auditRefs:manualAuditRefs,description:category.manualDescription});categoryElem.appendChild(manualElem);return categoryElem;}
renderScoreGauge(category,groupDefinitions){if(category.score===null){return super.renderScoreGauge(category,groupDefinitions);}
const tmpl=this.dom.cloneTemplate('#tmpl-lh-gauge--pwa',this.templateContext);const wrapper=(this.dom.find('.lh-gauge--pwa__wrapper',tmpl));wrapper.href=`#${category.id}`;const allGroups=this._getGroupIds(category.auditRefs);const passingGroupIds=this._getPassingGroupIds(category.auditRefs);if(passingGroupIds.size===allGroups.size){wrapper.classList.add('lh-badged--all');}else{for(const passingGroupId of passingGroupIds){wrapper.classList.add(`lh-badged--${passingGroupId}`);}}
this.dom.find('.lh-gauge__label',tmpl).textContent=category.title;wrapper.title=this._getGaugeTooltip(category.auditRefs,groupDefinitions);return tmpl;}
_getGroupIds(auditRefs){const groupIds=auditRefs.map(ref=>ref.group).filter(g=>!!g);return new Set(groupIds);}
_getPassingGroupIds(auditRefs){const uniqueGroupIds=this._getGroupIds(auditRefs);for(const auditRef of auditRefs){if(!Util.showAsPassed(auditRef.result)&&auditRef.group){uniqueGroupIds.delete(auditRef.group);}}
return uniqueGroupIds;}
_getGaugeTooltip(auditRefs,groupDefinitions){const groupIds=this._getGroupIds(auditRefs);const tips=[];for(const groupId of groupIds){const groupAuditRefs=auditRefs.filter(ref=>ref.group===groupId);const auditCount=groupAuditRefs.length;const passedCount=groupAuditRefs.filter(ref=>Util.showAsPassed(ref.result)).length;const title=groupDefinitions[groupId].title;tips.push(`${title}: ${passedCount}/${auditCount}`);}
return tips.join(', ');}
_renderAudits(auditRefs,groupDefinitions){const auditsElem=this.renderUnexpandableClump(auditRefs,groupDefinitions);const passsingGroupIds=this._getPassingGroupIds(auditRefs);for(const groupId of passsingGroupIds){const groupElem=this.dom.find(`.lh-audit-group--${groupId}`,auditsElem);groupElem.classList.add('lh-badged');}
return auditsElem;}}
if(typeof module!=='undefined'&&module.exports){module.exports=PwaCategoryRenderer;}else{self.PwaCategoryRenderer=PwaCategoryRenderer;};'use strict';const URL_PREFIXES=['http://','https://','data:'];class DetailsRenderer{constructor(dom){this._dom=dom;this._templateContext;}
setTemplateContext(context){this._templateContext=context;}
render(details){switch(details.type){case'text':return this._renderText((details));case'url':return this._renderTextURL((details));case'bytes':return this._renderBytes((details));case'ms':return this._renderMilliseconds((details));case'link':return this._renderLink((details));case'thumbnail':return this._renderThumbnail((details));case'filmstrip':return this._renderFilmstrip((details));case'table':return this._renderTable((details));case'code':return this._renderCode((details));case'node':return this.renderNode((details));case'criticalrequestchain':return CriticalRequestChainRenderer.render(this._dom,this._templateContext,(details));case'opportunity':return this._renderOpportunityTable(details);case'numeric':return this._renderNumeric((details));default:{throw new Error(`Unknown type: ${details.type}`);}}}
_renderBytes(details){const value=Util.formatBytesToKB(details.value,details.granularity);return this._renderText({value});}
_renderMilliseconds(details){let value=Util.formatMilliseconds(details.value,details.granularity);if(details.displayUnit==='duration'){value=Util.formatDuration(details.value);}
return this._renderText({value});}
_renderTextURL(text){const url=text.value;let displayedPath;let displayedHost;let title;try{const parsed=Util.parseURL(url);displayedPath=parsed.file==='/'?parsed.origin:parsed.file;displayedHost=parsed.file==='/'?'':`(${parsed.hostname})`;title=url;}catch(e){displayedPath=url;}
const element=this._dom.createElement('div','lh-text__url');element.appendChild(this._renderText({value:displayedPath,}));if(displayedHost){const hostElem=this._renderText({value:displayedHost,});hostElem.classList.add('lh-text__url-host');element.appendChild(hostElem);}
if(title)element.title=url;return element;}
_renderLink(details){const allowedProtocols=['https:','http:'];const url=new URL(details.url);if(!allowedProtocols.includes(url.protocol)){return this._renderText({value:details.text,});}
const a=this._dom.createElement('a');a.rel='noopener';a.target='_blank';a.textContent=details.text;a.href=url.href;return a;}
_renderText(text){const element=this._dom.createElement('div','lh-text');element.textContent=text.value;return element;}
_renderNumeric(text){const element=this._dom.createElement('div','lh-numeric');element.textContent=text.value;return element;}
_renderThumbnail(details){const element=this._dom.createElement('img','lh-thumbnail');const strValue=details.value;element.src=strValue;element.title=strValue;element.alt='';return element;}
_renderTable(details){if(!details.items.length)return this._dom.createElement('span');const tableElem=this._dom.createElement('table','lh-table');const theadElem=this._dom.createChildOf(tableElem,'thead');const theadTrElem=this._dom.createChildOf(theadElem,'tr');for(const heading of details.headings){const itemType=heading.itemType||'text';const classes=`lh-table-column--${itemType}`;this._dom.createChildOf(theadTrElem,'th',classes).appendChild(this.render({type:'text',value:heading.text||'',}));}
const tbodyElem=this._dom.createChildOf(tableElem,'tbody');for(const row of details.items){const rowElem=this._dom.createChildOf(tbodyElem,'tr');for(const heading of details.headings){const key=(heading.key);const value=(row[key]);if(typeof value==='undefined'||value===null){this._dom.createChildOf(rowElem,'td','lh-table-column--empty');continue;}
if(value.type){const valueAsDetails=(value);const classes=`lh-table-column--${valueAsDetails.type}`;this._dom.createChildOf(rowElem,'td',classes).appendChild(this.render(valueAsDetails));continue;}
const item={value:(value),type:heading.itemType,displayUnit:heading.displayUnit,granularity:heading.granularity,};const valueType=value.type;const classes=`lh-table-column--${valueType || heading.itemType}`;this._dom.createChildOf(rowElem,'td',classes).appendChild(this.render(item));}}
return tableElem;}
_renderOpportunityTable(details){if(!details.items.length)return this._dom.createElement('span');const tableElem=this._dom.createElement('table','lh-table');const theadElem=this._dom.createChildOf(tableElem,'thead');const theadTrElem=this._dom.createChildOf(theadElem,'tr');for(const heading of details.headings){const valueType=heading.valueType||'text';const classes=`lh-table-column--${valueType}`;const labelEl=this._dom.createElement('div','lh-text');labelEl.textContent=heading.label;this._dom.createChildOf(theadTrElem,'th',classes).appendChild(labelEl);}
const tbodyElem=this._dom.createChildOf(tableElem,'tbody');for(const row of details.items){const rowElem=this._dom.createChildOf(tbodyElem,'tr');for(const heading of details.headings){const key=(heading.key);const value=row[key];if(typeof value==='undefined'||value===null){this._dom.createChildOf(rowElem,'td','lh-table-column--empty');continue;}
const valueType=heading.valueType;let itemElement;switch(valueType){case'url':{const strValue=(value);if(URL_PREFIXES.some(prefix=>strValue.startsWith(prefix))){itemElement=this._renderTextURL({value:strValue});}else{const codeValue=(value);itemElement=this._renderCode({value:codeValue});}
break;}
case'timespanMs':{const numValue=(value);itemElement=this._renderMilliseconds({value:numValue});break;}
case'bytes':{const numValue=(value);itemElement=this._renderBytes({value:numValue,granularity:1});break;}
case'thumbnail':{const strValue=(value);itemElement=this._renderThumbnail({value:strValue});break;}
default:{throw new Error(`Unknown valueType: ${valueType}`);}}
const classes=`lh-table-column--${valueType}`;this._dom.createChildOf(rowElem,'td',classes).appendChild(itemElement);}}
return tableElem;}
renderNode(item){const element=this._dom.createElement('span','lh-node');if(item.snippet){element.textContent=item.snippet;}
if(item.selector){element.title=item.selector;}
if(item.path)element.setAttribute('data-path',item.path);if(item.selector)element.setAttribute('data-selector',item.selector);if(item.snippet)element.setAttribute('data-snippet',item.snippet);return element;}
_renderFilmstrip(details){const filmstripEl=this._dom.createElement('div','lh-filmstrip');for(const thumbnail of details.items){const frameEl=this._dom.createChildOf(filmstripEl,'div','lh-filmstrip__frame');this._dom.createChildOf(frameEl,'img','lh-filmstrip__thumbnail',{src:`data:image/jpeg;base64,${thumbnail.data}`,alt:`Screenshot`,});}
return filmstripEl;}
_renderCode(details){const pre=this._dom.createElement('pre','lh-code');pre.textContent=(details.value);return pre;}}
if(typeof module!=='undefined'&&module.exports){module.exports=DetailsRenderer;}else{self.DetailsRenderer=DetailsRenderer;};'use strict';class CriticalRequestChainRenderer{static initTree(tree){let startTime=0;const rootNodes=Object.keys(tree);if(rootNodes.length>0){const node=tree[rootNodes[0]];startTime=node.request.startTime;}
return{tree,startTime,transferSize:0};}
static createSegment(parent,id,startTime,transferSize,treeMarkers,parentIsLastChild){const node=parent[id];const siblings=Object.keys(parent);const isLastChild=siblings.indexOf(id)===(siblings.length-1);const hasChildren=!!node.children&&Object.keys(node.children).length>0;const newTreeMarkers=Array.isArray(treeMarkers)?treeMarkers.slice(0):[];if(typeof parentIsLastChild!=='undefined'){newTreeMarkers.push(!parentIsLastChild);}
return{node,isLastChild,hasChildren,startTime,transferSize:transferSize+node.request.transferSize,treeMarkers:newTreeMarkers,};}
static createChainNode(dom,tmpl,segment){const chainsEl=dom.cloneTemplate('#tmpl-lh-crc__chains',tmpl);dom.find('.crc-node',chainsEl).setAttribute('title',segment.node.request.url);const treeMarkeEl=dom.find('.crc-node__tree-marker',chainsEl);segment.treeMarkers.forEach(separator=>{if(separator){treeMarkeEl.appendChild(dom.createElement('span','tree-marker vert'));treeMarkeEl.appendChild(dom.createElement('span','tree-marker'));}else{treeMarkeEl.appendChild(dom.createElement('span','tree-marker'));treeMarkeEl.appendChild(dom.createElement('span','tree-marker'));}});if(segment.isLastChild){treeMarkeEl.appendChild(dom.createElement('span','tree-marker up-right'));treeMarkeEl.appendChild(dom.createElement('span','tree-marker right'));}else{treeMarkeEl.appendChild(dom.createElement('span','tree-marker vert-right'));treeMarkeEl.appendChild(dom.createElement('span','tree-marker right'));}
if(segment.hasChildren){treeMarkeEl.appendChild(dom.createElement('span','tree-marker horiz-down'));}else{treeMarkeEl.appendChild(dom.createElement('span','tree-marker right'));}
const{file,hostname}=Util.parseURL(segment.node.request.url);const treevalEl=dom.find('.crc-node__tree-value',chainsEl);dom.find('.crc-node__tree-file',treevalEl).textContent=`${file}`;dom.find('.crc-node__tree-hostname',treevalEl).textContent=hostname?`(${hostname})`:'';if(!segment.hasChildren){const{startTime,endTime,transferSize}=segment.node.request;const span=dom.createElement('span','crc-node__chain-duration');span.textContent=' - '+Util.formatMilliseconds((endTime-startTime)*1000)+', ';const span2=dom.createElement('span','crc-node__chain-duration');span2.textContent=Util.formatBytesToKB(transferSize,0.01);treevalEl.appendChild(span);treevalEl.appendChild(span2);}
return chainsEl;}
static buildTree(dom,tmpl,segment,elem,details){elem.appendChild(CriticalRequestChainRenderer.createChainNode(dom,tmpl,segment));if(segment.node.children){for(const key of Object.keys(segment.node.children)){const childSegment=CriticalRequestChainRenderer.createSegment(segment.node.children,key,segment.startTime,segment.transferSize,segment.treeMarkers,segment.isLastChild);CriticalRequestChainRenderer.buildTree(dom,tmpl,childSegment,elem,details);}}}
static render(dom,templateContext,details){const tmpl=dom.cloneTemplate('#tmpl-lh-crc',templateContext);const containerEl=dom.find('.lh-crc',tmpl);dom.find('.crc-initial-nav',tmpl).textContent=Util.UIStrings.crcInitialNavigation;dom.find('.lh-crc__longest_duration_label',tmpl).textContent=Util.UIStrings.crcLongestDurationLabel;dom.find('.lh-crc__longest_duration',tmpl).textContent=Util.formatMilliseconds(details.longestChain.duration);const root=CriticalRequestChainRenderer.initTree(details.chains);for(const key of Object.keys(root.tree)){const segment=CriticalRequestChainRenderer.createSegment(root.tree,key,root.startTime,root.transferSize);CriticalRequestChainRenderer.buildTree(dom,tmpl,segment,containerEl,details);}
return dom.find('.lh-crc-container',tmpl);}}
if(typeof module!=='undefined'&&module.exports){module.exports=CriticalRequestChainRenderer;}else{self.CriticalRequestChainRenderer=CriticalRequestChainRenderer;};'use strict';class ReportRenderer{constructor(dom){this._dom=dom;this._templateContext=this._dom.document();}
renderReport(result,container){const originalUIStrings=JSON.parse(JSON.stringify(Util.UIStrings));const report=Util.prepareReportResult(result);container.textContent='';container.appendChild(this._renderReport(report));Util.updateAllUIStrings(originalUIStrings);return container;}
setTemplateContext(context){this._templateContext=context;}
_renderReportHeader(report){const el=this._dom.cloneTemplate('#tmpl-lh-heading',this._templateContext);const domFragment=this._dom.cloneTemplate('#tmpl-lh-scores-wrapper',this._templateContext);const placeholder=this._dom.find('.lh-scores-wrapper-placeholder',el);(placeholder.parentNode).replaceChild(domFragment,placeholder);this._dom.find('.lh-config__timestamp',el).textContent=Util.formatDateTime(report.fetchTime);this._dom.find('.lh-product-info__version',el).textContent=report.lighthouseVersion;const metadataUrl=(this._dom.find('.lh-metadata__url',el));const toolbarUrl=(this._dom.find('.lh-toolbar__url',el));metadataUrl.href=metadataUrl.textContent=report.finalUrl;toolbarUrl.href=toolbarUrl.textContent=report.finalUrl;const emulationDescriptions=Util.getEmulationDescriptions(report.configSettings||{});this._dom.find('.lh-config__emulation',el).textContent=emulationDescriptions.summary;return el;}
_renderReportShortHeader(){const shortHeaderContainer=this._dom.createElement('div','lh-header-container');const wrapper=this._dom.cloneTemplate('#tmpl-lh-scores-wrapper',this._templateContext);shortHeaderContainer.appendChild(wrapper);return shortHeaderContainer;}
_renderReportFooter(report){const footer=this._dom.cloneTemplate('#tmpl-lh-footer',this._templateContext);const env=this._dom.find('.lh-env__items',footer);env.id='runtime-settings';const envValues=Util.getEnvironmentDisplayValues(report.configSettings||{});[{name:'URL',description:report.finalUrl},{name:'Fetch time',description:Util.formatDateTime(report.fetchTime)},...envValues,{name:'User agent (host)',description:report.userAgent},{name:'User agent (network)',description:report.environment&&report.environment.networkUserAgent},{name:'CPU/Memory Power',description:report.environment&&report.environment.benchmarkIndex.toFixed(0)},].forEach(runtime=>{if(!runtime.description)return;const item=this._dom.cloneTemplate('#tmpl-lh-env__items',env);this._dom.find('.lh-env__name',item).textContent=`${runtime.name}:`;this._dom.find('.lh-env__description',item).textContent=runtime.description;env.appendChild(item);});this._dom.find('.lh-footer__version',footer).textContent=report.lighthouseVersion;return footer;}
_renderReportWarnings(report){if(!report.runWarnings||report.runWarnings.length===0){return this._dom.createElement('div');}
const container=this._dom.cloneTemplate('#tmpl-lh-warnings--toplevel',this._templateContext);const message=this._dom.find('.lh-warnings__msg',container);message.textContent=Util.UIStrings.toplevelWarningsMessage;const warnings=this._dom.find('ul',container);for(const warningString of report.runWarnings){const warning=warnings.appendChild(this._dom.createElement('li'));warning.textContent=warningString;}
return container;}
_renderReport(report){let header;const headerContainer=this._dom.createElement('div');if(this._dom.isDevTools()){headerContainer.classList.add('lh-header-plain');header=this._renderReportShortHeader();}else{headerContainer.classList.add('lh-header-sticky');header=this._renderReportHeader(report);}
headerContainer.appendChild(header);const container=this._dom.createElement('div','lh-container');const reportSection=container.appendChild(this._dom.createElement('div','lh-report'));reportSection.appendChild(this._renderReportWarnings(report));let scoreHeader;const isSoloCategory=report.reportCategories.length===1;if(!isSoloCategory){scoreHeader=this._dom.createElement('div','lh-scores-header');}else{headerContainer.classList.add('lh-header--solo-category');}
const detailsRenderer=new DetailsRenderer(this._dom);const categoryRenderer=new CategoryRenderer(this._dom,detailsRenderer);categoryRenderer.setTemplateContext(this._templateContext);const specificCategoryRenderers={performance:new PerformanceCategoryRenderer(this._dom,detailsRenderer),pwa:new PwaCategoryRenderer(this._dom,detailsRenderer),};Object.values(specificCategoryRenderers).forEach(renderer=>{renderer.setTemplateContext(this._templateContext);});const categories=reportSection.appendChild(this._dom.createElement('div','lh-categories'));for(const category of report.reportCategories){const renderer=specificCategoryRenderers[category.id]||categoryRenderer;categories.appendChild(renderer.render(category,report.categoryGroups));}
const scoresAll100=report.reportCategories.every(cat=>cat.score===1);if(scoresAll100&&!this._dom.isDevTools()){headerContainer.classList.add('score100');this._dom.find('.lh-header',headerContainer).addEventListener('click',_=>{headerContainer.classList.toggle('fireworks-paused');});}
if(scoreHeader){const defaultGauges=[];const customGauges=[];for(const category of report.reportCategories){const renderer=specificCategoryRenderers[category.id]||categoryRenderer;const categoryGauge=renderer.renderScoreGauge(category,report.categoryGroups||{});if(renderer.renderScoreGauge===categoryRenderer.renderScoreGauge){defaultGauges.push(categoryGauge);}else{customGauges.push(categoryGauge);}}
scoreHeader.append(...defaultGauges,...customGauges);const scoreScale=this._dom.cloneTemplate('#tmpl-lh-scorescale',this._templateContext);this._dom.find('.lh-scorescale-label',scoreScale).textContent=Util.UIStrings.scorescaleLabel;const scoresContainer=this._dom.find('.lh-scores-container',headerContainer);scoresContainer.appendChild(scoreHeader);scoresContainer.appendChild(scoreScale);}
reportSection.appendChild(this._renderReportFooter(report));const reportFragment=this._dom.createFragment();reportFragment.appendChild(headerContainer);reportFragment.appendChild(container);return reportFragment;}}
ReportRenderer._UIStringsStash={};if(typeof module!=='undefined'&&module.exports){module.exports=ReportRenderer;}else{self.ReportRenderer=ReportRenderer;};Audits2.RadioSetting=class{constructor(options,setting){this._setting=setting;this._options=options;this.element=createElement('div','audits2-radio-group');this._radioElements=[];for(const option of this._options){const fragment=UI.Fragment.build`
        <label $="label" class="audits2-radio">
          <input $="input" type="radio" value=${option.value} name=${setting.name}>
          ${option.label}
        </label>
      `;this.element.appendChild(fragment.element());if(option.title)
UI.Tooltip.install(fragment.$('label'),option.title);const radioElement=fragment.$('input');radioElement.addEventListener('change',this._valueChanged.bind(this));this._radioElements.push(radioElement);}
this._ignoreChangeEvents=false;this._selectedIndex=-1;setting.addChangeListener(this._settingChanged,this);this._settingChanged();}
_updateUI(){this._ignoreChangeEvents=true;this._radioElements[this._selectedIndex].checked=true;this._ignoreChangeEvents=false;}
_settingChanged(){const value=this._setting.get();this._selectedIndex=this._options.findIndex(option=>option.value===value);this._updateUI();}
_valueChanged(event){if(this._ignoreChangeEvents)
return;const selectedRadio=this._radioElements.find(radio=>radio.checked);this._setting.set(selectedRadio.value);}};;Audits2.Audits2Panel=class extends UI.Panel{constructor(){super('audits2');this.registerRequiredCSS('audits2/lighthouse/report-styles.css');this.registerRequiredCSS('audits2/audits2Panel.css');this._protocolService=new Audits2.ProtocolService();this._controller=new Audits2.AuditController(this._protocolService);this._startView=new Audits2.StartView(this._controller);this._statusView=new Audits2.StatusView(this._controller);this._unauditableExplanation=null;this._cachedRenderedReports=new Map();this._dropTarget=new UI.DropTarget(this.contentElement,[UI.DropTarget.Type.File],Common.UIString('Drop audit file here'),this._handleDrop.bind(this));this._controller.addEventListener(Audits2.Events.PageAuditabilityChanged,this._refreshStartAuditUI.bind(this));this._controller.addEventListener(Audits2.Events.AuditProgressChanged,this._refreshStatusUI.bind(this));this._controller.addEventListener(Audits2.Events.RequestAuditStart,this._startAudit.bind(this));this._controller.addEventListener(Audits2.Events.RequestAuditCancel,this._cancelAudit.bind(this));this._renderToolbar();this._auditResultsElement=this.contentElement.createChild('div','audits2-results-container');this._renderStartView();this._controller.recomputePageAuditability();}
_refreshStartAuditUI(evt){this._unauditableExplanation=evt.data.helpText;this._startView.setUnauditableExplanation(evt.data.helpText);this._startView.setStartButtonEnabled(!evt.data.helpText);}
_refreshStatusUI(evt){this._statusView.updateStatus(evt.data.message);}
_refreshToolbarUI(){this._downloadButton.setEnabled(this._reportSelector.hasCurrentSelection());this._clearButton.setEnabled(this._reportSelector.hasItems());}
_clearAll(){this._reportSelector.clearAll();this._renderStartView();this._refreshToolbarUI();}
_downloadSelected(){this._reportSelector.downloadSelected();}
_renderToolbar(){const toolbar=new UI.Toolbar('',this.element);this._newButton=new UI.ToolbarButton(Common.UIString('Perform an audit\u2026'),'largeicon-add');toolbar.appendToolbarItem(this._newButton);this._newButton.addEventListener(UI.ToolbarButton.Events.Click,this._renderStartView.bind(this));this._downloadButton=new UI.ToolbarButton(Common.UIString('Download report'),'largeicon-download');toolbar.appendToolbarItem(this._downloadButton);this._downloadButton.addEventListener(UI.ToolbarButton.Events.Click,this._downloadSelected.bind(this));toolbar.appendSeparator();this._reportSelector=new Audits2.ReportSelector(()=>this._renderStartView());toolbar.appendToolbarItem(this._reportSelector.comboBox());this._clearButton=new UI.ToolbarButton(Common.UIString('Clear all'),'largeicon-clear');toolbar.appendToolbarItem(this._clearButton);this._clearButton.addEventListener(UI.ToolbarButton.Events.Click,this._clearAll.bind(this));this._refreshToolbarUI();}
_renderStartView(){this._auditResultsElement.removeChildren();this._statusView.hide();this._reportSelector.selectNewAudit();this.contentElement.classList.toggle('in-progress',false);this._startView.show(this.contentElement);this._startView.setUnauditableExplanation(this._unauditableExplanation);this._startView.setStartButtonEnabled(!this._unauditableExplanation);if(!this._unauditableExplanation)
this._startView.focusStartButton();this._newButton.setEnabled(false);this._refreshToolbarUI();this.setDefaultFocusedChild(this._startView);}
_renderStatusView(inspectedURL){this.contentElement.classList.toggle('in-progress',true);this._statusView.setInspectedURL(inspectedURL);this._statusView.show(this.contentElement);}
_renderReport(lighthouseResult,artifacts){this.contentElement.classList.toggle('in-progress',false);this._startView.hideWidget();this._statusView.hide();this._auditResultsElement.removeChildren();this._newButton.setEnabled(true);this._refreshToolbarUI();const cachedRenderedReport=this._cachedRenderedReports.get(lighthouseResult);if(cachedRenderedReport){this._auditResultsElement.appendChild(cachedRenderedReport);return;}
const reportContainer=this._auditResultsElement.createChild('div','lh-vars lh-root lh-devtools');const dom=new DOM((this._auditResultsElement.ownerDocument));const renderer=new Audits2.ReportRenderer(dom);const templatesHTML=Runtime.cachedResources['audits2/lighthouse/templates.html'];const templatesDOM=new DOMParser().parseFromString(templatesHTML,'text/html');if(!templatesDOM)
return;renderer.setTemplateContext(templatesDOM);const el=renderer.renderReport(lighthouseResult,reportContainer);Audits2.ReportRenderer.addViewTraceButton(el,artifacts);Audits2.ReportRenderer.linkifyNodeDetails(el);this._cachedRenderedReports.set(lighthouseResult,reportContainer);}
_buildReportUI(lighthouseResult,artifacts){if(lighthouseResult===null)
return;const optionElement=new Audits2.ReportSelector.Item(lighthouseResult,()=>this._renderReport(lighthouseResult,artifacts),this._renderStartView.bind(this));this._reportSelector.prepend(optionElement);this._refreshToolbarUI();this._renderReport(lighthouseResult);}
_handleDrop(dataTransfer){const items=dataTransfer.items;if(!items.length)
return;const item=items[0];if(item.kind==='file'){const entry=items[0].webkitGetAsEntry();if(!entry.isFile)
return;entry.file(file=>{const reader=new FileReader();reader.onload=()=>this._loadedFromFile((reader.result));reader.readAsText(file);});}}
_loadedFromFile(report){const data=JSON.parse(report);if(!data['lighthouseVersion'])
return;this._buildReportUI((data));}
async _startAudit(){Host.userMetrics.actionTaken(Host.UserMetrics.Action.Audits2Started);try{const inspectedURL=await this._controller.getInspectedURL({force:true});const categoryIDs=this._controller.getCategoryIDs();const flags=this._controller.getFlags();await this._setupEmulationAndProtocolConnection();this._renderStatusView(inspectedURL);const lighthouseResponse=await this._protocolService.startLighthouse(inspectedURL,categoryIDs,flags);if(lighthouseResponse&&lighthouseResponse.fatal){const error=new Error(lighthouseResponse.message);error.stack=lighthouseResponse.stack;throw error;}
if(!lighthouseResponse)
throw new Error('Auditing failed to produce a result');Host.userMetrics.actionTaken(Host.UserMetrics.Action.Audits2Finished);await this._resetEmulationAndProtocolConnection();this._buildReportUI(lighthouseResponse.lhr,lighthouseResponse.artifacts);}catch(err){if(err instanceof Error)
this._statusView.renderBugReport(err);}}
async _cancelAudit(){this._statusView.updateStatus(ls`Cancelling`);await this._resetEmulationAndProtocolConnection();this._renderStartView();}
async _setupEmulationAndProtocolConnection(){const flags=this._controller.getFlags();const emulationModel=self.singleton(Emulation.DeviceModeModel);this._emulationEnabledBefore=emulationModel.enabledSetting().get();this._emulationOutlineEnabledBefore=emulationModel.deviceOutlineSetting().get();emulationModel.toolbarControlsEnabledSetting().set(false);if(flags.disableDeviceEmulation){emulationModel.enabledSetting().set(false);emulationModel.deviceOutlineSetting().set(false);emulationModel.emulate(Emulation.DeviceModeModel.Type.None,null,null);}else{emulationModel.enabledSetting().set(true);emulationModel.deviceOutlineSetting().set(true);for(const device of Emulation.EmulatedDevicesList.instance().standard()){if(device.title==='Nexus 5X')
emulationModel.emulate(Emulation.DeviceModeModel.Type.Device,device,device.modes[0],1);}}
await this._protocolService.attach();this._isLHAttached=true;}
async _resetEmulationAndProtocolConnection(){if(!this._isLHAttached)
return;this._isLHAttached=false;await this._protocolService.detach();const emulationModel=self.singleton(Emulation.DeviceModeModel);emulationModel.enabledSetting().set(this._emulationEnabledBefore);emulationModel.deviceOutlineSetting().set(this._emulationOutlineEnabledBefore);emulationModel.toolbarControlsEnabledSetting().set(true);Emulation.InspectedPagePlaceholder.instance().update(true);const resourceTreeModel=SDK.targetManager.mainTarget().model(SDK.ResourceTreeModel);const inspectedURL=await this._controller.getInspectedURL();await resourceTreeModel.navigate(inspectedURL);}};;Audits2.AuditController=class extends Common.Object{constructor(protocolService){super();protocolService.registerStatusCallback(message=>this.dispatchEventToListeners(Audits2.Events.AuditProgressChanged,{message}));for(const preset of Audits2.Presets)
preset.setting.addChangeListener(this.recomputePageAuditability.bind(this));SDK.targetManager.observeModels(SDK.ServiceWorkerManager,this);SDK.targetManager.addEventListener(SDK.TargetManager.Events.InspectedURLChanged,this.recomputePageAuditability,this);}
modelAdded(serviceWorkerManager){if(this._manager)
return;this._manager=serviceWorkerManager;this._serviceWorkerListeners=[this._manager.addEventListener(SDK.ServiceWorkerManager.Events.RegistrationUpdated,this.recomputePageAuditability,this),this._manager.addEventListener(SDK.ServiceWorkerManager.Events.RegistrationDeleted,this.recomputePageAuditability,this),];this.recomputePageAuditability();}
modelRemoved(serviceWorkerManager){if(this._manager!==serviceWorkerManager)
return;Common.EventTarget.removeEventListeners(this._serviceWorkerListeners);this._manager=null;this.recomputePageAuditability();}
_hasActiveServiceWorker(){if(!this._manager)
return false;const mainTarget=this._manager.target();if(!mainTarget)
return false;const inspectedURL=mainTarget.inspectedURL().asParsedURL();const inspectedOrigin=inspectedURL&&inspectedURL.securityOrigin();for(const registration of this._manager.registrations().values()){if(registration.securityOrigin!==inspectedOrigin)
continue;for(const version of registration.versions.values()){if(version.controlledClients.length>1)
return true;}}
return false;}
_hasAtLeastOneCategory(){return Audits2.Presets.some(preset=>preset.setting.get());}
_unauditablePageMessage(){if(!this._manager)
return null;const mainTarget=this._manager.target();const inspectedURL=mainTarget&&mainTarget.inspectedURL();if(inspectedURL&&!/^(http|chrome-extension)/.test(inspectedURL)){return Common.UIString('Can only audit HTTP/HTTPS pages and Chrome extensions. '+'Navigate to a different page to start an audit.');}
if(!Host.isUnderTest()&&!Runtime.queryParam('can_dock'))
return Common.UIString('Can only audit tabs. Navigate to this page in a separate tab to start an audit.');return null;}
async _evaluateInspectedURL(){const mainTarget=this._manager.target();const runtimeModel=mainTarget.model(SDK.RuntimeModel);const executionContext=runtimeModel&&runtimeModel.defaultExecutionContext();let inspectedURL=mainTarget.inspectedURL();if(!executionContext)
return inspectedURL;try{const result=await executionContext.evaluate({expression:'window.location.href',objectGroup:'audits',includeCommandLineAPI:false,silent:false,returnByValue:true,generatePreview:false},false,false);if(!result.exceptionDetails&&result.object){inspectedURL=result.object.value;result.object.release();}}catch(err){console.error(err);}
return inspectedURL;}
getFlags(){const flags={};for(const runtimeSetting of Audits2.RuntimeSettings)
runtimeSetting.setFlags(flags,runtimeSetting.setting.get());return flags;}
getCategoryIDs(){const categoryIDs=[];for(const preset of Audits2.Presets){if(preset.setting.get())
categoryIDs.push(preset.configID);}
return categoryIDs;}
async getInspectedURL(options){if(options&&options.force||!this._inspectedURL)
this._inspectedURL=await this._evaluateInspectedURL();return this._inspectedURL;}
recomputePageAuditability(){const hasActiveServiceWorker=this._hasActiveServiceWorker();const hasAtLeastOneCategory=this._hasAtLeastOneCategory();const unauditablePageMessage=this._unauditablePageMessage();let helpText='';if(hasActiveServiceWorker){helpText=Common.UIString('Multiple tabs are being controlled by the same service worker. '+'Close your other tabs on the same origin to audit this page.');}else if(!hasAtLeastOneCategory){helpText=Common.UIString('At least one category must be selected.');}else if(unauditablePageMessage){helpText=unauditablePageMessage;}
this.dispatchEventToListeners(Audits2.Events.PageAuditabilityChanged,{helpText});}};Audits2.Preset;Audits2.Presets=[{setting:Common.settings.createSetting('audits2.cat_perf',true),configID:'performance',title:'Performance',description:'How long does this app take to show content and become usable'},{setting:Common.settings.createSetting('audits2.cat_pwa',true),configID:'pwa',title:'Progressive Web App',description:'Does this page meet the standard of a Progressive Web App'},{setting:Common.settings.createSetting('audits2.cat_best_practices',true),configID:'best-practices',title:'Best practices',description:'Does this page follow best practices for modern web development'},{setting:Common.settings.createSetting('audits2.cat_a11y',true),configID:'accessibility',title:'Accessibility',description:'Is this page usable by people with disabilities or impairments'},{setting:Common.settings.createSetting('audits2.cat_seo',true),configID:'seo',title:'SEO',description:'Is this page optimized for search engine results ranking'},];Audits2.RuntimeSetting;Audits2.RuntimeSettings=[{setting:Common.settings.createSetting('audits2.device_type','mobile'),description:ls`Apply mobile emulation during auditing`,setFlags:(flags,value)=>{flags.disableDeviceEmulation=value==='desktop';},options:[{label:ls`Mobile`,value:'mobile'},{label:ls`Desktop`,value:'desktop'},],},{setting:Common.settings.createSetting('audits2.throttling','default'),setFlags:(flags,value)=>{switch(value){case'devtools':flags.throttlingMethod='devtools';break;case'off':flags.throttlingMethod='provided';break;default:flags.throttlingMethod='simulate';}},options:[{label:ls`Simulated Fast 3G, 4x CPU Slowdown`,value:'default',title:'Throttling is simulated, resulting in faster audit runs with similar measurement accuracy'},{label:ls`Applied Fast 3G, 4x CPU Slowdown`,value:'devtools',title:'Typical DevTools throttling, with actual traffic shaping and CPU slowdown applied'},{label:ls`No throttling`,value:'off',title:'No network or CPU throttling used. (Useful when not evaluating performance)'},],},{setting:Common.settings.createSetting('audits2.clear_storage',true),title:ls`Clear storage`,description:ls`Reset storage (localStorage, IndexedDB, etc) before auditing. (Good for performance & PWA testing)`,setFlags:(flags,value)=>{flags.disableStorageReset=!value;},},];Audits2.Events={PageAuditabilityChanged:Symbol('PageAuditabilityChanged'),AuditProgressChanged:Symbol('AuditProgressChanged'),RequestAuditStart:Symbol('RequestAuditStart'),RequestAuditCancel:Symbol('RequestAuditCancel'),};;Audits2.ReportSelector=class{constructor(renderNewAuditView){this._renderNewAuditView=renderNewAuditView;this._newAuditItem=createElement('option');this._comboBox=new UI.ToolbarComboBox(this._handleChange.bind(this),'audits2-report');this._comboBox.setTitle(ls`Reports`);this._comboBox.setMaxWidth(180);this._comboBox.setMinWidth(140);this._itemByOptionElement=new Map();this._setEmptyState();}
_setEmptyState(){this._comboBox.selectElement().removeChildren();this._comboBox.setEnabled(false);this._newAuditItem=createElement('option');this._newAuditItem.label=Common.UIString('(new audit)');this._comboBox.selectElement().appendChild(this._newAuditItem);this._comboBox.select(this._newAuditItem);}
_handleChange(event){const item=this._selectedItem();if(item)
item.select();else
this._renderNewAuditView();}
_selectedItem(){const option=this._comboBox.selectedOption();return this._itemByOptionElement.get(option);}
hasCurrentSelection(){return!!this._selectedItem();}
hasItems(){return this._itemByOptionElement.size>0;}
comboBox(){return this._comboBox;}
prepend(item){const optionEl=item.optionElement();const selectEl=this._comboBox.selectElement();this._itemByOptionElement.set(optionEl,item);selectEl.insertBefore(optionEl,selectEl.firstElementChild);this._comboBox.setEnabled(true);this._comboBox.select(optionEl);item.select();}
clearAll(){for(const elem of this._comboBox.options()){if(elem===this._newAuditItem)
continue;this._itemByOptionElement.get(elem).delete();this._itemByOptionElement.delete(elem);}
this._setEmptyState();}
downloadSelected(){const item=this._selectedItem();if(item)
item.download();}
selectNewAudit(){this._comboBox.select(this._newAuditItem);}};Audits2.ReportSelector.Item=class{constructor(lighthouseResult,renderReport,showLandingCallback){this._lighthouseResult=lighthouseResult;this._renderReport=renderReport;this._showLandingCallback=showLandingCallback;const url=new Common.ParsedURL(lighthouseResult.finalUrl);const timestamp=lighthouseResult.fetchTime;this._element=createElement('option');this._element.label=`${new Date(timestamp).toLocaleTimeString()} - ${url.domain()}`;}
select(){this._renderReport();}
optionElement(){return this._element;}
delete(){if(this._element)
this._element.remove();this._showLandingCallback();}
download(){const domain=new Common.ParsedURL(this._lighthouseResult.finalUrl).domain();const sanitizedDomain=domain.replace(/[^a-z0-9.-]+/gi,'_');const timestamp=this._lighthouseResult.fetchTime;const fileName=`${sanitizedDomain}-${new Date(timestamp).toISO8601Compact()}.json`;Workspace.fileManager.save(fileName,JSON.stringify(this._lighthouseResult),true);}};;Audits2.ReportRenderer=class extends ReportRenderer{static addViewTraceButton(el,artifacts){if(!artifacts||!artifacts.traces||!artifacts.traces.defaultPass)
return;const defaultPassTrace=artifacts.traces.defaultPass;const timelineButton=UI.createTextButton(Common.UIString('View Trace'),onViewTraceClick,'view-trace');el.querySelector('.lh-column').appendChild(timelineButton);return el;async function onViewTraceClick(){Host.userMetrics.actionTaken(Host.UserMetrics.Action.Audits2ViewTrace);await UI.inspectorView.showPanel('timeline');Timeline.TimelinePanel.instance().loadFromEvents(defaultPassTrace.traceEvents);}}
static async linkifyNodeDetails(el){const mainTarget=SDK.targetManager.mainTarget();const resourceTreeModel=mainTarget.model(SDK.ResourceTreeModel);await resourceTreeModel.once(SDK.ResourceTreeModel.Events.Load);const domModel=mainTarget.model(SDK.DOMModel);for(const origElement of el.getElementsByClassName('lh-node')){const detailsItem=origElement.dataset;if(!detailsItem.path)
continue;const nodeId=await domModel.pushNodeByPathToFrontend(detailsItem.path);if(!nodeId)
continue;const node=domModel.nodeForId(nodeId);if(!node)
continue;const element=await Common.Linkifier.linkify(node,({title:detailsItem.snippet}));origElement.title='';origElement.textContent='';origElement.appendChild(element);}}};class ReportUIFeatures{initFeatures(report){}};Audits2.StartView=class extends UI.Widget{constructor(controller){super();this.registerRequiredCSS('audits2/audits2StartView.css');this._controller=controller;this._render();}
_populateRuntimeSettingAsRadio(settingName,parentElement){const runtimeSetting=Audits2.RuntimeSettings.find(item=>item.setting.name===settingName);if(!runtimeSetting||!runtimeSetting.options)
throw new Error(`${settingName} is not a setting with options`);const control=new Audits2.RadioSetting(runtimeSetting.options,runtimeSetting.setting);control.element.title=runtimeSetting.description;parentElement.appendChild(control.element);}
_populateRuntimeSettingAsCheckbox(settingName,parentElement){const runtimeSetting=Audits2.RuntimeSettings.find(item=>item.setting.name===settingName);if(!runtimeSetting||!runtimeSetting.title)
throw new Error(`${settingName} is not a setting with a title`);runtimeSetting.setting.setTitle(runtimeSetting.title);const control=new UI.ToolbarSettingCheckbox(runtimeSetting.setting,runtimeSetting.description);parentElement.appendChild(control.element);}
_populateFormControls(fragment){const deviceTypeFormElements=fragment.$('device-type-form-elements');this._populateRuntimeSettingAsRadio('audits2.device_type',deviceTypeFormElements);const categoryFormElements=fragment.$('categories-form-elements');for(const preset of Audits2.Presets){preset.setting.setTitle(preset.title);const checkbox=new UI.ToolbarSettingCheckbox(preset.setting);const row=categoryFormElements.createChild('div','vbox audits2-launcher-row');row.title=preset.description;row.appendChild(checkbox.element);}
const throttlingFormElements=fragment.$('throttling-form-elements');this._populateRuntimeSettingAsRadio('audits2.throttling',throttlingFormElements);const otherFormElements=fragment.$('other-form-elements');this._populateRuntimeSettingAsCheckbox('audits2.clear_storage',otherFormElements);}
_render(){this._startButton=UI.createTextButton(ls`Run audits`,()=>this._controller.dispatchEventToListeners(Audits2.Events.RequestAuditStart),'audits2-start-button',true);this.setDefaultFocusedElement(this._startButton);const deviceIcon=UI.Icon.create('largeicon-phone');const categoriesIcon=UI.Icon.create('largeicon-checkmark');const throttlingIcon=UI.Icon.create('largeicon-settings-gear');const fragment=UI.Fragment.build`
      <div class="vbox audits2-start-view">
        <header>
          <div class="audits2-logo"></div>
          <div class="audits2-start-view-text">
            <h2>Audits</h2>
            <p>
              Identify and fix common problems that affect your site's performance, accessibility, and user experience.
              <span class="link" $="learn-more">Learn more</a>
            </p>
          </div>
        </header>
        <form>
          <div class="audits2-form-section">
            <div class="audits2-form-section-label">
              <i>${deviceIcon}</i>
              <div class="audits2-icon-label">Device</div>
            </div>
            <div class="audits2-form-elements" $="device-type-form-elements"></div>
          </div>
          <div class="audits2-form-section">
            <div class="audits2-form-section-label">
              <i>${categoriesIcon}</i>
              <div class="audits2-icon-label">Audits</div>
            </div>
            <div class="audits2-form-elements" $="categories-form-elements"></div>
          </div>
          <div class="audits2-form-section">
            <div class="audits2-form-section-label">
              <i>${throttlingIcon}</i>
              <div class="audits2-icon-label">Throttling</div>
            </div>
            <div class="audits2-form-elements" $="throttling-form-elements"></div>
          </div>
          <div class="audits2-form-section">
            <div class="audits2-form-section-label"></div>
            <div class="audits2-form-elements" $="other-form-elements"></div>
          </div>
          <div class="audits2-form-section">
            <div class="audits2-form-section-label"></div>
            <div class="audits2-form-elements audits2-start-button-container hbox">
              ${this._startButton}
              <div $="help-text" class="audits2-help-text hidden"></div>
            </div>
          </div>
        </form>
      </div>
    `;this._helpText=fragment.$('help-text');const learnMoreLink=fragment.$('learn-more');learnMoreLink.addEventListener('click',()=>InspectorFrontendHost.openInNewTab('https://developers.google.com/web/tools/lighthouse/'));this._populateFormControls(fragment);this.contentElement.appendChild(fragment.element());this.contentElement.style.overflow='auto';}
focusStartButton(){this._startButton.focus();}
setStartButtonEnabled(isEnabled){if(this._helpText)
this._helpText.classList.toggle('hidden',isEnabled);if(this._startButton)
this._startButton.disabled=!isEnabled;}
setUnauditableExplanation(text){if(this._helpText)
this._helpText.textContent=text;}};;Audits2.StatusView=class{constructor(controller){this._controller=controller;this._statusView=null;this._statusHeader=null;this._progressWrapper=null;this._progressBar=null;this._statusText=null;this._inspectedURL='';this._textChangedAt=0;this._fastFactsQueued=Audits2.StatusView.FastFacts.slice();this._currentPhase=null;this._scheduledTextChangeTimeout=null;this._scheduledFastFactTimeout=null;this._dialog=new UI.Dialog();this._dialog.setDimmed(true);this._dialog.setCloseOnEscape(false);this._dialog.setOutsideClickCallback(event=>event.consume(true));this._render();}
_render(){const dialogRoot=UI.createShadowRootWithCoreStyles(this._dialog.contentElement,'audits2/audits2Dialog.css');const auditsViewElement=dialogRoot.createChild('div','audits2-view vbox');const cancelButton=UI.createTextButton(ls`Cancel`,this._cancel.bind(this));const fragment=UI.Fragment.build`
      <div class="audits2-view vbox">
        <h2 $="status-header">Auditing your web page\u2026</h2>
        <div class="audits2-status vbox" $="status-view">
          <div class="audits2-progress-wrapper" $="progress-wrapper">
            <div class="audits2-progress-bar" $="progress-bar"></div>
          </div>
          <div class="audits2-status-text" $="status-text"></div>
        </div>
        ${cancelButton}
      </div>
    `;auditsViewElement.appendChild(fragment.element());auditsViewElement.tabIndex=0;this._statusView=fragment.$('status-view');this._statusHeader=fragment.$('status-header');this._progressWrapper=fragment.$('progress-wrapper');this._progressBar=fragment.$('progress-bar');this._statusText=fragment.$('status-text');this._dialog.setDefaultFocusedElement(cancelButton);this._dialog.setSizeBehavior(UI.GlassPane.SizeBehavior.SetExactWidthMaxHeight);this._dialog.setMaxContentSize(new UI.Size(500,400));}
_reset(){this._resetProgressBarClasses();clearTimeout(this._scheduledFastFactTimeout);this._textChangedAt=0;this._fastFactsQueued=Audits2.StatusView.FastFacts.slice();this._currentPhase=null;this._scheduledTextChangeTimeout=null;this._scheduledFastFactTimeout=null;}
show(dialogRenderElement){this._reset();this.updateStatus(ls`Loading\u2026`);const parsedURL=this._inspectedURL.asParsedURL();const pageHost=parsedURL&&parsedURL.host;const statusHeader=pageHost?ls`Auditing ${pageHost}`:ls`Auditing your web page`;this._statusHeader.textContent=`${statusHeader}\u2026`;this._dialog.show(dialogRenderElement);}
hide(){if(this._dialog.isShowing())
this._dialog.hide();}
setInspectedURL(url=''){this._inspectedURL=url;}
updateStatus(message){if(!message||!this._statusText)
return;if(message.startsWith('Cancel')){this._commitTextChange(Common.UIString('Cancelling\u2026'));clearTimeout(this._scheduledFastFactTimeout);return;}
const nextPhase=this._getPhaseForMessage(message);if(!nextPhase&&!this._currentPhase){this._commitTextChange(Common.UIString('Lighthouse is warming up\u2026'));clearTimeout(this._scheduledFastFactTimeout);}else if(nextPhase&&(!this._currentPhase||this._currentPhase.order<nextPhase.order)){this._currentPhase=nextPhase;this._scheduleTextChange(this._getMessageForPhase(nextPhase));this._scheduleFastFactCheck();this._resetProgressBarClasses();this._progressBar.classList.add(nextPhase.progressBarClass);}}
_cancel(){this._controller.dispatchEventToListeners(Audits2.Events.RequestAuditCancel);}
_getMessageForPhase(phase){if(phase.message)
return Common.UIString(phase.message);const deviceType=Audits2.RuntimeSettings.find(item=>item.setting.name==='audits2.device_type').setting.get();const throttling=Audits2.RuntimeSettings.find(item=>item.setting.name==='audits2.throttling').setting.get();const match=Audits2.StatusView.LoadingMessages.find(item=>{return item.deviceType===deviceType&&item.throttling===throttling;});return match?ls`${match.message}`:ls`Lighthouse is loading your page`;}
_getPhaseForMessage(message){return Audits2.StatusView.StatusPhases.find(phase=>message.startsWith(phase.statusMessagePrefix));}
_resetProgressBarClasses(){if(!this._progressBar)
return;this._progressBar.className='audits2-progress-bar';}
_scheduleFastFactCheck(){if(!this._currentPhase||this._scheduledFastFactTimeout)
return;this._scheduledFastFactTimeout=setTimeout(()=>{this._updateFastFactIfNecessary();this._scheduledFastFactTimeout=null;this._scheduleFastFactCheck();},100);}
_updateFastFactIfNecessary(){const now=performance.now();if(now-this._textChangedAt<Audits2.StatusView.fastFactRotationInterval)
return;if(!this._fastFactsQueued.length)
return;const fastFactIndex=Math.floor(Math.random()*this._fastFactsQueued.length);this._scheduleTextChange(ls`\ud83d\udca1 ${this._fastFactsQueued[fastFactIndex]}`);this._fastFactsQueued.splice(fastFactIndex,1);}
_commitTextChange(text){if(!this._statusText)
return;this._textChangedAt=performance.now();this._statusText.textContent=text;}
_scheduleTextChange(text){if(this._scheduledTextChangeTimeout)
clearTimeout(this._scheduledTextChangeTimeout);const msSinceLastChange=performance.now()-this._textChangedAt;const msToTextChange=Audits2.StatusView.minimumTextVisibilityDuration-msSinceLastChange;this._scheduledTextChangeTimeout=setTimeout(()=>{this._commitTextChange(text);},Math.max(msToTextChange,0));}
renderBugReport(err){console.error(err);clearTimeout(this._scheduledFastFactTimeout);clearTimeout(this._scheduledTextChangeTimeout);this._resetProgressBarClasses();this._progressBar.classList.add('errored');this._commitTextChange('');this._statusText.createTextChild(Common.UIString('Ah, sorry! We ran into an error: '));this._statusText.createChild('em').createTextChild(err.message);if(Audits2.StatusView.KnownBugPatterns.some(pattern=>pattern.test(err.message))){const message=Common.UIString('Try to navigate to the URL in a fresh Chrome profile without any other tabs or '+'extensions open and try again.');this._statusText.createChild('p').createTextChild(message);}else{this._renderBugReportLink(err,this._inspectedURL);}}
_renderBugReportLink(err,auditURL){const baseURI='https://github.com/GoogleChrome/lighthouse/issues/new?';const title=encodeURI('title=DevTools Error: '+err.message.substring(0,60));const issueBody=`
**Initial URL**: ${auditURL}
**Chrome Version**: ${navigator.userAgent.match(/Chrome\/(\S+)/)[1]}
**Error Message**: ${err.message}
**Stack Trace**:
\`\`\`
${err.stack}
\`\`\`
    `;const body='&body='+encodeURIComponent(issueBody.trim());const reportErrorEl=UI.XLink.create(baseURI+title+body,Common.UIString('Report this bug'),'audits2-link audits2-report-error');this._statusText.appendChild(reportErrorEl);}};Audits2.StatusView.KnownBugPatterns=[/PARSING_PROBLEM/,/DOCUMENT_REQUEST/,/READ_FAILED/,/TRACING_ALREADY_STARTED/,/^You must provide a url to the runner/,/^You probably have multiple tabs open/,];Audits2.StatusView.StatusPhases=[{id:'loading',progressBarClass:'loading',statusMessagePrefix:'Loading page',order:10,},{id:'gathering',progressBarClass:'gathering',message:'Lighthouse is gathering information about the page to compute your score.',statusMessagePrefix:'Retrieving',order:20,},{id:'auditing',progressBarClass:'auditing',message:'Almost there! Lighthouse is now generating your report.',statusMessagePrefix:'Evaluating',order:30,}];Audits2.StatusView.LoadingMessages=[{deviceType:'mobile',throttling:'on',message:'Lighthouse is loading your page with throttling to measure performance on a mobile device on 3G.',},{deviceType:'desktop',throttling:'on',message:'Lighthouse is loading your page with throttling to measure performance on a slow desktop on 3G.',},{deviceType:'mobile',throttling:'off',message:'Lighthouse is loading your page with mobile emulation.',},{deviceType:'desktop',throttling:'off',message:'Lighthouse is loading your page.',},];Audits2.StatusView.FastFacts=['1MB takes a minimum of 5 seconds to download on a typical 3G connection [Source: WebPageTest and DevTools 3G definition].','Rebuilding Pinterest pages for performance increased conversion rates by 15% [Source: WPO Stats]','BBC has seen a loss of 10% of their users for every extra second of page load [Source: WPO Stats]','By reducing the response size of JSON needed for displaying comments, Instagram saw increased impressions [Source: WPO Stats]','Walmart saw a 1% increase in revenue for every 100ms improvement in page load [Source: WPO Stats]','If a site takes >1 second to become interactive, users lose attention, and their perception of completing the page task is broken [Source: Google Developers Blog]','75% of global mobile users in 2016 were on 2G or 3G [Source: GSMA Mobile]','The average user device costs less than 200 USD. [Source: International Data Corporation]','53% of all site visits are abandoned if page load takes more than 3 seconds [Source: Google DoubleClick blog]','19 seconds is the average time a mobile web page takes to load on a 3G connection [Source: Google DoubleClick blog]','14 seconds is the average time a mobile web page takes to load on a 4G connection [Source: Google DoubleClick blog]','70% of mobile pages take nearly 7 seconds for the visual content above the fold to display on the screen. [Source: Think with Google]','As page load time increases from one second to seven seconds, the probability of a mobile site visitor bouncing increases 113%. [Source: Think with Google]','As the number of elements on a page increases from 400 to 6,000, the probability of conversion drops 95%. [Source: Think with Google]','70% of mobile pages weigh over 1MB, 36% over 2MB, and 12% over 4MB. [Source: Think with Google]','Lighthouse only simulates mobile performance; to measure performance on a real device, try WebPageTest.org [Source: Lighthouse team]',];Audits2.StatusView.fastFactRotationInterval=6000;Audits2.StatusView.minimumTextVisibilityDuration=3000;;Audits2.ProtocolService=class extends Common.Object{constructor(){super();this._rawConnection=null;this._backend=null;this._backendPromise=null;this._status=null;}
attach(){return SDK.interceptMainConnection(this._dispatchProtocolMessage.bind(this)).then(rawConnection=>{this._rawConnection=rawConnection;});}
startLighthouse(auditURL,categoryIDs,flags){return this._send('start',{url:auditURL,categoryIDs,flags});}
detach(){return Promise.resolve().then(()=>this._send('stop')).then(()=>this._backend.dispose()).then(()=>{delete this._backend;delete this._backendPromise;return this._rawConnection.disconnect();});}
registerStatusCallback(callback){this._status=callback;}
_dispatchProtocolMessage(message){this._send('dispatchProtocolMessage',{message:message});}
_initWorker(){this._backendPromise=Services.serviceManager.createAppService('audits2_worker','Audits2Service').then(backend=>{if(this._backend)
return;this._backend=backend;this._backend.on('statusUpdate',result=>this._status(result.message));this._backend.on('sendProtocolMessage',result=>this._sendProtocolMessage(result.message));});}
_sendProtocolMessage(message){this._rawConnection.sendRawMessage(message);}
_send(method,params){if(!this._backendPromise)
this._initWorker();return this._backendPromise.then(_=>this._backend.send(method,params));}};;Runtime.cachedResources["audits2/audits2Dialog.css"]="/*\n * Copyright 2017 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.audits2-view {\n    --view-horizontal-margin: 20px;\n    margin: 7px var(--view-horizontal-margin);\n    flex: auto;\n    align-items: center;\n    width: 100%;\n    max-width: 500px;\n}\n\n.audits2-view h2 {\n    color: #666;\n    font-weight: bold;\n    font-size: 14px;\n    flex: none;\n    width: 100%;\n    text-align: left;\n}\n\n.audits2-view button {\n    z-index: 10;\n}\n\n.audits2-status {\n    width: 100%;\n    flex: auto;\n    align-items: center;\n    color: #666;\n}\n\n.audits2-status-text {\n    text-align: center;\n    min-height: 50px;\n    margin-bottom: 10px;\n    display: flex;\n    justify-content: center;\n    flex-direction: column;\n}\n\n.audits2-progress-wrapper {\n    width: calc(100% + 2 * var(--view-horizontal-margin));\n    height: 2px;\n    background-color: #E1F5FE;\n    position: relative;\n    margin: 10px;\n}\n\n.audits2-progress-bar {\n    width: 0%;\n    height: 100%;\n    background: #039BE5;\n    position: absolute;\n    transform-origin: left;\n    animation-fill-mode: forwards;\n    animation-timing-function: ease-out;\n    --progress-bar-loading-duration: 45s;\n    --progress-bar-gathering-duration: 12s;\n    --progress-bar-gathering-percent: 70%;\n    --progress-bar-auditing-duration: 5s;\n    --progress-bar-auditing-percent: 95%;\n}\n\n.audits2-progress-bar.errored {\n    width: 100%;\n    background: #E50303;\n}\n\n.audits2-progress-bar.loading {\n    animation-duration: var(--progress-bar-loading-duration);\n    animation-name: progressBarLoading;\n}\n\n@keyframes progressBarLoading {\n  0% { width: 0%; }\n  100% { width: var(--progress-bar-gathering-percent); }\n}\n\n.audits2-progress-bar.gathering {\n    animation-duration: var(--progress-bar-gathering-duration);\n    animation-name: progressBarGathering;\n}\n\n@keyframes progressBarGathering {\n  0% { width: var(--progress-bar-gathering-percent); }\n  100% { width: var(--progress-bar-auditing-percent); }\n}\n\n.audits2-progress-bar.auditing {\n    animation-duration: var(--progress-bar-auditing-duration);\n    animation-name: progressBarAuditing;\n}\n\n@keyframes progressBarAuditing {\n  0% { width: var(--progress-bar-auditing-percent); }\n  100% { width: 99%; }\n}\n\n.audits2-report-error {\n    display: block;\n    margin-top: 5px;\n}\n\n/*# sourceURL=audits2/audits2Dialog.css */";Runtime.cachedResources["audits2/audits2StartView.css"]="/*\n * Copyright 2018 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.audits2-start-view {\n  font-family: Roboto, sans-serif;\n  font-size: 13px;\n  line-height: 18px;\n}\n\n.audits2-start-view header {\n  padding: 0 16px;\n  display: flex;\n}\n\n.audits2-logo {\n    width: 150px;\n    height: 150px;\n    flex-shrink: 0;\n    background-repeat: no-repeat;\n    background-size: contain;\n    margin-right: 20px;\n    background-image: url(Images/audits_logo.svg);\n}\n\n.audits2-start-view-text {\n  color: #757575;\n  margin-top: 24px;\n}\n\n.audits2-start-view-text h2 {\n  color: black;\n  font-weight: normal;\n  font-size: 18px;\n  margin-bottom: 12px;\n}\n\n.audits2-start-view-text p {\n  margin-top: 0;\n}\n\n.audits2-start-view form {\n  padding: 0 16px;\n}\n\n.audits2-form-section {\n  border-top: 1px solid #ebebeb;\n  display: flex;\n  padding: 16px 8px;\n}\n\n.audits2-form-section:last-child {\n  border-top: none;\n  padding-top: 0;\n}\n\n.audits2-form-section-label {\n  display: flex;\n  width: 160px;\n}\n\n.audits2-form-section-label i {\n  width: 16px;\n  height: 16px;\n  display: block;\n  text-align: center;\n}\n\n.audits2-icon-label {\n  margin: 0 14px;\n}\n\n.audits2-form-section-label i span {\n  position: relative;\n  top: -2px;\n}\n\n.audits2-form-section-label span.largeicon-checkmark {\n  top: -4px;\n}\n\n.audits2-radio {\n  display: block;\n  margin-bottom: 8px;\n}\n\n.audits2-radio:last-child {\n  margin-bottom: 0;\n}\n\n.audits2-start-button-container {\n  align-items: center;\n}\n\n.audits2-start-button {\n  max-width: 100px;\n}\n\n.audits2-start-view .toolbar-dropdown-arrow {\n  display: none;\n}\n\n.audits2-launcher-row {\n  padding-bottom: 8px;\n}\n\n.audits2-launcher-row:last-of-type {\n  padding-bottom: 0;\n}\n\n.audits2-launcher-row .dimmed {\n  padding-left: 22px;\n}\n\n.audits2-help-text {\n  color: red;\n  font-weight: bold;\n  padding-left: 10px;\n}\n/*# sourceURL=audits2/audits2StartView.css */";Runtime.cachedResources["audits2/audits2Panel.css"]="/*\n * Copyright 2017 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.toolbar {\n    background-color: var(--toolbar-bg-color);\n    border-bottom: var(--divider-border);\n}\n\n.lh-root {\n  --report-menu-width: 0;\n  user-select: text;\n  --lh-bg-color: #fff;\n  background-color: var(--lh-bg-color);\n}\n\n.-theme-with-dark-background .lh-root {\n  --header-bg-color: hsl(0, 0%, 20%);\n  --lh-table-header-bg: hsl(0, 0%, 20%);\n  --display-value-gray: hsl(0, 0%, 66%);\n  --medium-75-gray: hsl(0, 0%, 66%);\n\n  --subheader-color: hsl(210, 15%, 80%);\n  --lh-bg-color: hsl(0, 0%, 14%);\n  --secondary-text-color: hsl(0, 0%, 66%);\n  --report-secondary-border-color: hsl(0, 0%, 8%);\n}\n\n.-theme-with-dark-background .lh-root .lh-gauge {\n  --circle-background: hsl(0, 0%, 27%);\n  --inset-color: var(--lh-bg-color);\n}\n\n.lh-root .lh-container {\n  word-wrap: normal;\n}\n\n.lh-root pre {\n  word-wrap: break-word;\n}\n\n/* for View Trace button */\n.lh-audit-group {\n  position: relative;\n}\nbutton.view-trace {\n  margin: 10px;\n}\n\n.audits2-results-container {\n    overflow-y: scroll;\n    position: relative;\n}\n\n/* TODO(phulce): remove the below on next LH roll */\n\n.-theme-with-dark-background .lh-scores-wrapper__background, .-theme-with-dark-background .lh-scores-wrapper__shadow {\n  background: var(--lh-bg-color) !important;\n}\n\n.-theme-with-dark-background .lh-gauge__label {\n  color: hsl(210, 15%, 80%);\n}\n\n.-theme-with-dark-background .lh-root .lh-audit a, .-theme-with-dark-background .lh-footer a {\n  color: hsl(210, 90%, 60%);\n}\n\n.-theme-with-dark-background .lh-load-opportunity__header .lh-load-opportunity__col {\n  background: hsl(0, 0%, 20%);\n}\n\n.-theme-with-dark-background .lh-crc .crc-node__tree-hostname {\n  color: hsl(0, 0%, 66%);\n}\n\n.-theme-with-dark-background .lh-audit-group__header::before {\n  background-color: hsl(0, 0%, 80%);\n  filter: invert(1);\n}\n/*# sourceURL=audits2/audits2Panel.css */";Runtime.cachedResources["audits2/lighthouse/report-styles.css"]="/**\n * @license\n * Copyright 2017 Google Inc. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS-IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n.lh-vars {\n  --text-font-family: Roboto, Helvetica, Arial, sans-serif;\n  --monospace-font-family: 'Menlo', 'dejavu sans mono', 'Consolas', 'Lucida Console', monospace;\n  --body-background-color: #fff;\n  --body-font-size: 14px;\n  --body-line-height: 18px;\n  --subheader-font-size: 14px;\n  --subheader-line-height: 20px;\n  --subheader-color: hsl(206, 6%, 25%);\n  --header-bg-color: #f1f3f4;\n  --header-font-size: 20px;\n  --header-line-height: 24px;\n  --title-font-size: 24px;\n  --title-line-height: 28px;\n  --caption-font-size: 12px;\n  --caption-line-height: 16px;\n  --default-padding: 12px;\n  --section-padding: 16px;\n  --section-indent: 16px;\n  --audit-group-indent: 16px;\n  --audit-item-gap: 5px;\n  --audit-indent: 16px;\n  --text-indent: 8px;\n  --expandable-indent: 20px;\n  --secondary-text-color: #565656;\n  /*--accent-color: #3879d9;*/\n  --fail-color: hsl(1, 73%, 45%);\n  --average-color: hsl(31, 100%, 45%); /* md orange 800 */\n  --pass-color: hsl(139, 70%, 30%);\n  --informative-color: #0c50c7;\n  --medium-75-gray: #757575;\n  --medium-50-gray: hsl(210, 17%, 98%);\n  --medium-100-gray: hsl(200, 12%, 95%);\n  --warning-color: #ffab00; /* md amber a700 */\n  --report-border-color: #ccc;\n  --report-secondary-border-color: #ebebeb;\n  --metric-timeline-rule-color: #b3b3b3;\n  --display-value-gray: hsl(216, 5%, 39%);\n  --report-width: calc(60 * var(--body-font-size));\n  --report-min-width: 400px;\n  /* Edge doesn't support calc(var(calc())) */\n  --report-width-half: calc(30 * var(--body-font-size));\n  --report-header-height: 161px;\n  --report-header-color: #202124;\n  --navitem-font-size: var(--body-font-size);\n  --navitem-line-height: var(--body-line-height);\n  --navitem-hpadding: var(--body-font-size);\n  --navitem-vpadding: calc(var(--navitem-line-height) / 2);\n  --lh-score-highlight-bg: hsla(0, 0%, 90%, 0.2);\n  --lh-score-icon-background-size: 24px;\n  --lh-group-icon-background-size: var(--lh-score-icon-background-size);\n  --lh-score-margin: 12px;\n  --lh-table-header-bg: #f8f9fa;\n  --lh-table-higlight-bg: hsla(0, 0%, 75%, 0.1);\n  --lh-sparkline-height: 5px;\n  --lh-sparkline-thin-height: 3px;\n  --lh-filmstrip-thumbnail-width: 60px;\n  --lh-score-icon-width: calc(var(--body-font-size) / 14 * 16);\n  --lh-category-score-width: calc(5 * var(--body-font-size));\n  --lh-audit-vpadding: 8px;\n  --lh-audit-index-width: 18px;\n  --lh-audit-hgap: 12px;\n  --lh-audit-group-vpadding: 8px;\n  --lh-section-vpadding: 12px;\n  --chevron-size: 12px;\n  --circle-size: calc(3 * var(--header-font-size));\n\n  --pass-icon-url: url('data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 48 48\"><title>check</title><path fill=\"%23178239\" d=\"M24 4C12.95 4 4 12.95 4 24c0 11.04 8.95 20 20 20 11.04 0 20-8.96 20-20 0-11.05-8.96-20-20-20zm-4 30L10 24l2.83-2.83L20 28.34l15.17-15.17L38 16 20 34z\"/></svg>');\n  --average-icon-url: url('data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 48 48\"><title>info</title><path fill=\"%23E67700\" d=\"M24 4C12.95 4 4 12.95 4 24s8.95 20 20 20 20-8.95 20-20S35.05 4 24 4zm2 30h-4V22h4v12zm0-16h-4v-4h4v4z\"/></svg>');\n  --fail-icon-url: url('data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 48 48\"><title>warn</title><path fill=\"%23C7221F\" d=\"M2 42h44L24 4 2 42zm24-6h-4v-4h4v4zm0-8h-4v-8h4v8z\"/></svg>');\n\n  --content-paste-icon-url: url('data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24\" height=\"24\"><path fill=\"%235E6268\" d=\"M19 2h-4.18C14.4.84 13.3 0 12 0c-1.3 0-2.4.84-2.82 2H5c-1.1 0-2 .9-2 2v16c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-7 0c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zm7 18H5V4h2v3h10V4h2v16z\"/><path d=\"M0 0h24v24H0z\" fill=\"none\"/></svg>');\n  --av-timer-icon-url: url('data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24\" height=\"24\" fill=\"%235E6268\"><path d=\"M0 0h24v24H0z\" fill=\"none\"/><path d=\"M15 1H9v2h6V1zm-4 13h2V8h-2v6zm8.03-6.61l1.42-1.42c-.43-.51-.9-.99-1.41-1.41l-1.42 1.42A8.962 8.962 0 0 0 12 4c-4.97 0-9 4.03-9 9s4.02 9 9 9a8.994 8.994 0 0 0 7.03-14.61zM12 20c-3.87 0-7-3.13-7-7s3.13-7 7-7 7 3.13 7 7-3.13 7-7 7z\"/></svg>');\n  --photo-filter-icon-url: url('data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"48\" height=\"48\"><path fill=\"none\" d=\"M0 0h48v48H0V0z\"/><path d=\"M38.04 20v18H10V10h18V6H10.04c-2.2 0-4 1.8-4 4v28c0 2.2 1.8 4 4 4h28c2.2 0 4-1.8 4-4V20h-4zM34 20l1.88-4.12L40 14l-4.12-1.88L34 8l-1.88 4.12L28 14l4.12 1.88zm-7.5 1.5L24 16l-2.5 5.5L16 24l5.5 2.5L24 32l2.5-5.5L32 24z\" fill=\"%235E6268\"/></svg>');\n  --visibility-icon-url: url('data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"48\" height=\"48\"><path d=\"M0 0h48v48H0z\" fill=\"none\"/><path d=\"M24 9C14 9 5.46 15.22 2 24c3.46 8.78 12 15 22 15 10.01 0 18.54-6.22 22-15-3.46-8.78-11.99-15-22-15zm0 25c-5.52 0-10-4.48-10-10s4.48-10 10-10 10 4.48 10 10-4.48 10-10 10zm0-16c-3.31 0-6 2.69-6 6s2.69 6 6 6 6-2.69 6-6-2.69-6-6-6z\" fill=\"%235E6268\"/></svg>');\n  --check-circle-icon-url: url('data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"48\" height=\"48\"><path d=\"M0 0h48v48H0z\" fill=\"none\"/><path d=\"M24 4C12.95 4 4 12.95 4 24c0 11.04 8.95 20 20 20 11.04 0 20-8.96 20-20 0-11.05-8.96-20-20-20zm-4 30L10 24l2.83-2.83L20 28.34l15.17-15.17L38 16 20 34z\" fill=\"%235E6268\"/></svg>');\n  --check-icon-url: url('data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"48\" height=\"48\"><path d=\"M0 0h48v48H0z\" fill=\"none\"/><path d=\"M18 32.34L9.66 24l-2.83 2.83L18 38l24-24-2.83-2.83z\"/></svg>');\n\n  --warning-icon-url: url('data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 48 48\"><title>warn</title><path fill=\"%235E6268\" d=\"M2 42h44L24 4 2 42zm24-6h-4v-4h4v4zm0-8h-4v-8h4v8z\"/></svg>');\n  --search-icon-url: url('data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"48\" height=\"48\"><path d=\"M31 28h-1.59l-.55-.55C30.82 25.18 32 22.23 32 19c0-7.18-5.82-13-13-13S6 11.82 6 19s5.82 13 13 13c3.23 0 6.18-1.18 8.45-3.13l.55.55V31l10 9.98L40.98 38 31 28zm-12 0a9 9 0 1 1 .001-18.001A9 9 0 0 1 19 28z\" fill=\"%235E6268\"/><path d=\"M0 0h48v48H0z\" fill=\"none\" /></svg>');\n  --remove-circle-icon-url: url('data:image/svg+xml;utf8,<svg height=\"24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M0 0h24v24H0z\" fill=\"none\"/><path d=\"M7 11v2h10v-2H7zm5-9C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8z\" fill=\"%235E6268\"/></svg>');\n\n  --pwa-fast-reliable-gray-url: url('data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\"><g fill=\"none\" fill-rule=\"nonzero\"><circle fill=\"%23DAE0E3\" cx=\"12\" cy=\"12\" r=\"12\"/><path d=\"M12.3 4l6.3 2.8V11c0 3.88-2.69 7.52-6.3 8.4C8.69 18.52 6 14.89 6 11V6.8L12.3 4zm-.56 12.88l3.3-5.79.04-.08c.05-.1.01-.29-.26-.29h-1.96l.56-3.92h-.56L9.6 12.52c0 .03.07-.12-.03.07-.11.2-.12.37.2.37h1.97l-.56 3.92h.56z\" fill=\"%23FFF\"/></g></svg>');\n  --pwa-installable-gray-url: url('data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\"><g fill=\"none\" fill-rule=\"nonzero\"><circle fill=\"%23DAE0E3\" cx=\"12\" cy=\"12\" r=\"12\"/><path d=\"M12 5a7 7 0 1 0 0 14 7 7 0 0 0 0-14zm3.5 7.7h-2.8v2.8h-1.4v-2.8H8.5v-1.4h2.8V8.5h1.4v2.8h2.8v1.4z\" fill=\"%23FFF\"/></g></svg>');\n  --pwa-optimized-gray-url: url('data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\"><g fill=\"none\" fill-rule=\"evenodd\"><rect fill=\"%23DAE0E3\" width=\"24\" height=\"24\" rx=\"12\"/><path fill=\"%23FFF\" d=\"M12 15.07l3.6 2.18-.95-4.1 3.18-2.76-4.2-.36L12 6.17l-1.64 3.86-4.2.36 3.2 2.76-.96 4.1z\"/><path d=\"M5 5h14v14H5z\"/></g></svg>');\n\n  --pwa-fast-reliable-color-url: url('data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"nonzero\" fill=\"none\"><circle fill=\"%23CCE3F6\" cx=\"12\" cy=\"12\" r=\"12\"/><path d=\"M12 4.3l6.3 2.8v4.2c0 3.88-2.69 7.52-6.3 8.4-3.61-.88-6.3-4.51-6.3-8.4V7.1L12 4.3zm-.56 12.88l3.3-5.79.04-.08c.05-.1.01-.29-.26-.29h-1.96l.56-3.92h-.56L9.3 12.82c0 .03.07-.12-.03.07-.11.2-.12.37.2.37h1.97l-.56 3.92h.56z\" fill=\"%23304FFE\"/></g></svg>');\n  --pwa-installable-color-url: url('data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"nonzero\" fill=\"none\"><circle fill=\"%23D4ECD5\" cx=\"12\" cy=\"12\" r=\"12\"/><path d=\"M12 5a7 7 0 1 0 0 14 7 7 0 0 0 0-14zm3.5 7.7h-2.8v2.8h-1.4v-2.8H8.5v-1.4h2.8V8.5h1.4v2.8h2.8v1.4z\" fill=\"%23009688\"/></g></svg>');\n  --pwa-optimized-color-url: url('data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\"><g fill=\"none\" fill-rule=\"evenodd\"><rect fill=\"%23FCE4EC\" width=\"24\" height=\"24\" rx=\"12\"/><path d=\"M5 5h14v14H5z\"/><path fill=\"%23EC3F7A\" d=\"M12 15.07l3.6 2.18-.95-4.1 3.18-2.76-4.2-.36L12 6.17l-1.64 3.86-4.2.36 3.2 2.76-.96 4.1z\"/></g></svg>');\n}\n\n.lh-vars.lh-devtools {\n  --text-font-family: '.SFNSDisplay-Regular', 'Helvetica Neue', 'Lucida Grande', sans-serif;\n  --monospace-font-family: 'Menlo', 'dejavu sans mono', 'Consolas', 'Lucida Console', monospace;\n  --body-font-size: 12px;\n  --body-line-height: 16px;\n  --subheader-font-size: 14px;\n  --subheader-line-height: 18px;\n  --header-font-size: 16px;\n  --header-line-height: 20px;\n  --title-font-size: 20px;\n  --title-line-height: 24px;\n  --caption-font-size: 11px;\n  --caption-line-height: 14px;\n  --default-padding: 12px;\n  --section-padding: 12px;\n  --section-indent: 8px;\n  --audit-group-indent: 16px;\n  --audit-indent: 16px;\n  --expandable-indent: 16px;\n\n  --lh-audit-vpadding: 4px;\n  --lh-audit-hgap: 12px;\n  --lh-audit-group-vpadding: 12px;\n  --lh-section-vpadding: 8px;\n}\n\n@keyframes fadeIn {\n  0% { opacity: 0;}\n  100% { opacity: 0.6;}\n}\n\n.lh-root * {\n  box-sizing: border-box;\n}\n\n.lh-root {\n  font-family: var(--text-font-family);\n  font-size: var(--body-font-size);\n  margin: 0;\n  line-height: var(--body-line-height);\n  background: var(--body-background-color);\n  scroll-behavior: smooth;\n}\n\n.lh-root :focus {\n    outline: -webkit-focus-ring-color auto 3px;\n}\n.lh-root summary:focus {\n    outline: none;\n    box-shadow: 0 0 0 1px hsl(217, 89%, 61%);\n}\n\n.lh-root [hidden] {\n  display: none !important;\n}\n\n.lh-root details > summary {\n  cursor: pointer;\n}\n\n.lh-audit-group a,\n.lh-category-header__description a {\n  color: #0c50c7;\n}\n\n.lh-audit__description {\n  --inner-audit-left-padding: calc(var(--text-indent) + var(--lh-audit-index-width) + 2 * var(--audit-item-gap));\n  --inner-audit-right-padding: calc(var(--text-indent) + 2px);\n  padding-left: var(--inner-audit-left-padding);\n  padding-right: var(--inner-audit-right-padding);\n  padding-top: 8px;\n  padding-bottom: 8px;\n}\n\n.lh-details {\n  font-size: var(--body-font-size);\n  margin-top: var(--default-padding);\n  margin-bottom: var(--default-padding);\n  /* whatever the .lh-details side margins are */\n  width: 100%;\n}\n\n.lh-details.flex .lh-code {\n  max-width: 70%;\n}\n\n/* Report header */\n\n.report-icon {\n  opacity: 0.7;\n}\n.report-icon:hover {\n  opacity: 1;\n}\n.report-icon[disabled] {\n  opacity: 0.3;\n  pointer-events: none;\n}\n\n.report-icon--share {\n  background-image: url('data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24\" height=\"24\" viewBox=\"0 0 24 24\"><path fill=\"none\" d=\"M0 0h24v24H0z\"/><path d=\"M18 16.08c-.76 0-1.44.3-1.96.77L8.91 12.7c.05-.23.09-.46.09-.7s-.04-.47-.09-.7l7.05-4.11c.54.5 1.25.81 2.04.81 1.66 0 3-1.34 3-3s-1.34-3-3-3-3 1.34-3 3c0 .24.04.47.09.7L8.04 9.81C7.5 9.31 6.79 9 6 9c-1.66 0-3 1.34-3 3s1.34 3 3 3c.79 0 1.5-.31 2.04-.81l7.12 4.16c-.05.21-.08.43-.08.65 0 1.61 1.31 2.92 2.92 2.92 1.61 0 2.92-1.31 2.92-2.92s-1.31-2.92-2.92-2.92z\"/></svg>');\n}\n.report-icon--print {\n  background-image: url('data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24\" height=\"24\" viewBox=\"0 0 24 24\"><path d=\"M19 8H5c-1.66 0-3 1.34-3 3v6h4v4h12v-4h4v-6c0-1.66-1.34-3-3-3zm-3 11H8v-5h8v5zm3-7c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm-1-9H6v4h12V3z\"/><path fill=\"none\" d=\"M0 0h24v24H0z\"/></svg>');\n}\n.report-icon--copy {\n  background-image: url('data:image/svg+xml;utf8,<svg height=\"24\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M0 0h24v24H0z\" fill=\"none\"/><path d=\"M16 1H4c-1.1 0-2 .9-2 2v14h2V3h12V1zm3 4H8c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h11c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm0 16H8V7h11v14z\"/></svg>');\n}\n.report-icon--open {\n  background-image: url('data:image/svg+xml;utf8,<svg height=\"24\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M0 0h24v24H0z\" fill=\"none\"/><path d=\"M19 4H5c-1.11 0-2 .9-2 2v12c0 1.1.89 2 2 2h4v-2H5V8h14v10h-4v2h4c1.1 0 2-.9 2-2V6c0-1.1-.89-2-2-2zm-7 6l-4 4h3v6h2v-6h3l-4-4z\"/></svg>');\n}\n.report-icon--download {\n  background-image: url('data:image/svg+xml;utf8,<svg height=\"24\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M19 9h-4V3H9v6H5l7 7 7-7zM5 18v2h14v-2H5z\"/><path d=\"M0 0h24v24H0z\" fill=\"none\"/></svg>');\n}\n\n/* Node */\n.lh-node {\n  display: block;\n  font-family: var(--monospace-font-family);\n  word-break: break-word;\n  color: hsl(174, 100%, 27%);\n}\n.lh-node:hover {\n    background: hsl(0, 0%, 98%);\n    border-radius: 2px;\n}\n\n/* Score */\n\n.lh-audit__score-icon {\n  margin-left: var(--lh-score-margin);\n  width: var(--lh-score-icon-width);\n  height: var(--lh-score-icon-width);\n  background: none no-repeat center center / contain;\n}\n\n.lh-audit--pass .lh-audit__display-text {\n  color: var(--pass-color);\n}\n.lh-audit--pass .lh-audit__score-icon {\n  background-image: var(--pass-icon-url);\n}\n\n.lh-audit--average .lh-audit__display-text {\n  color: var(--average-color);\n}\n.lh-audit--average .lh-audit__score-icon {\n  background-image: var(--average-icon-url);\n}\n\n.lh-audit--fail .lh-audit__display-text {\n  color: var(--fail-color);\n}\n.lh-audit--fail .lh-audit__score-icon {\n  background-image: var(--fail-icon-url);\n}\n\n.lh-audit--informative .lh-audit__display-text {\n  color: var(--display-value-gray);\n}\n\n.lh-audit--informative .lh-audit__score-icon,\n.lh-audit--manual .lh-audit__score-icon {\n  visibility: hidden;\n}\n.lh-audit--error .lh-audit__score-icon {\n  display: none;\n}\n\n.lh-category-header__description,\n.lh-audit__description   {\n  color: var(--secondary-text-color);\n}\n\n.lh-category-header__description  {\n  font-size: var(--body-font-size);\n  margin: calc(var(--default-padding) / 2) 0 var(--default-padding);\n}\n\n\n.lh-audit__index,\n.lh-audit__title,\n.lh-audit__display-text,\n.lh-audit__score-icon,\n.lh-load-opportunity__sparkline,\n.lh-chevron-container {\n  margin: 0 var(--audit-item-gap);\n}\n.lh-audit__index {\n  margin-left: 0;\n}\n.lh-chevron-container {\n  margin-right: 0;\n}\n\n\n.lh-audit__header .lh-audit__index {\n  width: var(--lh-audit-index-width);\n}\n\n.lh-audit__title {\n  flex: 1;\n}\n\n/* Expandable Details (Audit Groups, Audits) */\n.lh-audit__header {\n  display: flex;\n  padding: var(--lh-audit-vpadding) var(--text-indent);\n}\n\n.lh-audit--load-opportunity .lh-audit__header {\n  display: block;\n}\n\n.lh-audit__header:hover {\n  background-color: #F8F9FA;\n}\n\n/* Hide the expandable arrow icon, three ways: via the CSS Counter Styles spec, for webkit/blink browsers, hiding the polyfilled icon */\n/* https://github.com/javan/details-element-polyfill/blob/master/src/details-element-polyfill/polyfill.sass */\n.lh-audit-group > summary,\n.lh-expandable-details > summary {\n  list-style-type: none;\n}\n.lh-audit-group > summary::-webkit-details-marker,\n.lh-expandable-details > summary::-webkit-details-marker {\n  display: none;\n}\n.lh-audit-group > summary:before,\n.lh-expandable-details > summary:before {\n  display: none;\n}\n\n\n/* Perf Metric */\n\n.lh-columns {\n  display: flex;\n  width: 100%;\n}\n@media screen and (max-width: 640px) {\n  .lh-columns {\n    flex-wrap: wrap;\n\n  }\n}\n\n.lh-column {\n  flex: 1;\n}\n.lh-column:first-of-type {\n  margin-right: 24px;\n}\n\n@media screen and (max-width: 800px) {\n  .lh-column:first-of-type {\n    margin-right: 8px;\n  }\n}\n@media screen and (max-width: 640px) {\n  .lh-column {\n    flex-basis: 100%;\n  }\n  .lh-column:first-of-type {\n    margin-right: 0px;\n  }\n}\n\n\n.lh-metric {\n  border-bottom: 1px solid var(--report-secondary-border-color);\n}\n\n.lh-metric__innerwrap {\n  display: flex;\n  justify-content: space-between;\n  padding: 8px var(--text-indent);\n}\n\n.lh-metric__details {\n  order: -1;\n}\n\n.lh-metric__title {\n  font-size: var(--body-font-size);\n  line-height: var(--body-line-height);\n  display: flex;\n  white-space: nowrap;\n}\n\n.lh-metric__name {\n  flex: 1;\n}\n\n.lh-metrics__disclaimer {\n  color: var(--medium-75-gray);\n  text-align: right;\n  margin: var(--lh-section-vpadding) 0;\n  padding: 0 var(--text-indent);\n}\n\n.lh-metric__description {\n  color: var(--secondary-text-color);\n}\n\n.lh-metric__value {\n  white-space: nowrap; /* No wrapping between metric value and the icon */\n}\n\n\n.lh-metric .lh-metric__value::after {\n  content: '';\n  width: var(--lh-score-icon-width);\n  height: var(--lh-score-icon-width);\n  background-size: contain;\n  display: inline-block;\n  vertical-align: text-bottom;\n  margin-left: calc(var(--body-font-size) / 2);\n}\n\n.lh-metric--pass .lh-metric__value {\n  color: var(--pass-color);\n}\n.lh-metric--pass .lh-metric__value::after {\n  background: var(--pass-icon-url) no-repeat 50% 50%;\n}\n\n\n.lh-metric--average .lh-metric__value {\n  color: var(--average-color);\n  padding-left: 16px;\n}\n.lh-metric--average .lh-metric__value::after {\n  background: var(--average-icon-url) no-repeat 50% 50%;\n}\n\n\n.lh-metric--fail .lh-metric__value {\n  color: var(--fail-color);\n}\n.lh-metric--fail .lh-metric__value::after {\n  background: var(--fail-icon-url) no-repeat 50% 50%;\n}\n\n.lh-metric--error .lh-metric__value,\n.lh-metric--error .lh-metric__description {\n  color: var(--fail-color);\n}\n\n/* Hide icon if there was an error */\n.lh-metric--error .lh-metric__value::after {\n  display: none;\n}\n\n/* Perf load opportunity */\n\n.lh-load-opportunity__cols {\n  display: flex;\n  align-items: flex-start;\n}\n\n.lh-load-opportunity__header .lh-load-opportunity__col {\n  background-color: var(--medium-50-gray);\n  color: var(--medium-75-gray);\n  text-align: center;\n  display: unset;\n  line-height: calc(2.3 * var(--body-font-size));\n}\n\n.lh-load-opportunity__col {\n  display: flex;\n  justify-content: space-between;\n}\n\n.lh-load-opportunity__col--one {\n  flex: 5;\n  margin-right: 2px;\n}\n.lh-load-opportunity__col--two {\n  flex: 4;\n}\n\n.lh-audit--load-opportunity .lh-audit__display-text {\n  text-align: right;\n  flex: 0 0 calc(3 * var(--body-font-size));\n}\n\n\n/* Sparkline */\n\n.lh-load-opportunity__sparkline {\n  flex: 1;\n  margin-top: calc((var(--body-line-height) - var(--lh-sparkline-height)) / 2);\n}\n\n.lh-sparkline {\n  height: var(--lh-sparkline-height);\n  width: 100%;\n}\n\n.lh-sparkline__bar {\n  height: 100%;\n  float: right;\n}\n\n.lh-audit--pass .lh-sparkline__bar {\n  background: var(--pass-color);\n}\n\n.lh-audit--average .lh-sparkline__bar {\n  background: var(--average-color);\n}\n\n.lh-audit--fail .lh-sparkline__bar {\n  background: var(--fail-color);\n}\n\n\n\n/* Filmstrip */\n\n.lh-filmstrip-container {\n  padding: 0 var(--expandable-indent);\n  /* smaller gap between metrics and filmstrip */\n  margin: -8px auto 0 auto;\n}\n\n.lh-filmstrip {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n  padding-bottom: var(--default-padding);\n}\n\n.lh-filmstrip__frame {\n  text-align: right;\n  position: relative;\n}\n\n.lh-filmstrip__thumbnail {\n  border: 1px solid var(--report-secondary-border-color);\n  max-height: 100px;\n  max-width: 60px;\n}\n\n@media screen and (max-width: 750px) {\n  .lh-filmstrip {\n    flex-wrap: wrap;\n    justify-content: left;\n  }\n  .lh-filmstrip__frame {\n    margin: calc(var(--default-padding) / 3);\n  }\n}\n\n/* Audit */\n\n.lh-audit {\n  border-bottom: 1px solid var(--report-secondary-border-color);\n}\n\n.lh-audit--error .lh-audit__display-text {\n  color: var(--fail-color);\n}\n\n/* Audit Group */\n\n.lh-audit-group {\n  margin: var(--lh-audit-group-vpadding) 0;\n}\n\n.lh-audit-group__header {\n  font-size: var(--subheader-font-size);\n  line-height: var(--subheader-line-height);\n  color: var(--subheader-color);\n  flex: 1;\n  font-weight: bold;\n}\n\n.lh-audit-group__header::before {\n  /* By default, groups don't get an icon */\n  content: none;\n  width: calc(var(--subheader-font-size) / 14 * 24);\n  height: calc(var(--subheader-font-size) / 14 * 24);\n  margin-right: calc(var(--subheader-font-size) / 2);\n  background: var(--medium-100-gray) none no-repeat center / 16px;\n  display: inline-block;\n  border-radius: 50%;\n  vertical-align: middle;\n}\n\n.lh-clump--warning > summary .lh-audit-group__header::before {\n  content: '';\n  background-image: var(--warning-icon-url);\n}\n.lh-clump--manual > summary .lh-audit-group__header::before {\n  content: '';\n  background-image: var(--search-icon-url);\n}\n.lh-clump--passed > summary .lh-audit-group__header::before {\n  content: '';\n  background-image: var(--check-icon-url);\n}\n.lh-clump--notapplicable > summary .lh-audit-group__header::before {\n  content: '';\n  background-image: var(--remove-circle-icon-url);\n}\n\n.lh-audit-group--diagnostics .lh-audit-group__header::before {\n  content: '';\n  background-image: var(--content-paste-icon-url);\n}\n.lh-audit-group--load-opportunities .lh-audit-group__header::before {\n  content: '';\n  background-image: var(--photo-filter-icon-url);\n}\n.lh-audit-group--metrics .lh-audit-group__header::before {\n  content: '';\n  background-image: var(--av-timer-icon-url);\n}\n\n.lh-audit-group--pwa-fast-reliable .lh-audit-group__header::before {\n  content: '';\n  background-image: var(--pwa-fast-reliable-gray-url);\n  background-size: var(--lh-group-icon-background-size);\n}\n.lh-audit-group--pwa-installable .lh-audit-group__header::before {\n  content: '';\n  background-image: var(--pwa-installable-gray-url);\n  background-size: var(--lh-group-icon-background-size);\n}\n.lh-audit-group--pwa-optimized .lh-audit-group__header::before {\n  content: '';\n  background-image: var(--pwa-optimized-gray-url);\n  background-size: var(--lh-group-icon-background-size);\n}\n.lh-audit-group--pwa-fast-reliable.lh-badged .lh-audit-group__header::before {\n  background-image: var(--pwa-fast-reliable-color-url);\n}\n.lh-audit-group--pwa-installable.lh-badged .lh-audit-group__header::before {\n  background-image: var(--pwa-installable-color-url);\n}\n.lh-audit-group--pwa-optimized.lh-badged .lh-audit-group__header::before {\n  background-image: var(--pwa-optimized-color-url);\n}\n\n/* Removing too much whitespace */\n.lh-audit-group--metrics {\n  margin-top: calc(var(--circle-size)/2 * -1);\n  border-bottom: none;\n}\n.lh-audit-group--metrics .lh-audit-group__summary {\n  margin-top: 0;\n  margin-bottom: 0;\n}\n\n.lh-audit-group__summary {\n  display: flex;\n  justify-content: space-between;\n  padding-right: var(--text-indent);\n  margin-top: calc(var(--section-padding) * 1.5);\n  margin-bottom: var(--section-padding);\n}\n\n.lh-audit-group__itemcount {\n  color: var(--display-value-gray);\n  margin: 3px 10px 0;\n}\n.lh-audit-group__summary .lh-chevron {\n  margin-top: calc((var(--body-line-height) - 5px) / 2);\n}\n\n.lh-audit-group__description {\n  font-size: var(--body-font-size);\n  color: var(--medium-75-gray);\n  margin: 0 0 var(--lh-audit-group-vpadding);\n}\n\n.lh-clump > .lh-audit-group__description,\n.lh-audit-group--diagnostics .lh-audit-group__description,\n.lh-audit-group--load-opportunities .lh-audit-group__description,\n.lh-audit-group--metrics .lh-audit-group__description,\n.lh-audit-group--pwa-fast-reliable .lh-audit-group__description,\n.lh-audit-group--pwa-installable .lh-audit-group__description,\n.lh-audit-group--pwa-optimized .lh-audit-group__description {\n  margin-top: var(--lh-audit-group-vpadding);\n}\n\n.lh-audit-explanation {\n  margin: var(--lh-audit-vpadding) 0 calc(var(--lh-audit-vpadding) / 2);\n  line-height: var(--caption-line-height);\n}\n\n.lh-audit--fail .lh-audit-explanation {\n  color: var(--fail-color);\n}\n\n/* Report */\n\n.lh-container {\n  display: flex;\n  max-width: var(--report-width);\n  word-wrap: break-word;\n  margin: 0 auto;\n}\n\n.lh-header-sticky {\n  position: -webkit-sticky;\n  position: sticky;\n  top: 0;\n  width: 100%;\n  min-width: var(--report-min-width);\n  z-index: 2;\n  will-change: transform;\n}\n.lh-header-plain {\n  margin-top: var(--section-padding);\n}\n\n.lh-header-container {\n  display: block;\n  margin: 0 auto;\n  max-width: var(--report-width);\n  position: relative;\n  word-wrap: break-word;\n}\n\n.lh-report {\n  background-color: #fff;\n  min-width: var(--report-min-width);\n}\n@media screen {\n  .lh-report {\n    width: var(--report-width);\n  }\n}\n\n.lh-exception {\n  font-size: large;\n}\n\n.lh-code {\n  white-space: normal;\n  margin-top: 0;\n  font-size: 85%;\n  word-break: break-word;\n}\n\n.lh-warnings {\n  --item-margin: calc(var(--body-line-height) / 6);\n  border: 1px solid var(--average-color);\n  border-radius: 4px;\n  margin: var(--lh-audit-vpadding) 0;\n  padding: calc(var(--lh-audit-vpadding) / 2) var(--lh-audit-vpadding);\n}\n\n.lh-warnings--toplevel {\n  --item-margin: calc(var(--header-line-height) / 4);\n  color: var(--secondary-text-color);\n  margin: var(--section-padding);\n  padding: var(--section-padding);\n}\n.lh-warnings ul {\n  padding-left: calc(var(--section-padding) * 2);\n  margin: 0;\n}\n.lh-warnings li {\n  margin: var(--item-margin) 0;\n}\n.lh-warnings li:last-of-type {\n  margin-bottom: 0;\n}\n\n.lh-scores-header {\n  display: flex;\n  justify-content: left;\n  overflow-x: hidden;\n  position: relative;\n  padding: var(--section-indent) calc(var(--section-indent) / 2) calc(var(--section-indent) * 2);\n}\n.lh-scores-header__solo {\n  padding: 0;\n  border: 0;\n}\n\n.lh-scores-header .lh-gauge__wrapper,\n.lh-scores-header .lh-gauge--pwa__wrapper {\n  padding: 0 4px;\n}\n\n.lh-scores-header .lh-gauge--pwa__wrapper {\n  border-left: 1px solid var(--report-secondary-border-color)\n}\n\n.lh-scorescale {\n  color: var(--medium-75-gray);\n  padding: 0 calc(var(--section-indent) * 1.5) 0;\n  text-align: right;\n  transform-origin: bottom right;\n  will-change: opacity; /* opacity is changed on scroll */\n}\n\n.lh-scorescale-range {\n  margin-left: 10px;\n  white-space: nowrap;\n}\n\n.lh-scorescale-range::before {\n  content: '';\n  width: var(--body-font-size);\n  height: calc(var(--body-font-size) * .60);\n  border-radius: 4px;\n  display: inline-block;\n  margin: 0 5px;\n}\n\n.lh-scorescale-range--pass::before {\n  background-color: var(--pass-color);\n}\n\n.lh-scorescale-range--average::before {\n  background-color: var(--average-color);\n}\n\n.lh-scorescale-range--fail::before {\n  background-color: var(--fail-color);\n}\n\n/* Hide category score gauages if it's a single category report */\n.lh-header--solo-category .lh-scores-wrapper {\n  display: none;\n}\n\n\n.lh-categories {\n  width: 100%;\n  overflow: hidden;\n}\n\n.lh-category {\n  padding: var(--section-padding);\n}\n\n.lh-category:first-of-type {\n  padding-top: calc(2 * var(--section-padding));\n  border: none;\n}\n\n/* section hash link jump should preserve fixed header\n   https://css-tricks.com/hash-tag-links-padding/\n*/\n.lh-category > .lh-permalink {\n  margin-top: calc((var(--report-header-height) + var(--default-padding)) * -1);\n  padding-bottom: calc(var(--report-header-height) + var(--default-padding));\n  display: block;\n  visibility: hidden;\n}\n\n.lh-category-header {\n  font-size: var(--header-font-size);\n  min-height: var(--circle-size);\n  margin-bottom: var(--lh-section-vpadding);\n}\n\n.lh-category-header__title {\n  line-height: 24px;\n}\n\n.lh-category-header .lh-score__gauge .lh-gauge__label {\n  display: none;\n}\n\n\n.lh-category-header .lh-score__gauge {\n  float: right;\n}\n\n.lh-category-header .lh-score__gauge {\n  margin-left: var(--section-indent);\n}\n\n.lh-category-header .lh-audit__title {\n  font-size: var(--header-font-size);\n  line-height: var(--header-line-height);\n}\n\n#lh-log {\n  position: fixed;\n  background-color: #323232;\n  color: #fff;\n  min-height: 48px;\n  min-width: 288px;\n  padding: 16px 24px;\n  box-shadow: 0 2px 5px 0 rgba(0, 0, 0, 0.26);\n  border-radius: 2px;\n  margin: 12px;\n  font-size: 14px;\n  cursor: default;\n  transition: transform 0.3s, opacity 0.3s;\n  transform: translateY(100px);\n  opacity: 0;\n  -webkit-font-smoothing: antialiased;\n  bottom: 0;\n  left: 0;\n  z-index: 3;\n}\n\n#lh-log.show {\n  opacity: 1;\n  transform: translateY(0);\n}\n\n/* 964 fits the min-width of the filmstrip */\n@media screen and (max-width: 964px) {\n  .lh-report {\n    margin-left: 0;\n    width: 100%;\n  }\n}\n\n@media print {\n  body {\n    -webkit-print-color-adjust: exact; /* print background colors */\n  }\n  .lh-container {\n    display: block;\n  }\n  .lh-report {\n    margin-left: 0;\n    padding-top: 0;\n  }\n  .lh-categories {\n    margin-top: 0;\n  }\n}\n\n.lh-table {\n  --image-preview-size: 24px;\n  border-collapse: collapse;\n}\n\n.lh-table thead {\n  background: var(--lh-table-header-bg);\n}\n.lh-table thead th {\n  color: var(--medium-75-gray);\n  font-weight: normal;\n  word-wrap: normal;\n}\n\n.lh-table tbody tr:nth-child(even) {\n  background-color: var(--lh-table-higlight-bg);\n}\n\n.lh-table th,\n.lh-table td {\n  padding: 8px 6px;\n}\n\n/* Looks unnecessary, but mostly for keeping the <th>s left-aligned */\n.lh-table-column--text,\n.lh-table-column--url,\n/* .lh-table-column--thumbnail, */\n/* .lh-table-column--empty,*/\n.lh-table-column--code,\n.lh-table-column--node {\n  text-align: left;\n}\n\n.lh-table-column--bytes,\n.lh-table-column--timespanMs,\n.lh-table-column--ms,\n.lh-table-column--numeric {\n  text-align: right;\n}\n\n\n.lh-table-column--thumbnail {\n  width: calc(var(--image-preview-size) * 2);\n}\n\n.lh-table-column--url {\n  min-width: 250px;\n  white-space: nowrap;\n}\n\n/* Keep columns narrow if they follow the URL column */\n/* 12% was determined to be a decent narrow width, but wide enough for column headings */\n.lh-table-column--url + th.lh-table-column--bytes,\n.lh-table-column--url + .lh-table-column--bytes + th.lh-table-column--bytes,\n.lh-table-column--url + .lh-table-column--ms,\n.lh-table-column--url + .lh-table-column--ms + th.lh-table-column--bytes,\n.lh-table-column--url + .lh-table-column--bytes + th.lh-table-column--timespanMs {\n  width: 12%;\n}\n\n.lh-text__url {\n  overflow: hidden;\n  text-overflow: ellipsis;\n}\n\n.lh-text__url:hover {\n  text-decoration: underline dotted #999;\n  text-decoration-skip-ink: auto;\n}\n\n.lh-text__url > .lh-text, .lh-text__url-host {\n  display: inline-block;\n}\n\n.lh-text__url-host {\n  margin-left: calc(var(--body-font-size) / 2);\n  opacity: 0.6;\n  font-size: 90%\n}\n\n.lh-thumbnail {\n  height: var(--image-preview-size);\n  width: var(--image-preview-size);\n  object-fit: contain;\n}\n\n/* Chevron\n   https://codepen.io/paulirish/pen/LmzEmK\n */\n.lh-chevron {\n  --chevron-angle: 42deg;\n  /* Edge doesn't support transform: rotate(calc(...)), so we define it here */\n  --chevron-angle-right: -42deg;\n  width: var(--chevron-size);\n  height: var(--chevron-size);\n  margin-top: calc((var(--body-line-height) - 12px) / 2);\n}\n\n.lh-chevron__lines {\n  transition: transform 0.4s;\n  transform: translateY(var(--body-line-height));\n}\n.lh-chevron__line {\n stroke: var(--display-value-gray);\n stroke-width: var(--chevron-size);\n stroke-linecap: square;\n transform-origin: 50%;\n transform: rotate(var(--chevron-angle));\n transition: transform 300ms, stroke 300ms;\n}\n\n.lh-audit-group > summary > .lh-audit-group__summary > .lh-chevron .lh-chevron__line-right,\n.lh-audit-group[open] > summary > .lh-audit-group__summary > .lh-chevron .lh-chevron__line-left,\n.lh-audit > .lh-expandable-details .lh-chevron__line-right,\n.lh-audit > .lh-expandable-details[open] .lh-chevron__line-left {\n transform: rotate(var(--chevron-angle-right));\n}\n\n.lh-audit-group[open] > summary > .lh-audit-group__summary > .lh-chevron .lh-chevron__line-right,\n.lh-audit > .lh-expandable-details[open] .lh-chevron__line-right {\n  transform: rotate(var(--chevron-angle));\n}\n\n.lh-audit-group[open] > summary > .lh-audit-group__summary > .lh-chevron .lh-chevron__lines,\n.lh-audit > .lh-expandable-details[open] .lh-chevron__lines {\n transform: translateY(calc(var(--chevron-size) * -1));\n}\n\n\n\n/* Tooltip */\n.tooltip-boundary {\n  position: relative;\n}\n\n.tooltip {\n  position: absolute;\n  display: none; /* Don't retain these layers when not needed */\n  opacity: 0;\n  background: #ffffff;\n  min-width: 246px;\n  max-width: 275px;\n  padding: 15px;\n  border-radius: 5px;\n  text-align: initial;\n}\n/* shrink tooltips to not be cutoff on left edge of narrow viewports\n   45vw is chosen to be ~= width of the left column of metrics\n*/\n@media screen and (max-width: 535px) {\n  .tooltip {\n    min-width: 45vw;\n    padding: 3vw;\n  }\n}\n\n.tooltip-boundary:hover {\n  background-color: #F8F9FA;\n}\n\n.tooltip-boundary:hover .tooltip {\n  display: block;\n  animation: fadeInTooltip 250ms;\n  animation-fill-mode: forwards;\n  animation-delay: 850ms;\n  bottom: 100%;\n  z-index: 1;\n  will-change: opacity;\n  right: 0;\n  pointer-events: none;\n}\n\n.tooltip::before {\n  content: \"\";\n  border: solid transparent;\n  border-bottom-color: #fff;\n  border-width: 10px;\n  position: absolute;\n  bottom: -20px;\n  right: 6px;\n  transform: rotate(180deg);\n  pointer-events: none;\n}\n\n@keyframes fadeInTooltip {\n  0% { opacity: 0; }\n  75% { opacity: 1; }\n  100% { opacity: 1;  filter: drop-shadow(1px 0px 1px #aaa) drop-shadow(0px 2px 4px hsla(206, 6%, 25%, 0.15)); pointer-events: auto; }\n}\n\n/*# sourceURL=audits2/lighthouse/report-styles.css */";Runtime.cachedResources["audits2/lighthouse/templates.html"]="<!--\n@license\nCopyright 2018 Google Inc. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\nhttp://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS-IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n-->\n\n<!-- Lighthouse run warnings -->\n<template id=\"tmpl-lh-warnings--toplevel\">\n  <div class=\"lh-warnings lh-warnings--toplevel\">\n    <strong class=\"lh-warnings__msg\"></strong>\n    <ul></ul>\n  </div>\n</template>\n\n<!-- Lighthouse score scale -->\n<template id=\"tmpl-lh-scorescale\">\n  <div class=\"lh-scorescale\">\n    <span class=\"lh-scorescale-label\"></span>\n    <span class=\"lh-scorescale-range lh-scorescale-range--pass\">90-100</span>\n    <span class=\"lh-scorescale-range lh-scorescale-range--average\">50-89</span>\n    <span class=\"lh-scorescale-range lh-scorescale-range--fail\">0-49</span>\n  </div>\n</template>\n\n<!-- Toggle arrow chevron -->\n<template id=\"tmpl-lh-chevron\">\n  <svg class=\"lh-chevron\" title=\"See audits\" xmlns=\"http://www.w3.org/2000/svg\"  viewbox=\"0 0 100 100\">\n    <g class=\"lh-chevron__lines\">\n      <path class=\"lh-chevron__line lh-chevron__line-left\" d=\"M10 50h40\" stroke=\"#707173\"></path>\n      <path class=\"lh-chevron__line lh-chevron__line-right\" d=\"M90 50H50\" stroke=\"#707173\"></path>\n    </g>\n  </svg>\n</template>\n\n<!-- Lighthouse category header -->\n<template id=\"tmpl-lh-category-header\">\n  <div class=\"lh-category-header\">\n    <div class=\"lh-score__gauge\"></div>\n    <span class=\"lh-category-header__title\"></span>\n    <div class=\"lh-category-header__description\"></div>\n  </div>\n</template>\n\n<!-- Lighthouse clump -->\n<template id=\"tmpl-lh-clump\">\n  <!-- TODO: group classes shouldn't be reused for clumps. -->\n  <details class=\"lh-clump lh-audit-group\">\n    <summary>\n      <div class=\"lh-audit-group__summary\">\n        <div class=\"lh-audit-group__header\"></div>\n        <div class=\"lh-audit-group__itemcount\"></div>\n        <div class=\"\"></div>\n      </div>\n    </summary>\n  </details>\n</template>\n\n<!-- Lighthouse audit -->\n<template id=\"tmpl-lh-audit\">\n  <div class=\"lh-audit\">\n    <details class=\"lh-expandable-details\">\n      <summary>\n        <div class=\"lh-audit__header lh-expandable-details__summary\">\n          <span class=\"lh-audit__index\"></span>\n          <span class=\"lh-audit__title\"></span>\n          <span class=\"lh-audit__display-text\"></span>\n          <div class=\"lh-audit__score-icon\"></div>\n          <div class=\"lh-chevron-container\"></div>\n        </div>\n      </summary>\n      <div class=\"lh-audit__description\"></div>\n    </details>\n  </div>\n</template>\n\n<!-- Lighthouse perf metric -->\n<template id=\"tmpl-lh-metric\">\n  <div class=\"lh-metric\">\n    <div class=\"lh-metric__innerwrap tooltip-boundary\">\n      <span class=\"lh-metric__title\"></span>\n      <div class=\"lh-metric__value\"></div>\n      <div class=\"lh-metric__description tooltip\"></div>\n    </div>\n  </div>\n</template>\n\n<!-- Lighthouse perf opportunity -->\n<template id=\"tmpl-lh-opportunity\">\n  <div class=\"lh-audit lh-audit--load-opportunity\">\n    <details class=\"lh-expandable-details\">\n        <summary>\n          <div class=\"lh-audit__header lh-expandable-details__summary\">\n            <div class=\"lh-load-opportunity__cols\">\n              <div class=\"lh-load-opportunity__col lh-load-opportunity__col--one\">\n                <span class=\"lh-audit__index\"></span>\n                <div class=\"lh-audit__title\"></div>\n              </div>\n              <div class=\"lh-load-opportunity__col lh-load-opportunity__col--two\">\n                <div class=\"lh-load-opportunity__sparkline\">\n                  <div class=\"lh-sparkline\"><div class=\"lh-sparkline__bar\"></div></div>\n                </div>\n                <div class=\"lh-audit__display-text\"></div>\n                <div class=\"lh-chevron-container\" title=\"See resources\"></div>\n              </div>\n            </div>\n          </div>\n        </summary>\n      <div class=\"lh-audit__description\"></div>\n    </details>\n  </div>\n</template>\n\n\n<!-- Lighthouse perf opportunity header -->\n<template id=\"tmpl-lh-opportunity-header\">\n  <div class=\"lh-load-opportunity__header lh-load-opportunity__cols\">\n    <div class=\"lh-load-opportunity__col lh-load-opportunity__col--one\"></div>\n    <div class=\"lh-load-opportunity__col lh-load-opportunity__col--two\"></div>\n  </div>\n</template>\n\n\n<!-- Lighthouse score container -->\n<template id=\"tmpl-lh-scores-wrapper\">\n  <style>\n    .lh-scores-wrapper__background,\n    .lh-scores-wrapper__shadow {\n      position: absolute;\n      top: 0;\n      left: 0;\n      width: 100%;\n      height: 100%;\n      background: white;\n      border-radius: 8px;\n    }\n    .lh-scores-wrapper__shadow {\n      border-radius: 0;\n      box-shadow: rgba(0, 0, 0, 0.2) 0px 3px 0px -2px\n    }\n    .lh-scores-container {\n      padding-bottom: calc(var(--section-indent) / 2);\n      position: relative;\n      width: 100%;\n    }\n  </style>\n  <div class=\"lh-scores-wrapper\">\n    <div class=\"lh-scores-container\">\n      <div class=\"lh-scores-wrapper__background\"></div>\n      <div class=\"lh-scores-wrapper__shadow\"></div>\n    </div>\n  </div>\n</template>\n\n\n<!-- Lighthouse header -->\n<template id=\"tmpl-lh-heading\">\n  <style>\n    :root {\n      --report-header-overlap-top: 30px;\n    }\n    .lh-header-bg {\n      background-color: var(--header-bg-color);\n      height: var(--report-header-height);\n      left: 0;\n      position: absolute;\n      top: 0;\n      width: 100%;\n      will-change: transform;\n      contain: strict;\n    }\n    .lh-lighthouse {\n      position: absolute;\n      bottom: -4px;\n      right: 0;\n      opacity: 1;\n      transform-origin: bottom right;\n      will-change: transform, opacity;\n    }\n    .lh-header {\n      width: 100%;\n      height: var(--report-header-height);\n      max-width: 100%; /* support text-overflow on url */\n      position: relative;\n    }\n    .lh-metadata {\n      flex: 1 1 0;\n      padding: calc(var(--section-padding) / 2);\n      padding-left: var(--section-indent);\n      line-height: 20px;\n      color: var(--report-header-color);\n      z-index: 1;\n      position: relative;\n      max-width: 60%;\n    }\n    .lh-metadata__results {\n      text-overflow: ellipsis;\n      white-space: nowrap;\n    }\n    .lh-metadata__url {\n      color: currentColor;\n    }\n    .lh-scores-wrapper {\n      margin-top: -30px;\n    }\n    .lh-scores-wrapper__shadow {\n      opacity: 0;\n    }\n    .lh-scores-wrapper__background,\n    .lh-scores-wrapper__shadow {\n      box-shadow: 0 1px 3px 1px rgba(0, 0, 0, 0.1);\n      border-radius: 8px;\n      will-change: opacity, transform;\n      transform-origin: top;\n    }\n\n    .lh-product-info, .lh-toolbar__metadata {\n      align-items: center;\n      white-space: nowrap;\n      color: #5F6369;\n      display: flex;\n      font-size: calc(var(--body-font-size) * 0.9);\n      margin-left: var(--section-indent);\n      opacity: 0;\n      transform: translateY(-50%);\n      will-change: opacity;\n    }\n    .lh-product-info__icon {\n      height: 20px;\n      margin-right: var(--default-padding);\n    }\n    .lh-toolbar {\n      height: 50px;\n      position: absolute;\n      top: 25px;\n      will-change: transform;\n      display: flex;\n      width: calc(100% - 70px);  /* give room for export */\n    }\n    .lh-toolbar__metadata {\n      overflow: hidden;\n      text-overflow: ellipsis;\n      width: 100%;\n    }\n    .lh-toolbar__url {\n      color: currentColor;\n      display: block;\n      white-space: nowrap;\n      margin-right: 2px;\n    }\n    .lh-export {\n      position: absolute;\n      right: var(--section-indent);\n      transform: translateY(0);\n      top: calc(var(--section-padding) / 2);\n      will-change: transform;\n      z-index: 2;\n    }\n    .lh-export__button {\n      background-color: #fff;\n      border: 1px solid #dadada;\n      border-radius: 2px;\n      cursor: pointer;\n      outline: none;\n      height: 32px;\n      width: 48px;\n      background-repeat: no-repeat;\n      background-size: 20px;\n      background-position: 50% 50%;\n      will-change: transform;\n    }\n    .lh-export__button:focus,\n    .lh-export__button.active {\n      box-shadow: 1px 1px 3px #ccc;\n    }\n    .lh-export__button.active + .lh-export__dropdown {\n      opacity: 1;\n      clip: rect(0, 164px, 200px, 0);\n    }\n    .lh-export__dropdown {\n      position: absolute;\n      background-color: #fff;\n      border: 1px solid var(--report-border-color);\n      border-radius: 3px;\n      padding: calc(var(--default-padding) / 2) 0;\n      cursor: pointer;\n      top: 36px;\n      right: 0;\n      box-shadow: 1px 1px 3px #ccc;\n      min-width: 125px;\n      clip: rect(0, 164px, 0, 0);\n      opacity: 0;\n      transition: all 200ms cubic-bezier(0,0,0.2,1);\n    }\n    .lh-export__dropdown a {\n      display: block;\n      color: currentColor;\n      text-decoration: none;\n      white-space: nowrap;\n      padding: 0 12px;\n      line-height: 2;\n    }\n    .lh-export__dropdown a:hover,\n    .lh-export__dropdown a:focus {\n      background-color: #efefef;\n      outline: none;\n    }\n    .lh-export__dropdown .report-icon {\n      cursor: pointer;\n      background-repeat: no-repeat;\n      background-position: 8px 50%;\n      background-size: 18px;\n      background-color: transparent;\n      text-indent: 18px;\n    }\n    /* copy icon needs slight adjustments to look great */\n    .lh-export__dropdown .report-icon--copy {\n      background-size: 16px;\n      background-position: 9px 50%;\n    }\n    /* save-as-gist option hidden in report */\n    .lh-export__dropdown .lh-export--gist {\n      display: none;\n    }\n    .lh-config {\n      color: var(--secondary-text-color);\n    }\n    .lh-config__timestamp {\n      font-size: var(--caption-font-size);\n      display: block;\n    }\n    a.lh-config__emulation {\n      color: inherit;\n      text-decoration: none;\n    }\n    @media screen and (max-width: 964px) {\n      .lh-export__dropdown {\n        right: 0;\n        left: initial;\n      }\n    }\n    @media print {\n      .lh-header {\n        position: static;\n        margin-left: 0;\n      }\n    }\n/*\n    TODO: Enable animating the clouds\n    .lh-lighthouse__clouds {\n      animation: panacross 30s linear infinite;\n      animation-play-state: paused;\n    }\n    @keyframes panacross {\n      0% { transform: translateX(0px); }\n      77% { transform: translateX(-680px); }\n      77.0001% { transform: translateX(195px); }\n      100% { transform: translateX(0px); }\n    } */\n\n    .score100 .lh-header-bg {\n      background-color: hsl(234, 64%, 19%);\n    }\n    .score100 .lh-metadata, .score100 .lh-toolbar__metadata, .score100 .lh-product-info {\n      color: #fff;\n    }\n    .score100 .lh-config {\n      color: #eee;\n    }\n\n    /* CSS Fireworks. Originally by Eddie Lin\n       https://codepen.io/paulirish/pen/yEVMbP\n    */\n    .pyro {\n      display: none;\n    }\n    .score100 .pyro {\n      display: block;\n    }\n    .score100 .lh-lighthouse stop:first-child {\n      stop-color: hsla(200, 12%, 95%, 0);\n    }\n    .score100 .lh-lighthouse stop:last-child {\n      stop-color: hsla(65, 81%, 76%, 1);\n    }\n\n    .pyro > .before, .pyro > .after {\n      position: absolute;\n      width: 5px;\n      height: 5px;\n      border-radius: 2.5px;\n      box-shadow: 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff, 0 0 #fff;\n      animation: 1s bang ease-out infinite backwards,  1s gravity ease-in infinite backwards,  5s position linear infinite backwards;\n      animation-delay: 1s, 1s, 1s;\n    }\n\n    .pyro > .after {\n      animation-delay: 2.25s, 2.25s, 2.25s;\n      animation-duration: 1.25s, 1.25s, 6.25s;\n    }\n    .fireworks-paused .pyro > div {\n      animation-play-state: paused;\n    }\n\n    @keyframes bang {\n      to {\n        box-shadow: -70px -115.67px #47ebbc, -28px -99.67px #eb47a4, 58px -31.67px #7eeb47, 13px -141.67px #eb47c5, -19px 6.33px #7347eb, -2px -74.67px #ebd247, 24px -151.67px #eb47e0, 57px -138.67px #b4eb47, -51px -104.67px #479eeb, 62px 8.33px #ebcf47, -93px 0.33px #d547eb, -16px -118.67px #47bfeb, 53px -84.67px #47eb83, 66px -57.67px #eb47bf, -93px -65.67px #91eb47, 30px -13.67px #86eb47, -2px -59.67px #83eb47, -44px 1.33px #eb47eb, 61px -58.67px #47eb73, 5px -22.67px #47e8eb, -66px -28.67px #ebe247, 42px -123.67px #eb5547, -75px 26.33px #7beb47, 15px -52.67px #a147eb, 36px -51.67px #eb8347, -38px -12.67px #eb5547, -46px -59.67px #47eb81, 78px -114.67px #eb47ba, 15px -156.67px #eb47bf, -36px 1.33px #eb4783, -72px -86.67px #eba147, 31px -46.67px #ebe247, -68px 29.33px #47e2eb, -55px 19.33px #ebe047, -56px 27.33px #4776eb, -13px -91.67px #eb5547, -47px -138.67px #47ebc7, -18px -96.67px #eb47ac, 11px -88.67px #4783eb, -67px -28.67px #47baeb, 53px 10.33px #ba47eb, 11px 19.33px #5247eb, -5px -11.67px #eb4791, -68px -4.67px #47eba7, 95px -37.67px #eb478b, -67px -162.67px #eb5d47, -54px -120.67px #eb6847, 49px -12.67px #ebe047, 88px 8.33px #47ebda, 97px 33.33px #eb8147, 6px -71.67px #ebbc47;\n      }\n    }\n    @keyframes gravity {\n      to {\n        transform: translateY(80px);\n        opacity: 0;\n      }\n    }\n    @keyframes position {\n      0%, 19.9% {\n        margin-top: 4%;\n        margin-left: 47%;\n      }\n      20%, 39.9% {\n        margin-top: 7%;\n        margin-left: 30%;\n      }\n      40%, 59.9% {\n        margin-top: 6%;\n        margin-left: 70%;\n      }\n      60%, 79.9% {\n        margin-top: 3%;\n        margin-left: 20%;\n      }\n      80%, 99.9% {\n        margin-top: 3%;\n        margin-left: 80%;\n      }\n    }\n  </style>\n  <div class=\"lh-header-bg\">\n    <div class=\"pyro\">\n      <div class=\"before\"></div>\n      <div class=\"after\"></div>\n    </div>\n  </div>\n  \n\n  <div class=\"lh-header-container\">\n    <div class=\"lh-header\">\n      <div class=\"lh-lighthouse\">\n        <svg width=\"217\" height=\"148\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\">\n          <defs>\n            <mask id=\"a\" x=\"-56\" y=\"-54\" width=\"284\" height=\"202\" maskUnits=\"userSpaceOnUse\">\n              <path d=\"M-56-54h284v202H-56z\" fill=\"#fff\"></path>\n            </mask>\n            <linearGradient id=\"b\" x1=\"-525.16\" y1=\"560.08\" x2=\"-524.23\" y2=\"560.08\" gradientTransform=\"matrix(91 0 0 -77 47797 43181)\" gradientUnits=\"userSpaceOnUse\">\n              <stop offset=\"0\" stop-color=\"#FFFFFF00\"/>\n              <stop offset=\"1\" stop-color=\"#FFFFFF\"/>\n            </linearGradient>\n          </defs>\n          <g mask=\"url(#a)\">\n            <!-- lighthouse building elements -->\n            <path d=\"M95 47h24v2H95z\" fill=\"#ec5548\"/>\n            <path d=\"M95 59h24v7H95z\" fill=\"#ec5548\"/>\n            <path d=\"M97.63 66h19.74l2.63 47H95z\" fill=\"#fff\"/>\n            <path d=\"M107 38a10 10 0 0 1 10 10v1H97v-1a10 10 0 0 1 10-10zM96.77 82.23l21-10.7.63 11.87-22.31 11.87zM95 110.8L119.1 98l.9 14H95z\" fill=\"#ec5548\"/>\n            <path d=\"M0 148a177.58 177.58 0 0 1 217 0z\" fill=\"#e8eaed\"/>\n            <!-- lighthouse beam elements -->\n            <path d=\"M98 49h18v11H98z\" fill=\"#fbc21b\"/>\n            <path d=\"M103 49a5 5 0 0 1 5 5 5 5 0 0 1-5 5 5 5 0 0 1-5-5 5 5 0 0 1 5-5z\" fill=\"#fef0c8\"/>\n            <path d=\"M7 16l91 33.18v10L7 93z\" fill=\"url(#b)\"/>\n          </g>\n          <g mask=\"url(#a)\" class=\"lh-lighthouse__clouds\">\n            <path d=\"M60 .19A9.77 9.77 0 0 1 61.93 0a9.44 9.44 0 0 1 9.24 7.83A7.24 7.24 0 0 1 79 14.45v.73A7.37 7.37 0 0 1 76.2 21h-31a7.44 7.44 0 0 1-1.2-4.09 7.31 7.31 0 0 1 7.26-7.36 6.84 6.84 0 0 1 1.28.1v-.11A9.51 9.51 0 0 1 60 .19m79.78 22.31h-17.9a4.37 4.37 0 0 1-.63-2.25 4.2 4.2 0 0 1 4.16-4.25 4.37 4.37 0 0 1 .72.06V16a5.35 5.35 0 0 1 10.64-1h.33a4.2 4.2 0 0 1 4.15 4.25 4.29 4.29 0 0 1-1.47 3.25zM163 62h-24.15a5.1 5.1 0 0 1-.85-2.81 5.65 5.65 0 0 1 6.59-5.19v-.08a7.07 7.07 0 0 1 7.24-6.92 7.15 7.15 0 0 1 7.17 5.64h.44a5.46 5.46 0 0 1 5.6 5.32A5.19 5.19 0 0 1 163 62z\" fill=\"#fff\"/>\n          </g>\n        </svg>\n      </div>\n\n      <div class=\"lh-metadata\">\n        <div class=\"lh-metadata__results\"><a href=\"\" class=\"lh-metadata__url\" target=\"_blank\" rel=\"noopener\"></a></div>\n        <div class=\"lh-config\">\n          <span class=\"lh-config__timestamp\"></span>\n          <a href=\"#runtime-settings\" class=\"lh-config__emulation\"></a>\n        </div>\n      </div>\n    </div>\n\n    <div class=\"lh-scores-wrapper-placeholder\"></div>\n\n    <div class=\"lh-toolbar\">\n      <div class=\"lh-product-info\">\n        <img src=\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAIAAAD8GO2jAAADjklEQVR4AWI08P/HQEvAQrxSQKvlECfLFYXx75xCY2qmh89GbNvOMjb3v9jOOlxnFWxj206ebQ3b7q6q+z1rNagu8/zvPSZACAABpeUAA0miMgU7SA7JjCraFGwZwECOwvL75dWjsKgWBKtx0jvWo+vkBAFbACCkByMP6nMn48+AVgXB2fzSCwsv22/lMGlUhmJ0AE7BH8dyUUDbUEgN6RzJRSeaPxhdRYR0Inel+7Hd5lBiFpkMAxACc0394//9C4voFHDiAAGLpuOXebdfdHfctgwJKaZRLRKy6ItrSis6RBnVBgGtbHyKTEmJHQoEXoBCE5BCrDeA2ogMUIGDAKEBDEhUqwgMqBYDjW4DQzmuffVdqff42/ZQYYqVcMXGZsMPyCsH3lyJSetxvEaxAQXdjR1HjfwCdIS7lo2DZke26Qe+MXO12OWkGT0O6oE7vMGkMnkYw4aN1KQgMKExhXqswfiov4+a7MQ11XPnbr/5qpKlgACAAQj94Lu271bN9DUecQasIZlNzG72llRAAKJiAi+/BSHrSFjRvQhg3DEKEqJh08tsmLTx597+f6enr4cc2Zpk57pihfX24dW7RHcOLLUbJYhJSl0ErQCI9BVXH/XrO97QasuvQQSiECa0BrQCIIJp6X9T/r8QG6L71WYSqCoIIGo2BZDUBnS/D9EA9Nun1iYvbM0MFExIDQRoKFatc1Z6zrm5uWeObJotq0BGV9FuQBWq5a4Fw3PPz848rZHstZSuA5FWAFSMP2nOppOOGpl6qh9PCSg0IFyHKjSQyDNQHTru2t75NOEe0fsf246oAmFkI6vCdnWvbQFQFCKx8vCswV8TrDLiDLgH4Nr7RAtNsrC9d8sfk7b8ls4igdNy8CQKAISlsB0FjZfd3Lfp155tf8fKI4BxZZIj/oTdVEAIAcJFOCmzauHG71I7/rdreUAgAqpDP05fDARCAQQARwEIBQSVxq0FyaLvZZtevpHa8WHw8cft6cpxlq8eAJtIhnSbWDf951yx3y13OqUuu5qyGgkxCgGFh9cDihDGbTa6BqvT1lWmrav3bmt2ZMJ4mU6TGgIC4DBzcv/JqAau1WhzSt3x9Ixk/4Jk/8J4ZrrViFMA4W6A7+WK8xcVjvyrOmVD0FbAXokcT48r+xVqLKvuJYbmpNadnlp3mpufJHOe/GXktM+r09bT8kEdq9BRYAbGSgzP7ll82U71Mc+ZFooXgwAAAABJRU5ErkJggg==\" alt=\"\" class=\"lh-product-info__icon\" />\n        <span class=\"lh-product-info__name\">Lighthouse</span>&nbsp;\n        <span class=\"lh-product-info__version\"></span>\n      </div>\n\n      <div class=\"lh-toolbar__metadata\">\n        <a href=\"\" class=\"lh-toolbar__url\" target=\"_blank\" rel=\"noopener\"></a>\n        <span class=\"lh-toggle-arrow\" title=\"See report's runtime settings\"></span>\n      </div>\n    </div>\n\n    <div class=\"lh-export\">\n      <button class=\"report-icon report-icon--share lh-export__button\" title=\"Export report\"></button>\n      <div class=\"lh-export__dropdown\">\n        <!-- TODO(i18n): localize export dropdown -->\n        <a href=\"#\" class=\"report-icon report-icon--print\" data-action=\"print-summary\">Print Summary</a>\n        <a href=\"#\" class=\"report-icon report-icon--print\" data-action=\"print-expanded\">Print Expanded</a>\n        <a href=\"#\" class=\"report-icon report-icon--copy\" data-action=\"copy\">Copy JSON</a>\n        <a href=\"#\" class=\"report-icon report-icon--download\" data-action=\"save-html\">Save as HTML</a>\n        <a href=\"#\" class=\"report-icon report-icon--download\" data-action=\"save-json\">Save as JSON</a>\n        <a href=\"#\" class=\"report-icon report-icon--open lh-export--viewer\" data-action=\"open-viewer\">Open in Viewer</a>\n        <a href=\"#\" class=\"report-icon report-icon--open lh-export--gist\" data-action=\"save-gist\">Save as Gist</a>\n      </div>\n    </div>\n</template>\n\n\n<!-- Lighthouse footer -->\n<template id=\"tmpl-lh-footer\">\n  <style>\n    .lh-footer {\n      background-color: var(--header-bg-color);\n      border-top: 1px solid var(--report-secondary-border-color);\n      padding: var(--section-indent) calc(var(--default-padding) * 2);\n    }\n    .lh-footer .lh-generated {\n      text-align: center;\n      border-top: 1px solid var(--report-border-color);\n      padding-top: var(--default-padding);\n    }\n    .lh-env {\n      padding: var(--default-padding) 0;\n    }\n    .lh-env__items {\n      padding-left: 16px;\n    }\n    span.lh-env__name {\n      font-weight: bold;\n      color: var(--secondary-text-color);\n    }\n    span.lh-env__description {\n      font-family: var(--monospace-font-family);\n      font-size: var(--caption-font-size);\n      padding-left: 5px;\n    }\n  </style>\n  <footer class=\"lh-footer\">\n    <!-- TODO(i18n): localize runtime settings -->\n    <div class=\"lh-env\">\n      <div class=\"lh-env__title\">Runtime settings</div>\n      <ul class=\"lh-env__items\">\n        <template id=\"tmpl-lh-env__items\">\n          <li class=\"lh-env__item\">\n            <span class=\"lh-env__name\"></span>\n            <span class=\"lh-env__description\"></span>\n          </li>\n        </template>\n      </ul>\n    </div>\n\n    <div class=\"lh-generated\">\n      Generated by <b>Lighthouse</b> <span class=\"lh-footer__version\"></span> |\n      <a href=\"https://github.com/GoogleChrome/Lighthouse/issues\" target=\"_blank\" rel=\"noopener\">File an issue</a>\n    </div>\n  </footer>\n</template>\n\n<!-- Lighthouse score gauge -->\n<template id=\"tmpl-lh-gauge\">\n  <style>\n    .lh-gauge__wrapper {\n      --circle-size-half: calc(var(--circle-size) / 2);\n      --circle-background: hsl(216, 12%, 92%);\n      --circle-border-width: 9;\n      --inset-size: calc(var(--circle-size) - 2 * var(--circle-border-width));\n      --transition-length: 1s;\n    }\n\n    .lh-gauge__wrapper--pass,\n    .lh-gauge__wrapper--pass .lh-gauge {\n      --circle-color: var(--pass-color);\n      color: var(--circle-color);\n    }\n\n    .lh-gauge__wrapper--average,\n    .lh-gauge__wrapper--average .lh-gauge {\n      --circle-color: var(--average-color);\n      color: var(--circle-color);\n    }\n\n    .lh-gauge__wrapper--fail,\n    .lh-gauge__wrapper--fail .lh-gauge {\n      --circle-color: var(--fail-color);\n      color: var(--circle-color);\n    }\n\n    .lh-gauge {\n        max-width: 360px;\n        max-height: 360px;\n        stroke-linecap: round;\n        width: var(--circle-size);\n        height: var(--circle-size);\n    }\n\n    .lh-gauge-base {\n        fill: none;\n        stroke: var(--circle-background);\n        stroke-width: var(--circle-border-width);\n    }\n    .lh-gauge-arc {\n        fill: none;\n        stroke: var(--circle-color);\n        stroke-width: var(--circle-border-width);\n        animation: load-gauge var(--transition-length) ease forwards;\n        animation-delay: 250ms;\n    }\n\n    @keyframes load-gauge {\n      from { stroke-dasharray: 0 329; }\n    }\n\n    .lh-gauge__percentage {\n      --spacer: calc((var(--circle-size) - var(--inset-size)) / 2);\n      width: 100%;\n      height: var(--inset-size);\n      position: absolute;\n      border-radius: inherit;\n      font-size: var(--header-font-size);\n      line-height: var(--header-font-size);\n      text-align: center;\n      top: calc(var(--circle-size) / 3);\n    }\n\n    .lh-gauge__wrapper {\n      display: inline-flex;\n      align-items: center;\n      flex-direction: column;\n      text-decoration: none;\n      flex: 1;\n      min-width: auto;\n      position: relative;\n\n      /* Contain the layout style paint & layers during animation*/\n      contain: content;\n      will-change: opacity; /* Only using for layer promotion */\n    }\n\n    .lh-gauge__label {\n      font-size: var(--body-font-size);\n      line-height: var(--body-line-height);\n      margin-top: calc(0.5 * var(--body-line-height));\n      text-align: center;\n      color: black;\n    }\n\n  </style>\n  <a href=\"#\" class=\"lh-gauge__wrapper\">\n    <svg viewBox=\"0 0 120 120\" class=\"lh-gauge\" fill=\"none\" stroke-width=\"2\">\n      <circle class=\"lh-gauge-base\" r=\"53\" cx=\"60\" cy=\"60\"></circle>\n      <circle class=\"lh-gauge-arc\" transform=\"rotate(-90 60 60)\" stroke-dasharray=\"0 329\" stroke-dashoffset=\"0\" r=\"53\" cx=\"60\" cy=\"60\"></circle>\n    </svg>\n    <div class=\"lh-gauge__percentage\"></div>\n    <div class=\"lh-gauge__label\"></div>\n  </a>\n</template>\n\n\n<!-- Lighthouse PWA badge gauge -->\n<template id=\"tmpl-lh-gauge--pwa\">\n  <style>\n    .lh-gauge--pwa__wrapper {\n      display: inline-flex;\n      align-items: center;\n      flex-direction: column;\n      text-decoration: none;\n      flex: 1;\n      min-width: auto;\n      position: relative;\n    }\n    .lh-gauge--pwa {\n      width: var(--circle-size);\n      height: var(--circle-size);\n    }\n    .lh-gauge--pwa .lh-gauge--pwa__component {\n      display: none;\n    }\n    .lh-gauge--pwa__wrapper:not(.lh-badged--all) .lh-gauge--pwa__logo > path {\n      /* Gray logo unless everything is passing. */\n      fill: #B0B0B0;\n    }\n\n    /* No passing groups. */\n    .lh-gauge--pwa__wrapper:not([class*='lh-badged--']) .lh-gauge--pwa__na-line {\n      display: inline;\n    }\n    /* Just optimized. Same n/a line as no passing groups. */\n    .lh-gauge--pwa__wrapper.lh-badged--pwa-optimized .lh-gauge--pwa__na-line {\n      display: inline;\n    }\n\n    /* Just fast and reliable. */\n    .lh-gauge--pwa__wrapper.lh-badged--pwa-fast-reliable:not(.lh-badged--pwa-installable) .lh-gauge--pwa__fast-reliable-badge {\n      display: inline;\n    }\n\n    /* Just installable. */\n    .lh-gauge--pwa__wrapper.lh-badged--pwa-installable:not(.lh-badged--pwa-fast-reliable) .lh-gauge--pwa__installable-badge {\n      display: inline;\n    }\n\n    /* Fast and reliable and installable. */\n    .lh-gauge--pwa__wrapper.lh-badged--pwa-fast-reliable.lh-badged--pwa-installable .lh-gauge--pwa__fast-reliable-installable-badges {\n      display: inline;\n    }\n\n    /* All passing groups. */\n    .lh-gauge--pwa__wrapper.lh-badged--all .lh-gauge--pwa__check-circle {\n      display: inline;\n    }\n\n    .lh-gauge__label {\n      font-size: var(--body-font-size);\n      line-height: var(--body-line-height);\n      margin-top: calc(0.5 * var(--body-line-height));\n      text-align: center;\n      color: black;\n    }\n  </style>\n\n  <a href=\"#\" class=\"lh-gauge--pwa__wrapper\">\n    <svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 60 60\" class=\"lh-gauge--pwa\">\n      <defs>\n        <linearGradient id=\"lh-gauge--pwa__bg-disk__gradient\" x1=\"50%\" y1=\"2.15%\" x2=\"50%\" y2=\"97.645%\">\n          <stop stop-color=\"#F1F3F4\" offset=\"0%\"></stop>\n          <stop stop-color=\"#DEE6EA\" offset=\"100%\"></stop>\n        </linearGradient>\n        <linearGradient id=\"lh-gauge--pwa__check-circle__gradient\" x1=\"50%\" y1=\"0%\" x2=\"50%\" y2=\"100%\">\n          <stop stop-color=\"#00C852\" offset=\"0%\"></stop>\n          <stop stop-color=\"#009688\" offset=\"100%\"></stop>\n        </linearGradient>\n        <linearGradient id=\"lh-gauge--pwa__installable__shadow-gradient\" x1=\"76.056%\" x2=\"24.111%\" y1=\"82.995%\" y2=\"24.735%\">\n          <stop stop-color=\"#A5D6A7\" offset=\"0%\"></stop>\n          <stop stop-color=\"#80CBC4\" offset=\"100%\"></stop>\n        </linearGradient>\n        <linearGradient id=\"lh-gauge--pwa__fast-reliable__shadow-gradient\" x1=\"76.056%\" y1=\"82.995%\" x2=\"25.678%\" y2=\"26.493%\">\n          <stop stop-color=\"#64B5F6\" offset=\"0%\"></stop>\n          <stop stop-color=\"#2979FF\" offset=\"100%\"></stop>\n        </linearGradient>\n\n        <g id=\"lh-gauge--pwa__fast-reliable-badge\">\n          <circle fill=\"#FFFFFF\" cx=\"10\" cy=\"10\" r=\"10\"></circle>\n          <path fill=\"#304FFE\" d=\"M10 3.58l5.25 2.34v3.5c0 3.23-2.24 6.26-5.25 7-3.01-.74-5.25-3.77-5.25-7v-3.5L10 3.58zm-.47 10.74l2.76-4.83.03-.07c.04-.08 0-.24-.22-.24h-1.64l.47-3.26h-.47l-2.7 4.77c-.02.01.05-.1-.04.05-.09.16-.1.31.18.31h1.63l-.47 3.27h.47z\"/>\n        </g>\n        <g id=\"lh-gauge--pwa__installable-badge\">\n          <circle fill=\"#FFFFFF\" cx=\"10\" cy=\"10\" r=\"10\"></circle>\n          <path fill=\"#009688\" d=\"M10 4.167A5.835 5.835 0 0 0 4.167 10 5.835 5.835 0 0 0 10 15.833 5.835 5.835 0 0 0 15.833 10 5.835 5.835 0 0 0 10 4.167zm2.917 6.416h-2.334v2.334H9.417v-2.334H7.083V9.417h2.334V7.083h1.166v2.334h2.334v1.166z\"/>\n        </g>\n      </defs>\n\n      <g stroke=\"none\" fill-rule=\"nonzero\">\n        <!-- Background and PWA logo (color by default) -->\n        <circle fill=\"url(#lh-gauge--pwa__bg-disk__gradient)\" cx=\"30\" cy=\"30\" r=\"30\"></circle>\n        <g class=\"lh-gauge--pwa__logo\">\n          <path fill=\"#3D3D3D\" d=\"M35.66 19.39l.7-1.75h2L37.4 15 38.6 12l3.4 9h-2.51l-.58-1.61z\"/>\n          <path fill=\"#304FFE\" d=\"M33.52 21l3.65-9h-2.42l-2.5 5.82L30.5 12h-1.86l-1.9 5.82-1.35-2.65-1.21 3.72L25.4 21h2.38l1.72-5.2 1.64 5.2z\"/>\n          <path fill=\"#3D3D3D\" fill-rule=\"nonzero\" d=\"M20.3 17.91h1.48c.45 0 .85-.05 1.2-.15l.39-1.18 1.07-3.3a2.64 2.64 0 0 0-.28-.37c-.55-.6-1.36-.91-2.42-.91H18v9h2.3V17.9zm1.96-3.84c.22.22.33.5.33.87 0 .36-.1.65-.29.87-.2.23-.59.35-1.15.35h-.86v-2.41h.87c.52 0 .89.1 1.1.32z\"/>\n        </g>\n\n        <!-- No badges. -->\n        <rect class=\"lh-gauge--pwa__component lh-gauge--pwa__na-line\" fill=\"#FFFFFF\" x=\"20\" y=\"32\" width=\"20\" height=\"4\" rx=\"2\"></rect>\n\n        <!-- Just fast and reliable. -->\n        <g class=\"lh-gauge--pwa__component lh-gauge--pwa__fast-reliable-badge\" transform=\"translate(20, 29)\">\n          <path fill=\"url(#lh-gauge--pwa__fast-reliable__shadow-gradient)\" d=\"M33.63 19.49A30 30 0 0 1 16.2 30.36L3 17.14 17.14 3l16.49 16.49z\"/>\n          <use xlink:href=\"#lh-gauge--pwa__fast-reliable-badge\" />\n        </g>\n\n        <!-- Just installable. -->\n        <g class=\"lh-gauge--pwa__component lh-gauge--pwa__installable-badge\" transform=\"translate(20, 29)\">\n          <path fill=\"url(#lh-gauge--pwa__installable__shadow-gradient)\" d=\"M33.629 19.487c-4.272 5.453-10.391 9.39-17.415 10.869L3 17.142 17.142 3 33.63 19.487z\"/>\n          <use xlink:href=\"#lh-gauge--pwa__installable-badge\" />\n        </g>\n\n        <!-- Fast and reliable and installable. -->\n        <g class=\"lh-gauge--pwa__component lh-gauge--pwa__fast-reliable-installable-badges\">\n          <g transform=\"translate(8, 29)\"> <!-- fast and reliable -->\n            <path fill=\"url(#lh-gauge--pwa__fast-reliable__shadow-gradient)\" d=\"M16.321 30.463L3 17.143 17.142 3l22.365 22.365A29.864 29.864 0 0 1 22 31c-1.942 0-3.84-.184-5.679-.537z\"/>\n            <use xlink:href=\"#lh-gauge--pwa__fast-reliable-badge\" />\n          </g>\n          <g transform=\"translate(32, 29)\"> <!-- installable -->\n            <path fill=\"url(#lh-gauge--pwa__installable__shadow-gradient)\" d=\"M25.982 11.84a30.107 30.107 0 0 1-13.08 15.203L3 17.143 17.142 3l8.84 8.84z\"/>\n            <use xlink:href=\"#lh-gauge--pwa__installable-badge\" />\n          </g>\n        </g>\n\n        <!-- Full PWA. -->\n        <g class=\"lh-gauge--pwa__component lh-gauge--pwa__check-circle\" transform=\"translate(18, 28)\">\n          <circle fill=\"#FFFFFF\" cx=\"12\" cy=\"12\" r=\"12\"></circle>\n          <path fill=\"url(#lh-gauge--pwa__check-circle__gradient)\" d=\"M12 2a10 10 0 1 0 0 20 10 10 0 0 0 0-20zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z\"></path>\n        </g>\n      </g>\n    </svg>\n\n    <div class=\"lh-gauge__label\"></div>\n  </a>\n</template>\n\n<!-- Lighthouse crtiical request chains component -->\n<template id=\"tmpl-lh-crc\">\n  <div class=\"lh-crc-container\">\n    <style>\n      .lh-crc .tree-marker {\n        width: 12px;\n        height: 26px;\n        display: block;\n        float: left;\n        background-position: top left;\n      }\n      .lh-crc .horiz-down {\n        background: url('data:image/svg+xml;utf8,<svg width=\"16\" height=\"26\" viewBox=\"0 0 16 26\" xmlns=\"http://www.w3.org/2000/svg\"><g fill=\"%23D8D8D8\" fill-rule=\"evenodd\"><path d=\"M16 12v2H-2v-2z\"/><path d=\"M9 12v14H7V12z\"/></g></svg>');\n      }\n      .lh-crc .right {\n        background: url('data:image/svg+xml;utf8,<svg width=\"16\" height=\"26\" viewBox=\"0 0 16 26\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M16 12v2H0v-2z\" fill=\"%23D8D8D8\" fill-rule=\"evenodd\"/></svg>');\n      }\n      .lh-crc .up-right {\n        background: url('data:image/svg+xml;utf8,<svg width=\"16\" height=\"26\" viewBox=\"0 0 16 26\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M7 0h2v14H7zm2 12h7v2H9z\" fill=\"%23D8D8D8\" fill-rule=\"evenodd\"/></svg>');\n      }\n      .lh-crc .vert-right {\n        background: url('data:image/svg+xml;utf8,<svg width=\"16\" height=\"26\" viewBox=\"0 0 16 26\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M7 0h2v27H7zm2 12h7v2H9z\" fill=\"%23D8D8D8\" fill-rule=\"evenodd\"/></svg>');\n      }\n      .lh-crc .vert {\n        background: url('data:image/svg+xml;utf8,<svg width=\"16\" height=\"26\" viewBox=\"0 0 16 26\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M7 0h2v26H7z\" fill=\"%23D8D8D8\" fill-rule=\"evenodd\"/></svg>');\n      }\n      .lh-crc .crc-tree {\n        font-size: 14px;\n        width: 100%;\n        overflow-x: auto;\n      }\n      .lh-crc .crc-node {\n        height: 26px;\n        line-height: 26px;\n        white-space: nowrap;\n      }\n      .lh-crc .crc-node__tree-value {\n        margin-left: 10px;\n      }\n      .lh-crc .crc-node__chain-duration {\n        font-weight: 700;\n      }\n      .lh-crc .crc-node__tree-hostname {\n        color: #595959;\n      }\n      .lh-crc .crc-initial-nav {\n        color: #595959;\n        font-style: italic;\n      }\n      .lh-crc__summary-value {\n        margin-bottom: 10px;\n      }\n    </style>\n    <div>\n      <div class=\"lh-crc__summary-value\">\n        <span class=\"lh-crc__longest_duration_label\"></span> <b class=\"lh-crc__longest_duration\"></b>\n      </div>\n    </div>\n    <div class=\"lh-crc\">\n      <div class=\"crc-initial-nav\"></div>\n      <!-- stamp for each chain -->\n      <template id=\"tmpl-lh-crc__chains\">\n        <div class=\"crc-node\">\n          <span class=\"crc-node__tree-marker\">\n\n          </span>\n          <span class=\"crc-node__tree-value\">\n            <span class=\"crc-node__tree-file\"><!-- fill me: node.request.url.file --></span>\n            <span class=\"crc-node__tree-hostname\">(<!-- fill me: node.request.url.host -->)</span>\n\n          </span>\n        </div>\n      </template>\n    </div>\n  </div>\n</template>\n\n/*# sourceURL=audits2/lighthouse/templates.html */";