/*
 * Decompiled with CFR 0.152.
 */
package com.zk.action;

import com.zk.util.ConfigFile;
import com.zk.util.NewActionListener;
import com.zk.util.NewMouseAdapter;
import java.awt.AWTException;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class SystemTrayControl
extends JFrame {
    private static final long serialVersionUID = 5372929216061177393L;
    private static final String TRAY_IMAGE_PATH = "..\\Image\\pubMark\\icno.jpg";
    private TrayIcon trayIcon = null;
    private static ResourceBundle res = null;

    public SystemTrayControl() {
        this.setTitle(res.getString("sys.title"));
        this.jbInit();
        this.setSize(300, 280);
        this.setLocation(300, 300);
    }

    public void jbInit() {
        ResourceBundle res = (ResourceBundle)SystemTrayControl.getRes();
        if (SystemTray.isSupported()) {
            SystemTray tray = SystemTray.getSystemTray();
            Image image = Toolkit.getDefaultToolkit().getImage(TRAY_IMAGE_PATH);
            PopupMenu popupMenu = new PopupMenu();
            MenuItem configWebPort = new MenuItem(res.getString("menu.webport"));
            MenuItem configDB = new MenuItem(res.getString("menu.configDB"));
            MenuItem backDB = new MenuItem(res.getString("menu.backDB"));
            MenuItem startServer = new MenuItem(res.getString("menu.stopServer"));
            MenuItem restoreDB = new MenuItem(res.getString("menu.rebuildDB"));
            MenuItem activation = new MenuItem(res.getString("menu.activation"));
            MenuItem exitItem = new MenuItem(res.getString("menu.exit"));
            configWebPort.setName("configWebPort");
            configDB.setName("configDB");
            backDB.setName("backDB");
            startServer.setName("stopServer");
            restoreDB.setName("restoreDB");
            activation.setName("activation");
            exitItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        System.exit(0);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            configWebPort.addActionListener(new NewActionListener(res, configWebPort));
            configDB.addActionListener(new NewActionListener(res, configDB));
            backDB.addActionListener(new NewActionListener(res, backDB));
            restoreDB.addActionListener(new NewActionListener(res, restoreDB));
            startServer.addActionListener(new NewActionListener(res, startServer));
            activation.addActionListener(new NewActionListener(res, activation));
            popupMenu.add(configWebPort);
            popupMenu.add(configDB);
            popupMenu.add(backDB);
            popupMenu.add(restoreDB);
            popupMenu.add(startServer);
            popupMenu.add(activation);
            popupMenu.add(exitItem);
            this.trayIcon = new TrayIcon(image, res.getString("sys.title"), popupMenu);
            this.trayIcon.setImageAutoSize(true);
            this.trayIcon.addMouseListener(new NewMouseAdapter(res, startServer));
            try {
                tray.add(this.trayIcon);
            }
            catch (AWTException e) {
                System.err.println(e);
            }
        } else {
            JOptionPane.showMessageDialog(null, res.getString("sys.dialog2.content"));
            System.exit(0);
        }
    }

    public static String getadmin() {
        String temp;
        block13: {
            temp = "";
            Process pro = null;
            BufferedReader read = null;
            try {
                try {
                    pro = Runtime.getRuntime().exec("..//Config//isadmin.bat");
                    read = new BufferedReader(new InputStreamReader(pro.getInputStream()));
                    while (read.readLine() != null) {
                        temp = read.readLine();
                    }
                }
                catch (IOException e) {
                    System.out.println("Before the main run, first determine whether a system administrator privileges");
                    e.printStackTrace();
                    if (read == null) break block13;
                    try {
                        read.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
            finally {
                if (read != null) {
                    try {
                        read.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
        return temp;
    }

    public static Object getRes() {
        ResourceBundle res = null;
        String language = ConfigFile.getValue(0, "options", "language");
        res = language.equalsIgnoreCase("zh_CN") ? ResourceBundle.getBundle("com/zk/Languages/app", Locale.CHINA) : ResourceBundle.getBundle("com/zk/Languages/app", Locale.US);
        return res;
    }

    public static void main(String[] args) {
        res = (ResourceBundle)SystemTrayControl.getRes();
        String temp = SystemTrayControl.getadmin();
        if (temp.trim().equalsIgnoreCase("noadmin")) {
            JOptionPane.showMessageDialog(null, res.getString("sys.dialog3.content"));
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    new SystemTrayControl().setVisible(false);
                }
            });
        }
    }
}

