/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.appcontext.AppContext;
import com.sun.deploy.config.Config;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.StringQuoteUtil;
import com.sun.deploy.util.SystemUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class Property
implements Cloneable {
    private static final boolean DEBUG = false;
    public static final String JNLP_PACK_ENABLED = "jnlp.packEnabled";
    public static final String JNLP_VERSION_ENABLED = "jnlp.versionEnabled";
    public static final String JNLP_CONCURRENT_DOWNLOADS = "jnlp.concurrentDownloads";
    public static final int CONCURRENT_DOWNLOADS_DEF = Config.getIntProperty("deployment.javaws.concurrentDownloads") == -1 ? 4 : Config.getIntProperty("deployment.javaws.concurrentDownloads");
    String key;
    String value;
    boolean isSecure;
    private static final boolean _quoteWholePropertySpec = Config.getOSName().startsWith("Win");
    private static List jnlpProps = Arrays.asList("jnlp.packEnabled", "jnlp.versionEnabled", "jnlp.concurrentDownloads");

    public Property(String string) {
        string = StringQuoteUtil.unquoteIfNeeded(string).trim();
        if (!string.startsWith("-D") || string.length() < 3) {
            throw new IllegalArgumentException("Property invalid");
        }
        int n = string.indexOf("=");
        if (n < 0) {
            this.key = string.substring(2);
            this.value = "";
        } else {
            this.key = string.substring(2, n);
            this.value = StringQuoteUtil.unquoteIfNeeded(string.substring(n + 1));
        }
        this.isSecure = Config.isSecureProperty(this.key, this.value);
    }

    public static Property createProperty(String string) {
        Property property = null;
        try {
            property = new Property(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return property;
    }

    public Property(String string, String string2) {
        this.key = string;
        this.value = string2 != null ? StringQuoteUtil.unquoteIfNeeded(string2) : new String("");
        this.isSecure = Config.isSecureProperty(this.key, this.value);
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        if (this.value.length() == 0) {
            return "-D" + this.key;
        }
        if (bl && _quoteWholePropertySpec) {
            return StringQuoteUtil.quoteIfNeeded("-D" + this.key + "=" + this.value);
        }
        return "-D" + this.key + "=" + StringQuoteUtil.quoteIfNeeded(this.value);
    }

    public void addTo(Properties properties) {
        properties.setProperty(this.key, this.value);
    }

    public Object clone() {
        return new Property(this.key, this.value);
    }

    public boolean equals(Object object) {
        int n;
        if (!(object instanceof Property)) {
            return false;
        }
        Property property = (Property)object;
        int n2 = property.hashCode();
        return n2 == (n = this.hashCode());
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public static final boolean getQuotesWholePropertySpec() {
        return _quoteWholePropertySpec;
    }

    public static boolean isJnlpProperty(String string) {
        try {
            Property property = new Property(string);
            return Property.isJnlpPropertyKey(property.getKey());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isJnlpPropertyKey(String string) {
        return string != null && jnlpProps.contains(string);
    }

    public static List getJnlpProperties(String string) {
        List list = StringQuoteUtil.parseCommandLine(string);
        ArrayList<Property> arrayList = new ArrayList<Property>();
        for (int i = 0; i < list.size(); ++i) {
            String string2 = (String)list.get(i);
            try {
                Property property = new Property(string2);
                if (!property.getKey().startsWith("jnlp.")) continue;
                arrayList.add(property);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    public static boolean collectsJnlpPropertyIntoAppContext(String string, String string2) {
        if (Property.isJnlpPropertyKey(string)) {
            Property.collectsJnlpProperties(string, string2, ToolkitStore.get().getAppContext());
            return true;
        }
        return false;
    }

    public static void collectsJnlpProperties(String string, AppContext appContext) {
        List list = Property.getJnlpProperties(string);
        for (int i = 0; i < list.size(); ++i) {
            Property property = (Property)list.get(i);
            Property.collectsJnlpProperties(property.getKey(), property.getValue(), appContext);
        }
    }

    private static void collectsJnlpProperties(String string, String string2, AppContext appContext) {
        if (appContext == null) {
            return;
        }
        Comparable<Boolean> comparable = null;
        if (string.equals(JNLP_CONCURRENT_DOWNLOADS)) {
            int n = 0;
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                Trace.println(numberFormatException.getLocalizedMessage() + " " + string, TraceLevel.NETWORK);
            }
            if (n <= 0) {
                n = CONCURRENT_DOWNLOADS_DEF;
            }
            if (n > 10) {
                n = 10;
            }
            comparable = SystemUtils.integerValueOf(n);
        } else if (string.equals(JNLP_PACK_ENABLED) || string.equals(JNLP_VERSION_ENABLED)) {
            comparable = Boolean.valueOf(string2);
        }
        appContext.put(string, comparable);
    }

    public static boolean isPackEnabled() {
        return Property.isPackEnabled(ToolkitStore.get().getAppContext());
    }

    public static boolean isPackEnabled(AppContext appContext) {
        if (!Config.isJavaVersionAtLeast15()) {
            return false;
        }
        return Property.booleanValue(appContext, JNLP_PACK_ENABLED);
    }

    public static boolean isVersionEnabled() {
        return Property.isVersionEnabled(ToolkitStore.get().getAppContext());
    }

    public static boolean isVersionEnabled(AppContext appContext) {
        return Property.booleanValue(appContext, JNLP_VERSION_ENABLED);
    }

    public static int getConcurrentDownloads() {
        return Property.getConcurrentDownloads(ToolkitStore.get().getAppContext());
    }

    public static int getConcurrentDownloads(AppContext appContext) {
        int n = Property.intValue(appContext, JNLP_CONCURRENT_DOWNLOADS);
        if (n <= 0) {
            n = CONCURRENT_DOWNLOADS_DEF;
        }
        return n;
    }

    private static boolean booleanValue(AppContext appContext, String string) {
        if (appContext == null) {
            return false;
        }
        Object object = appContext.get(string);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return Boolean.valueOf((String)object);
        }
        return false;
    }

    private static int intValue(AppContext appContext, String string) {
        if (appContext == null) {
            return -1;
        }
        Object object = appContext.get(string);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String) {
            try {
                return Integer.valueOf((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }
}

