/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.util.Date;
import oracle.jrockit.jfr.JFR;
import oracle.jrockit.jfr.Logger;

@Deprecated
final class RepositoryChunk {
    private final Logger logger;
    private Date startTime;
    private Date endTime;
    private final File tempFile;
    private final File destFile;
    private int refCount = 1;
    private long size;
    private FileChannel outputChannel;
    private FileOutputStream outputStream;
    static boolean rename_overwrites;
    static boolean checked_overwrites;

    public RepositoryChunk(Logger logger, File file) {
        JFR.checkControl();
        this.logger = logger;
        this.tempFile = file;
        String string = file.getPath();
        this.destFile = new File(string.substring(0, string.length() - ".part".length()));
        this.startTime = null;
        assert (this.tempFile.exists());
        assert (this.destFile.exists());
    }

    public File getOutputFile() throws IOException {
        if (this.isFinished()) {
            throw new IOException("Chunk finished");
        }
        return this.tempFile;
    }

    public String getOutputPath() throws IOException {
        return this.getOutputFile().getPath();
    }

    public FileChannel getOutputChannel() throws IOException {
        if (this.outputChannel == null) {
            this.outputStream = new FileOutputStream(this.getOutputFile());
            this.outputChannel = this.outputStream.getChannel();
        }
        return this.outputChannel;
    }

    public void finish(long l, long l2) throws IOException {
        this.finish(new Date(l), new Date(l2));
    }

    private void finish(Date date, Date date2) throws IOException {
        if (this.outputChannel != null) {
            this.outputChannel.force(true);
            this.outputChannel.close();
        }
        if (this.outputStream != null) {
            this.outputStream.close();
        }
        if (!checked_overwrites) {
            File file;
            File file2 = File.createTempFile("test1", "tst");
            if (file2.renameTo(file = File.createTempFile("test2", "tst"))) {
                rename_overwrites = true;
            }
            file2.delete();
            file.delete();
            checked_overwrites = true;
        }
        assert (this.tempFile != null);
        if (!rename_overwrites && !this.destFile.delete()) {
            throw new IOException("Could not delete " + this.destFile);
        }
        if (!this.tempFile.renameTo(this.destFile)) {
            throw new IOException("Could not rename " + this.tempFile + " to " + this.destFile);
        }
        this.endTime = date2;
        this.startTime = date;
        this.size = this.destFile.length();
        this.logger.debug("Chunk finished: " + this.destFile);
    }

    public Date getStartTime() {
        return this.startTime != null ? (Date)this.startTime.clone() : null;
    }

    public Date getEndTime() {
        return this.endTime != null ? (Date)this.endTime.clone() : null;
    }

    private void delete(File file) {
        if (!file.exists()) {
            return;
        }
        if (!file.delete() && file.exists()) {
            file.deleteOnExit();
            this.logger.error("Repository chunk " + file + " could not be deleted");
            return;
        }
        this.logger.debug("Repository chunk " + file + " deleted");
    }

    private void destroy() {
        if (!this.isFinished()) {
            try {
                this.finish(0L, 0L);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.delete(this.tempFile);
        this.delete(this.destFile);
    }

    public synchronized void use() {
        ++this.refCount;
        this.logger.debug("Use chunk " + this.toString() + " ref count now " + this.refCount);
    }

    public synchronized void release() {
        --this.refCount;
        this.logger.debug("Release chunk " + this.toString() + " ref count now " + this.refCount);
        if (this.refCount == 0) {
            this.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        boolean bl = false;
        RepositoryChunk repositoryChunk = this;
        synchronized (repositoryChunk) {
            if (this.refCount > 0) {
                bl = true;
            }
        }
        if (bl) {
            this.destroy();
        }
    }

    public long getSize() {
        return this.size;
    }

    public boolean isFinished() {
        return this.endTime != null;
    }

    public String toString() {
        if (this.isFinished()) {
            return this.destFile.getPath();
        }
        return this.tempFile.getPath();
    }

    InputStream newInputStream() throws IOException {
        if (!this.isFinished()) {
            throw new IOException("Chunk not finished");
        }
        return new FileInputStream(this.destFile);
    }
}

