/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.applet.viewer;

import com.sun.applet2.AppletParameters;
import com.sun.deploy.Environment;
import com.sun.deploy.appcontext.AppContext;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.JfxRuntime;
import com.sun.deploy.config.OSType;
import com.sun.deploy.config.Platform;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.model.ResourceObject;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.si.SingleInstanceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.uitoolkit.DragContext;
import com.sun.deploy.uitoolkit.DragListener;
import com.sun.deploy.uitoolkit.PluginUIToolkit;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.uitoolkit.Window;
import com.sun.deploy.util.JVMParameters;
import com.sun.deploy.util.SessionState;
import com.sun.javaws.Globals;
import com.sun.javaws.HtmlOptions;
import com.sun.javaws.IconUtil;
import com.sun.javaws.JnlpxArgs;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.exceptions.JreExecException;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.JREMatcher;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.ui.LaunchErrorDialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import sun.plugin2.applet.Applet2Environment;
import sun.plugin2.applet.Applet2ExecutionContext;
import sun.plugin2.applet.Applet2Listener;
import sun.plugin2.applet.JNLP2Manager;
import sun.plugin2.applet.JNLP2Tag;
import sun.plugin2.applet.Plugin2ConsoleController;
import sun.plugin2.applet.Plugin2Manager;
import sun.plugin2.applet.context.InitialJNLPExecutionContext;
import sun.plugin2.applet.viewer.util.AppletTagParser;
import sun.plugin2.main.client.Applet2DragContext;
import sun.plugin2.main.client.DisconnectedExecutionContext;
import sun.plugin2.main.client.PluginMain;
import sun.plugin2.util.SystemUtil;

public class JNLP2Viewer {
    private static final boolean DEBUG = SystemUtil.getenv("JPI_PLUGIN2_DEBUG") != null;
    private boolean _isDraggedApplet;
    private boolean _isAssociation;
    private boolean _isAppletDescApplet;
    private String _jnlpFile;

    public static void main(String[] stringArray) throws Exception {
        Environment.setEnvironmentType((int)0);
        ToolkitStore.setMode((int)1);
        new JNLP2Viewer().run(stringArray);
    }

    private void run(String[] stringArray) throws Exception {
        JNLP2Manager jNLP2Manager = this.parseAndInitialize(stringArray);
        this.start(jNLP2Manager);
    }

    JNLP2Manager parseAndInitialize(String[] stringArray) throws Exception {
        Object object;
        Object object2;
        AppletParameters appletParameters = new AppletParameters();
        String string = null;
        URL uRL = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (stringArray.length > 5 || stringArray.length < 1) {
            System.out.println("Usage: JNLP2Viewer [url to HTML page containing <applet> tag with " + JNLP2Tag.JNLP_HREF + " parameter,]");
            System.out.println("                   [url to a jnlp file direct.]");
            System.out.println("Views the first applet on the specified HTML page.");
            System.exit(1);
        }
        int n = 0;
        do {
            if (stringArray[n].equals("-open") || stringArray[n].equals("-print")) {
                this._isAssociation = true;
                string4 = stringArray[++n];
                string = stringArray[++n];
                continue;
            }
            if (stringArray[n].equals("-codebase")) {
                this._isAppletDescApplet = true;
                string2 = stringArray[++n];
                continue;
            }
            if (stringArray[n].equals("-documentbase")) {
                this._isAppletDescApplet = true;
                string3 = stringArray[++n];
                continue;
            }
            if (stringArray[n].equals("-draggedApplet")) {
                this._isDraggedApplet = true;
                continue;
            }
            string = stringArray[n];
        } while (++n < stringArray.length);
        if (DEBUG) {
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.println("\tJNLP2Viewer args[" + i + "] = " + stringArray[i]);
            }
        }
        if (this._isAppletDescApplet || this._isDraggedApplet || this._isAssociation) {
            object2 = null;
            try {
                object2 = LaunchDescFactory.buildDescriptor((File)new File(string), (URL)new URL(string2), null, null);
            }
            catch (Exception exception) {
                Trace.ignoredException((Exception)exception);
            }
            if (object2 != null) {
                uRL = object2.getInformation().getHome();
            }
        } else {
            try {
                uRL = new URL(string);
            }
            catch (Exception exception) {
                if (!string.startsWith("http") && !string.startsWith("file")) {
                    try {
                        uRL = new URL("file:///" + string);
                        string = uRL.toString();
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace(System.out);
                    }
                }
                exception.printStackTrace(System.out);
            }
            object2 = uRL.openStream();
            if (object2 == null) {
                throw new RuntimeException("Error opening URL " + uRL);
            }
            object = new AppletTagParser();
            new ParserDelegator().parse(new InputStreamReader((InputStream)object2), (HTMLEditorKit.ParserCallback)object, true);
            ((InputStream)object2).close();
            if (!((AppletTagParser)object).foundApplet()) {
                if (DEBUG) {
                    System.out.println("No applet found on web page, try as JNLP direct");
                }
            } else {
                appletParameters = ((AppletTagParser)object).getParameters();
                try {
                    string = (String)appletParameters.get((Object)JNLP2Tag.JNLP_HREF);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (string == null) {
                    System.out.println("No <" + JNLP2Tag.JNLP_HREF + "> parameter given in applet tag, bail out\n");
                    System.exit(1);
                }
                try {
                    string2 = (String)appletParameters.get((Object)"java_codebase");
                    if (string2 == null) {
                        string2 = (String)appletParameters.get((Object)"codebase");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        object2 = new JVMParameters();
        object2.parseTrustedOptions(JnlpxArgs.getVMArgs());
        object2.parseBootClassPath(JVMParameters.getPlugInDependentJars());
        object2.setDefault(true);
        JVMParameters.setRunningJVMParameters((JVMParameters)object2);
        if (DEBUG) {
            System.out.println("Initializing Applet2Environment");
        }
        object = new InitialJNLPExecutionContext(appletParameters);
        Applet2Environment.initialize(null, true, false, new Plugin2ConsoleController(null, null), (Applet2ExecutionContext)object, null);
        JNLP2Manager.initializeExecutionEnvironment();
        if (this._isAppletDescApplet && string3 != null) {
            uRL = new URL(string3);
        }
        LocalApplicationProperties localApplicationProperties = null;
        ResourceObject resourceObject = ResourceProvider.get().getResourceObject(string);
        if (this._isDraggedApplet && resourceObject != null && (localApplicationProperties = ResourceProvider.get().getLocalApplicationProperties(resourceObject.getResourceURL(), resourceObject.getResourceVersion(), true)) != null) {
            string2 = localApplicationProperties.getCodebase();
            uRL = new URL(localApplicationProperties.getDocumentBase());
        }
        String string5 = null;
        if (this._isAppletDescApplet || this._isDraggedApplet || this._isAssociation) {
            string5 = string;
            if (resourceObject != null) {
                string = resourceObject.getResourceURL().toString();
            } else if (DEBUG) {
                System.err.println("Unable to obtain the CacheEntry from file " + string + ".idx");
            }
        }
        this._jnlpFile = string;
        if (this._isAssociation) {
            appletParameters.put((Object)"_numargs", (Object)"1");
            appletParameters.put((Object)"_arg0", (Object)string4);
        }
        JNLP2Manager jNLP2Manager = new JNLP2Manager(string2, uRL, string, JnlpxArgs.getIsRelaunch());
        if (this._isAppletDescApplet || this._isDraggedApplet || this._isAssociation) {
            jNLP2Manager.setCachedJNLPFilePath(string5);
        }
        jNLP2Manager.setAppletExecutionContext(new DisconnectedExecutionContext(appletParameters, uRL.toExternalForm(), (Applet2ExecutionContext)object));
        return jNLP2Manager;
    }

    private void start(final JNLP2Manager jNLP2Manager) {
        LocalApplicationProperties localApplicationProperties = this.getLapFile();
        final boolean bl = localApplicationProperties != null ? localApplicationProperties.isDraggedApplet() : this._isDraggedApplet;
        final boolean bl2 = this._isAssociation;
        final boolean bl3 = this._isAppletDescApplet;
        final ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        AppContext appContext = jNLP2Manager.getAppletAppContext();
        appContext.invokeLater(new Runnable(){

            public void run() {
                Object object;
                Frame frame;
                Window window;
                try {
                    jNLP2Manager.initialize();
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.out);
                    System.err.println("Error while initializing manager: " + exception + ", bail out");
                    Environment.setEnvironmentType((int)1);
                    LaunchErrorDialog.show(null, (Throwable)exception, (boolean)true);
                }
                AppletParameters appletParameters = jNLP2Manager.getAppletExecutionContext().getAppletParameters();
                final LaunchDesc launchDesc = jNLP2Manager.getLaunchDesc();
                int n = 512;
                int n2 = 512;
                try {
                    n = Integer.parseInt((String)appletParameters.get((Object)"width"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    n2 = Integer.parseInt((String)appletParameters.get((Object)"height"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (DEBUG) {
                    System.out.println("Starting applet (" + n + "x" + n2 + ") with parameters:");
                }
                if (DEBUG) {
                    appletParameters.dump();
                }
                String string = null;
                if (launchDesc != null) {
                    string = launchDesc.getInformation().getTitle();
                }
                if (string == null) {
                    string = "JNLPApplet2Viewer";
                }
                jNLP2Manager.setAppletSize(n, n2);
                if (!launchDesc.isFXApp()) {
                    window = ToolkitStore.getWindowFactory().createWindow();
                    frame = (Frame)window.getWindowObject();
                    frame.setTitle(string);
                    boolean bl4 = jNLP2Manager.getUndecorated();
                    frame.setUndecorated(bl4);
                    frame.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent windowEvent) {
                            JNLP2Viewer.this.stopAndExit(threadGroup, jNLP2Manager);
                        }
                    });
                    jNLP2Manager.setAppletParent(window);
                    frame.pack();
                    object = frame.getInsets();
                    frame.setSize(n + ((Insets)object).left + ((Insets)object).right, n2 + ((Insets)object).right + ((Insets)object).top);
                    if (bl3) {
                        frame.setResizable(false);
                    }
                } else {
                    JNLP2Manager.setEmbeddedMode(false);
                    window = null;
                    frame = null;
                }
                final Applet2DragContext applet2DragContext = Applet2DragContext.getDragContext(jNLP2Manager);
                if (bl) {
                    object = (PluginUIToolkit)ToolkitStore.get();
                    object.getDragHelper().register(applet2DragContext, new DragListener(){

                        public void appletDraggingToDesktop(DragContext dragContext) {
                        }

                        public void appletDroppedOntoDesktop(DragContext dragContext) {
                        }

                        public void appletExternalWindowClosed(DragContext dragContext) {
                            JNLP2Viewer.this.stopAndExit(threadGroup, jNLP2Manager);
                        }
                    });
                }
                jNLP2Manager.addAppletListener(new Applet2Listener(){

                    public boolean appletSSVValidation(Plugin2Manager plugin2Manager) throws ExitException {
                        boolean bl = PluginMain.performSSVValidation(plugin2Manager);
                        if (!bl && plugin2Manager instanceof JNLP2Manager) {
                            JNLP2Manager jNLP2Manager = (JNLP2Manager)plugin2Manager;
                            jNLP2Manager.clearRelaunchException();
                        }
                        if (DEBUG) {
                            System.out.println("JNLP2Viewer.appletSSVValidation return: " + bl);
                        }
                        return bl;
                    }

                    public boolean isAppletRelaunchSupported() {
                        return true;
                    }

                    public void appletJRERelaunch(Plugin2Manager plugin2Manager, String string, String string2) {
                        if (DEBUG) {
                            System.out.println("JNLP2Viewer.appletJRERelaunch:");
                            System.out.println("\tjava_version   : " + string);
                            System.out.println("\tjava_arguments : " + string2);
                            System.out.println("\thostingManager : " + plugin2Manager);
                            Thread.dumpStack();
                        }
                        if (plugin2Manager instanceof JNLP2Manager) {
                            File file;
                            JNLP2Manager jNLP2Manager = (JNLP2Manager)plugin2Manager;
                            LaunchDesc launchDesc2 = jNLP2Manager.getLaunchDesc();
                            JREMatcher jREMatcher = launchDesc2.getJREMatcher();
                            JVMParameters jVMParameters = jREMatcher.getSelectedJVMParameters();
                            JREInfo jREInfo = jREMatcher.getSelectedJREInfo();
                            JREDesc jREDesc = jREMatcher.getSelectedJREDesc();
                            String[] stringArray = new String[3];
                            stringArray[0] = "-codebase";
                            stringArray[1] = jNLP2Manager.getCodeBase().toString();
                            URL uRL = launchDesc2.getCanonicalHome();
                            if (uRL == null && JNLP2Viewer.this._jnlpFile != null) {
                                try {
                                    uRL = new URL(JNLP2Viewer.this._jnlpFile);
                                }
                                catch (MalformedURLException malformedURLException) {
                                    Trace.ignored((Throwable)malformedURLException);
                                }
                            }
                            if (uRL != null && (file = ResourceProvider.get().getCachedJNLPFile(uRL, launchDesc2.getVersion())) != null) {
                                stringArray[2] = file.getAbsolutePath();
                            }
                            if (stringArray[2] == null) {
                                stringArray[2] = JNLP2Viewer.this._jnlpFile;
                            }
                            try {
                                this.relaunch(jREInfo, jREDesc, launchDesc2, stringArray, jVMParameters, false, jREInfo.getJfxRuntime(), launchDesc2.needFX());
                            }
                            catch (Exception exception) {
                                Trace.ignoredException((Exception)exception);
                            }
                        }
                    }

                    private String[] insertApplicationArgs(String[] stringArray) {
                        String[] stringArray2 = Globals.getApplicationArgs();
                        if (stringArray2 == null) {
                            return stringArray;
                        }
                        String[] stringArray3 = new String[stringArray2.length + stringArray.length];
                        for (int i = 0; i < stringArray2.length; ++i) {
                            stringArray3[i] = stringArray2[i];
                        }
                        for (int i = 0; i < stringArray.length; ++i) {
                            stringArray3[i++] = stringArray[i];
                        }
                        return stringArray3;
                    }

                    private void relaunch(JREInfo jREInfo, JREDesc jREDesc, LaunchDesc launchDesc2, String[] stringArray, JVMParameters jVMParameters, boolean bl, JfxRuntime jfxRuntime, boolean bl2) throws ExitException {
                        Object object;
                        Object object2;
                        if (OSType.isMac()) {
                            String string = launchDesc2.getInformation().getTitle();
                            Charset charset = Charset.forName("UTF-8");
                            CharsetDecoder charsetDecoder = charset.newDecoder();
                            CharsetEncoder charsetEncoder = charset.newEncoder();
                            try {
                                object2 = charsetEncoder.encode(CharBuffer.wrap(string));
                                CharBuffer charBuffer = charsetDecoder.decode((ByteBuffer)object2);
                                object = charBuffer.toString();
                            }
                            catch (CharacterCodingException characterCodingException) {
                                object = null;
                            }
                            if (string != null) {
                                System.setProperty("macosx.jnlpx.dock.name", (String)object);
                            }
                            if ((object2 = IconUtil.getIconPath((LaunchDesc)launchDesc2)) == null) {
                                object2 = Platform.get().getDefaultIconPath();
                            }
                            if (object2 != null) {
                                System.setProperty("macosx.jnlpx.dock.icon", (String)object2);
                            }
                        }
                        long l = jREDesc.getMinHeap();
                        long l2 = jREDesc.getMaxHeap();
                        object = HtmlOptions.get();
                        if (object != null) {
                            try {
                                object2 = File.createTempFile("zzjnl", ".tmp");
                                object.export((OutputStream)new FileOutputStream((File)object2));
                                stringArray = new String[]{"-nocodebase", ((File)object2).getAbsolutePath()};
                            }
                            catch (IOException iOException) {
                                throw new ExitException("Failed to relaunch. Can not save launch file.", (Throwable)iOException);
                            }
                        }
                        if ((object2 = SessionState.save()) != null) {
                            System.setProperty("jnlpx.session.data", ((File)object2).getAbsolutePath());
                        }
                        try {
                            stringArray = this.insertApplicationArgs(stringArray);
                            JnlpxArgs.execProgram((JREInfo)jREInfo, (String[])stringArray, (long)l, (long)l2, (JVMParameters)jVMParameters, (boolean)bl, (JfxRuntime)jfxRuntime, (boolean)bl2);
                        }
                        catch (IOException iOException) {
                            throw new ExitException((Throwable)new JreExecException(jREInfo.getPath(), (Exception)iOException), 3);
                        }
                        if (JnlpxArgs.shouldRemoveArgumentFile()) {
                            JnlpxArgs.setShouldRemoveArgumentFile((String)String.valueOf(false));
                        }
                        JNLP2Viewer.this.stopAndExit(threadGroup, jNLP2Manager);
                    }

                    public void appletLoaded(Plugin2Manager plugin2Manager) {
                    }

                    public void appletReady(Plugin2Manager plugin2Manager) {
                        if (bl2 && SingleInstanceManager.isServerRunning((String)launchDesc.getCanonicalHome().toString())) {
                            SingleInstanceManager.connectToServer((String)launchDesc.toString());
                        }
                        if (frame != null) {
                            frame.setVisible(true);
                        }
                        if (bl) {
                            PluginUIToolkit pluginUIToolkit = (PluginUIToolkit)ToolkitStore.get();
                            pluginUIToolkit.getDragHelper().makeDisconnected(applet2DragContext, window);
                        }
                    }

                    public void appletErrorOccurred(Plugin2Manager plugin2Manager) {
                    }

                    public String getBestJREVersion(Plugin2Manager plugin2Manager, String string, String string2) {
                        return null;
                    }
                });
                jNLP2Manager.start();
            }
        });
    }

    private void stopAndExit(final ThreadGroup threadGroup, final Plugin2Manager plugin2Manager) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread thread = new Thread(threadGroup, new Runnable(){

                    public void run() {
                        plugin2Manager.stop(null, null);
                        Trace.flush();
                        System.exit(0);
                    }
                });
                thread.setDaemon(true);
                thread.start();
                return null;
            }
        });
    }

    private LocalApplicationProperties getLapFile() {
        LocalApplicationProperties localApplicationProperties = null;
        try {
            URL uRL = new URL(this._jnlpFile);
            localApplicationProperties = ResourceProvider.get().getLocalApplicationProperties(uRL, null, true);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (localApplicationProperties == null) {
            localApplicationProperties = Cache.getLocalApplicationProperties((String)this._jnlpFile);
        }
        return localApplicationProperties;
    }
}

