/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal;

import java.util.ArrayList;
import java.util.List;
import sun.org.mozilla.javascript.internal.BaseFunction;
import sun.org.mozilla.javascript.internal.Callable;
import sun.org.mozilla.javascript.internal.CodeGenerator;
import sun.org.mozilla.javascript.internal.CompilerEnvirons;
import sun.org.mozilla.javascript.internal.ConstProperties;
import sun.org.mozilla.javascript.internal.Context;
import sun.org.mozilla.javascript.internal.EcmaError;
import sun.org.mozilla.javascript.internal.Evaluator;
import sun.org.mozilla.javascript.internal.EvaluatorException;
import sun.org.mozilla.javascript.internal.Function;
import sun.org.mozilla.javascript.internal.Icode;
import sun.org.mozilla.javascript.internal.IdFunctionObject;
import sun.org.mozilla.javascript.internal.InterpretedFunction;
import sun.org.mozilla.javascript.internal.InterpreterData;
import sun.org.mozilla.javascript.internal.JavaScriptException;
import sun.org.mozilla.javascript.internal.Kit;
import sun.org.mozilla.javascript.internal.NativeContinuation;
import sun.org.mozilla.javascript.internal.NativeGenerator;
import sun.org.mozilla.javascript.internal.NativeIterator;
import sun.org.mozilla.javascript.internal.NativeWith;
import sun.org.mozilla.javascript.internal.ObjArray;
import sun.org.mozilla.javascript.internal.Ref;
import sun.org.mozilla.javascript.internal.RhinoException;
import sun.org.mozilla.javascript.internal.Script;
import sun.org.mozilla.javascript.internal.ScriptRuntime;
import sun.org.mozilla.javascript.internal.ScriptStackElement;
import sun.org.mozilla.javascript.internal.Scriptable;
import sun.org.mozilla.javascript.internal.ScriptableObject;
import sun.org.mozilla.javascript.internal.SecurityUtilities;
import sun.org.mozilla.javascript.internal.UintMap;
import sun.org.mozilla.javascript.internal.Undefined;
import sun.org.mozilla.javascript.internal.UniqueTag;
import sun.org.mozilla.javascript.internal.ast.ScriptNode;
import sun.org.mozilla.javascript.internal.debug.DebugFrame;

public final class Interpreter
extends Icode
implements Evaluator {
    InterpreterData itsData;
    static final int EXCEPTION_TRY_START_SLOT = 0;
    static final int EXCEPTION_TRY_END_SLOT = 1;
    static final int EXCEPTION_HANDLER_SLOT = 2;
    static final int EXCEPTION_TYPE_SLOT = 3;
    static final int EXCEPTION_LOCAL_SLOT = 4;
    static final int EXCEPTION_SCOPE_SLOT = 5;
    static final int EXCEPTION_SLOT_SIZE = 6;

    private static CallFrame captureFrameForGenerator(CallFrame callFrame) {
        callFrame.frozen = true;
        CallFrame callFrame2 = callFrame.cloneFrozen();
        callFrame.frozen = false;
        callFrame2.parentFrame = null;
        callFrame2.frameIndex = 0;
        return callFrame2;
    }

    @Override
    public Object compile(CompilerEnvirons compilerEnvirons, ScriptNode scriptNode, String string, boolean bl) {
        CodeGenerator codeGenerator = new CodeGenerator();
        this.itsData = codeGenerator.compile(compilerEnvirons, scriptNode, string, bl);
        return this.itsData;
    }

    @Override
    public Script createScriptObject(Object object, Object object2) {
        if (object != this.itsData) {
            Kit.codeBug();
        }
        return InterpretedFunction.createScript(this.itsData, object2);
    }

    @Override
    public void setEvalScriptFlag(Script script) {
        ((InterpretedFunction)script).idata.evalScriptFlag = true;
    }

    @Override
    public Function createFunctionObject(Context context, Scriptable scriptable, Object object, Object object2) {
        if (object != this.itsData) {
            Kit.codeBug();
        }
        return InterpretedFunction.createFunction(context, scriptable, this.itsData, object2);
    }

    private static int getShort(byte[] byArray, int n) {
        return byArray[n] << 8 | byArray[n + 1] & 0xFF;
    }

    private static int getIndex(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
    }

    private static int getInt(byte[] byArray, int n) {
        return byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    private static int getExceptionHandler(CallFrame callFrame, boolean bl) {
        int[] nArray = callFrame.idata.itsExceptionTable;
        if (nArray == null) {
            return -1;
        }
        int n = callFrame.pc - 1;
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i != nArray.length; i += 6) {
            int n5 = nArray[i + 0];
            int n6 = nArray[i + 1];
            if (n5 > n || n >= n6 || bl && nArray[i + 3] != 1) continue;
            if (n2 >= 0) {
                if (n4 < n6) continue;
                if (n3 > n5) {
                    Kit.codeBug();
                }
                if (n4 == n6) {
                    Kit.codeBug();
                }
            }
            n2 = i;
            n3 = n5;
            n4 = n6;
        }
        return n2;
    }

    static void dumpICode(InterpreterData interpreterData) {
    }

    private static int bytecodeSpan(int n) {
        switch (n) {
            case -63: 
            case -62: 
            case 50: 
            case 72: {
                return 3;
            }
            case -54: 
            case -23: 
            case -6: 
            case 5: 
            case 6: 
            case 7: {
                return 3;
            }
            case -21: {
                return 5;
            }
            case 57: {
                return 2;
            }
            case -11: 
            case -10: 
            case -9: 
            case -8: 
            case -7: {
                return 2;
            }
            case -27: {
                return 3;
            }
            case -28: {
                return 5;
            }
            case -38: {
                return 2;
            }
            case -39: {
                return 3;
            }
            case -40: {
                return 5;
            }
            case -45: {
                return 2;
            }
            case -46: {
                return 3;
            }
            case -47: {
                return 5;
            }
            case -61: 
            case -49: 
            case -48: {
                return 2;
            }
            case -26: {
                return 3;
            }
        }
        if (!Interpreter.validBytecode(n)) {
            throw Kit.codeBug();
        }
        return 1;
    }

    static int[] getLineNumbers(InterpreterData interpreterData) {
        int n;
        UintMap uintMap = new UintMap();
        byte[] byArray = interpreterData.itsICode;
        int n2 = byArray.length;
        for (int i = 0; i != n2; i += n) {
            byte by = byArray[i];
            n = Interpreter.bytecodeSpan(by);
            if (by != -26) continue;
            if (n != 3) {
                Kit.codeBug();
            }
            int n3 = Interpreter.getIndex(byArray, i + 1);
            uintMap.put(n3, 0);
        }
        return uintMap.getKeys();
    }

    @Override
    public void captureStackInfo(RhinoException rhinoException) {
        int n;
        Object[] objectArray;
        Context context = Context.getCurrentContext();
        if (context == null || context.lastInterpreterFrame == null) {
            rhinoException.interpreterStackInfo = null;
            rhinoException.interpreterLineData = null;
            return;
        }
        if (context.previousInterpreterInvocations == null || context.previousInterpreterInvocations.size() == 0) {
            objectArray = new CallFrame[1];
        } else {
            n = context.previousInterpreterInvocations.size();
            if (context.previousInterpreterInvocations.peek() == context.lastInterpreterFrame) {
                --n;
            }
            objectArray = new CallFrame[n + 1];
            context.previousInterpreterInvocations.toArray(objectArray);
        }
        objectArray[objectArray.length - 1] = (CallFrame)context.lastInterpreterFrame;
        n = 0;
        for (int i = 0; i != objectArray.length; ++i) {
            n += 1 + ((CallFrame)objectArray[i]).frameIndex;
        }
        int[] nArray = new int[n];
        int n2 = n;
        int n3 = objectArray.length;
        while (n3 != 0) {
            Object object = objectArray[--n3];
            while (object != null) {
                nArray[--n2] = ((CallFrame)object).pcSourceLineStart;
                object = ((CallFrame)object).parentFrame;
            }
        }
        if (n2 != 0) {
            Kit.codeBug();
        }
        rhinoException.interpreterStackInfo = objectArray;
        rhinoException.interpreterLineData = nArray;
    }

    @Override
    public String getSourcePositionFromStack(Context context, int[] nArray) {
        CallFrame callFrame = (CallFrame)context.lastInterpreterFrame;
        InterpreterData interpreterData = callFrame.idata;
        nArray[0] = callFrame.pcSourceLineStart >= 0 ? Interpreter.getIndex(interpreterData.itsICode, callFrame.pcSourceLineStart) : 0;
        return interpreterData.itsSourceFile;
    }

    @Override
    public String getPatchedStack(RhinoException rhinoException, String string) {
        String string2 = "sun.org.mozilla.javascript.internal.Interpreter.interpretLoop";
        StringBuffer stringBuffer = new StringBuffer(string.length() + 1000);
        String string3 = SecurityUtilities.getSystemProperty("line.separator");
        CallFrame[] callFrameArray = (CallFrame[])rhinoException.interpreterStackInfo;
        int[] nArray = rhinoException.interpreterLineData;
        int n = callFrameArray.length;
        int n2 = nArray.length;
        int n3 = 0;
        while (n != 0) {
            char c;
            --n;
            int n4 = string.indexOf(string2, n3);
            if (n4 < 0) break;
            n4 += string2.length();
            while (n4 != string.length() && (c = string.charAt(n4)) != '\n' && c != '\r') {
                ++n4;
            }
            stringBuffer.append(string.substring(n3, n4));
            n3 = n4;
            CallFrame callFrame = callFrameArray[n];
            while (callFrame != null) {
                if (n2 == 0) {
                    Kit.codeBug();
                }
                --n2;
                InterpreterData interpreterData = callFrame.idata;
                stringBuffer.append(string3);
                stringBuffer.append("\tat script");
                if (interpreterData.itsName != null && interpreterData.itsName.length() != 0) {
                    stringBuffer.append('.');
                    stringBuffer.append(interpreterData.itsName);
                }
                stringBuffer.append('(');
                stringBuffer.append(interpreterData.itsSourceFile);
                int n5 = nArray[n2];
                if (n5 >= 0) {
                    stringBuffer.append(':');
                    stringBuffer.append(Interpreter.getIndex(interpreterData.itsICode, n5));
                }
                stringBuffer.append(')');
                callFrame = callFrame.parentFrame;
            }
        }
        stringBuffer.append(string.substring(n3));
        return stringBuffer.toString();
    }

    @Override
    public List<String> getScriptStack(RhinoException rhinoException) {
        ScriptStackElement[][] scriptStackElementArray = this.getScriptStackElements(rhinoException);
        ArrayList<String> arrayList = new ArrayList<String>(scriptStackElementArray.length);
        String string = SecurityUtilities.getSystemProperty("line.separator");
        for (ScriptStackElement[] scriptStackElementArray2 : scriptStackElementArray) {
            StringBuilder stringBuilder = new StringBuilder();
            for (ScriptStackElement scriptStackElement : scriptStackElementArray2) {
                scriptStackElement.renderJavaStyle(stringBuilder);
                stringBuilder.append(string);
            }
            arrayList.add(stringBuilder.toString());
        }
        return arrayList;
    }

    public ScriptStackElement[][] getScriptStackElements(RhinoException rhinoException) {
        if (rhinoException.interpreterStackInfo == null) {
            return null;
        }
        ArrayList<ScriptStackElement[]> arrayList = new ArrayList<ScriptStackElement[]>();
        CallFrame[] callFrameArray = (CallFrame[])rhinoException.interpreterStackInfo;
        int[] nArray = rhinoException.interpreterLineData;
        int n = callFrameArray.length;
        int n2 = nArray.length;
        while (n != 0) {
            CallFrame callFrame = callFrameArray[--n];
            ArrayList<ScriptStackElement> arrayList2 = new ArrayList<ScriptStackElement>();
            while (callFrame != null) {
                int n3;
                if (n2 == 0) {
                    Kit.codeBug();
                }
                InterpreterData interpreterData = callFrame.idata;
                String string = interpreterData.itsSourceFile;
                String string2 = null;
                int n4 = -1;
                if ((n3 = nArray[--n2]) >= 0) {
                    n4 = Interpreter.getIndex(interpreterData.itsICode, n3);
                }
                if (interpreterData.itsName != null && interpreterData.itsName.length() != 0) {
                    string2 = interpreterData.itsName;
                }
                callFrame = callFrame.parentFrame;
                arrayList2.add(new ScriptStackElement(string, string2, n4));
            }
            arrayList.add(arrayList2.toArray(new ScriptStackElement[arrayList2.size()]));
        }
        return (ScriptStackElement[][])arrayList.toArray((T[])new ScriptStackElement[arrayList.size()][]);
    }

    static String getEncodedSource(InterpreterData interpreterData) {
        if (interpreterData.encodedSource == null) {
            return null;
        }
        return interpreterData.encodedSource.substring(interpreterData.encodedSourceStart, interpreterData.encodedSourceEnd);
    }

    private static void initFunction(Context context, Scriptable scriptable, InterpretedFunction interpretedFunction, int n) {
        InterpretedFunction interpretedFunction2 = InterpretedFunction.createFunction(context, scriptable, interpretedFunction, n);
        ScriptRuntime.initFunction(context, scriptable, interpretedFunction2, interpretedFunction2.idata.itsFunctionType, interpretedFunction.idata.evalScriptFlag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object interpret(InterpretedFunction interpretedFunction, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!ScriptRuntime.hasTopCall(context)) {
            Kit.codeBug();
        }
        if (context.interpreterSecurityDomain != interpretedFunction.securityDomain) {
            Object object = context.interpreterSecurityDomain;
            context.interpreterSecurityDomain = interpretedFunction.securityDomain;
            try {
                Object object2 = interpretedFunction.securityController.callWithDomain(interpretedFunction.securityDomain, context, interpretedFunction, scriptable, scriptable2, objectArray);
                return object2;
            }
            finally {
                context.interpreterSecurityDomain = object;
            }
        }
        CallFrame callFrame = new CallFrame();
        Interpreter.initFrame(context, scriptable, scriptable2, objectArray, null, 0, objectArray.length, interpretedFunction, null, callFrame);
        callFrame.isContinuationsTopFrame = context.isContinuationsTopCall;
        context.isContinuationsTopCall = false;
        return Interpreter.interpretLoop(context, callFrame, null);
    }

    public static Object resumeGenerator(Context context, Scriptable scriptable, int n, Object object, Object object2) {
        CallFrame callFrame = (CallFrame)object;
        GeneratorState generatorState = new GeneratorState(n, object2);
        if (n == 2) {
            try {
                return Interpreter.interpretLoop(context, callFrame, generatorState);
            }
            catch (RuntimeException runtimeException) {
                if (runtimeException != object2) {
                    throw runtimeException;
                }
                return Undefined.instance;
            }
        }
        Object object3 = Interpreter.interpretLoop(context, callFrame, generatorState);
        if (generatorState.returnedException != null) {
            throw generatorState.returnedException;
        }
        return object3;
    }

    public static Object restartContinuation(NativeContinuation nativeContinuation, Context context, Scriptable scriptable, Object[] objectArray) {
        if (!ScriptRuntime.hasTopCall(context)) {
            return ScriptRuntime.doTopCall(nativeContinuation, context, scriptable, null, objectArray);
        }
        Object object = objectArray.length == 0 ? Undefined.instance : objectArray[0];
        CallFrame callFrame = (CallFrame)nativeContinuation.getImplementation();
        if (callFrame == null) {
            return object;
        }
        ContinuationJump continuationJump = new ContinuationJump(nativeContinuation, null);
        continuationJump.result = object;
        return Interpreter.interpretLoop(context, null, continuationJump);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static Object interpretLoop(Context var0, CallFrame var1_1, Object var2_2) {
        block289: {
            var3_3 = UniqueTag.DOUBLE_MARK;
            var4_4 = Undefined.instance;
            var5_5 = var0.instructionThreshold != 0;
            var8_6 = null;
            var9_7 = -1;
            if (var0.lastInterpreterFrame != null) {
                if (var0.previousInterpreterInvocations == null) {
                    var0.previousInterpreterInvocations = new ObjArray();
                }
                var0.previousInterpreterInvocations.push(var0.lastInterpreterFrame);
            }
            var10_8 = null;
            if (var2_2 != null) {
                if (var2_2 instanceof GeneratorState) {
                    var10_8 = (GeneratorState)var2_2;
                    Interpreter.enterFrame(var0, var1_1, ScriptRuntime.emptyArgs, true);
                    var2_2 = null;
                } else if (!(var2_2 instanceof ContinuationJump)) {
                    Kit.codeBug();
                }
            }
            var11_9 = null;
            var12_10 = 0.0;
            block156: while (true) {
                block290: {
                    block288: {
                        try {
                            block157: while (true) {
                                if (var2_2 != null) {
                                    var1_1 = Interpreter.processThrowable(var0, var2_2, var1_1, var9_7, var5_5);
                                    var2_2 = var1_1.throwable;
                                    var1_1.throwable = null;
                                } else if (var10_8 == null && var1_1.frozen) {
                                    Kit.codeBug();
                                }
                                var14_11 = var1_1.stack;
                                var15_13 = var1_1.sDbl;
                                var16_14 = var1_1.varSource.stack;
                                var17_15 = var1_1.varSource.sDbl;
                                var18_17 /* !! */  = var1_1.varSource.stackAttributes;
                                var19_18 /* !! */  = var1_1.idata.itsICode;
                                var20_22 = var1_1.idata.itsStringTable;
                                var21_24 = var1_1.savedStackTop;
                                var0.lastInterpreterFrame = var1_1;
                                block158: while (true) {
                                    var22_25 = var19_18 /* !! */ [var1_1.pc++];
                                    switch (var22_25) {
                                        case -62: {
                                            if (!var1_1.frozen) {
                                                --var1_1.pc;
                                                var23_26 = Interpreter.captureFrameForGenerator(var1_1);
                                                var23_26.frozen = true;
                                                var24_86 = new NativeGenerator(var1_1.scope, var23_26.fnOrScript, var23_26);
                                                var1_1.result = var24_86;
                                                break block158;
                                            }
                                        }
                                        case 72: {
                                            if (!var1_1.frozen) {
                                                return Interpreter.freezeGenerator(var0, var1_1, var21_24, var10_8);
                                            }
                                            var23_27 = Interpreter.thawGenerator(var1_1, var21_24, var10_8, var22_25);
                                            if (var23_27 == Scriptable.NOT_FOUND) continue block158;
                                            var2_2 = var23_27;
                                            break block288;
                                        }
                                        case -63: {
                                            var1_1.frozen = true;
                                            var23_28 = Interpreter.getIndex(var19_18 /* !! */ , var1_1.pc);
                                            var10_8.returnedException = new JavaScriptException(NativeIterator.getStopIterationObject(var1_1.scope), var1_1.idata.itsSourceFile, var23_28);
                                            break block158;
                                        }
                                        case 73: {
                                            var23_29 = var14_11[var21_24];
                                            if (var23_29 == var3_3) {
                                                var23_29 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            if ((var24_87 = (Scriptable)var14_11[--var21_24]) != null) {
                                                var14_11[var21_24] = ScriptRuntime.setName(var24_87, var23_29, var0, var1_1.scope, var8_6);
                                                continue block158;
                                            }
                                            var14_11[var21_24] = var0.newObject(var1_1.scope, "ReferenceError", new Object[]{var8_6});
                                        }
                                        case 50: {
                                            var23_30 = var14_11[var21_24];
                                            if (var23_30 == var3_3) {
                                                var23_30 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            --var21_24;
                                            var24_88 = Interpreter.getIndex(var19_18 /* !! */ , var1_1.pc);
                                            var2_2 = new JavaScriptException(var23_30, var1_1.idata.itsSourceFile, var24_88);
                                            break block288;
                                        }
                                        case 51: {
                                            var2_2 = var14_11[var9_7 += var1_1.localShift];
                                            break block288;
                                        }
                                        case 14: 
                                        case 15: 
                                        case 16: 
                                        case 17: {
                                            var23_31 = var14_11[--var21_24 + 1];
                                            var24_89 = var14_11[var21_24];
                                            if (var23_31 != var3_3) ** GOTO lbl91
                                            var26_136 = var15_13[var21_24 + 1];
                                            var28_151 = Interpreter.stack_double(var1_1, var21_24);
                                            ** GOTO lbl94
lbl91:
                                            // 1 sources

                                            if (var24_89 != var3_3) ** GOTO lbl109
                                            var26_136 = ScriptRuntime.toNumber(var23_31);
                                            var28_151 = var15_13[var21_24];
lbl94:
                                            // 2 sources

                                            switch (var22_25) {
                                                case 17: {
                                                    var25_119 = var28_151 >= var26_136;
                                                    ** GOTO lbl124
                                                }
                                                case 15: {
                                                    var25_119 = var28_151 <= var26_136;
                                                    ** GOTO lbl124
                                                }
                                                case 16: {
                                                    var25_119 = var28_151 > var26_136;
                                                    ** GOTO lbl124
                                                }
                                                case 14: {
                                                    var25_119 = var28_151 < var26_136;
                                                    ** GOTO lbl124
                                                }
                                                default: {
                                                    throw Kit.codeBug();
                                                }
                                            }
lbl109:
                                            // 1 sources

                                            switch (var22_25) {
                                                case 17: {
                                                    var25_119 = ScriptRuntime.cmp_LE(var23_31, var24_89);
                                                    break;
                                                }
                                                case 15: {
                                                    var25_119 = ScriptRuntime.cmp_LE(var24_89, var23_31);
                                                    break;
                                                }
                                                case 16: {
                                                    var25_119 = ScriptRuntime.cmp_LT(var23_31, var24_89);
                                                    break;
                                                }
                                                case 14: {
                                                    var25_119 = ScriptRuntime.cmp_LT(var24_89, var23_31);
                                                    break;
                                                }
                                                default: {
                                                    throw Kit.codeBug();
                                                }
                                            }
lbl124:
                                            // 8 sources

                                            var14_11[var21_24] = ScriptRuntime.wrapBoolean(var25_119);
                                            continue block158;
                                        }
                                        case 52: 
                                        case 53: {
                                            var23_32 = var14_11[var21_24];
                                            if (var23_32 == var3_3) {
                                                var23_32 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            if ((var24_90 = var14_11[--var21_24]) == var3_3) {
                                                var24_90 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var25_120 = var22_25 == 52 ? ScriptRuntime.in(var24_90, var23_32, var0) : ScriptRuntime.instanceOf(var24_90, var23_32, var0);
                                            var14_11[var21_24] = ScriptRuntime.wrapBoolean(var25_120);
                                            continue block158;
                                        }
                                        case 12: 
                                        case 13: {
                                            var24_91 = var14_11[--var21_24 + 1];
                                            var25_121 = var14_11[var21_24];
                                            var23_33 = var24_91 == var3_3 ? (var25_121 == var3_3 ? var15_13[var21_24] == var15_13[var21_24 + 1] : ScriptRuntime.eqNumber(var15_13[var21_24 + 1], var25_121)) : (var25_121 == var3_3 ? ScriptRuntime.eqNumber(var15_13[var21_24], var24_91) : ScriptRuntime.eq(var25_121, var24_91));
                                            var14_11[var21_24] = ScriptRuntime.wrapBoolean(var23_33 ^= var22_25 == 13);
                                            continue block158;
                                        }
                                        case 46: 
                                        case 47: {
                                            var23_34 = Interpreter.shallowEquals(var14_11, var15_13, --var21_24);
                                            var14_11[var21_24] = ScriptRuntime.wrapBoolean(var23_34 ^= var22_25 == 47);
                                            continue block158;
                                        }
                                        case 7: {
                                            if (!Interpreter.stack_boolean(var1_1, var21_24--)) break;
                                            var1_1.pc += 2;
                                            continue block158;
                                        }
                                        case 6: {
                                            if (Interpreter.stack_boolean(var1_1, var21_24--)) break;
                                            var1_1.pc += 2;
                                            continue block158;
                                        }
                                        case -6: {
                                            if (!Interpreter.stack_boolean(var1_1, var21_24--)) {
                                                var1_1.pc += 2;
                                                continue block158;
                                            }
                                            var14_11[var21_24--] = null;
                                            break;
                                        }
                                        case 5: {
                                            break;
                                        }
                                        case -23: {
                                            var14_11[++var21_24] = var3_3;
                                            var15_13[var21_24] = var1_1.pc + 2;
                                            break;
                                        }
                                        case -24: {
                                            if (var21_24 == var1_1.emptyStackTop + 1) {
                                                var14_11[var9_7 += var1_1.localShift] = var14_11[var21_24];
                                                var15_13[var9_7] = var15_13[var21_24];
                                                --var21_24;
                                                continue block158;
                                            }
                                            if (var21_24 == var1_1.emptyStackTop) continue block158;
                                            Kit.codeBug();
                                            continue block158;
                                        }
                                        case -25: {
                                            if (var5_5) {
                                                Interpreter.addInstructionCount(var0, var1_1, 0);
                                            }
                                            if ((var23_35 = var14_11[var9_7 += var1_1.localShift]) != var3_3) {
                                                var2_2 = var23_35;
                                                break block288;
                                            }
                                            var1_1.pc = (int)var15_13[var9_7];
                                            if (!var5_5) continue block158;
                                            var1_1.pcPrevBranch = var1_1.pc;
                                            continue block158;
                                        }
                                        case -4: {
                                            var14_11[var21_24] = null;
                                            --var21_24;
                                            continue block158;
                                        }
                                        case -5: {
                                            var1_1.result = var14_11[var21_24];
                                            var1_1.resultDbl = var15_13[var21_24];
                                            var14_11[var21_24] = null;
                                            --var21_24;
                                            continue block158;
                                        }
                                        case -1: {
                                            var14_11[var21_24 + 1] = var14_11[var21_24];
                                            var15_13[var21_24 + 1] = var15_13[var21_24];
                                            ++var21_24;
                                            continue block158;
                                        }
                                        case -2: {
                                            var14_11[var21_24 + 1] = var14_11[var21_24 - 1];
                                            var15_13[var21_24 + 1] = var15_13[var21_24 - 1];
                                            var14_11[var21_24 + 2] = var14_11[var21_24];
                                            var15_13[var21_24 + 2] = var15_13[var21_24];
                                            var21_24 += 2;
                                            continue block158;
                                        }
                                        case -3: {
                                            var23_36 = var14_11[var21_24];
                                            var14_11[var21_24] = var14_11[var21_24 - 1];
                                            var14_11[var21_24 - 1] = var23_36;
                                            var24_92 = var15_13[var21_24];
                                            var15_13[var21_24] = var15_13[var21_24 - 1];
                                            var15_13[var21_24 - 1] = var24_92;
                                            continue block158;
                                        }
                                        case 4: {
                                            var1_1.result = var14_11[var21_24];
                                            var1_1.resultDbl = var15_13[var21_24];
                                            --var21_24;
                                            break block158;
                                        }
                                        case 64: {
                                            break block158;
                                        }
                                        case -22: {
                                            var1_1.result = var4_4;
                                            break block158;
                                        }
                                        case 27: {
                                            var23_37 = Interpreter.stack_int32(var1_1, var21_24);
                                            var14_11[var21_24] = var3_3;
                                            var15_13[var21_24] = ~var23_37;
                                            continue block158;
                                        }
                                        case 9: 
                                        case 10: 
                                        case 11: 
                                        case 18: 
                                        case 19: {
                                            var23_38 = Interpreter.stack_int32(var1_1, var21_24 - 1);
                                            var24_93 = Interpreter.stack_int32(var1_1, var21_24);
                                            var14_11[--var21_24] = var3_3;
                                            switch (var22_25) {
                                                case 11: {
                                                    var23_38 &= var24_93;
                                                    break;
                                                }
                                                case 9: {
                                                    var23_38 |= var24_93;
                                                    break;
                                                }
                                                case 10: {
                                                    var23_38 ^= var24_93;
                                                    break;
                                                }
                                                case 18: {
                                                    var23_38 <<= var24_93;
                                                    break;
                                                }
                                                case 19: {
                                                    var23_38 >>= var24_93;
                                                }
                                            }
                                            var15_13[var21_24] = var23_38;
                                            continue block158;
                                        }
                                        case 20: {
                                            var23_39 = Interpreter.stack_double(var1_1, var21_24 - 1);
                                            var25_122 = Interpreter.stack_int32(var1_1, var21_24) & 31;
                                            var14_11[--var21_24] = var3_3;
                                            var15_13[var21_24] = ScriptRuntime.toUint32(var23_39) >>> var25_122;
                                            continue block158;
                                        }
                                        case 28: 
                                        case 29: {
                                            var23_40 = Interpreter.stack_double(var1_1, var21_24);
                                            var14_11[var21_24] = var3_3;
                                            if (var22_25 == 29) {
                                                var23_40 = -var23_40;
                                            }
                                            var15_13[var21_24] = var23_40;
                                            continue block158;
                                        }
                                        case 21: {
                                            Interpreter.do_add(var14_11, var15_13, --var21_24, var0);
                                            continue block158;
                                        }
                                        case 22: 
                                        case 23: 
                                        case 24: 
                                        case 25: {
                                            var23_41 = Interpreter.stack_double(var1_1, var21_24);
                                            var25_123 = Interpreter.stack_double(var1_1, --var21_24);
                                            var14_11[var21_24] = var3_3;
                                            switch (var22_25) {
                                                case 22: {
                                                    var25_123 -= var23_41;
                                                    break;
                                                }
                                                case 23: {
                                                    var25_123 *= var23_41;
                                                    break;
                                                }
                                                case 24: {
                                                    var25_123 /= var23_41;
                                                    break;
                                                }
                                                case 25: {
                                                    var25_123 %= var23_41;
                                                }
                                            }
                                            var15_13[var21_24] = var25_123;
                                            continue block158;
                                        }
                                        case 26: {
                                            var14_11[var21_24] = ScriptRuntime.wrapBoolean(Interpreter.stack_boolean(var1_1, var21_24) == false);
                                            continue block158;
                                        }
                                        case 49: {
                                            var14_11[++var21_24] = ScriptRuntime.bind(var0, var1_1.scope, var8_6);
                                            continue block158;
                                        }
                                        case 8: {
                                            var23_42 = var14_11[var21_24];
                                            if (var23_42 == var3_3) {
                                                var23_42 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var24_94 = (Scriptable)var14_11[--var21_24];
                                            var14_11[var21_24] = ScriptRuntime.setName(var24_94, var23_42, var0, var1_1.scope, var8_6);
                                            continue block158;
                                        }
                                        case -59: {
                                            var23_43 = var14_11[var21_24];
                                            if (var23_43 == var3_3) {
                                                var23_43 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var24_95 = (Scriptable)var14_11[--var21_24];
                                            var14_11[var21_24] = ScriptRuntime.setConst(var24_95, var23_43, var0, var8_6);
                                            continue block158;
                                        }
                                        case 31: {
                                            var23_44 = var14_11[var21_24];
                                            if (var23_44 == var3_3) {
                                                var23_44 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            if ((var24_96 = var14_11[--var21_24]) == var3_3) {
                                                var24_96 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var14_11[var21_24] = ScriptRuntime.delete(var24_96, var23_44, var0);
                                            continue block158;
                                        }
                                        case 34: {
                                            var23_45 = var14_11[var21_24];
                                            if (var23_45 == var3_3) {
                                                var23_45 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var14_11[var21_24] = ScriptRuntime.getObjectPropNoWarn(var23_45, var8_6, var0);
                                            continue block158;
                                        }
                                        case 33: {
                                            var23_46 = var14_11[var21_24];
                                            if (var23_46 == var3_3) {
                                                var23_46 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var14_11[var21_24] = ScriptRuntime.getObjectProp(var23_46, var8_6, var0, var1_1.scope);
                                            continue block158;
                                        }
                                        case 35: {
                                            var23_47 = var14_11[var21_24];
                                            if (var23_47 == var3_3) {
                                                var23_47 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            if ((var24_97 = var14_11[--var21_24]) == var3_3) {
                                                var24_97 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var14_11[var21_24] = ScriptRuntime.setObjectProp(var24_97, var8_6, var23_47, var0);
                                            continue block158;
                                        }
                                        case -9: {
                                            var23_48 = var14_11[var21_24];
                                            if (var23_48 == var3_3) {
                                                var23_48 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var14_11[var21_24] = ScriptRuntime.propIncrDecr(var23_48, var8_6, var0, var19_18 /* !! */ [var1_1.pc]);
                                            ++var1_1.pc;
                                            continue block158;
                                        }
                                        case 36: {
                                            var23_49 = var14_11[--var21_24];
                                            if (var23_49 == var3_3) {
                                                var23_49 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            if ((var25_124 = var14_11[var21_24 + 1]) != var3_3) {
                                                var24_98 = ScriptRuntime.getObjectElem(var23_49, var25_124, var0, var1_1.scope);
                                            } else {
                                                var26_137 = var15_13[var21_24 + 1];
                                                var24_98 = ScriptRuntime.getObjectIndex(var23_49, var26_137, var0);
                                            }
                                            var14_11[var21_24] = var24_98;
                                            continue block158;
                                        }
                                        case 37: {
                                            var23_50 = var14_11[(var21_24 -= 2) + 2];
                                            if (var23_50 == var3_3) {
                                                var23_50 = ScriptRuntime.wrapNumber(var15_13[var21_24 + 2]);
                                            }
                                            if ((var24_99 = var14_11[var21_24]) == var3_3) {
                                                var24_99 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            if ((var26_138 = var14_11[var21_24 + 1]) != var3_3) {
                                                var25_125 = ScriptRuntime.setObjectElem(var24_99, var26_138, var23_50, var0);
                                            } else {
                                                var27_146 = var15_13[var21_24 + 1];
                                                var25_125 = ScriptRuntime.setObjectIndex(var24_99, var27_146, var23_50, var0);
                                            }
                                            var14_11[var21_24] = var25_125;
                                            continue block158;
                                        }
                                        case -10: {
                                            var23_51 = var14_11[var21_24];
                                            if (var23_51 == var3_3) {
                                                var23_51 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            if ((var24_100 = var14_11[--var21_24]) == var3_3) {
                                                var24_100 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var14_11[var21_24] = ScriptRuntime.elemIncrDecr(var24_100, var23_51, var0, var19_18 /* !! */ [var1_1.pc]);
                                            ++var1_1.pc;
                                            continue block158;
                                        }
                                        case 67: {
                                            var23_52 = (Ref)var14_11[var21_24];
                                            var14_11[var21_24] = ScriptRuntime.refGet(var23_52, var0);
                                            continue block158;
                                        }
                                        case 68: {
                                            var23_53 = var14_11[var21_24];
                                            if (var23_53 == var3_3) {
                                                var23_53 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var24_101 = (Ref)var14_11[--var21_24];
                                            var14_11[var21_24] = ScriptRuntime.refSet(var24_101, var23_53, var0);
                                            continue block158;
                                        }
                                        case 69: {
                                            var23_54 = (Ref)var14_11[var21_24];
                                            var14_11[var21_24] = ScriptRuntime.refDel(var23_54, var0);
                                            continue block158;
                                        }
                                        case -11: {
                                            var23_55 = (Ref)var14_11[var21_24];
                                            var14_11[var21_24] = ScriptRuntime.refIncrDecr(var23_55, var0, var19_18 /* !! */ [var1_1.pc]);
                                            ++var1_1.pc;
                                            continue block158;
                                        }
                                        case 54: {
                                            var14_11[++var21_24] = var14_11[var9_7 += var1_1.localShift];
                                            var15_13[var21_24] = var15_13[var9_7];
                                            continue block158;
                                        }
                                        case -56: {
                                            var14_11[var9_7 += var1_1.localShift] = null;
                                            continue block158;
                                        }
                                        case -15: {
                                            var14_11[++var21_24] = ScriptRuntime.getNameFunctionAndThis(var8_6, var0, var1_1.scope);
                                            var14_11[++var21_24] = ScriptRuntime.lastStoredScriptable(var0);
                                            continue block158;
                                        }
                                        case -16: {
                                            var23_56 = var14_11[var21_24];
                                            if (var23_56 == var3_3) {
                                                var23_56 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var14_11[var21_24] = ScriptRuntime.getPropFunctionAndThis(var23_56, var8_6, var0, var1_1.scope);
                                            var14_11[++var21_24] = ScriptRuntime.lastStoredScriptable(var0);
                                            continue block158;
                                        }
                                        case -17: {
                                            var23_57 = var14_11[var21_24 - 1];
                                            if (var23_57 == var3_3) {
                                                var23_57 = ScriptRuntime.wrapNumber(var15_13[var21_24 - 1]);
                                            }
                                            if ((var24_102 = var14_11[var21_24]) == var3_3) {
                                                var24_102 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var14_11[var21_24 - 1] = ScriptRuntime.getElemFunctionAndThis(var23_57, var24_102, var0);
                                            var14_11[var21_24] = ScriptRuntime.lastStoredScriptable(var0);
                                            continue block158;
                                        }
                                        case -18: {
                                            var23_58 = var14_11[var21_24];
                                            if (var23_58 == var3_3) {
                                                var23_58 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var14_11[var21_24] = ScriptRuntime.getValueFunctionAndThis(var23_58, var0);
                                            var14_11[++var21_24] = ScriptRuntime.lastStoredScriptable(var0);
                                            continue block158;
                                        }
                                        case -21: {
                                            if (var5_5) {
                                                var0.instructionCount += 100;
                                            }
                                            var23_59 = var19_18 /* !! */ [var1_1.pc] & 255;
                                            var24_103 = var19_18 /* !! */ [var1_1.pc + 1] != 0;
                                            var25_126 = Interpreter.getIndex(var19_18 /* !! */ , var1_1.pc + 2);
                                            if (var24_103) {
                                                var26_139 = var14_11[var21_24 -= var9_7];
                                                if (var26_139 == var3_3) {
                                                    var26_139 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                                }
                                                var27_147 = Interpreter.getArgsArray(var14_11, var15_13, var21_24 + 1, var9_7);
                                                var14_11[var21_24] = ScriptRuntime.newSpecial(var0, var26_139, var27_147, var1_1.scope, var23_59);
                                            } else {
                                                var26_139 = (Scriptable)var14_11[(var21_24 -= 1 + var9_7) + 1];
                                                var27_147 = (Object[])var14_11[var21_24];
                                                var28_152 = Interpreter.getArgsArray(var14_11, var15_13, var21_24 + 2, var9_7);
                                                var14_11[var21_24] = ScriptRuntime.callSpecial(var0, (Callable)var27_147, (Scriptable)var26_139, var28_152, var1_1.scope, var1_1.thisObj, var23_59, var1_1.idata.itsSourceFile, var25_126);
                                            }
                                            var1_1.pc += 4;
                                            continue block158;
                                        }
                                        case -55: 
                                        case 38: 
                                        case 70: {
                                            if (var5_5) {
                                                var0.instructionCount += 100;
                                            }
                                            var23_60 = (Callable)var14_11[var21_24 -= 1 + var9_7];
                                            var24_104 = (Scriptable)var14_11[var21_24 + 1];
                                            if (var22_25 == 70) {
                                                var25_127 = Interpreter.getArgsArray(var14_11, var15_13, var21_24 + 2, var9_7);
                                                var14_11[var21_24] = ScriptRuntime.callRef(var23_60, var24_104, var25_127, var0);
                                                continue block158;
                                            }
                                            var25_128 = var1_1.scope;
                                            if (var1_1.useActivation) {
                                                var25_128 = ScriptableObject.getTopLevelScope(var1_1.scope);
                                            }
                                            if (var23_60 instanceof InterpretedFunction) {
                                                var26_140 = (InterpretedFunction)var23_60;
                                                if (var1_1.fnOrScript.securityDomain == var26_140.securityDomain) {
                                                    var27_148 = var1_1;
                                                    var28_153 = new CallFrame();
                                                    if (var22_25 == -55) {
                                                        var27_148 = var1_1.parentFrame;
                                                        Interpreter.exitFrame(var0, var1_1, null);
                                                    }
                                                    Interpreter.initFrame(var0, var25_128, var24_104, var14_11, var15_13, var21_24 + 2, var9_7, var26_140, var27_148, var28_153);
                                                    if (var22_25 != -55) {
                                                        var1_1.savedStackTop = var21_24;
                                                        var1_1.savedCallOp = var22_25;
                                                    }
                                                    var1_1 = var28_153;
                                                    continue block157;
                                                }
                                            }
                                            if (var23_60 instanceof NativeContinuation) {
                                                var26_141 = new ContinuationJump((NativeContinuation)var23_60, var1_1);
                                                if (var9_7 == 0) {
                                                    var26_141.result = var4_4;
                                                } else {
                                                    var26_141.result = var14_11[var21_24 + 2];
                                                    var26_141.resultDbl = var15_13[var21_24 + 2];
                                                }
                                                var2_2 = var26_141;
                                                break block288;
                                            }
                                            if (var23_60 instanceof IdFunctionObject) {
                                                var26_142 = (IdFunctionObject)var23_60;
                                                if (NativeContinuation.isContinuationConstructor(var26_142)) {
                                                    var1_1.stack[var21_24] = Interpreter.captureContinuation(var0, var1_1.parentFrame, false);
                                                    continue block158;
                                                }
                                                if (BaseFunction.isApplyOrCall(var26_142) && (var27_149 = ScriptRuntime.getCallable(var24_104)) instanceof InterpretedFunction) {
                                                    var28_154 = (InterpretedFunction)var27_149;
                                                    if (var1_1.fnOrScript.securityDomain == var28_154.securityDomain) {
                                                        var1_1 = Interpreter.initFrameForApplyOrCall(var0, var1_1, var9_7, var14_11, var15_13, var21_24, var22_25, var25_128, var26_142, var28_154);
                                                        continue block157;
                                                    }
                                                }
                                            }
                                            if (var23_60 instanceof ScriptRuntime.NoSuchMethodShim) {
                                                var26_143 = (ScriptRuntime.NoSuchMethodShim)var23_60;
                                                var27_150 = var26_143.noSuchMethodMethod;
                                                if (var27_150 instanceof InterpretedFunction) {
                                                    var28_155 = (InterpretedFunction)var27_150;
                                                    if (var1_1.fnOrScript.securityDomain == var28_155.securityDomain) {
                                                        var1_1 = Interpreter.initFrameForNoSuchMethod(var0, var1_1, var9_7, var14_11, var15_13, var21_24, var22_25, var24_104, var25_128, var26_143, var28_155);
                                                        continue block157;
                                                    }
                                                }
                                            }
                                            var0.lastInterpreterFrame = var1_1;
                                            var1_1.savedCallOp = var22_25;
                                            var1_1.savedStackTop = var21_24;
                                            var14_11[var21_24] = var23_60.call(var0, var25_128, var24_104, Interpreter.getArgsArray(var14_11, var15_13, var21_24 + 2, var9_7));
                                            continue block158;
                                        }
                                        case 30: {
                                            if (var5_5) {
                                                var0.instructionCount += 100;
                                            }
                                            if ((var23_61 = var14_11[var21_24 -= var9_7]) instanceof InterpretedFunction) {
                                                var24_105 = (InterpretedFunction)var23_61;
                                                if (var1_1.fnOrScript.securityDomain == var24_105.securityDomain) {
                                                    var25_129 = var24_105.createObject(var0, var1_1.scope);
                                                    var26_144 = new CallFrame();
                                                    Interpreter.initFrame(var0, var1_1.scope, var25_129, var14_11, var15_13, var21_24 + 1, var9_7, var24_105, var1_1, var26_144);
                                                    var14_11[var21_24] = var25_129;
                                                    var1_1.savedStackTop = var21_24;
                                                    var1_1.savedCallOp = var22_25;
                                                    var1_1 = var26_144;
                                                    continue block157;
                                                }
                                            }
                                            if (!(var23_61 instanceof Function)) {
                                                if (var23_61 == var3_3) {
                                                    var23_61 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                                }
                                                throw ScriptRuntime.notFunctionError(var23_61);
                                            }
                                            var24_106 = (Function)var23_61;
                                            if (var24_106 instanceof IdFunctionObject && NativeContinuation.isContinuationConstructor(var25_130 = (IdFunctionObject)var24_106)) {
                                                var1_1.stack[var21_24] = Interpreter.captureContinuation(var0, var1_1.parentFrame, false);
                                                continue block158;
                                            }
                                            var25_131 = Interpreter.getArgsArray(var14_11, var15_13, var21_24 + 1, var9_7);
                                            var14_11[var21_24] = var24_106.construct(var0, var1_1.scope, var25_131);
                                            continue block158;
                                        }
                                        case 32: {
                                            var23_62 = var14_11[var21_24];
                                            if (var23_62 == var3_3) {
                                                var23_62 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var14_11[var21_24] = ScriptRuntime.typeof(var23_62);
                                            continue block158;
                                        }
                                        case -14: {
                                            var14_11[++var21_24] = ScriptRuntime.typeofName(var1_1.scope, var8_6);
                                            continue block158;
                                        }
                                        case 41: {
                                            var14_11[++var21_24] = var8_6;
                                            continue block158;
                                        }
                                        case -27: {
                                            var14_11[++var21_24] = var3_3;
                                            var15_13[var21_24] = Interpreter.getShort(var19_18 /* !! */ , var1_1.pc);
                                            var1_1.pc += 2;
                                            continue block158;
                                        }
                                        case -28: {
                                            var14_11[++var21_24] = var3_3;
                                            var15_13[var21_24] = Interpreter.getInt(var19_18 /* !! */ , var1_1.pc);
                                            var1_1.pc += 4;
                                            continue block158;
                                        }
                                        case 40: {
                                            var14_11[++var21_24] = var3_3;
                                            var15_13[var21_24] = var1_1.idata.itsDoubleTable[var9_7];
                                            continue block158;
                                        }
                                        case 39: {
                                            var14_11[++var21_24] = ScriptRuntime.name(var0, var1_1.scope, var8_6);
                                            continue block158;
                                        }
                                        case -8: {
                                            var14_11[++var21_24] = ScriptRuntime.nameIncrDecr(var1_1.scope, var8_6, var0, var19_18 /* !! */ [var1_1.pc]);
                                            ++var1_1.pc;
                                            continue block158;
                                        }
                                        case -61: {
                                            var9_7 = var19_18 /* !! */ [var1_1.pc++];
                                        }
                                        case 156: {
                                            if (!var1_1.useActivation) {
                                                if ((var18_17 /* !! */ [var9_7] & 1) == 0) {
                                                    throw Context.reportRuntimeError1("msg.var.redecl", var1_1.idata.argNames[var9_7]);
                                                }
                                                if ((var18_17 /* !! */ [var9_7] & 8) == 0) continue block158;
                                                var16_14[var9_7] = var14_11[var21_24];
                                                v0 = var9_7;
                                                var18_17 /* !! */ [v0] = var18_17 /* !! */ [v0] & -9;
                                                var17_15[var9_7] = var15_13[var21_24];
                                                continue block158;
                                            }
                                            var23_63 = var14_11[var21_24];
                                            if (var23_63 == var3_3) {
                                                var23_63 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var8_6 = var1_1.idata.argNames[var9_7];
                                            if (var1_1.scope instanceof ConstProperties) {
                                                var24_107 = (ConstProperties)var1_1.scope;
                                                var24_107.putConst(var8_6, var1_1.scope, var23_63);
                                                continue block158;
                                            }
                                            throw Kit.codeBug();
                                        }
                                        case -49: {
                                            var9_7 = var19_18 /* !! */ [var1_1.pc++];
                                        }
                                        case 56: {
                                            if (!var1_1.useActivation) {
                                                if ((var18_17 /* !! */ [var9_7] & 1) != 0) continue block158;
                                                var16_14[var9_7] = var14_11[var21_24];
                                                var17_15[var9_7] = var15_13[var21_24];
                                                continue block158;
                                            }
                                            var23_64 = var14_11[var21_24];
                                            if (var23_64 == var3_3) {
                                                var23_64 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var8_6 = var1_1.idata.argNames[var9_7];
                                            var1_1.scope.put(var8_6, var1_1.scope, var23_64);
                                            continue block158;
                                        }
                                        case -48: {
                                            var9_7 = var19_18 /* !! */ [var1_1.pc++];
                                        }
                                        case 55: {
                                            ++var21_24;
                                            if (!var1_1.useActivation) {
                                                var14_11[var21_24] = var16_14[var9_7];
                                                var15_13[var21_24] = var17_15[var9_7];
                                                continue block158;
                                            }
                                            var8_6 = var1_1.idata.argNames[var9_7];
                                            var14_11[var21_24] = var1_1.scope.get(var8_6, var1_1.scope);
                                            continue block158;
                                        }
                                        case -7: {
                                            ++var21_24;
                                            var23_65 = var19_18 /* !! */ [var1_1.pc];
                                            if (!var1_1.useActivation) {
                                                var14_11[var21_24] = var3_3;
                                                var24_108 = var16_14[var9_7];
                                                if (var24_108 == var3_3) {
                                                    var25_132 = var17_15[var9_7];
                                                } else {
                                                    var25_132 = ScriptRuntime.toNumber(var24_108);
                                                    var16_14[var9_7] = var3_3;
                                                }
                                                var17_15[var9_7] = var27_146 = (var23_65 & 1) == 0 ? var25_132 + 1.0 : var25_132 - 1.0;
                                                var15_13[var21_24] = (var23_65 & 2) == 0 ? var27_146 : var25_132;
                                            } else {
                                                var24_108 = var1_1.idata.argNames[var9_7];
                                                var14_11[var21_24] = ScriptRuntime.nameIncrDecr(var1_1.scope, (String)var24_108, var0, var23_65);
                                            }
                                            ++var1_1.pc;
                                            continue block158;
                                        }
                                        case -51: {
                                            var14_11[++var21_24] = var3_3;
                                            var15_13[var21_24] = 0.0;
                                            continue block158;
                                        }
                                        case -52: {
                                            var14_11[++var21_24] = var3_3;
                                            var15_13[var21_24] = 1.0;
                                            continue block158;
                                        }
                                        case 42: {
                                            var14_11[++var21_24] = null;
                                            continue block158;
                                        }
                                        case 43: {
                                            var14_11[++var21_24] = var1_1.thisObj;
                                            continue block158;
                                        }
                                        case 63: {
                                            var14_11[++var21_24] = var1_1.fnOrScript;
                                            continue block158;
                                        }
                                        case 44: {
                                            var14_11[++var21_24] = Boolean.FALSE;
                                            continue block158;
                                        }
                                        case 45: {
                                            var14_11[++var21_24] = Boolean.TRUE;
                                            continue block158;
                                        }
                                        case -50: {
                                            var14_11[++var21_24] = var4_4;
                                            continue block158;
                                        }
                                        case 2: {
                                            var23_66 = var14_11[var21_24];
                                            if (var23_66 == var3_3) {
                                                var23_66 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            --var21_24;
                                            var1_1.scope = ScriptRuntime.enterWith(var23_66, var0, var1_1.scope);
                                            continue block158;
                                        }
                                        case 3: {
                                            var1_1.scope = ScriptRuntime.leaveWith(var1_1.scope);
                                            continue block158;
                                        }
                                        case 57: {
                                            var23_67 = var1_1.idata.itsICode[var1_1.pc] != 0;
                                            var24_109 = (Throwable)var14_11[--var21_24 + 1];
                                            var25_133 = var23_67 == false ? null : (Scriptable)var14_11[var9_7 += var1_1.localShift];
                                            var14_11[var9_7] = ScriptRuntime.newCatchScope(var24_109, var25_133, var8_6, var0, var1_1.scope);
                                            ++var1_1.pc;
                                            continue block158;
                                        }
                                        case 58: 
                                        case 59: 
                                        case 60: {
                                            var23_68 = var14_11[var21_24];
                                            if (var23_68 == var3_3) {
                                                var23_68 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            --var21_24;
                                            var24_110 = var22_25 == 58 ? 0 : (var22_25 == 59 ? 1 : 2);
                                            var14_11[var9_7 += var1_1.localShift] = ScriptRuntime.enumInit(var23_68, var0, var24_110);
                                            continue block158;
                                        }
                                        case 61: 
                                        case 62: {
                                            var23_69 = var14_11[var9_7 += var1_1.localShift];
                                            var14_11[++var21_24] = var22_25 == 61 ? ScriptRuntime.enumNext(var23_69) : ScriptRuntime.enumId(var23_69, var0);
                                            continue block158;
                                        }
                                        case 71: {
                                            var23_70 = var14_11[var21_24];
                                            if (var23_70 == var3_3) {
                                                var23_70 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var14_11[var21_24] = ScriptRuntime.specialRef(var23_70, var8_6, var0);
                                            continue block158;
                                        }
                                        case 77: {
                                            var23_71 = var14_11[var21_24];
                                            if (var23_71 == var3_3) {
                                                var23_71 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            if ((var24_111 = var14_11[--var21_24]) == var3_3) {
                                                var24_111 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var14_11[var21_24] = ScriptRuntime.memberRef(var24_111, var23_71, var0, var9_7);
                                            continue block158;
                                        }
                                        case 78: {
                                            var23_72 = var14_11[var21_24];
                                            if (var23_72 == var3_3) {
                                                var23_72 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            if ((var24_112 = var14_11[--var21_24]) == var3_3) {
                                                var24_112 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            if ((var25_134 = var14_11[--var21_24]) == var3_3) {
                                                var25_134 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var14_11[var21_24] = ScriptRuntime.memberRef(var25_134, var24_112, var23_72, var0, var9_7);
                                            continue block158;
                                        }
                                        case 79: {
                                            var23_73 = var14_11[var21_24];
                                            if (var23_73 == var3_3) {
                                                var23_73 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var14_11[var21_24] = ScriptRuntime.nameRef(var23_73, var0, var1_1.scope, var9_7);
                                            continue block158;
                                        }
                                        case 80: {
                                            var23_74 = var14_11[var21_24];
                                            if (var23_74 == var3_3) {
                                                var23_74 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            if ((var24_113 = var14_11[--var21_24]) == var3_3) {
                                                var24_113 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var14_11[var21_24] = ScriptRuntime.nameRef(var24_113, var23_74, var0, var1_1.scope, var9_7);
                                            continue block158;
                                        }
                                        case -12: {
                                            var1_1.scope = (Scriptable)var14_11[var9_7 += var1_1.localShift];
                                            continue block158;
                                        }
                                        case -13: {
                                            var14_11[var9_7 += var1_1.localShift] = var1_1.scope;
                                            continue block158;
                                        }
                                        case -19: {
                                            var14_11[++var21_24] = InterpretedFunction.createFunction(var0, var1_1.scope, var1_1.fnOrScript, var9_7);
                                            continue block158;
                                        }
                                        case -20: {
                                            Interpreter.initFunction(var0, var1_1.scope, var1_1.fnOrScript, var9_7);
                                            continue block158;
                                        }
                                        case 48: {
                                            var14_11[++var21_24] = var1_1.scriptRegExps[var9_7];
                                            continue block158;
                                        }
                                        case -29: {
                                            var14_11[++var21_24] = new int[var9_7];
                                            var14_11[++var21_24] = new Object[var9_7];
                                            var15_13[var21_24] = 0.0;
                                            continue block158;
                                        }
                                        case -30: {
                                            var23_75 = var14_11[var21_24];
                                            if (var23_75 == var3_3) {
                                                var23_75 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var24_114 = (int)var15_13[--var21_24];
                                            ((Object[])var14_11[var21_24])[var24_114] = var23_75;
                                            var15_13[var21_24] = var24_114 + 1;
                                            continue block158;
                                        }
                                        case -57: {
                                            var23_76 = var14_11[var21_24];
                                            var24_115 = (int)var15_13[--var21_24];
                                            ((Object[])var14_11[var21_24])[var24_115] = var23_76;
                                            ((int[])var14_11[var21_24 - 1])[var24_115] = -1;
                                            var15_13[var21_24] = var24_115 + 1;
                                            continue block158;
                                        }
                                        case -58: {
                                            var23_77 = var14_11[var21_24];
                                            var24_116 = (int)var15_13[--var21_24];
                                            ((Object[])var14_11[var21_24])[var24_116] = var23_77;
                                            ((int[])var14_11[var21_24 - 1])[var24_116] = 1;
                                            var15_13[var21_24] = var24_116 + 1;
                                            continue block158;
                                        }
                                        case -31: 
                                        case 65: 
                                        case 66: {
                                            var23_78 = (Object[])var14_11[var21_24];
                                            var24_117 = (int[])var14_11[--var21_24];
                                            if (var22_25 == 66) {
                                                var26_145 /* !! */  = (Object[])var1_1.idata.literalIds[var9_7];
                                                var25_135 = ScriptRuntime.newObjectLiteral(var26_145 /* !! */ , var23_78, var24_117, var0, var1_1.scope);
                                            } else {
                                                var26_145 /* !! */  = null;
                                                if (var22_25 == -31) {
                                                    var26_145 /* !! */  = (int[])var1_1.idata.literalIds[var9_7];
                                                }
                                                var25_135 = ScriptRuntime.newArrayLiteral(var23_78, (int[])var26_145 /* !! */ , var0, var1_1.scope);
                                            }
                                            var14_11[var21_24] = var25_135;
                                            continue block158;
                                        }
                                        case -53: {
                                            var23_79 = var14_11[var21_24];
                                            if (var23_79 == var3_3) {
                                                var23_79 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            --var21_24;
                                            var1_1.scope = ScriptRuntime.enterDotQuery(var23_79, var1_1.scope);
                                            continue block158;
                                        }
                                        case -54: {
                                            var23_80 = Interpreter.stack_boolean(var1_1, var21_24);
                                            var24_118 = ScriptRuntime.updateDotQuery(var23_80, var1_1.scope);
                                            if (var24_118 != null) {
                                                var14_11[var21_24] = var24_118;
                                                var1_1.scope = ScriptRuntime.leaveDotQuery(var1_1.scope);
                                                var1_1.pc += 2;
                                                continue block158;
                                            }
                                            --var21_24;
                                            break;
                                        }
                                        case 74: {
                                            var23_81 = var14_11[var21_24];
                                            if (var23_81 == var3_3) {
                                                var23_81 = ScriptRuntime.wrapNumber(var15_13[var21_24]);
                                            }
                                            var14_11[var21_24] = ScriptRuntime.setDefaultNamespace(var23_81, var0);
                                            continue block158;
                                        }
                                        case 75: {
                                            var23_82 = var14_11[var21_24];
                                            if (var23_82 == var3_3) continue block158;
                                            var14_11[var21_24] = ScriptRuntime.escapeAttributeValue(var23_82, var0);
                                            continue block158;
                                        }
                                        case 76: {
                                            var23_83 = var14_11[var21_24];
                                            if (var23_83 == var3_3) continue block158;
                                            var14_11[var21_24] = ScriptRuntime.escapeTextValue(var23_83, var0);
                                            continue block158;
                                        }
                                        case -64: {
                                            if (var1_1.debuggerFrame == null) continue block158;
                                            var1_1.debuggerFrame.onDebuggerStatement(var0);
                                            continue block158;
                                        }
                                        case -26: {
                                            var1_1.pcSourceLineStart = var1_1.pc;
                                            if (var1_1.debuggerFrame != null) {
                                                var23_84 = Interpreter.getIndex(var19_18 /* !! */ , var1_1.pc);
                                                var1_1.debuggerFrame.onLineChange(var0, var23_84);
                                            }
                                            var1_1.pc += 2;
                                            continue block158;
                                        }
                                        case -32: {
                                            var9_7 = 0;
                                            continue block158;
                                        }
                                        case -33: {
                                            var9_7 = 1;
                                            continue block158;
                                        }
                                        case -34: {
                                            var9_7 = 2;
                                            continue block158;
                                        }
                                        case -35: {
                                            var9_7 = 3;
                                            continue block158;
                                        }
                                        case -36: {
                                            var9_7 = 4;
                                            continue block158;
                                        }
                                        case -37: {
                                            var9_7 = 5;
                                            continue block158;
                                        }
                                        case -38: {
                                            var9_7 = 255 & var19_18 /* !! */ [var1_1.pc];
                                            ++var1_1.pc;
                                            continue block158;
                                        }
                                        case -39: {
                                            var9_7 = Interpreter.getIndex(var19_18 /* !! */ , var1_1.pc);
                                            var1_1.pc += 2;
                                            continue block158;
                                        }
                                        case -40: {
                                            var9_7 = Interpreter.getInt(var19_18 /* !! */ , var1_1.pc);
                                            var1_1.pc += 4;
                                            continue block158;
                                        }
                                        case -41: {
                                            var8_6 = var20_22[0];
                                            continue block158;
                                        }
                                        case -42: {
                                            var8_6 = var20_22[1];
                                            continue block158;
                                        }
                                        case -43: {
                                            var8_6 = var20_22[2];
                                            continue block158;
                                        }
                                        case -44: {
                                            var8_6 = var20_22[3];
                                            continue block158;
                                        }
                                        case -45: {
                                            var8_6 = var20_22[255 & var19_18 /* !! */ [var1_1.pc]];
                                            ++var1_1.pc;
                                            continue block158;
                                        }
                                        case -46: {
                                            var8_6 = var20_22[Interpreter.getIndex(var19_18 /* !! */ , var1_1.pc)];
                                            var1_1.pc += 2;
                                            continue block158;
                                        }
                                        case -47: {
                                            var8_6 = var20_22[Interpreter.getInt(var19_18 /* !! */ , var1_1.pc)];
                                            var1_1.pc += 4;
                                            continue block158;
                                        }
                                        default: {
                                            Interpreter.dumpICode(var1_1.idata);
                                            throw new RuntimeException("Unknown icode : " + var22_25 + " @ pc : " + (var1_1.pc - 1));
                                        }
                                    }
                                    if (var5_5) {
                                        Interpreter.addInstructionCount(var0, var1_1, 2);
                                    }
                                    var1_1.pc = (var23_85 = Interpreter.getShort(var19_18 /* !! */ , var1_1.pc)) != 0 ? (var1_1.pc += var23_85 - 1) : var1_1.idata.longJumps.getExistingInt(var1_1.pc);
                                    if (!var5_5) continue;
                                    var1_1.pcPrevBranch = var1_1.pc;
                                }
                                Interpreter.exitFrame(var0, var1_1, null);
                                var11_9 = var1_1.result;
                                var12_10 = var1_1.resultDbl;
                                if (var1_1.parentFrame != null) {
                                    var1_1 = var1_1.parentFrame;
                                    if (var1_1.frozen) {
                                        var1_1 = var1_1.cloneFrozen();
                                    }
                                    Interpreter.setCallResult(var1_1, var11_9, var12_10);
                                    var11_9 = null;
                                    continue;
                                }
                                break block289;
                                break;
                            }
                        }
                        catch (Throwable var14_12) {
                            if (var2_2 != null) {
                                var14_12.printStackTrace(System.err);
                                throw new IllegalStateException();
                            }
                            var2_2 = var14_12;
                        }
                    }
                    if (var2_2 == null) {
                        Kit.codeBug();
                    }
                    var18_17 /* !! */  = null;
                    if (var10_8 != null && var10_8.operation == 2 && var2_2 == var10_8.value) {
                        var17_16 = 1;
                    } else if (var2_2 instanceof JavaScriptException) {
                        var17_16 = 2;
                    } else if (var2_2 instanceof EcmaError) {
                        var17_16 = 2;
                    } else if (var2_2 instanceof EvaluatorException) {
                        var17_16 = 2;
                    } else if (var2_2 instanceof RuntimeException) {
                        var17_16 = var0.hasFeature(13) != false ? 2 : 1;
                    } else if (var2_2 instanceof Error) {
                        var17_16 = var0.hasFeature(13) != false ? 2 : 0;
                    } else if (var2_2 instanceof ContinuationJump) {
                        var17_16 = 1;
                        var18_17 /* !! */  = (int[])((ContinuationJump)var2_2);
                    } else {
                        v1 = var17_16 = var0.hasFeature(13) != false ? 2 : 1;
                    }
                    if (var5_5) {
                        try {
                            Interpreter.addInstructionCount(var0, var1_1, 100);
                        }
                        catch (RuntimeException var19_19) {
                            var2_2 = var19_19;
                            var17_16 = 1;
                        }
                        catch (Error var19_20) {
                            var2_2 = var19_20;
                            var18_17 /* !! */  = null;
                            var17_16 = 0;
                        }
                    }
                    if (var1_1.debuggerFrame != null && var2_2 instanceof RuntimeException) {
                        var19_18 /* !! */  = (byte[])((RuntimeException)var2_2);
                        try {
                            var1_1.debuggerFrame.onExceptionThrown(var0, (Throwable)var19_18 /* !! */ );
                        }
                        catch (Throwable var20_23) {
                            var2_2 = var20_23;
                            var18_17 /* !! */  = null;
                            var17_16 = 0;
                        }
                    }
                    do {
                        if (var17_16 != 0 && (var9_7 = Interpreter.getExceptionHandler(var1_1, var19_21 = var17_16 != 2)) >= 0) continue block156;
                        Interpreter.exitFrame(var0, var1_1, var2_2);
                        var1_1 = var1_1.parentFrame;
                        if (var1_1 == null) break block290;
                    } while (var18_17 /* !! */  == null || var18_17 /* !! */ .branchFrame != var1_1);
                    var9_7 = -1;
                    continue;
                }
                if (var18_17 /* !! */  == null) break block289;
                if (var18_17 /* !! */ .branchFrame != null) {
                    Kit.codeBug();
                }
                if (var18_17 /* !! */ .capturedFrame == null) break;
                var9_7 = -1;
            }
            var11_9 = var18_17 /* !! */ .result;
            var12_10 = var18_17 /* !! */ .resultDbl;
            var2_2 = null;
        }
        if (var0.previousInterpreterInvocations != null && var0.previousInterpreterInvocations.size() != 0) {
            var0.lastInterpreterFrame = var0.previousInterpreterInvocations.pop();
        } else {
            var0.lastInterpreterFrame = null;
            var0.previousInterpreterInvocations = null;
        }
        if (var2_2 != null) {
            if (var2_2 instanceof RuntimeException) {
                throw (RuntimeException)var2_2;
            }
            throw (Error)var2_2;
        }
        return var11_9 != var3_3 ? var11_9 : ScriptRuntime.wrapNumber(var12_10);
    }

    private static CallFrame initFrameForNoSuchMethod(Context context, CallFrame callFrame, int n, Object[] objectArray, double[] dArray, int n2, int n3, Scriptable scriptable, Scriptable scriptable2, ScriptRuntime.NoSuchMethodShim noSuchMethodShim, InterpretedFunction interpretedFunction) {
        Object object;
        Object[] objectArray2 = null;
        int n4 = n2 + 2;
        Object[] objectArray3 = new Object[n];
        int n5 = 0;
        while (n5 < n) {
            object = objectArray[n4];
            if (object == UniqueTag.DOUBLE_MARK) {
                object = ScriptRuntime.wrapNumber(dArray[n4]);
            }
            objectArray3[n5] = object;
            ++n5;
            ++n4;
        }
        objectArray2 = new Object[]{noSuchMethodShim.methodName, context.newArray(scriptable2, objectArray3)};
        CallFrame callFrame2 = callFrame;
        object = new CallFrame();
        if (n3 == -55) {
            callFrame2 = callFrame.parentFrame;
            Interpreter.exitFrame(context, callFrame, null);
        }
        Interpreter.initFrame(context, scriptable2, scriptable, objectArray2, null, 0, 2, interpretedFunction, callFrame2, (CallFrame)object);
        if (n3 != -55) {
            callFrame.savedStackTop = n2;
            callFrame.savedCallOp = n3;
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean shallowEquals(Object[] objectArray, double[] dArray, int n) {
        double d;
        double d2;
        Object object = objectArray[n + 1];
        Object object2 = objectArray[n];
        UniqueTag uniqueTag = UniqueTag.DOUBLE_MARK;
        if (object == uniqueTag) {
            d2 = dArray[n + 1];
            if (object2 == uniqueTag) {
                d = dArray[n];
            } else {
                if (!(object2 instanceof Number)) return false;
                d = ((Number)object2).doubleValue();
            }
        } else {
            if (object2 != uniqueTag) return ScriptRuntime.shallowEq(object2, object);
            d = dArray[n];
            if (object == uniqueTag) {
                d2 = dArray[n + 1];
            } else {
                if (!(object instanceof Number)) return false;
                d2 = ((Number)object).doubleValue();
            }
        }
        if (d != d2) return false;
        return true;
    }

    private static CallFrame processThrowable(Context context, Object object, CallFrame callFrame, int n, boolean bl) {
        if (n >= 0) {
            if (callFrame.frozen) {
                callFrame = callFrame.cloneFrozen();
            }
            int[] nArray = callFrame.idata.itsExceptionTable;
            callFrame.pc = nArray[n + 2];
            if (bl) {
                callFrame.pcPrevBranch = callFrame.pc;
            }
            callFrame.savedStackTop = callFrame.emptyStackTop;
            int n2 = callFrame.localShift + nArray[n + 5];
            int n3 = callFrame.localShift + nArray[n + 4];
            callFrame.scope = (Scriptable)callFrame.stack[n2];
            callFrame.stack[n3] = object;
            object = null;
        } else {
            ContinuationJump continuationJump = (ContinuationJump)object;
            object = null;
            if (continuationJump.branchFrame != callFrame) {
                Kit.codeBug();
            }
            if (continuationJump.capturedFrame == null) {
                Kit.codeBug();
            }
            int n4 = continuationJump.capturedFrame.frameIndex + 1;
            if (continuationJump.branchFrame != null) {
                n4 -= continuationJump.branchFrame.frameIndex;
            }
            int n5 = 0;
            CallFrame[] callFrameArray = null;
            CallFrame callFrame2 = continuationJump.capturedFrame;
            for (int i = 0; i != n4; ++i) {
                if (!callFrame2.frozen) {
                    Kit.codeBug();
                }
                if (Interpreter.isFrameEnterExitRequired(callFrame2)) {
                    if (callFrameArray == null) {
                        callFrameArray = new CallFrame[n4 - i];
                    }
                    callFrameArray[n5] = callFrame2;
                    ++n5;
                }
                callFrame2 = callFrame2.parentFrame;
            }
            while (n5 != 0) {
                callFrame2 = callFrameArray[--n5];
                Interpreter.enterFrame(context, callFrame2, ScriptRuntime.emptyArgs, true);
            }
            callFrame = continuationJump.capturedFrame.cloneFrozen();
            Interpreter.setCallResult(callFrame, continuationJump.result, continuationJump.resultDbl);
        }
        callFrame.throwable = object;
        return callFrame;
    }

    private static Object freezeGenerator(Context context, CallFrame callFrame, int n, GeneratorState generatorState) {
        if (generatorState.operation == 2) {
            throw ScriptRuntime.typeError0("msg.yield.closing");
        }
        callFrame.frozen = true;
        callFrame.result = callFrame.stack[n];
        callFrame.resultDbl = callFrame.sDbl[n];
        callFrame.savedStackTop = n;
        --callFrame.pc;
        ScriptRuntime.exitActivationFunction(context);
        return callFrame.result != UniqueTag.DOUBLE_MARK ? callFrame.result : ScriptRuntime.wrapNumber(callFrame.resultDbl);
    }

    private static Object thawGenerator(CallFrame callFrame, int n, GeneratorState generatorState, int n2) {
        callFrame.frozen = false;
        int n3 = Interpreter.getIndex(callFrame.idata.itsICode, callFrame.pc);
        callFrame.pc += 2;
        if (generatorState.operation == 1) {
            return new JavaScriptException(generatorState.value, callFrame.idata.itsSourceFile, n3);
        }
        if (generatorState.operation == 2) {
            return generatorState.value;
        }
        if (generatorState.operation != 0) {
            throw Kit.codeBug();
        }
        if (n2 == 72) {
            callFrame.stack[n] = generatorState.value;
        }
        return Scriptable.NOT_FOUND;
    }

    private static CallFrame initFrameForApplyOrCall(Context context, CallFrame object, int n, Object[] objectArray, double[] dArray, int n2, int n3, Scriptable scriptable, IdFunctionObject idFunctionObject, InterpretedFunction interpretedFunction) {
        Scriptable scriptable2;
        Object object2;
        if (n != 0) {
            object2 = objectArray[n2 + 2];
            if (object2 == UniqueTag.DOUBLE_MARK) {
                object2 = ScriptRuntime.wrapNumber(dArray[n2 + 2]);
            }
            scriptable2 = ScriptRuntime.toObjectOrNull(context, object2);
        } else {
            scriptable2 = null;
        }
        if (scriptable2 == null) {
            scriptable2 = ScriptRuntime.getTopCallScope(context);
        }
        if (n3 == -55) {
            Interpreter.exitFrame(context, (CallFrame)object, null);
            object = ((CallFrame)object).parentFrame;
        } else {
            ((CallFrame)object).savedStackTop = n2;
            ((CallFrame)object).savedCallOp = n3;
        }
        object2 = new CallFrame();
        if (BaseFunction.isApply(idFunctionObject)) {
            Object[] objectArray2 = n < 2 ? ScriptRuntime.emptyArgs : ScriptRuntime.getApplyArguments(context, objectArray[n2 + 3]);
            Interpreter.initFrame(context, scriptable, scriptable2, objectArray2, null, 0, objectArray2.length, interpretedFunction, (CallFrame)object, (CallFrame)object2);
        } else {
            int n4;
            for (n4 = 1; n4 < n; ++n4) {
                objectArray[n2 + 1 + n4] = objectArray[n2 + 2 + n4];
                dArray[n2 + 1 + n4] = dArray[n2 + 2 + n4];
            }
            n4 = n < 2 ? 0 : n - 1;
            Interpreter.initFrame(context, scriptable, scriptable2, objectArray, dArray, n2 + 2, n4, interpretedFunction, (CallFrame)object, (CallFrame)object2);
        }
        object = object2;
        return object;
    }

    private static void initFrame(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray, double[] dArray, int n, int n2, InterpretedFunction interpretedFunction, CallFrame callFrame, CallFrame callFrame2) {
        int n3;
        int n4;
        double[] dArray2;
        int[] nArray;
        Object[] objectArray2;
        boolean bl;
        int n5;
        int n6;
        Scriptable scriptable3;
        InterpreterData interpreterData = interpretedFunction.idata;
        boolean bl2 = interpreterData.itsNeedsActivation;
        DebugFrame debugFrame = null;
        if (context.debugger != null && (debugFrame = context.debugger.getFrame(context, interpreterData)) != null) {
            bl2 = true;
        }
        if (bl2) {
            if (dArray != null) {
                objectArray = Interpreter.getArgsArray(objectArray, dArray, n, n2);
            }
            n = 0;
            dArray = null;
        }
        if (interpreterData.itsFunctionType != 0) {
            scriptable3 = !interpreterData.useDynamicScope ? interpretedFunction.getParentScope() : scriptable;
            if (bl2) {
                scriptable3 = ScriptRuntime.createFunctionActivation(interpretedFunction, scriptable3, objectArray);
            }
        } else {
            scriptable3 = scriptable;
            ScriptRuntime.initScript(interpretedFunction, scriptable2, context, scriptable3, interpretedFunction.idata.evalScriptFlag);
        }
        if (interpreterData.itsNestedFunctions != null) {
            if (interpreterData.itsFunctionType != 0 && !interpreterData.itsNeedsActivation) {
                Kit.codeBug();
            }
            for (int i = 0; i < interpreterData.itsNestedFunctions.length; ++i) {
                InterpreterData interpreterData2 = interpreterData.itsNestedFunctions[i];
                if (interpreterData2.itsFunctionType != 1) continue;
                Interpreter.initFunction(context, scriptable3, interpretedFunction, i);
            }
        }
        Scriptable[] scriptableArray = null;
        if (interpreterData.itsRegExpLiterals != null) {
            scriptableArray = interpreterData.itsFunctionType != 0 ? interpretedFunction.functionRegExps : interpretedFunction.createRegExpWraps(context, scriptable3);
        }
        if ((n6 = interpreterData.itsMaxFrameArray) != (n5 = interpreterData.itsMaxVars + interpreterData.itsMaxLocals - 1) + interpreterData.itsMaxStack + 1) {
            Kit.codeBug();
        }
        if (callFrame2.stack != null && n6 <= callFrame2.stack.length) {
            bl = true;
            objectArray2 = callFrame2.stack;
            nArray = callFrame2.stackAttributes;
            dArray2 = callFrame2.sDbl;
        } else {
            bl = false;
            objectArray2 = new Object[n6];
            nArray = new int[n6];
            dArray2 = new double[n6];
        }
        int n7 = interpreterData.getParamAndVarCount();
        for (n4 = 0; n4 < n7; ++n4) {
            if (!interpreterData.getParamOrVarConst(n4)) continue;
            nArray[n4] = 13;
        }
        n4 = interpreterData.argCount;
        if (n4 > n2) {
            n4 = n2;
        }
        callFrame2.parentFrame = callFrame;
        int n8 = callFrame2.frameIndex = callFrame == null ? 0 : callFrame.frameIndex + 1;
        if (callFrame2.frameIndex > context.getMaximumInterpreterStackDepth()) {
            throw Context.reportRuntimeError("Exceeded maximum stack depth");
        }
        callFrame2.frozen = false;
        callFrame2.fnOrScript = interpretedFunction;
        callFrame2.idata = interpreterData;
        callFrame2.stack = objectArray2;
        callFrame2.stackAttributes = nArray;
        callFrame2.sDbl = dArray2;
        callFrame2.varSource = callFrame2;
        callFrame2.localShift = interpreterData.itsMaxVars;
        callFrame2.emptyStackTop = n5;
        callFrame2.debuggerFrame = debugFrame;
        callFrame2.useActivation = bl2;
        callFrame2.thisObj = scriptable2;
        callFrame2.scriptRegExps = scriptableArray;
        callFrame2.result = Undefined.instance;
        callFrame2.pc = 0;
        callFrame2.pcPrevBranch = 0;
        callFrame2.pcSourceLineStart = interpreterData.firstLinePC;
        callFrame2.scope = scriptable3;
        callFrame2.savedStackTop = n5;
        callFrame2.savedCallOp = 0;
        System.arraycopy(objectArray, n, objectArray2, 0, n4);
        if (dArray != null) {
            System.arraycopy(dArray, n, dArray2, 0, n4);
        }
        for (n3 = n4; n3 != interpreterData.itsMaxVars; ++n3) {
            objectArray2[n3] = Undefined.instance;
        }
        if (bl) {
            for (n3 = n5 + 1; n3 != objectArray2.length; ++n3) {
                objectArray2[n3] = null;
            }
        }
        Interpreter.enterFrame(context, callFrame2, objectArray, false);
    }

    private static boolean isFrameEnterExitRequired(CallFrame callFrame) {
        return callFrame.debuggerFrame != null || callFrame.idata.itsNeedsActivation;
    }

    private static void enterFrame(Context context, CallFrame callFrame, Object[] objectArray, boolean bl) {
        boolean bl2;
        boolean bl3 = callFrame.idata.itsNeedsActivation;
        boolean bl4 = bl2 = callFrame.debuggerFrame != null;
        if (bl3 || bl2) {
            Scriptable scriptable = callFrame.scope;
            if (scriptable == null) {
                Kit.codeBug();
            } else if (bl) {
                while (scriptable instanceof NativeWith) {
                    if ((scriptable = scriptable.getParentScope()) != null && (callFrame.parentFrame == null || callFrame.parentFrame.scope != scriptable)) continue;
                    Kit.codeBug();
                    break;
                }
            }
            if (bl2) {
                callFrame.debuggerFrame.onEnter(context, scriptable, callFrame.thisObj, objectArray);
            }
            if (bl3) {
                ScriptRuntime.enterActivationFunction(context, scriptable);
            }
        }
    }

    private static void exitFrame(Context context, CallFrame callFrame, Object object) {
        if (callFrame.idata.itsNeedsActivation) {
            ScriptRuntime.exitActivationFunction(context);
        }
        if (callFrame.debuggerFrame != null) {
            try {
                if (object instanceof Throwable) {
                    callFrame.debuggerFrame.onExit(context, true, object);
                } else {
                    ContinuationJump continuationJump = (ContinuationJump)object;
                    Object object2 = continuationJump == null ? callFrame.result : continuationJump.result;
                    if (object2 == UniqueTag.DOUBLE_MARK) {
                        double d = continuationJump == null ? callFrame.resultDbl : continuationJump.resultDbl;
                        object2 = ScriptRuntime.wrapNumber(d);
                    }
                    callFrame.debuggerFrame.onExit(context, false, object2);
                }
            }
            catch (Throwable throwable) {
                System.err.println("RHINO USAGE WARNING: onExit terminated with exception");
                throwable.printStackTrace(System.err);
            }
        }
    }

    private static void setCallResult(CallFrame callFrame, Object object, double d) {
        if (callFrame.savedCallOp == 38) {
            callFrame.stack[callFrame.savedStackTop] = object;
            callFrame.sDbl[callFrame.savedStackTop] = d;
        } else if (callFrame.savedCallOp == 30) {
            if (object instanceof Scriptable) {
                callFrame.stack[callFrame.savedStackTop] = object;
            }
        } else {
            Kit.codeBug();
        }
        callFrame.savedCallOp = 0;
    }

    public static NativeContinuation captureContinuation(Context context) {
        if (context.lastInterpreterFrame == null || !(context.lastInterpreterFrame instanceof CallFrame)) {
            throw new IllegalStateException("Interpreter frames not found");
        }
        return Interpreter.captureContinuation(context, (CallFrame)context.lastInterpreterFrame, true);
    }

    private static NativeContinuation captureContinuation(Context context, CallFrame callFrame, boolean bl) {
        NativeContinuation nativeContinuation = new NativeContinuation();
        ScriptRuntime.setObjectProtoAndParent(nativeContinuation, ScriptRuntime.getTopCallScope(context));
        CallFrame callFrame2 = callFrame;
        CallFrame callFrame3 = callFrame;
        while (callFrame2 != null && !callFrame2.frozen) {
            callFrame2.frozen = true;
            for (int i = callFrame2.savedStackTop + 1; i != callFrame2.stack.length; ++i) {
                callFrame2.stack[i] = null;
                callFrame2.stackAttributes[i] = 0;
            }
            if (callFrame2.savedCallOp == 38) {
                callFrame2.stack[callFrame2.savedStackTop] = null;
            } else if (callFrame2.savedCallOp != 30) {
                Kit.codeBug();
            }
            callFrame3 = callFrame2;
            callFrame2 = callFrame2.parentFrame;
        }
        if (bl) {
            while (callFrame3.parentFrame != null) {
                callFrame3 = callFrame3.parentFrame;
            }
            if (!callFrame3.isContinuationsTopFrame) {
                throw new IllegalStateException("Cannot capture continuation from JavaScript code not called directly by executeScriptWithContinuations or callFunctionWithContinuations");
            }
        }
        nativeContinuation.initImplementation(callFrame);
        return nativeContinuation;
    }

    private static int stack_int32(CallFrame callFrame, int n) {
        Object object = callFrame.stack[n];
        double d = object == UniqueTag.DOUBLE_MARK ? callFrame.sDbl[n] : ScriptRuntime.toNumber(object);
        return ScriptRuntime.toInt32(d);
    }

    private static double stack_double(CallFrame callFrame, int n) {
        Object object = callFrame.stack[n];
        if (object != UniqueTag.DOUBLE_MARK) {
            return ScriptRuntime.toNumber(object);
        }
        return callFrame.sDbl[n];
    }

    private static boolean stack_boolean(CallFrame callFrame, int n) {
        Object object = callFrame.stack[n];
        if (object == Boolean.TRUE) {
            return true;
        }
        if (object == Boolean.FALSE) {
            return false;
        }
        if (object == UniqueTag.DOUBLE_MARK) {
            double d = callFrame.sDbl[n];
            return d == d && d != 0.0;
        }
        if (object == null || object == Undefined.instance) {
            return false;
        }
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            return d == d && d != 0.0;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return ScriptRuntime.toBoolean(object);
    }

    private static void do_add(Object[] objectArray, double[] dArray, int n, Context context) {
        boolean bl;
        double d;
        Object object = objectArray[n + 1];
        Object object2 = objectArray[n];
        if (object == UniqueTag.DOUBLE_MARK) {
            d = dArray[n + 1];
            if (object2 == UniqueTag.DOUBLE_MARK) {
                int n2 = n;
                dArray[n2] = dArray[n2] + d;
                return;
            }
            bl = true;
        } else if (object2 == UniqueTag.DOUBLE_MARK) {
            d = dArray[n];
            object2 = object;
            bl = false;
        } else {
            if (object2 instanceof Scriptable || object instanceof Scriptable) {
                objectArray[n] = ScriptRuntime.add(object2, object, context);
            } else if (object2 instanceof String) {
                String string = (String)object2;
                String string2 = ScriptRuntime.toString(object);
                objectArray[n] = string.concat(string2);
            } else if (object instanceof String) {
                String string = ScriptRuntime.toString(object2);
                String string3 = (String)object;
                objectArray[n] = string.concat(string3);
            } else {
                double d2 = object2 instanceof Number ? ((Number)object2).doubleValue() : ScriptRuntime.toNumber(object2);
                double d3 = object instanceof Number ? ((Number)object).doubleValue() : ScriptRuntime.toNumber(object);
                objectArray[n] = UniqueTag.DOUBLE_MARK;
                dArray[n] = d2 + d3;
            }
            return;
        }
        if (object2 instanceof Scriptable) {
            object = ScriptRuntime.wrapNumber(d);
            if (!bl) {
                Object object3 = object2;
                object2 = object;
                object = object3;
            }
            objectArray[n] = ScriptRuntime.add(object2, object, context);
        } else if (object2 instanceof String) {
            String string = (String)object2;
            String string4 = ScriptRuntime.toString(d);
            objectArray[n] = bl ? string.concat(string4) : string4.concat(string);
        } else {
            double d4 = object2 instanceof Number ? ((Number)object2).doubleValue() : ScriptRuntime.toNumber(object2);
            objectArray[n] = UniqueTag.DOUBLE_MARK;
            dArray[n] = d4 + d;
        }
    }

    private static Object[] getArgsArray(Object[] objectArray, double[] dArray, int n, int n2) {
        if (n2 == 0) {
            return ScriptRuntime.emptyArgs;
        }
        Object[] objectArray2 = new Object[n2];
        int n3 = 0;
        while (n3 != n2) {
            Object object = objectArray[n];
            if (object == UniqueTag.DOUBLE_MARK) {
                object = ScriptRuntime.wrapNumber(dArray[n]);
            }
            objectArray2[n3] = object;
            ++n3;
            ++n;
        }
        return objectArray2;
    }

    private static void addInstructionCount(Context context, CallFrame callFrame, int n) {
        context.instructionCount += callFrame.pc - callFrame.pcPrevBranch + n;
        if (context.instructionCount > context.instructionThreshold) {
            context.observeInstructionCount(context.instructionCount);
            context.instructionCount = 0;
        }
    }

    private static class CallFrame
    implements Cloneable {
        CallFrame parentFrame;
        int frameIndex;
        boolean frozen;
        InterpretedFunction fnOrScript;
        InterpreterData idata;
        Object[] stack;
        int[] stackAttributes;
        double[] sDbl;
        CallFrame varSource;
        int localShift;
        int emptyStackTop;
        DebugFrame debuggerFrame;
        boolean useActivation;
        boolean isContinuationsTopFrame;
        Scriptable thisObj;
        Scriptable[] scriptRegExps;
        Object result;
        double resultDbl;
        int pc;
        int pcPrevBranch;
        int pcSourceLineStart;
        Scriptable scope;
        int savedStackTop;
        int savedCallOp;
        Object throwable;

        private CallFrame() {
        }

        CallFrame cloneFrozen() {
            CallFrame callFrame;
            if (!this.frozen) {
                Kit.codeBug();
            }
            try {
                callFrame = (CallFrame)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException();
            }
            callFrame.stack = (Object[])this.stack.clone();
            callFrame.stackAttributes = (int[])this.stackAttributes.clone();
            callFrame.sDbl = (double[])this.sDbl.clone();
            callFrame.frozen = false;
            return callFrame;
        }
    }

    private static final class ContinuationJump {
        CallFrame capturedFrame;
        CallFrame branchFrame;
        Object result;
        double resultDbl;

        ContinuationJump(NativeContinuation nativeContinuation, CallFrame callFrame) {
            this.capturedFrame = (CallFrame)nativeContinuation.getImplementation();
            if (this.capturedFrame == null || callFrame == null) {
                this.branchFrame = null;
            } else {
                CallFrame callFrame2 = this.capturedFrame;
                CallFrame callFrame3 = callFrame;
                int n = callFrame2.frameIndex - callFrame3.frameIndex;
                if (n != 0) {
                    if (n < 0) {
                        callFrame2 = callFrame;
                        callFrame3 = this.capturedFrame;
                        n = -n;
                    }
                    do {
                        callFrame2 = callFrame2.parentFrame;
                    } while (--n != 0);
                    if (callFrame2.frameIndex != callFrame3.frameIndex) {
                        Kit.codeBug();
                    }
                }
                while (callFrame2 != callFrame3 && callFrame2 != null) {
                    callFrame2 = callFrame2.parentFrame;
                    callFrame3 = callFrame3.parentFrame;
                }
                this.branchFrame = callFrame2;
                if (this.branchFrame != null && !this.branchFrame.frozen) {
                    Kit.codeBug();
                }
            }
        }
    }

    static class GeneratorState {
        int operation;
        Object value;
        RuntimeException returnedException;

        GeneratorState(int n, Object object) {
            this.operation = n;
            this.value = object;
        }
    }
}

