/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.xvolks.jnative.Convention;
import org.xvolks.jnative.Type;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.logging.ConsoleLogger;
import org.xvolks.jnative.logging.JNativeLogger;
import org.xvolks.jnative.misc.basicStructures.DWORD;
import org.xvolks.jnative.misc.basicStructures.HANDLE;
import org.xvolks.jnative.misc.basicStructures.HWND;
import org.xvolks.jnative.misc.basicStructures.LONG;
import org.xvolks.jnative.pointers.NullPointer;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.NativeMemoryBlock;
import org.xvolks.jnative.util.Callback;
import org.xvolks.jnative.util.DbgHelp;
import org.xvolks.jnative.util.Kernel32;
import org.xvolks.jnative.util.StructConverter;
import org.xvolks.jnative.util.WindowProc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JNative {
    private static final boolean isWindows;
    private static final boolean isLinux;
    private static boolean mInitDone;
    private static boolean DEBUG;
    private static JNativeLogger mLogger;
    private static final Map<String, JNative> mLibs;
    public static final String DLL_NAME;
    private static int currentHModule;
    private int mJNativePointer;
    private boolean mNativeDebug = false;
    private boolean mIsClosed = false;
    private final String mDllName;
    private final String mFunctionName;
    private static Map<Integer, Callback> mCallbacks;
    private Vector<byte[]> parameters = new Vector();
    private Vector<Integer> parameterTypes = new Vector();
    private String mRetValue;
    private int mJNativeHModule;
    private int convention;
    private int mRetType;
    private static List<String> sides;

    private Vector<byte[]> getParameters() {
        return this.parameters;
    }

    private Vector<Integer> getParameterTypes() {
        return this.parameterTypes;
    }

    private native int nLoadLibrary(String var1, String var2, boolean var3) throws NativeException;

    private native int nFindFunction(int var1, String var2, boolean var3) throws NativeException;

    private native String nGetParameter(int var1, int var2) throws NativeException;

    private native void nInvoke(int var1) throws NativeException;

    private native void nDispose(int var1) throws NativeException;

    private static native int nMalloc(int var0) throws NativeException;

    private static native void nFree(int var0) throws NativeException;

    private static native void nSetMemory(int var0, byte[] var1, int var2, int var3) throws NativeException;

    private static native byte[] nGetMemory(int var0, int var1) throws NativeException;

    private static native int nRegisterWindowProc(int var0, Object var1, boolean var2) throws NativeException;

    private static native int nGetCurrentModule() throws NativeException;

    private static native int nCreateCallBack(int var0) throws NativeException;

    private static native boolean nReleaseCallBack(int var0) throws NativeException;

    private static native int nGetNativePattern(int var0, byte[] var1, int var2) throws NativeException;

    private static native String nGetNativeSideVersion() throws NativeException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadFromJar() throws UnsatisfiedLinkError {
        File tempDir = new File(System.getProperty("user.dir"));
        File dllFile = new File(tempDir, DLL_NAME);
        InputStream in = JNative.class.getResourceAsStream("/lib-bin/" + DLL_NAME);
        if (in == null) {
            if (!dllFile.exists()) {
                throw new UnsatisfiedLinkError(DLL_NAME + " : unable to find in " + tempDir);
            }
        } else {
            if (dllFile.exists() && dllFile.canWrite()) {
                dllFile.delete();
            }
            if (!dllFile.exists()) {
                byte[] buffer = new byte[512];
                FilterOutputStream out = null;
                try {
                    try {
                        int readed;
                        out = new BufferedOutputStream(new FileOutputStream(dllFile));
                        while ((readed = in.read(buffer)) > -1) {
                            ((BufferedOutputStream)out).write(buffer, 0, readed);
                        }
                    }
                    finally {
                        if (out != null) {
                            out.close();
                        }
                    }
                }
                catch (IOException e) {
                    throw new UnsatisfiedLinkError("Can't write library in " + dllFile);
                }
            }
            System.load(dllFile.toString());
        }
    }

    public static int callback(int address, long[] values) {
        JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, String.format("in Java callback #%x with %d arguments\n", address, values.length));
        Callback c = mCallbacks.get(address);
        if (c != null) {
            return c.callback(values);
        }
        return -1;
    }

    public String toString() {
        return this.mDllName + "-" + this.mFunctionName;
    }

    public static void setDefaultCallingConvention(Convention defaultConvention) {
        Convention.setDefaultStyle(defaultConvention);
    }

    public JNative(int address, Convention convention) throws NativeException {
        if (!mInitDone) {
            throw new IllegalStateException("JNative library not loaded, sorry !");
        }
        this.convention = convention.getValue();
        this.mFunctionName = this.mDllName = "Anonymous";
        this.mJNativePointer = address;
        try {
            this.setRetVal(Type.VOID);
        }
        catch (IllegalAccessException e) {
            JNative.getLogger().log(JNativeLogger.SEVERITY.ERROR, e);
        }
    }

    public JNative(String dllName, String functionName) throws NativeException {
        this(dllName, functionName, false, Convention.DEFAULT);
    }

    public JNative(String dllName, String functionName, Convention convention) throws NativeException {
        this(dllName, functionName, false, convention);
    }

    public JNative(String dllName, String functionName, boolean debug) throws NativeException {
        this(dllName, functionName, debug, Convention.DEFAULT);
    }

    public JNative(String dllName, String functionName, boolean nativeDebug, Convention convention) throws NativeException {
        if (!mInitDone) {
            throw new IllegalStateException("JNative library not loaded, sorry !");
        }
        this.convention = convention.getValue();
        this.mDllName = dllName;
        this.mFunctionName = functionName;
        this.mNativeDebug = nativeDebug;
        this.loadLibrary();
        try {
            this.setRetVal(Type.VOID);
        }
        catch (IllegalAccessException e) {
            JNative.getLogger().log(JNativeLogger.SEVERITY.ERROR, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean loadLibrary() throws NativeException {
        Map<String, JNative> map = mLibs;
        synchronized (map) {
            JNative libDesc = mLibs.get(this.mDllName);
            if (libDesc == null || libDesc.getHModule() == 0) {
                this.mJNativePointer = this.nLoadLibrary(this.mDllName, this.mFunctionName, this.mNativeDebug);
                mLibs.put(this.mDllName, this);
                JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, "Successfully loaded library '" + this.getDLLName() + "', functionName = " + this.getFunctionName() + ": hModule = " + this.getHModule());
            } else {
                this.mJNativeHModule = libDesc.getHModule();
                this.mJNativePointer = this.nFindFunction(this.mJNativeHModule, this.mFunctionName, this.mNativeDebug);
                JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, "Reusing cached handle " + libDesc.getHModule() + " for function '" + this.getFunctionName() + "' in library '" + libDesc.getDLLName() + "'");
            }
            this.mIsClosed = false;
            return this.mJNativePointer != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean isLibraryLoaded(String name) {
        Map<String, JNative> map = mLibs;
        synchronized (map) {
            JNative libDesc = mLibs.get(name);
            return libDesc != null && libDesc.getHModule() != 0 && libDesc.getFunctionPointer() != 0;
        }
    }

    public int getFunctionPointer() {
        return this.mJNativePointer;
    }

    public int getHModule() {
        return this.mJNativeHModule;
    }

    public void setParameter(int pos, int value) throws IllegalAccessException {
        this.setParameter(pos, Type.INT, value + "");
    }

    public void setParameter(int pos, Type type, String value) throws IllegalAccessException {
        if (value == null) {
            this.setParameter(pos, 0);
        } else {
            this.setParameter(pos, type, (value + '\u0000').getBytes());
        }
    }

    public void setParameter(int pos, String lValue) throws IllegalAccessException {
        this.setParameter(pos, Type.STRING, lValue);
    }

    public void setParameter(int pos, Type type, byte[] value) throws IllegalAccessException {
        if (this.parameters.size() <= pos) {
            int i = this.parameters.size();
            while (i++ <= pos) {
                this.parameters.add(new byte[4]);
                this.parameterTypes.add(Type.INT.getNativeType());
            }
        }
        this.parameters.set(pos, value);
        this.parameterTypes.set(pos, type.getNativeType());
    }

    public void setParameter(int pos, Pointer p) throws NativeException, IllegalAccessException {
        if (p == null || p.getPointer() == 0) {
            this.setParameter(pos, 0);
        } else {
            byte[] buf = new byte[4];
            StructConverter.intIntoBytes(p.getPointer(), buf, 0);
            this.setParameter(pos, Type.PSTRUCT, buf);
        }
    }

    public void setRetVal(Type type) throws NativeException, IllegalAccessException {
        this.mRetType = type.getNativeType();
    }

    public String getRetVal() throws IllegalAccessException {
        this.throwClosed();
        return this.mRetValue;
    }

    public int getRetValAsInt() throws IllegalAccessException {
        return Integer.parseInt(this.getRetVal());
    }

    public String getParameter(int pos) throws NativeException, IllegalAccessException {
        this.throwClosed();
        return this.nGetParameter(this.mJNativePointer, pos);
    }

    public void invoke() throws NativeException, IllegalAccessException {
        if (!JNative.isLibraryLoaded(this.mDllName)) {
            JNative.getLogger().log("Library '" + this.mDllName + "' is currently not loaded! Loading it now...");
            this.loadLibrary();
        }
        this.nInvoke(this.mJNativePointer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized void unLoad() throws NativeException {
        try {
            if (JNative.isLibraryLoaded(this.mDllName)) {
                JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, "Unloading native library '" + this.mDllName + "'");
                this.nDispose(this.mJNativeHModule);
            }
            this.mIsClosed = true;
            this.mJNativeHModule = 0;
        }
        finally {
            Map<String, JNative> map = mLibs;
            synchronized (map) {
                mLibs.remove(this.mDllName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean unLoadLibrary(String name) throws NativeException {
        Map<String, JNative> map = mLibs;
        synchronized (map) {
            if (mLibs.containsKey(name)) {
                mLibs.get(name).unLoad();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void unLoadAllLibraries() {
        Map<String, JNative> map = mLibs;
        synchronized (map) {
            if (!mLibs.isEmpty()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                Object[] keys = mLibs.keySet().toArray();
                for (int i = 0; i < keys.length; ++i) {
                    try {
                        JNative.unLoadLibrary(keys[i].toString());
                        continue;
                    }
                    catch (Throwable e) {
                        JNative.getLogger().log(JNativeLogger.SEVERITY.WARN, "Error while unloading library '" + keys[i].toString() + "': " + e.toString());
                    }
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public final String getFunctionName() {
        return this.mFunctionName;
    }

    public final String getDLLName() {
        return this.mDllName;
    }

    public Convention getStyle() {
        return Convention.fromInt(this.convention);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof JNative)) {
            return false;
        }
        JNative n = (JNative)obj;
        return this.mDllName.equals(n.getDLLName()) && this.mFunctionName.equals(n.getFunctionName());
    }

    private void throwClosed() throws IllegalAccessException {
        if (this.mIsClosed) {
            throw new IllegalAccessException("This function (" + this.getFunctionName() + " in " + this.getDLLName() + ") is already closed");
        }
    }

    public static int allocMemory(int size) throws NativeException {
        return JNative.nMalloc(size);
    }

    public static void freeMemory(int pointer) throws NativeException {
        JNative.nFree(pointer);
    }

    public static void setMemory(int pointer, String buffer) throws NativeException {
        JNative.setMemory(pointer, buffer.getBytes());
    }

    public static void setMemory(int pointer, byte[] buffer) throws NativeException {
        JNative.setMemory(pointer, buffer, 0, buffer.length);
    }

    public static void setMemory(int pointer, byte[] buffer, int offset, int len) throws NativeException {
        JNative.nSetMemory(pointer, buffer, offset, len);
    }

    public static byte[] getMemory(int pointer, int size) throws NativeException {
        return JNative.nGetMemory(pointer, size);
    }

    public static int getStrLen(int pointer) throws NativeException {
        int counter = 0;
        while (JNative.getMemory(pointer++, 1)[0] != 0) {
            ++counter;
        }
        return counter;
    }

    public static String getMemoryAsString(int pointer) throws NativeException {
        return JNative.getMemoryAsString(pointer, JNative.getStrLen(pointer));
    }

    public static String getMemoryAsString(int pointer, int size) throws NativeException {
        byte[] buf = JNative.nGetMemory(pointer, size);
        for (int i = 0; i < buf.length; ++i) {
            if (buf[i] != 0) continue;
            return new String(buf, 0, i);
        }
        return new String(buf);
    }

    public static int registerWindowProc(int hwnd, WindowProc proc) throws NativeException {
        return JNative.nRegisterWindowProc(hwnd, proc, false);
    }

    public static int registerWindowProc(HWND hwnd, WindowProc proc) throws NativeException {
        return JNative.nRegisterWindowProc((Integer)hwnd.getValue(), proc, false);
    }

    public static int createCallback(int numParams, Callback callback) throws NativeException {
        Integer address = JNative.nCreateCallBack(numParams);
        JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, String.format("registering callback %x\n", address));
        mCallbacks.put(address, callback);
        return address;
    }

    public static boolean releaseCallback(Callback callback) throws NativeException {
        boolean ret = false;
        if (null != mCallbacks.remove(callback.getCallbackAddress())) {
            ret = JNative.nReleaseCallBack(callback.getCallbackAddress());
            JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, String.format("released callback %x\n", callback.getCallbackAddress()));
        }
        return ret;
    }

    public static int getCurrentModule() throws NativeException {
        if (currentHModule == 0) {
            currentHModule = JNative.nGetCurrentModule();
        }
        if (currentHModule == 0) {
            JNative.getLogger().log("JNative.nGetCurrentModule() returns 0, seems we still do not get the correct native JNative-library handle... ;-(");
            try {
                currentHModule = Kernel32.LoadLibrary(DLL_NAME).getValue();
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
        }
        return currentHModule;
    }

    public static boolean isFunctionExported(String lib, String function) throws NativeException, InterruptedException {
        String[] funcs = JNative.getDLLFileExports(lib);
        if (funcs != null) {
            for (int i = 0; i < funcs.length; ++i) {
                if (!funcs[i].equalsIgnoreCase(function)) continue;
                return true;
            }
        }
        return false;
    }

    public static String[] getDLLFileExports(String dllFile, boolean demangled) throws NativeException, InterruptedException {
        if (isWindows) {
            try {
                HANDLE hFile = Kernel32.CreateFile(dllFile, Kernel32.AccessMask.GENERIC_READ, Kernel32.ShareMode.FILE_SHARE_READ, null, Kernel32.CreationDisposition.OPEN_EXISTING, Kernel32.FileAttribute.FILE_ATTRIBUTE_NORMAL, 0);
                if (hFile.equals(HANDLE.INVALID_HANDLE_VALUE)) {
                    JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, String.format(">>>ERROR<<< : %s file not found, CreateFile returned an invalid handle\n", dllFile));
                    return null;
                }
                HANDLE hFileMapping = Kernel32.CreateFileMapping(hFile, null, Kernel32.PageAccess.PAGE_READONLY, new DWORD(0), new DWORD(0), null);
                if (hFileMapping.equals(HANDLE.INVALID_HANDLE_VALUE)) {
                    Kernel32.CloseHandle(hFile);
                    JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, String.format(">>>ERROR<<< : CreateFileMapping returned a NULL handle\n", new Object[0]));
                    return null;
                }
                LONG lpFileBase = Kernel32.MapViewOfFileEx(hFileMapping, Kernel32.FileMap.FILE_MAP_READ, new DWORD(0), new DWORD(0), new DWORD(0), new LONG(0));
                if (lpFileBase.getValue() == 0) {
                    Kernel32.CloseHandle(hFileMapping);
                    Kernel32.CloseHandle(hFile);
                    JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, String.format(">>>ERROR<<< : MapViewOfFile returned 0\n", new Object[0]));
                    return null;
                }
                int IMAGE_DOS_HEADER_SIZE = 64;
                int IMAGE_NUMBEROF_DIRECTORY_ENTRIES = 16;
                int IMAGE_OPTIONAL_HEADER32_SIZE = 96 + IMAGE_NUMBEROF_DIRECTORY_ENTRIES * 2 * 4;
                int IMAGE_NT_HEADERS32_SIZE = 24 + IMAGE_OPTIONAL_HEADER32_SIZE;
                int IMAGE_NT_SIGNATURE = 17744;
                int IMAGE_EXPORT_DIRECTORY_SIZE = 40;
                Pointer pImg_DOS_Header = new Pointer(new NativeMemoryBlock(lpFileBase.getValue(), IMAGE_DOS_HEADER_SIZE));
                Pointer pImg_NT_Header = new Pointer(new NativeMemoryBlock(pImg_DOS_Header.getPointer() + pImg_DOS_Header.getAsInt(IMAGE_DOS_HEADER_SIZE - 4), IMAGE_NT_HEADERS32_SIZE));
                if (!Kernel32.IsBadReadPtr(pImg_NT_Header) || pImg_NT_Header.getAsInt(0) != IMAGE_NT_SIGNATURE) {
                    Kernel32.UnmapViewOfFile(lpFileBase);
                    Kernel32.CloseHandle(hFileMapping);
                    Kernel32.CloseHandle(hFile);
                    JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, String.format(">>>ERROR<<< : IsBadReadPtr returned false, pointer is %d\n", pImg_NT_Header.getPointer()));
                    return null;
                }
                JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, String.format(">>>INFO<<< : IsBadReadPtr returned true, pointer is %d\n", pImg_NT_Header.getPointer()));
                Pointer pOptionalHeader = new Pointer(new NativeMemoryBlock(pImg_NT_Header.getPointer() + IMAGE_NT_HEADERS32_SIZE - IMAGE_OPTIONAL_HEADER32_SIZE, IMAGE_OPTIONAL_HEADER32_SIZE));
                Pointer pImg_Export_Dir = new Pointer(new NativeMemoryBlock(pOptionalHeader.getAsInt(96), 4));
                if (pImg_Export_Dir.isNull()) {
                    Kernel32.UnmapViewOfFile(lpFileBase);
                    Kernel32.CloseHandle(hFileMapping);
                    Kernel32.CloseHandle(hFile);
                    JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, String.format(">>>ERROR<<< : pImg_Export_Dir is NULL\n", new Object[0]));
                    return null;
                }
                pImg_Export_Dir = new Pointer(new NativeMemoryBlock(DbgHelp.ImageRvaToVa(pImg_NT_Header, pImg_DOS_Header, pImg_Export_Dir.asLONG(), NullPointer.NULL).getValue(), IMAGE_EXPORT_DIRECTORY_SIZE));
                LONG ppdwNames = new LONG(pImg_Export_Dir.getAsInt(32));
                if ((ppdwNames = DbgHelp.ImageRvaToVa(pImg_NT_Header, pImg_DOS_Header, ppdwNames, NullPointer.NULL)).getValue() == 0) {
                    Kernel32.UnmapViewOfFile(lpFileBase);
                    Kernel32.CloseHandle(hFileMapping);
                    Kernel32.CloseHandle(hFile);
                    JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, String.format(">>>ERROR<<< : ImageRvaToVa returned NULL\n", new Object[0]));
                    return null;
                }
                int iNoOfExports = pImg_Export_Dir.getAsInt(24);
                String[] pszFunctions = new String[iNoOfExports];
                JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, String.format("pszFunctions = %d\n", pszFunctions.length));
                int i = 0;
                int ippdwNames = ppdwNames.getValue();
                while (i < iNoOfExports) {
                    JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, String.format("ippdwNames[%d] : %d\n", i, ippdwNames));
                    LONG szFunc = DbgHelp.ImageRvaToVa(pImg_NT_Header, pImg_DOS_Header, new LONG(new Pointer(new NativeMemoryBlock(ippdwNames, 4)).getAsInt(0)), NullPointer.NULL);
                    pszFunctions[i] = new Pointer(new NativeMemoryBlock(szFunc.getValue(), 1000)).getAsString().trim();
                    JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, pszFunctions[i]);
                    ++i;
                    ippdwNames += 4;
                }
                Kernel32.UnmapViewOfFile(lpFileBase);
                Kernel32.CloseHandle(hFileMapping);
                Kernel32.CloseHandle(hFile);
                return pszFunctions;
            }
            catch (IllegalAccessException e) {
                JNative.getLogger().log(JNativeLogger.SEVERITY.ERROR, e);
                return null;
            }
        }
        if (isLinux) {
            try {
                String option = "";
                if (demangled) {
                    option = "C";
                }
                Process p = Runtime.getRuntime().exec("/usr/bin/nm -" + option + "Dg --defined-only " + dllFile);
                BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String line = br.readLine();
                ArrayList<String> l = new ArrayList<String>();
                while (line != null) {
                    l.add(line);
                    line = br.readLine();
                }
                br.close();
                JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, "exit value : " + p.waitFor());
                String[] array = new String[l.size()];
                int i = 0;
                for (String s : l) {
                    array[i++] = s;
                }
                return array;
            }
            catch (IOException e) {
                JNative.getLogger().log(JNativeLogger.SEVERITY.ERROR, e);
                throw new NativeException(e.getMessage());
            }
        }
        return null;
    }

    public static void copyMemory(Pointer source, Pointer dest) throws NativeException {
        if (dest == null || source == null || source.getSize() == 0 || dest.getSize() == 0) {
            return;
        }
        if (dest.getSize() >= source.getSize()) {
            dest.setMemory(source.getMemory());
        } else {
            dest.setMemory(JNative.getMemory(source.getPointer(), dest.getSize()));
        }
    }

    public static String[] getDLLFileExports(String dllFile) throws NativeException, InterruptedException {
        return JNative.getDLLFileExports(dllFile, false);
    }

    public static int searchNativePattern(int nativePointer, byte[] pattern, int maxSize) throws NativeException {
        return JNative.nGetNativePattern(nativePointer, pattern, maxSize);
    }

    public static int searchNativePattern(Pointer pointer, byte[] pattern, int maxSize) throws NativeException {
        return JNative.nGetNativePattern(pointer.getPointer(), pattern, maxSize);
    }

    public static String getNativeSideVersion() throws NativeException {
        return JNative.nGetNativeSideVersion();
    }

    public static List<String> getCompatibleNativeVersion() {
        if (sides == null) {
            sides = new ArrayList<String>();
            sides.add("1.3.2");
        }
        return sides;
    }

    public static boolean isWindows() {
        return isWindows;
    }

    public static boolean isLinux() {
        return isLinux;
    }

    public static void setLogger(JNativeLogger _logger) {
        mLogger = _logger;
    }

    public static JNativeLogger getLogger() {
        if (mLogger == null) {
            mLogger = ConsoleLogger.getInstance(JNative.class);
        }
        return mLogger;
    }

    public static void setLoggingEnabled(boolean b) {
        DEBUG = b;
    }

    public static boolean isLogginEnabled() {
        return DEBUG;
    }

    @Deprecated
    public static void initCallbacks() throws NativeException {
    }

    @Deprecated
    public final void dispose() throws NativeException, IllegalAccessException {
    }

    public static int getAvailableCallbacks() {
        return 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static {
        block24: {
            boolean lInit;
            block22: {
                isWindows = System.getProperty("os.name").toLowerCase().indexOf("windows") != -1;
                isLinux = System.getProperty("os.name").toLowerCase().indexOf("linux") != -1;
                mLogger = null;
                mLibs = new HashMap<String, JNative>();
                DLL_NAME = isWindows ? "JNativeCpp.dll" : "libJNativeCpp.so";
                mCallbacks = new TreeMap<Integer, Callback>();
                lInit = false;
                String debug = System.getProperty("jnative.debug");
                if (debug != null) {
                    try {
                        JNative.setLoggingEnabled(Boolean.parseBoolean(debug));
                    }
                    catch (Exception e) {
                        System.err.println("DEBUG messages disabled!");
                        e.printStackTrace();
                        JNative.setLoggingEnabled(false);
                    }
                } else {
                    JNative.setLoggingEnabled(false);
                }
                String loadNative = System.getProperty("jnative.loadNative");
                JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, "jnative.loadNative property = " + loadNative);
                if (loadNative == null || loadNative.equalsIgnoreCase("default")) {
                    JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, "Using default System.loadLibrary()");
                    try {
                        System.loadLibrary("JNativeCpp");
                    }
                    catch (UnsatisfiedLinkError e) {
                        JNative.getLogger().log(JNativeLogger.SEVERITY.INFO, "Library not found, trying to extract it from JAR");
                        JNative.loadFromJar();
                    }
                    lInit = true;
                    break block22;
                }
                if (loadNative.equalsIgnoreCase("manual")) {
                    JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, "Using manual : you MUST load the library yourself, then init callbacks !");
                    lInit = true;
                    break block22;
                }
                JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, "Trying to load Library from " + loadNative);
                System.load(loadNative);
                lInit = true;
            }
            Object var5_6 = null;
            mInitDone = lInit;
            boolean ok = false;
            String nativeSideVersion = null;
            try {
                nativeSideVersion = JNative.getNativeSideVersion();
                nativeSideVersion = "1.3.1";
                for (String s : JNative.getCompatibleNativeVersion()) {
                    if (!nativeSideVersion.equals(s)) continue;
                    ok = true;
                    break;
                }
            }
            catch (Throwable e2) {
                JNative.getLogger().log(JNativeLogger.SEVERITY.ERROR, e2);
            }
            if (!ok) {
                JNative.getLogger().log(JNativeLogger.SEVERITY.WARN, "Caution : the native side version (" + nativeSideVersion + ") is not in the compatibility list.");
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    JNative.unLoadAllLibraries();
                }
            });
            {
                break block24;
                catch (Throwable e) {
                    JNative.getLogger().log(JNativeLogger.SEVERITY.ERROR, e);
                    Object var5_7 = null;
                    mInitDone = lInit;
                    ok = false;
                    nativeSideVersion = null;
                    try {
                        nativeSideVersion = JNative.getNativeSideVersion();
                        nativeSideVersion = "1.3.1";
                        for (String s : JNative.getCompatibleNativeVersion()) {
                            if (!nativeSideVersion.equals(s)) continue;
                            ok = true;
                            break;
                        }
                    }
                    catch (Throwable e2) {
                        JNative.getLogger().log(JNativeLogger.SEVERITY.ERROR, e2);
                    }
                    if (!ok) {
                        JNative.getLogger().log(JNativeLogger.SEVERITY.WARN, "Caution : the native side version (" + nativeSideVersion + ") is not in the compatibility list.");
                    }
                    Runtime.getRuntime().addShutdownHook(new /* invalid duplicate definition of identical inner class */);
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                mInitDone = lInit;
                ok = false;
                nativeSideVersion = null;
                try {
                    nativeSideVersion = JNative.getNativeSideVersion();
                    nativeSideVersion = "1.3.1";
                    for (String s : JNative.getCompatibleNativeVersion()) {
                        if (!nativeSideVersion.equals(s)) continue;
                        ok = true;
                        break;
                    }
                }
                catch (Throwable e2) {
                    JNative.getLogger().log(JNativeLogger.SEVERITY.ERROR, e2);
                }
                if (!ok) {
                    JNative.getLogger().log(JNativeLogger.SEVERITY.WARN, "Caution : the native side version (" + nativeSideVersion + ") is not in the compatibility list.");
                }
                Runtime.getRuntime().addShutdownHook(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
        }
        sides = null;
    }
}

