/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.misc.basicStructures;

import java.awt.geom.Rectangle2D;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.basicStructures.AbstractBasicData;
import org.xvolks.jnative.misc.machine.Machine;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.MemoryBlockFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRECT
extends AbstractBasicData<LRECT> {
    public LRECT() {
        super(null);
        try {
            this.createPointer();
        }
        catch (NativeException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public LRECT(Rectangle2D rectangle) {
        this();
        try {
            this.setTop((int)rectangle.getY());
            this.setLeft((int)rectangle.getX());
            this.setRight((int)(rectangle.getX() + rectangle.getWidth()));
            this.setBottom((int)(rectangle.getY() + rectangle.getHeight()));
        }
        catch (NativeException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public int getWidth() throws NativeException {
        return this.getRight() - this.getLeft();
    }

    public int getHeight() throws NativeException {
        return this.getBottom() - this.getTop();
    }

    public int getLeft() throws NativeException {
        return this.pointer.getAsInt(0);
    }

    public int getRight() throws NativeException {
        return this.pointer.getAsInt(8);
    }

    public int getTop() throws NativeException {
        return this.pointer.getAsInt(4);
    }

    public int getBottom() throws NativeException {
        return this.pointer.getAsInt(12);
    }

    public void setLeft(int value) throws NativeException {
        this.pointer.setIntAt(0, value);
    }

    public void setRight(int value) throws NativeException {
        this.pointer.setIntAt(8, value);
    }

    public void setTop(int value) throws NativeException {
        this.pointer.setIntAt(4, value);
    }

    public void setBottom(int value) throws NativeException {
        this.pointer.setIntAt(12, value);
    }

    @Override
    public Pointer createPointer() throws NativeException {
        this.pointer = new Pointer(MemoryBlockFactory.createMemoryBlock(LRECT.sizeOf()));
        return this.pointer;
    }

    @Override
    public LRECT getValueFromPointer() throws NativeException {
        return this;
    }

    @Override
    public int getSizeOf() {
        return LRECT.sizeOf();
    }

    public static int sizeOf() {
        return Machine.SIZE * 16;
    }
}

