/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.ForceInline;
import java.lang.invoke.InvokerBytecodeGenerator;
import java.lang.invoke.Invokers;
import java.lang.invoke.LambdaForm;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleImpl;
import java.lang.invoke.MethodHandleNatives;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import sun.invoke.util.ValueConversions;
import sun.invoke.util.VerifyAccess;
import sun.invoke.util.VerifyType;
import sun.invoke.util.Wrapper;
import sun.misc.Unsafe;

class DirectMethodHandle
extends MethodHandle {
    final MemberName member;
    private static final MemberName.Factory IMPL_NAMES = MemberName.getFactory();
    private static byte AF_GETFIELD = 0;
    private static byte AF_PUTFIELD = 1;
    private static byte AF_GETSTATIC = (byte)2;
    private static byte AF_PUTSTATIC = (byte)3;
    private static byte AF_GETSTATIC_INIT = (byte)4;
    private static byte AF_PUTSTATIC_INIT = (byte)5;
    private static byte AF_LIMIT = (byte)6;
    private static int FT_LAST_WRAPPER = Wrapper.values().length - 1;
    private static int FT_UNCHECKED_REF = Wrapper.OBJECT.ordinal();
    private static int FT_CHECKED_REF = FT_LAST_WRAPPER + 1;
    private static int FT_LIMIT = FT_LAST_WRAPPER + 2;
    private static final LambdaForm[] ACCESSOR_FORMS = new LambdaForm[DirectMethodHandle.afIndex(AF_LIMIT, false, 0)];
    private static final LambdaForm.NamedFunction NF_internalMemberName;
    private static final LambdaForm.NamedFunction NF_internalMemberNameEnsureInit;
    private static final LambdaForm.NamedFunction NF_ensureInitialized;
    private static final LambdaForm.NamedFunction NF_fieldOffset;
    private static final LambdaForm.NamedFunction NF_checkBase;
    private static final LambdaForm.NamedFunction NF_staticBase;
    private static final LambdaForm.NamedFunction NF_staticOffset;
    private static final LambdaForm.NamedFunction NF_checkCast;
    private static final LambdaForm.NamedFunction NF_allocateInstance;
    private static final LambdaForm.NamedFunction NF_constructorMethod;

    private DirectMethodHandle(MethodType methodType, LambdaForm lambdaForm, MemberName memberName) {
        super(methodType, lambdaForm);
        if (!memberName.isResolved()) {
            throw new InternalError();
        }
        if (memberName.getDeclaringClass().isInterface() && !memberName.isAbstract()) {
            MemberName memberName2 = new MemberName(Object.class, memberName.getName(), memberName.getMethodType(), memberName.getReferenceKind());
            memberName2 = MemberName.getFactory().resolveOrNull(memberName2.getReferenceKind(), memberName2, null);
            if (memberName2 != null && memberName2.isPublic()) {
                memberName = memberName2;
            }
        }
        this.member = memberName;
    }

    static DirectMethodHandle make(Class<?> clazz, MemberName memberName) {
        MethodType methodType = memberName.getMethodOrFieldType();
        if (!memberName.isStatic()) {
            if (!memberName.getDeclaringClass().isAssignableFrom(clazz) || memberName.isConstructor()) {
                throw new InternalError(memberName.toString());
            }
            methodType = methodType.insertParameterTypes(0, clazz);
        }
        if (!memberName.isField()) {
            LambdaForm lambdaForm = DirectMethodHandle.preparedLambdaForm(memberName);
            return new DirectMethodHandle(methodType, lambdaForm, memberName);
        }
        LambdaForm lambdaForm = DirectMethodHandle.preparedFieldLambdaForm(memberName);
        if (memberName.isStatic()) {
            long l = MethodHandleNatives.staticFieldOffset(memberName);
            Object object = MethodHandleNatives.staticFieldBase(memberName);
            return new StaticAccessor(methodType, lambdaForm, memberName, object, l);
        }
        long l = MethodHandleNatives.objectFieldOffset(memberName);
        assert (l == (long)((int)l));
        return new Accessor(methodType, lambdaForm, memberName, (int)l);
    }

    static DirectMethodHandle make(MemberName memberName) {
        if (memberName.isConstructor()) {
            return DirectMethodHandle.makeAllocator(memberName);
        }
        return DirectMethodHandle.make(memberName.getDeclaringClass(), memberName);
    }

    static DirectMethodHandle make(Method method) {
        return DirectMethodHandle.make(method.getDeclaringClass(), new MemberName(method));
    }

    static DirectMethodHandle make(Field field) {
        return DirectMethodHandle.make(field.getDeclaringClass(), new MemberName(field));
    }

    private static DirectMethodHandle makeAllocator(MemberName memberName) {
        assert (memberName.isConstructor() && memberName.getName().equals("<init>"));
        Class<?> clazz = memberName.getDeclaringClass();
        memberName = memberName.asConstructor();
        assert (memberName.isConstructor() && memberName.getReferenceKind() == 8) : memberName;
        MethodType methodType = memberName.getMethodType().changeReturnType(clazz);
        LambdaForm lambdaForm = DirectMethodHandle.preparedLambdaForm(memberName);
        MemberName memberName2 = memberName.asSpecial();
        assert (memberName2.getMethodType().returnType() == Void.TYPE);
        return new Constructor(methodType, lambdaForm, memberName, memberName2, clazz);
    }

    @Override
    MethodHandle copyWith(MethodType methodType, LambdaForm lambdaForm) {
        return new DirectMethodHandle(methodType, lambdaForm, this.member);
    }

    @Override
    String internalProperties() {
        return "/DMH=" + this.member.toString();
    }

    @Override
    @ForceInline
    MemberName internalMemberName() {
        return this.member;
    }

    @Override
    MethodHandle bindArgument(int n, char c, Object object) {
        DirectMethodHandle directMethodHandle;
        if (n == 0 && c == 'L' && (directMethodHandle = this.maybeRebind(object)) != null) {
            return directMethodHandle.bindReceiver(object);
        }
        return super.bindArgument(n, c, object);
    }

    @Override
    MethodHandle bindReceiver(Object object) {
        DirectMethodHandle directMethodHandle = this.maybeRebind(object);
        if (directMethodHandle != null) {
            return directMethodHandle.bindReceiver(object);
        }
        return super.bindReceiver(object);
    }

    private DirectMethodHandle maybeRebind(Object object) {
        if (object != null) {
            switch (this.member.getReferenceKind()) {
                case 5: 
                case 9: {
                    Class<?> clazz = object.getClass();
                    MemberName memberName = new MemberName(clazz, this.member.getName(), this.member.getMethodType(), 7);
                    memberName = IMPL_NAMES.resolveOrNull((byte)7, memberName, clazz);
                    if (memberName == null) break;
                    return new DirectMethodHandle(this.type(), DirectMethodHandle.preparedLambdaForm(memberName), memberName);
                }
            }
        }
        return null;
    }

    private static LambdaForm preparedLambdaForm(MemberName memberName) {
        int n;
        assert (memberName.isInvocable()) : memberName;
        MethodType methodType = memberName.getInvocationType().basicType();
        assert (!memberName.isMethodHandleInvoke() || "invokeBasic".equals(memberName.getName())) : memberName;
        switch (memberName.getReferenceKind()) {
            case 5: {
                n = 0;
                break;
            }
            case 6: {
                n = 1;
                break;
            }
            case 7: {
                n = 2;
                break;
            }
            case 9: {
                n = 4;
                break;
            }
            case 8: {
                n = 3;
                break;
            }
            default: {
                throw new InternalError(memberName.toString());
            }
        }
        if (n == 1 && DirectMethodHandle.shouldBeInitialized(memberName)) {
            DirectMethodHandle.preparedLambdaForm(methodType, n);
            n = 5;
        }
        LambdaForm lambdaForm = DirectMethodHandle.preparedLambdaForm(methodType, n);
        DirectMethodHandle.maybeCompile(lambdaForm, memberName);
        assert (lambdaForm.methodType().dropParameterTypes(0, 1).equals((Object)memberName.getInvocationType().basicType())) : Arrays.asList(memberName, memberName.getInvocationType().basicType(), lambdaForm, lambdaForm.methodType());
        return lambdaForm;
    }

    private static LambdaForm preparedLambdaForm(MethodType methodType, int n) {
        LambdaForm lambdaForm = methodType.form().cachedLambdaForm(n);
        if (lambdaForm != null) {
            return lambdaForm;
        }
        lambdaForm = DirectMethodHandle.makePreparedLambdaForm(methodType, n);
        return methodType.form().setCachedLambdaForm(n, lambdaForm);
    }

    private static LambdaForm makePreparedLambdaForm(MethodType methodType, int n) {
        int n2;
        String string;
        String string2;
        boolean bl = n == 5;
        boolean bl2 = n == 3;
        switch (n) {
            case 0: {
                string2 = "linkToVirtual";
                string = "DMH.invokeVirtual";
                break;
            }
            case 1: {
                string2 = "linkToStatic";
                string = "DMH.invokeStatic";
                break;
            }
            case 5: {
                string2 = "linkToStatic";
                string = "DMH.invokeStaticInit";
                break;
            }
            case 2: {
                string2 = "linkToSpecial";
                string = "DMH.invokeSpecial";
                break;
            }
            case 4: {
                string2 = "linkToInterface";
                string = "DMH.invokeInterface";
                break;
            }
            case 3: {
                string2 = "linkToSpecial";
                string = "DMH.newInvokeSpecial";
                break;
            }
            default: {
                throw new InternalError("which=" + n);
            }
        }
        MethodType methodType2 = methodType.appendParameterTypes(MemberName.class);
        if (bl2) {
            methodType2 = methodType2.insertParameterTypes(0, Object.class).changeReturnType(Void.TYPE);
        }
        MemberName memberName = new MemberName(MethodHandle.class, string2, methodType2, 6);
        try {
            memberName = IMPL_NAMES.resolveOrFail((byte)6, memberName, null, NoSuchMethodException.class);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw MethodHandleStatics.newInternalError(reflectiveOperationException);
        }
        int n3 = n2 = 1 + methodType.parameterCount();
        int n4 = bl2 ? n3++ : -1;
        int n5 = n3++;
        int n6 = n3++;
        LambdaForm.Name[] nameArray = LambdaForm.arguments(n3 - n2, methodType.invokerType());
        assert (nameArray.length == n3);
        if (bl2) {
            nameArray[n4] = new LambdaForm.Name(NF_allocateInstance, nameArray[0]);
            nameArray[n5] = new LambdaForm.Name(NF_constructorMethod, nameArray[0]);
        } else {
            nameArray[n5] = bl ? new LambdaForm.Name(NF_internalMemberNameEnsureInit, nameArray[0]) : new LambdaForm.Name(NF_internalMemberName, nameArray[0]);
        }
        Object[] objectArray = Arrays.copyOfRange(nameArray, 1, n5 + 1, Object[].class);
        assert (objectArray[objectArray.length - 1] == nameArray[n5]);
        int n7 = -2;
        if (bl2) {
            assert (objectArray[objectArray.length - 2] == nameArray[n4]);
            System.arraycopy(objectArray, 0, objectArray, 1, objectArray.length - 2);
            objectArray[0] = nameArray[n4];
            n7 = n4;
        }
        nameArray[n6] = new LambdaForm.Name(memberName, objectArray);
        string = string + "_" + LambdaForm.basicTypeSignature(methodType);
        LambdaForm lambdaForm = new LambdaForm(string, n2, nameArray, n7);
        lambdaForm.compileToBytecode();
        return lambdaForm;
    }

    private static void maybeCompile(LambdaForm lambdaForm, MemberName memberName) {
        if (VerifyAccess.isSamePackage(memberName.getDeclaringClass(), MethodHandle.class)) {
            lambdaForm.compileToBytecode();
        }
    }

    @ForceInline
    static Object internalMemberName(Object object) {
        return ((DirectMethodHandle)object).member;
    }

    static Object internalMemberNameEnsureInit(Object object) {
        DirectMethodHandle directMethodHandle = (DirectMethodHandle)object;
        directMethodHandle.ensureInitialized();
        return directMethodHandle.member;
    }

    static boolean shouldBeInitialized(MemberName memberName) {
        switch (memberName.getReferenceKind()) {
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                break;
            }
            default: {
                return false;
            }
        }
        Class<?> clazz = memberName.getDeclaringClass();
        if (clazz == ValueConversions.class || clazz == MethodHandleImpl.class || clazz == Invokers.class) {
            return false;
        }
        if (VerifyAccess.isSamePackage(MethodHandle.class, clazz) || VerifyAccess.isSamePackage(ValueConversions.class, clazz)) {
            if (MethodHandleStatics.UNSAFE.shouldBeInitialized(clazz)) {
                MethodHandleStatics.UNSAFE.ensureClassInitialized(clazz);
            }
            return false;
        }
        return MethodHandleStatics.UNSAFE.shouldBeInitialized(clazz);
    }

    private void ensureInitialized() {
        if (DirectMethodHandle.checkInitialized(this.member)) {
            if (this.member.isField()) {
                this.updateForm(DirectMethodHandle.preparedFieldLambdaForm(this.member));
            } else {
                this.updateForm(DirectMethodHandle.preparedLambdaForm(this.member));
            }
        }
    }

    private static boolean checkInitialized(MemberName memberName) {
        Class<?> clazz = memberName.getDeclaringClass();
        WeakReference weakReference = (WeakReference)EnsureInitialized.INSTANCE.get(clazz);
        if (weakReference == null) {
            return true;
        }
        Thread thread = (Thread)weakReference.get();
        if (thread == Thread.currentThread()) {
            if (MethodHandleStatics.UNSAFE.shouldBeInitialized(clazz)) {
                return false;
            }
        } else {
            MethodHandleStatics.UNSAFE.ensureClassInitialized(clazz);
        }
        assert (!MethodHandleStatics.UNSAFE.shouldBeInitialized(clazz));
        EnsureInitialized.INSTANCE.remove(clazz);
        return true;
    }

    static void ensureInitialized(Object object) {
        ((DirectMethodHandle)object).ensureInitialized();
    }

    static Object constructorMethod(Object object) {
        Constructor constructor = (Constructor)object;
        return constructor.initMethod;
    }

    static Object allocateInstance(Object object) throws InstantiationException {
        Constructor constructor = (Constructor)object;
        return MethodHandleStatics.UNSAFE.allocateInstance(constructor.instanceClass);
    }

    @ForceInline
    static long fieldOffset(Object object) {
        return ((Accessor)object).fieldOffset;
    }

    @ForceInline
    static Object checkBase(Object object) {
        object.getClass();
        return object;
    }

    @ForceInline
    static Object nullCheck(Object object) {
        object.getClass();
        return object;
    }

    @ForceInline
    static Object staticBase(Object object) {
        return ((StaticAccessor)object).staticBase;
    }

    @ForceInline
    static long staticOffset(Object object) {
        return ((StaticAccessor)object).staticOffset;
    }

    @ForceInline
    static Object checkCast(Object object, Object object2) {
        return ((DirectMethodHandle)object).checkCast(object2);
    }

    Object checkCast(Object object) {
        return this.member.getReturnType().cast(object);
    }

    private static int afIndex(byte by, boolean bl, int n) {
        return by * FT_LIMIT * 2 + (bl ? FT_LIMIT : 0) + n;
    }

    private static int ftypeKind(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return Wrapper.forPrimitiveType(clazz).ordinal();
        }
        if (VerifyType.isNullReferenceConversion(Object.class, clazz)) {
            return FT_UNCHECKED_REF;
        }
        return FT_CHECKED_REF;
    }

    private static LambdaForm preparedFieldLambdaForm(MemberName memberName) {
        byte by;
        Class<?> clazz = memberName.getFieldType();
        boolean bl = memberName.isVolatile();
        switch (memberName.getReferenceKind()) {
            case 1: {
                by = AF_GETFIELD;
                break;
            }
            case 3: {
                by = AF_PUTFIELD;
                break;
            }
            case 2: {
                by = AF_GETSTATIC;
                break;
            }
            case 4: {
                by = AF_PUTSTATIC;
                break;
            }
            default: {
                throw new InternalError(memberName.toString());
            }
        }
        if (DirectMethodHandle.shouldBeInitialized(memberName)) {
            DirectMethodHandle.preparedFieldLambdaForm(by, bl, clazz);
            assert (AF_GETSTATIC_INIT - AF_GETSTATIC == AF_PUTSTATIC_INIT - AF_PUTSTATIC);
            by = (byte)(by + (AF_GETSTATIC_INIT - AF_GETSTATIC));
        }
        LambdaForm lambdaForm = DirectMethodHandle.preparedFieldLambdaForm(by, bl, clazz);
        DirectMethodHandle.maybeCompile(lambdaForm, memberName);
        assert (lambdaForm.methodType().dropParameterTypes(0, 1).equals((Object)memberName.getInvocationType().basicType())) : Arrays.asList(memberName, memberName.getInvocationType().basicType(), lambdaForm, lambdaForm.methodType());
        return lambdaForm;
    }

    private static LambdaForm preparedFieldLambdaForm(byte by, boolean bl, Class<?> clazz) {
        int n = DirectMethodHandle.afIndex(by, bl, DirectMethodHandle.ftypeKind(clazz));
        LambdaForm lambdaForm = ACCESSOR_FORMS[n];
        if (lambdaForm != null) {
            return lambdaForm;
        }
        DirectMethodHandle.ACCESSOR_FORMS[n] = lambdaForm = DirectMethodHandle.makePreparedFieldLambdaForm(by, bl, DirectMethodHandle.ftypeKind(clazz));
        return lambdaForm;
    }

    private static LambdaForm makePreparedFieldLambdaForm(byte by, boolean bl, int n) {
        boolean bl2 = (by & 1) == (AF_GETFIELD & 1);
        boolean bl3 = by >= AF_GETSTATIC;
        boolean bl4 = by >= AF_GETSTATIC_INIT;
        boolean bl5 = n == FT_CHECKED_REF;
        Wrapper wrapper = bl5 ? Wrapper.OBJECT : Wrapper.values()[n];
        Class<?> clazz = wrapper.primitiveType();
        assert (DirectMethodHandle.ftypeKind(bl5 ? String.class : clazz) == n);
        String string = wrapper.primitiveSimpleName();
        String string2 = Character.toUpperCase(string.charAt(0)) + string.substring(1);
        if (bl) {
            string2 = string2 + "Volatile";
        }
        String string3 = bl2 ? "get" : "put";
        String string4 = string3 + string2;
        MethodType methodType = bl2 ? MethodType.methodType(clazz, Object.class, Long.TYPE) : MethodType.methodType(Void.TYPE, Object.class, Long.TYPE, clazz);
        MemberName memberName = new MemberName(Unsafe.class, string4, methodType, 5);
        try {
            memberName = IMPL_NAMES.resolveOrFail((byte)5, memberName, null, NoSuchMethodException.class);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw MethodHandleStatics.newInternalError(reflectiveOperationException);
        }
        MethodType methodType2 = bl2 ? MethodType.methodType(clazz) : MethodType.methodType(Void.TYPE, clazz);
        methodType2 = methodType2.basicType();
        if (!bl3) {
            methodType2 = methodType2.insertParameterTypes(0, Object.class);
        }
        int n2 = 1 + methodType2.parameterCount();
        int n3 = bl3 ? -1 : 1;
        int n4 = bl2 ? -1 : n2 - 1;
        int n5 = n2;
        int n6 = bl3 ? n5++ : -1;
        int n7 = n5++;
        int n8 = n3 >= 0 ? n5++ : -1;
        int n9 = bl4 ? n5++ : -1;
        int n10 = bl5 && !bl2 ? n5++ : -1;
        int n11 = n5++;
        int n12 = bl5 && bl2 ? n5++ : -1;
        int n13 = n5 - 1;
        LambdaForm.Name[] nameArray = LambdaForm.arguments(n5 - n2, methodType2.invokerType());
        if (bl4) {
            nameArray[n9] = new LambdaForm.Name(NF_ensureInitialized, nameArray[0]);
        }
        if (bl5 && !bl2) {
            nameArray[n10] = new LambdaForm.Name(NF_checkCast, nameArray[0], nameArray[n4]);
        }
        Object[] objectArray = new Object[1 + methodType.parameterCount()];
        assert (objectArray.length == (bl2 ? 3 : 4));
        objectArray[0] = MethodHandleStatics.UNSAFE;
        if (bl3) {
            nameArray[n6] = new LambdaForm.Name(NF_staticBase, nameArray[0]);
            objectArray[1] = nameArray[n6];
            nameArray[n7] = new LambdaForm.Name(NF_staticOffset, nameArray[0]);
            objectArray[2] = nameArray[n7];
        } else {
            nameArray[n8] = new LambdaForm.Name(NF_checkBase, nameArray[n3]);
            objectArray[1] = nameArray[n8];
            nameArray[n7] = new LambdaForm.Name(NF_fieldOffset, nameArray[0]);
            objectArray[2] = nameArray[n7];
        }
        if (!bl2) {
            objectArray[3] = bl5 ? nameArray[n10] : nameArray[n4];
        }
        for (Object object : objectArray) {
            assert (object != null);
        }
        nameArray[n11] = new LambdaForm.Name(memberName, objectArray);
        if (bl5 && bl2) {
            nameArray[n12] = new LambdaForm.Name(NF_checkCast, nameArray[0], nameArray[n11]);
        }
        for (LambdaForm.Name name : nameArray) {
            assert (name != null);
        }
        String string5 = bl3 ? "Static" : "Field";
        String string6 = string4 + string5;
        if (bl5) {
            string6 = string6 + "Cast";
        }
        if (bl4) {
            string6 = string6 + "Init";
        }
        return new LambdaForm(string6, n2, nameArray, n13);
    }

    static {
        try {
            LambdaForm.NamedFunction[] namedFunctionArray;
            NF_internalMemberName = new LambdaForm.NamedFunction(DirectMethodHandle.class.getDeclaredMethod("internalMemberName", Object.class));
            for (LambdaForm.NamedFunction namedFunction : namedFunctionArray = new LambdaForm.NamedFunction[]{NF_internalMemberName, NF_internalMemberNameEnsureInit = new LambdaForm.NamedFunction(DirectMethodHandle.class.getDeclaredMethod("internalMemberNameEnsureInit", Object.class)), NF_ensureInitialized = new LambdaForm.NamedFunction(DirectMethodHandle.class.getDeclaredMethod("ensureInitialized", Object.class)), NF_fieldOffset = new LambdaForm.NamedFunction(DirectMethodHandle.class.getDeclaredMethod("fieldOffset", Object.class)), NF_checkBase = new LambdaForm.NamedFunction(DirectMethodHandle.class.getDeclaredMethod("checkBase", Object.class)), NF_staticBase = new LambdaForm.NamedFunction(DirectMethodHandle.class.getDeclaredMethod("staticBase", Object.class)), NF_staticOffset = new LambdaForm.NamedFunction(DirectMethodHandle.class.getDeclaredMethod("staticOffset", Object.class)), NF_checkCast = new LambdaForm.NamedFunction(DirectMethodHandle.class.getDeclaredMethod("checkCast", Object.class, Object.class)), NF_allocateInstance = new LambdaForm.NamedFunction(DirectMethodHandle.class.getDeclaredMethod("allocateInstance", Object.class)), NF_constructorMethod = new LambdaForm.NamedFunction(DirectMethodHandle.class.getDeclaredMethod("constructorMethod", Object.class))}) {
                assert (InvokerBytecodeGenerator.isStaticallyInvocable(namedFunction.member)) : namedFunction;
                namedFunction.resolve();
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw MethodHandleStatics.newInternalError(reflectiveOperationException);
        }
    }

    static class Accessor
    extends DirectMethodHandle {
        final Class<?> fieldType;
        final int fieldOffset;

        private Accessor(MethodType methodType, LambdaForm lambdaForm, MemberName memberName, int n) {
            super(methodType, lambdaForm, memberName);
            this.fieldType = memberName.getFieldType();
            this.fieldOffset = n;
        }

        @Override
        Object checkCast(Object object) {
            return this.fieldType.cast(object);
        }
    }

    static class Constructor
    extends DirectMethodHandle {
        final MemberName initMethod;
        final Class<?> instanceClass;

        private Constructor(MethodType methodType, LambdaForm lambdaForm, MemberName memberName, MemberName memberName2, Class<?> clazz) {
            super(methodType, lambdaForm, memberName);
            this.initMethod = memberName2;
            this.instanceClass = clazz;
            assert (memberName2.isResolved());
        }
    }

    private static class EnsureInitialized
    extends ClassValue<WeakReference<Thread>> {
        static final EnsureInitialized INSTANCE = new EnsureInitialized();

        private EnsureInitialized() {
        }

        @Override
        protected WeakReference<Thread> computeValue(Class<?> clazz) {
            MethodHandleStatics.UNSAFE.ensureClassInitialized(clazz);
            if (MethodHandleStatics.UNSAFE.shouldBeInitialized(clazz)) {
                return new WeakReference<Thread>(Thread.currentThread());
            }
            return null;
        }
    }

    static class StaticAccessor
    extends DirectMethodHandle {
        private final Class<?> fieldType;
        private final Object staticBase;
        private final long staticOffset;

        private StaticAccessor(MethodType methodType, LambdaForm lambdaForm, MemberName memberName, Object object, long l) {
            super(methodType, lambdaForm, memberName);
            this.fieldType = memberName.getFieldType();
            this.staticBase = object;
            this.staticOffset = l;
        }

        @Override
        Object checkCast(Object object) {
            return this.fieldType.cast(object);
        }
    }
}

