/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.com;

import java.util.logging.Logger;
import org.xvolks.jnative.Native;
import org.xvolks.jnative.com.interfaces.IDispatch;

public abstract class EventProxy {
    private int eventCookie;
    protected final Logger logger;
    private final String sinkIID;
    private boolean disposed = false;
    private IDispatch iDispatch;

    private native EventProxy comNewInstance(int var1, String var2) throws Exception;

    private native void comDispose() throws Exception;

    @Native
    protected void setEventCookie(int eventCookie) {
        this.eventCookie = eventCookie;
    }

    @Native
    protected int getEventCookie() {
        return this.eventCookie;
    }

    @Native
    protected String getSinkIID() {
        return this.sinkIID;
    }

    @Native
    protected int getPIUnknown() {
        return this.iDispatch.getPIDispatch();
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public EventProxy(IDispatch iDispatch, String sinkIID) throws Exception {
        this.iDispatch = iDispatch;
        this.eventCookie = 0;
        this.logger = Logger.getLogger(this.getClass().getSimpleName());
        this.sinkIID = sinkIID;
        iDispatch.syncExec(new ComNewInstanceTask(iDispatch, sinkIID));
    }

    public synchronized void dispose() {
        if (!this.disposed) {
            try {
                this.iDispatch.syncExec(new ComDisposeTask(this.iDispatch, this.sinkIID));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.disposed = true;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    private class ComDisposeTask
    extends ComTasks {
        public ComDisposeTask(IDispatch iDispatch, String sinkIID) {
            super(iDispatch, sinkIID);
        }

        public void run() {
            try {
                EventProxy.this.comDispose();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    private class ComNewInstanceTask
    extends ComTasks {
        public ComNewInstanceTask(IDispatch iDispatch, String sinkIID) {
            super(iDispatch, sinkIID);
        }

        public void run() {
            try {
                EventProxy.this.comNewInstance(this.iDispatch.getPIDispatch(), this.sinkIID);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    private abstract class ComTasks
    implements Runnable {
        protected String sinkIID;
        protected IDispatch iDispatch;

        public ComTasks(IDispatch iDispatch, String sinkIID) {
            this.iDispatch = iDispatch;
            this.sinkIID = sinkIID;
        }

        public abstract void run();
    }
}

