/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.misc;

import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.basicStructures.AbstractBasicData;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.MemoryBlockFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POINT
extends AbstractBasicData<POINT> {
    protected int x;
    protected int y;

    public POINT() {
        this(0, 0);
    }

    public POINT(int x, int y) {
        super(null);
        try {
            this.createPointer();
        }
        catch (NativeException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
        this.x = x;
        this.y = y;
    }

    @Override
    public Pointer createPointer() throws NativeException {
        this.pointer = new Pointer(MemoryBlockFactory.createMemoryBlock(POINT.sizeOf()));
        return this.pointer;
    }

    @Override
    public POINT getValueFromPointer() throws NativeException {
        this.x = this.pointer.getAsInt(0);
        this.y = this.pointer.getAsInt(4);
        return this;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setX(int x) throws NativeException {
        this.x = x;
        this.pointer.setIntAt(0, x);
    }

    public void setY(int y) throws NativeException {
        this.y = y;
        this.pointer.setIntAt(4, y);
    }

    @Override
    public POINT getValue() {
        try {
            this.pointer.setIntAt(0, this.x);
            this.pointer.setIntAt(4, this.y);
        }
        catch (NativeException ex) {
            ex.printStackTrace();
        }
        return this;
    }

    @Override
    public int getSizeOf() {
        return POINT.sizeOf();
    }

    public static int sizeOf() {
        return 8;
    }
}

