/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PlsqlIndexTableAccessor;
import oracle.jdbc.driver.T4CMAREngine;

class T4CPlsqlIndexTableAccessor
extends PlsqlIndexTableAccessor {
    T4CMAREngine mare;
    final int[] meta = new int[1];
    final int[] tmp = new int[1];
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_17:37:41_PDT_2008";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    T4CPlsqlIndexTableAccessor(OracleStatement oracleStatement, int n2, int n3, int n4, int n5, short s2, boolean bl, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, n2, n3, n4, n5, s2, bl);
        this.calculateSizeTmpByteArray();
        this.mare = t4CMAREngine;
    }

    void processIndicator(int n2) throws IOException, SQLException {
        if (this.internalType == 1 && this.describeType == 112 || this.internalType == 23 && this.describeType == 113) {
            this.mare.unmarshalUB2();
            this.mare.unmarshalUB2();
        } else if (this.mare.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (this.statement.sqlKind != 1 && this.statement.sqlKind != 4) {
                this.mare.unmarshalSB2();
            }
        } else if (this.statement.sqlKind == 1 || this.statement.sqlKind == 4 || this.isDMLReturnedParam) {
            this.mare.processIndicator(n2 <= 0, n2);
        }
    }

    @Override
    boolean unmarshalOneRow() throws SQLException, IOException {
        if (this.isUseLess) {
            ++this.lastRowProcessed;
            return false;
        }
        if (this.rowSpaceIndicator == null) {
            byte[] byArray = new byte[16000];
            this.mare.unmarshalCLR(byArray, 0, this.meta);
            this.processIndicator(this.meta[0]);
            ++this.lastRowProcessed;
            return false;
        }
        int n2 = this.indicatorIndex + this.lastRowProcessed;
        int n3 = this.lengthIndex + this.lastRowProcessed;
        byte[] byArray = this.statement.ibtBindBytes;
        char[] cArray = this.statement.ibtBindChars;
        short[] sArray = this.statement.ibtBindIndicators;
        int n4 = this.statement.ibtBindByteOffset;
        int n5 = this.statement.ibtBindCharOffset;
        int n6 = this.statement.ibtBindIndicatorOffset;
        if (this.isNullByDescribe) {
            this.rowSpaceIndicator[n2] = -1;
            this.rowSpaceIndicator[n3] = 0;
            ++this.lastRowProcessed;
            if (this.mare.versionNumber < 9200) {
                this.processIndicator(0);
            }
            return false;
        }
        int n7 = (int)this.mare.unmarshalUB4();
        sArray[this.ibtMetaIndex + 4] = (short)(n7 & 0xFFFFFFFF & 0xFFFF);
        sArray[this.ibtMetaIndex + 5] = (short)(n7 & 0xFFFF);
        if (this.elementInternalType == 9 || this.elementInternalType == 96 || this.elementInternalType == 1) {
            byte[] byArray2 = this.statement.tmpByteArray;
            for (int i2 = 0; i2 < n7; ++i2) {
                int n8 = this.ibtValueIndex + this.elementMaxLen * i2;
                this.mare.unmarshalCLR(byArray2, 0, this.meta);
                this.tmp[0] = this.meta[0];
                int n9 = this.statement.connection.conversion.CHARBytesToJavaChars(byArray2, 0, cArray, n8 + 1, this.tmp, cArray.length - n8 - 1);
                cArray[n8] = (char)(n9 * 2);
                this.processIndicator(this.meta[0]);
                if (this.meta[0] == 0) {
                    sArray[this.ibtIndicatorIndex + i2] = -1;
                    sArray[this.ibtLengthIndex + i2] = 0;
                    continue;
                }
                sArray[this.ibtLengthIndex + i2] = (short)(this.meta[0] * 2);
                sArray[this.ibtIndicatorIndex + i2] = 0;
            }
        } else {
            for (int i3 = 0; i3 < n7; ++i3) {
                int n10 = this.ibtValueIndex + this.elementMaxLen * i3;
                this.mare.unmarshalCLR(byArray, n10 + 1, this.meta);
                byArray[n10] = (byte)this.meta[0];
                this.processIndicator(this.meta[0]);
                if (this.meta[0] == 0) {
                    sArray[this.ibtIndicatorIndex + i3] = -1;
                    sArray[this.ibtLengthIndex + i3] = 0;
                    continue;
                }
                sArray[this.ibtLengthIndex + i3] = (short)this.meta[0];
                sArray[this.ibtIndicatorIndex + i3] = 0;
            }
        }
        ++this.lastRowProcessed;
        return false;
    }

    @Override
    void calculateSizeTmpByteArray() {
        int n2;
        if ((this.elementInternalType == 9 || this.elementInternalType == 96 || this.elementInternalType == 1) && this.statement.sizeTmpByteArray < (n2 = this.ibtCharLength * this.statement.connection.conversion.cMaxCharSize / this.maxNumberOfElements)) {
            this.statement.sizeTmpByteArray = n2;
        }
    }

    @Override
    String getString(int n2) throws SQLException {
        String string = super.getString(n2);
        if (string != null && this.definedColumnSize > 0 && string.length() > this.definedColumnSize) {
            string = string.substring(0, this.definedColumnSize);
        }
        return string;
    }
}

