/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.TDSReader;
import oracle.sql.Datum;
import oracle.sql.RAW;

public class OracleTypeRAW
extends OracleType
implements Serializable {
    static final long serialVersionUID = -6083664758336974576L;
    int length;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_17:37:32_PDT_2008";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    public OracleTypeRAW() {
    }

    public OracleTypeRAW(int n2) {
        super(n2);
    }

    @Override
    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        RAW rAW = null;
        if (object != null) {
            try {
                rAW = object instanceof RAW ? (RAW)object : new RAW(object);
            }
            catch (SQLException sQLException) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 59, object);
            }
        }
        return rAW;
    }

    @Override
    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection, long l2, int n2) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            if (object instanceof char[][]) {
                char[][] cArray = (char[][])object;
                int n3 = (int)(n2 == -1 ? (long)cArray.length : Math.min((long)cArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    datumArray[i2] = this.toDatum(new String(cArray[(int)l2 + i2 - 1]), oracleConnection);
                }
            } else {
                if (object instanceof Object[]) {
                    return super.toDatumArray(object, oracleConnection, l2, n2);
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 59, object);
            }
        }
        return datumArray;
    }

    @Override
    public int getTypeCode() {
        return -2;
    }

    @Override
    public void parseTDSrec(TDSReader tDSReader) throws SQLException {
        super.parseTDSrec(tDSReader);
        this.length = tDSReader.readUB2();
    }

    @Override
    protected int pickle81(PickleContext pickleContext, Datum datum) throws SQLException {
        if (datum.getLength() > (long)this.length) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 72, this);
        }
        int n2 = pickleContext.writeLength((int)datum.getLength());
        return n2 += pickleContext.writeData(datum.shareBytes());
    }

    public int getLength() {
        return this.length;
    }

    @Override
    protected Object toObject(byte[] byArray, int n2, Map map) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        switch (n2) {
            case 1: {
                return new RAW(byArray);
            }
            case 2: 
            case 3: {
                return byArray;
            }
        }
        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 59, byArray);
        return null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.length);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.length = objectInputStream.readInt();
    }
}

