/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmediaimpl;

import com.sun.media.jfxmedia.MetadataParser;
import com.sun.media.jfxmedia.events.MetadataListener;
import com.sun.media.jfxmedia.locator.ConnectionHolder;
import com.sun.media.jfxmedia.locator.Locator;
import java.io.EOFException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public abstract class MetadataParserImpl
extends Thread
implements MetadataParser {
    private String[] FLV_VIDEO_CODEC_NAME = new String[]{"Unsupported", "JPEG Video (Unsupported)", "Sorenson H.263 Video", "Flash Screen Video", "On2 VP6 Video", "On2 VP6-Alpha Video", "Unsupported", "H.264 Video", "Unsupported", "Unsupported", "Unsupported", "Unsupported", "Unsupported", "Unsupported", "Unsupported", "Unsupported"};
    private final List<WeakReference<MetadataListener>> listeners = new ArrayList<WeakReference<MetadataListener>>();
    private Map<String, Object> metadata = new HashMap<String, Object>();
    private Locator locator = null;
    private ConnectionHolder connectionHolder = null;
    private ByteBuffer buffer = null;
    private Map<String, ByteBuffer> rawMetaMap = null;
    protected ByteBuffer rawMetaBlob = null;
    private boolean parsingRawMetadata = false;
    private int length = 0;
    private int index = 0;
    private int streamPosition = 0;

    public MetadataParserImpl(Locator locator) {
        this.locator = locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(MetadataListener listener) {
        List<WeakReference<MetadataListener>> list = this.listeners;
        synchronized (list) {
            if (listener != null) {
                this.listeners.add(new WeakReference<MetadataListener>(listener));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(MetadataListener listener) {
        List<WeakReference<MetadataListener>> list = this.listeners;
        synchronized (list) {
            if (listener != null) {
                ListIterator<WeakReference<MetadataListener>> it = this.listeners.listIterator();
                while (it.hasNext()) {
                    MetadataListener l = (MetadataListener)it.next().get();
                    if (l != null && l != listener) continue;
                    it.remove();
                }
            }
        }
    }

    public void startParser() throws IOException {
        this.start();
    }

    public void stopParser() {
        if (this.connectionHolder != null) {
            this.connectionHolder.closeConnection();
        }
    }

    public void run() {
        try {
            this.connectionHolder = this.locator.createConnectionHolder();
            this.parse();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected abstract void parse();

    protected void addMetadataItem(String tag, Object value) {
        this.metadata.put(tag, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void done() {
        List<WeakReference<MetadataListener>> list = this.listeners;
        synchronized (list) {
            if (!this.metadata.isEmpty()) {
                ListIterator<WeakReference<MetadataListener>> it = this.listeners.listIterator();
                while (it.hasNext()) {
                    MetadataListener l = (MetadataListener)it.next().get();
                    if (l != null) {
                        l.onMetadata(this.metadata);
                        continue;
                    }
                    it.remove();
                }
            }
        }
    }

    protected int getStreamPosition() {
        if (this.parsingRawMetadata) {
            return this.rawMetaBlob.position();
        }
        return this.streamPosition;
    }

    protected void startRawMetadata(int sizeHint) {
        this.rawMetaBlob = ByteBuffer.allocate(sizeHint);
    }

    private void adjustRawMetadataSize(int addSize) {
        if (this.rawMetaBlob.remaining() < addSize) {
            int pos = this.rawMetaBlob.position();
            int newSize = pos + addSize;
            ByteBuffer newBuffer = ByteBuffer.allocate(newSize);
            this.rawMetaBlob.position(0);
            newBuffer.put(this.rawMetaBlob.array(), 0, pos);
            this.rawMetaBlob = newBuffer;
        }
    }

    protected void readRawMetadata(int size) throws IOException {
        byte[] data = this.getBytes(size);
        this.adjustRawMetadataSize(size);
        if (null != data) {
            this.rawMetaBlob.put(data);
        }
    }

    protected void stuffRawMetadata(byte[] data, int offset, int size) {
        if (null != this.rawMetaBlob) {
            this.adjustRawMetadataSize(size);
            this.rawMetaBlob.put(data, offset, size);
        }
    }

    protected void disposeRawMetadata() {
        this.parsingRawMetadata = false;
        this.rawMetaBlob = null;
    }

    protected void setParseRawMetadata(boolean state) {
        if (null == this.rawMetaBlob) {
            this.parsingRawMetadata = false;
            return;
        }
        if (state) {
            this.rawMetaBlob.position(0);
        }
        this.parsingRawMetadata = state;
    }

    protected void addRawMetadata(String type) {
        if (null == this.rawMetaBlob) {
            return;
        }
        if (null == this.rawMetaMap) {
            this.rawMetaMap = new HashMap<String, ByteBuffer>();
            this.metadata.put("raw metadata", Collections.unmodifiableMap(this.rawMetaMap));
        }
        this.rawMetaMap.put(type, this.rawMetaBlob.asReadOnlyBuffer());
    }

    protected void skipBytes(int num) throws IOException, EOFException {
        if (this.parsingRawMetadata) {
            this.rawMetaBlob.position(this.rawMetaBlob.position() + num);
            return;
        }
        for (int i = 0; i < num; ++i) {
            this.getNextByte();
        }
    }

    protected byte getNextByte() throws IOException, EOFException {
        if (this.parsingRawMetadata) {
            return this.rawMetaBlob.get();
        }
        if (this.buffer == null) {
            this.buffer = this.connectionHolder.getBuffer();
            this.length = this.connectionHolder.readNextBlock();
        }
        if (this.index >= this.length) {
            this.length = this.connectionHolder.readNextBlock();
            if (this.length < 1) {
                throw new EOFException();
            }
            this.index = 0;
        }
        byte b = this.buffer.get(this.index);
        ++this.index;
        ++this.streamPosition;
        return b;
    }

    protected byte[] getBytes(int size) throws IOException, EOFException {
        byte[] bytes = new byte[size];
        if (this.parsingRawMetadata) {
            this.rawMetaBlob.get(bytes);
            return bytes;
        }
        for (int i = 0; i < size; ++i) {
            bytes[i] = this.getNextByte();
        }
        return bytes;
    }

    protected long getLong() throws IOException, EOFException {
        if (this.parsingRawMetadata) {
            return this.rawMetaBlob.getLong();
        }
        long value = 0L;
        value |= (long)(this.getNextByte() & 0xFF);
        value <<= 8;
        value |= (long)(this.getNextByte() & 0xFF);
        value <<= 8;
        value |= (long)(this.getNextByte() & 0xFF);
        value <<= 8;
        value |= (long)(this.getNextByte() & 0xFF);
        value <<= 8;
        value |= (long)(this.getNextByte() & 0xFF);
        value <<= 8;
        value |= (long)(this.getNextByte() & 0xFF);
        value <<= 8;
        value |= (long)(this.getNextByte() & 0xFF);
        value <<= 8;
        return value |= (long)(this.getNextByte() & 0xFF);
    }

    protected int getInteger() throws IOException, EOFException {
        if (this.parsingRawMetadata) {
            return this.rawMetaBlob.getInt();
        }
        int value = 0;
        value |= this.getNextByte() & 0xFF;
        value <<= 8;
        value |= this.getNextByte() & 0xFF;
        value <<= 8;
        value |= this.getNextByte() & 0xFF;
        value <<= 8;
        return value |= this.getNextByte() & 0xFF;
    }

    protected short getShort() throws IOException, EOFException {
        if (this.parsingRawMetadata) {
            return this.rawMetaBlob.getShort();
        }
        short value = 0;
        value = (short)(value | this.getNextByte() & 0xFF);
        value = (short)(value << 8);
        value = (short)(value | this.getNextByte() & 0xFF);
        return value;
    }

    protected double getDouble() throws IOException, EOFException {
        if (this.parsingRawMetadata) {
            return this.rawMetaBlob.getDouble();
        }
        double value = 0.0;
        long bits = this.getLong();
        value = Double.longBitsToDouble(bits);
        return value;
    }

    protected String getString(int length) throws IOException, EOFException {
        String value = "";
        byte[] bytes = this.getBytes(length);
        value = new String(bytes, 0, length);
        return value;
    }

    protected int getU24() throws IOException, EOFException {
        int value = 0;
        value |= this.getNextByte() & 0xFF;
        value <<= 8;
        value |= this.getNextByte() & 0xFF;
        value <<= 8;
        return value |= this.getNextByte() & 0xFF;
    }

    protected Object convertValue(String tag, Object value) {
        if (tag.equals("duration") && value instanceof Double) {
            Double v = (Double)value * 1000.0;
            return v.longValue();
        }
        if (tag.equals("duration") && value instanceof String) {
            String v = (String)value;
            return Long.valueOf(v.trim());
        }
        if (tag.equals("width") || tag.equals("height")) {
            Double v = (Double)value;
            return v.intValue();
        }
        if (tag.equals("framerate")) {
            return value;
        }
        if (tag.equals("videocodecid")) {
            int codecid = ((Double)value).intValue();
            if (codecid < this.FLV_VIDEO_CODEC_NAME.length) {
                return this.FLV_VIDEO_CODEC_NAME[codecid];
            }
            return null;
        }
        if (tag.equals("audiocodecid")) {
            return "MPEG 1 Audio";
        }
        if (tag.equals("creationdate")) {
            return ((String)value).trim();
        }
        if (tag.equals("track number") || tag.equals("disc number")) {
            String[] v = ((String)value).split("/");
            if (v.length == 2) {
                return Integer.valueOf(v[0].trim());
            }
        } else if (tag.equals("track count") || tag.equals("disc count")) {
            String[] tc = ((String)value).split("/");
            if (tc.length == 2) {
                return Integer.valueOf(tc[1].trim());
            }
        } else {
            if (tag.equals("album")) {
                return value;
            }
            if (tag.equals("artist")) {
                return value;
            }
            if (tag.equals("genre")) {
                return value;
            }
            if (tag.equals("title")) {
                return value;
            }
            if (tag.equals("album artist")) {
                return value;
            }
            if (tag.equals("comment")) {
                return value;
            }
            if (tag.equals("composer")) {
                return value;
            }
            if (tag.equals("year")) {
                String v = (String)value;
                return Integer.valueOf(v.trim());
            }
        }
        return null;
    }
}

