/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.jnlp.ApiDialog;
import com.sun.jnlp.CheckServicePermission;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.jnlp.PrintService;

public final class PrintServiceImpl
implements PrintService {
    private static PrintServiceImpl _sharedInstance = null;
    private static ApiDialog _apiDialog = new ApiDialog();
    private PageFormat _pageFormat = null;

    private PrintServiceImpl() {
    }

    public static synchronized PrintServiceImpl getInstance() {
        if (_sharedInstance == null) {
            _sharedInstance = new PrintServiceImpl();
        }
        return _sharedInstance;
    }

    public PageFormat getDefaultPage() {
        return (PageFormat)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                PrinterJob printerJob = PrinterJob.getPrinterJob();
                if (printerJob != null) {
                    return printerJob.defaultPage();
                }
                return null;
            }
        });
    }

    public PageFormat showPageFormatDialog(final PageFormat pageFormat) {
        return (PageFormat)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                PrinterJob printerJob = PrinterJob.getPrinterJob();
                if (printerJob != null) {
                    PrintServiceImpl.this._pageFormat = printerJob.pageDialog(pageFormat);
                    return PrintServiceImpl.this._pageFormat;
                }
                return null;
            }
        });
    }

    public synchronized boolean print(Pageable pageable) {
        return this.doPrinting(null, pageable);
    }

    public synchronized boolean print(Printable printable) {
        return this.doPrinting(printable, null);
    }

    private boolean doPrinting(final Printable printable, final Pageable pageable) {
        if (!this.askUser()) {
            return false;
        }
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                final PrinterJob printerJob = PrinterJob.getPrinterJob();
                if (printerJob == null) {
                    return Boolean.FALSE;
                }
                if (pageable != null) {
                    printerJob.setPageable(pageable);
                } else if (PrintServiceImpl.this._pageFormat == null) {
                    printerJob.setPrintable(printable);
                } else {
                    printerJob.setPrintable(printable, PrintServiceImpl.this._pageFormat);
                }
                if (printerJob.printDialog()) {
                    Thread thread = new Thread(new Runnable(){

                        public void run() {
                            try {
                                printerJob.print();
                            }
                            catch (PrinterException printerException) {
                                Trace.ignoredException((Exception)printerException);
                            }
                        }
                    });
                    thread.start();
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        return bl;
    }

    private synchronized boolean askUser() {
        if (CheckServicePermission.hasPrintAccessPermissions()) {
            return true;
        }
        return PrintServiceImpl.requestPrintPermission();
    }

    public static boolean requestPrintPermission() {
        return _apiDialog.askUser(ResourceManager.getString((String)"api.print.title"), ResourceManager.getString((String)"api.print.message"), ResourceManager.getString((String)"api.print.always"));
    }
}

