/*
 * Decompiled with CFR 0.152.
 */
package com.zk.util;

import com.zk.conn.Conn;
import com.zk.util.BaseDBBackupUtil;
import com.zk.util.CheckProperties;
import com.zk.util.CompareSnAndAuthNumber;
import com.zk.util.ConfigFile;
import com.zk.util.ConstUtil;
import com.zk.util.DBOPUtil;
import com.zk.util.DateFormatUtil;
import com.zk.util.LicenseUtil;
import com.zk.util.MJTextField;
import com.zk.util.OperateBat;
import com.zk.util.ProgressBarRestore;
import com.zk.util.QuickLink;
import com.zk.util.ReplaceChar;
import com.zk.util.UpdateXml;
import com.zk.util.WebUrlRequestBuilder;
import com.zk.view.ActivationJFrame;
import com.zk.view.ConfigDBBackPathJFrame;
import com.zk.view.ConfigDBJFrame;
import com.zk.view.ConfigServerPortJFrame;
import com.zk.view.RestoreDBJFrame;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.URLConnection;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.xvolks.jnative.exceptions.NativeException;

public class NewActionListener
implements ActionListener {
    private static ResourceBundle res = null;
    private String flag = "";
    private JFrame frame = null;
    private JButton jClose = null;
    private JFileChooser fc = null;
    private JTextField txtfile = null;
    private JButton btnSelect = null;
    private MenuItem menuitem = null;
    private String myCopy = "";
    private String myPaste = "";
    private String myCut = "";
    protected static String dbBackupTxtFile = null;
    protected static int RESTOREDB_STATE_OK = 1;
    protected static int RESTOREDB_STATE_HIGH = 2;
    protected static int RESTOREDB_STATE_LOW = 3;
    private static final int COMPANY_NAME_MAXLENGTH = 50;
    private static final int SN_NAME_MAXLENGTH = 53;
    private static final String FORM_IMAGE_PATH = "..//Image//pubMark//favicon.ico";
    private static String currLanguage = ConfigFile.getValue(0, "options", "language");
    private static String FONT_STYLE = "Serif";

    static {
        if ("zh_CN".equals(currLanguage) || "zh_TW".equals(currLanguage)) {
            FONT_STYLE = "\u5b8b\u4f53";
        }
    }

    public NewActionListener(ResourceBundle res, MenuItem menuitem) {
        NewActionListener.res = res;
        this.menuitem = menuitem;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.flag = this.menuitem.getName();
        this.myCopy = res.getString("popupmenu.copy");
        this.myPaste = res.getString("popupmenu.paste");
        this.myCut = res.getString("popupmenu.cut");
        String path = "tomcat6\\webapps\\ROOT\\WEB-INF\\classes\\init.properties";
        if (this.flag.equalsIgnoreCase("configWebPort")) {
            try {
                this.frame.getName();
                this.frame.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.frame = new ConfigServerPortJFrame(res.getString("menu.webport"), FORM_IMAGE_PATH);
            this.frame.setLayout(null);
            JPanel panel1 = new JPanel();
            JPanel panel2 = new JPanel();
            panel1.setLayout(null);
            panel1.setBounds(30, 10, 389, 150);
            TitledBorder panel1Border = new TitledBorder(res.getString("frame1.title"));
            panel1Border.setTitleFont(new Font(FONT_STYLE, 1, 12));
            panel1.setBorder(panel1Border);
            panel2.setLayout(null);
            panel2.setBounds(30, 156, 389, 50);
            String checkFirePort = ConfigFile.getValue(0, "options", "checkFirePort");
            JLabel labport = new JLabel(res.getString("frame1.webport"));
            final JTextField port = new JTextField(10);
            port.setText(ConfigFile.getValue(0, "Options", "Port"));
            JButton textPort = new JButton(res.getString("frame1.textport"));
            final JCheckBox chport = new JCheckBox();
            chport.setSelected(checkFirePort.equals("1"));
            JLabel labche = new JLabel(res.getString("frame1.labche"));
            final JButton jSave = new JButton(res.getString("frame1.save"));
            this.jClose = new JButton(res.getString("frame1.close"));
            jSave.setEnabled(false);
            port.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                    char c = e.getKeyChar();
                    if (Character.isDigit(c) || c == '\b' || c == '\u007f') {
                        return;
                    }
                    e.consume();
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.isControlDown() || e.isAltDown() || e.isShiftDown()) {
                        e.consume();
                    } else if (e.getKeyChar() >= '0' && e.getKeyChar() <= '9' || e.getKeyCode() == 8) {
                        jSave.setEnabled(false);
                    }
                }
            });
            textPort.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    block14: {
                        ServerSocket sock = null;
                        if (port.getText().length() > 5) {
                            JOptionPane.showMessageDialog(NewActionListener.this.frame, res.getString("frame1.dialog5.content"), res.getString("frame1.dialog1.title"), 2);
                            return;
                        }
                        int newPort = Integer.parseInt(port.getText());
                        if (newPort < 10 || newPort > 65535 || newPort == 17777 || newPort == 80 || newPort == 21) {
                            JOptionPane.showMessageDialog(NewActionListener.this.frame, res.getString("frame1.dialog5.content"), res.getString("frame1.dialog1.title"), 2);
                            return;
                        }
                        try {
                            try {
                                sock = new ServerSocket(newPort);
                                JOptionPane.showMessageDialog(NewActionListener.this.frame, res.getString("frame1.dialog1.content"), res.getString("frame1.dialog1.title"), 2);
                                jSave.setEnabled(true);
                            }
                            catch (IOException e1) {
                                JOptionPane.showMessageDialog(NewActionListener.this.frame, res.getString("frame1.dialog2.content"), res.getString("frame1.dialog1.title"), 2);
                                if (sock == null) break block14;
                                try {
                                    sock.close();
                                }
                                catch (IOException e12) {
                                    e12.printStackTrace();
                                }
                            }
                        }
                        finally {
                            if (sock != null) {
                                try {
                                    sock.close();
                                }
                                catch (IOException e1) {
                                    e1.printStackTrace();
                                }
                            }
                        }
                    }
                }
            });
            jSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String urlStr = "";
                    ConfigFile.setValue(0, "Options", "port_old", ConfigFile.getValue(0, "Options", "port"));
                    ConfigFile.setValue(0, "Options", "Port", port.getText());
                    CheckProperties.updateValue("tomcat6\\webapps\\ROOT\\WEB-INF\\classes\\init.properties");
                    UpdateXml.xmlUpdateDemo(port.getText());
                    QuickLink ql = new QuickLink(ConfigFile.getValue(0, "Options", "destTop_path"));
                    ql.createShortCut(port.getText(), ConfigFile.getValue(0, "Options", "install_path"));
                    String startMenu = ConfigFile.getValue(0, "Options", "start_menu_path");
                    QuickLink startMenuTop = new QuickLink(String.valueOf(startMenu) + "\\" + startMenu.substring(startMenu.lastIndexOf("\\"), startMenu.length()));
                    startMenuTop.createStartMenu(port.getText(), ConfigFile.getValue(0, "Options", "install_path"));
                    urlStr = "tomcat6/bin/stopserver.bat";
                    NewActionListener.ExecBat(urlStr);
                    urlStr = "tomcat6/bin/startserver.bat";
                    NewActionListener.ExecBat(urlStr);
                    NewActionListener.ExecBat("..//Config//delete_fire_port.bat");
                    ConfigFile.setValue(0, "Options", "checkFirePort", "0");
                    if (chport.isSelected()) {
                        OperateBat.WriteBat("open_fire_port.bat", port.getText());
                        OperateBat.WriteBat("delete_fire_port.bat", port.getText());
                        NewActionListener.ExecBat("..//Config//open_fire_port.bat");
                        ConfigFile.setValue(0, "Options", "checkFirePort", "1");
                    }
                    jSave.setEnabled(false);
                    JOptionPane.showMessageDialog(null, res.getString("frame1.dialog3.content"));
                }
            });
            this.jClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NewActionListener.this.frame.dispose();
                }
            });
            labport.setBounds(50, 40, 100, 20);
            port.setBounds(110, 40, 100, 20);
            textPort.setBounds(220, 40, 100, 20);
            chport.setBounds(50, 90, 20, 20);
            labche.setBounds(70, 90, 200, 20);
            jSave.setBounds(50, 14, 100, 20);
            this.jClose.setBounds(220, 14, 100, 20);
            panel1.add(labport);
            panel1.add(port);
            panel1.add(textPort);
            panel1.add(chport);
            panel1.add(labche);
            panel2.add(jSave);
            panel2.add(this.jClose);
            this.frame.add(panel1);
            this.frame.add(panel2);
            this.frame.setVisible(true);
        } else if (this.flag.equalsIgnoreCase("configDB")) {
            try {
                this.frame.getName();
                this.frame.dispose();
            }
            catch (Exception panel1) {
                // empty catch block
            }
            this.frame = new ConfigDBJFrame(res.getString("menu.configDB"), FORM_IMAGE_PATH);
            this.frame.setLayout(null);
            String dbstr = ConfigFile.getValue(0, "options", "dbtype");
            JPanel panel1 = new JPanel(new GridLayout(6, 2));
            JPanel panel2 = new JPanel(new GridLayout(1, 3));
            panel1.setLayout(null);
            panel1.setBounds(30, 10, 389, 190);
            TitledBorder panel1Border = new TitledBorder(res.getString("frame2.title"));
            panel1Border.setTitleFont(new Font(FONT_STYLE, 1, 12));
            panel1.setBorder(panel1Border);
            panel2.setLayout(null);
            panel2.setBounds(30, 190, 389, 50);
            JLabel labDBType = new JLabel(res.getString("frame2.labdbtype"));
            final JLabel labDBName = new JLabel();
            if (dbstr.equalsIgnoreCase("oracle")) {
                labDBName.setText(res.getString("frame2.labInstanceName"));
            } else {
                labDBName.setText(res.getString("frame2.labdbname"));
            }
            JLabel labUserName = new JLabel(res.getString("frame2.labusername"));
            JLabel labPassword = new JLabel(res.getString("frame2.labpwd"));
            JLabel labHost = new JLabel(res.getString("frame2.labhost"));
            JLabel labPort = new JLabel(res.getString("frame2.labport"));
            final JComboBox<String> chebox = new JComboBox<String>();
            final MJTextField texDBName = new MJTextField(this.myCopy, this.myPaste, this.myCut);
            final MJTextField texUserName = new MJTextField(this.myCopy, this.myPaste, this.myCut);
            final JPasswordField texPassword = new JPasswordField(20);
            final JTextField texHost = new JTextField(20);
            final JTextField texPort = new JTextField(20);
            chebox.addItem("mysql");
            chebox.addItem("sqlserver");
            chebox.addItem("oracle");
            int selIndex = dbstr.equalsIgnoreCase("mysql") ? 0 : (dbstr.equalsIgnoreCase("sqlserver") ? 1 : 2);
            chebox.setSelectedIndex(selIndex);
            texDBName.setText(ConfigFile.getValue(0, "database_" + dbstr, "name"));
            texUserName.setText(ConfigFile.getValue(0, "database_" + dbstr, "user"));
            texPassword.setText(ConfigFile.getValue(0, "database_" + dbstr, "password"));
            texHost.setText(ConfigFile.getValue(0, "database_" + dbstr, "host"));
            texPort.setText(ConfigFile.getValue(0, "database_" + dbstr, "port"));
            JButton testConn = new JButton(res.getString("frame2.testconn"));
            final JButton jSave = new JButton(res.getString("frame1.save"));
            jSave.setEnabled(false);
            this.jClose = new JButton(res.getString("frame1.close"));
            texDBName.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                    jSave.setEnabled(false);
                }
            });
            texUserName.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                    jSave.setEnabled(false);
                }
            });
            texPassword.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                    jSave.setEnabled(false);
                }
            });
            texHost.addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.isControlDown() || e.isAltDown() || e.isShiftDown()) {
                        e.consume();
                    } else if (e.getKeyChar() >= '0' && e.getKeyChar() <= '9' || e.getKeyCode() == 46 || e.getKeyCode() == 110 || e.getKeyCode() == 8) {
                        jSave.setEnabled(false);
                    }
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }

                @Override
                public void keyTyped(KeyEvent e) {
                    char keyChar = e.getKeyChar();
                    if ((keyChar < '0' || keyChar > '9') && keyChar != '.') {
                        e.consume();
                    }
                    if (texHost.getText().length() > 14) {
                        e.consume();
                    }
                }
            });
            texPort.addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.isControlDown() || e.isAltDown() || e.isShiftDown()) {
                        e.consume();
                    }
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }

                @Override
                public void keyTyped(KeyEvent e) {
                    char keyChar = e.getKeyChar();
                    if (keyChar >= '0' && keyChar <= '9' || keyChar == '\b') {
                        jSave.setEnabled(false);
                    } else {
                        e.consume();
                    }
                    if (texPort.getText().length() > 4) {
                        e.consume();
                    }
                }
            });
            chebox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int index = chebox.getSelectedIndex();
                    String selStr = "";
                    switch (index) {
                        case 1: {
                            selStr = "database_sqlserver";
                            break;
                        }
                        case 2: {
                            selStr = "database_oracle";
                            break;
                        }
                        default: {
                            selStr = "database_mysql";
                        }
                    }
                    if (selStr.indexOf("oracle") > 0) {
                        labDBName.setText(res.getString("frame2.labInstanceName"));
                    } else {
                        labDBName.setText(res.getString("frame2.labdbname"));
                    }
                    texDBName.setText(ConfigFile.getValue(0, selStr, "name"));
                    texUserName.setText(ConfigFile.getValue(0, selStr, "user"));
                    texPassword.setText(ConfigFile.getValue(0, selStr, "password"));
                    texHost.setText(ConfigFile.getValue(0, selStr, "host"));
                    texPort.setText(ConfigFile.getValue(0, selStr, "port"));
                    jSave.setEnabled(false);
                }
            });
            testConn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String dbType = chebox.getSelectedItem().toString();
                    String urlStr = "";
                    if (texDBName.getText().equals("") || texUserName.getText().equals("") || texPassword.getText().equals("") || texHost.getText().equals("") || texPort.getText().equals("")) {
                        JOptionPane.showMessageDialog(null, res.getString("frame2.dialog3.content"));
                        jSave.setEnabled(false);
                        return;
                    }
                    if (dbType.equals("mysql")) {
                        urlStr = "jdbc:mysql://" + texHost.getText() + ":" + texPort.getText() + "/" + texDBName.getText() + "," + texUserName.getText() + "," + texPassword.getText();
                    } else if (dbType.equals("sqlserver")) {
                        urlStr = "jdbc:sqlserver://" + texHost.getText() + ":" + texPort.getText() + ";DatabaseName=" + texDBName.getText() + "," + texUserName.getText() + "," + texPassword.getText();
                    } else if (dbType.equals("oracle")) {
                        urlStr = "jdbc:oracle:thin:@" + texHost.getText() + ":" + texPort.getText() + ":" + texDBName.getText() + "," + texUserName.getText() + "," + texPassword.getText();
                    }
                    Conn conn = new Conn(dbType);
                    Conn.getConn("1", urlStr);
                    boolean flag = Conn.getStatus();
                    if (flag) {
                        JOptionPane.showMessageDialog(null, res.getString("frame2.dialog1.content"));
                        jSave.setEnabled(true);
                    } else {
                        JOptionPane.showMessageDialog(null, res.getString("frame2.dialog2.content"), res.getString("frame1.dialog1.title"), 0);
                        jSave.setEnabled(false);
                    }
                    Conn.close();
                }
            });
            jSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String urlStr = "tomcat6//bin//stopserver.bat";
                    if (NewActionListener.ExecBat(urlStr) != "error") {
                        String temp = chebox.getSelectedItem().toString();
                        String dbType = temp == "mysql" ? "database_mysql" : (temp == "oracle" ? "database_oracle" : "database_sqlserver");
                        CheckProperties.updateDB("tomcat6\\webapps\\ROOT\\WEB-INF\\classes\\init.properties", dbType, texHost.getText(), texDBName.getText(), texPort.getText(), texUserName.getText(), texPassword.getText());
                        ConfigFile.setValue(0, dbType, "engine", temp);
                        ConfigFile.setValue(0, dbType, "name", texDBName.getText());
                        ConfigFile.setValue(0, dbType, "user", texUserName.getText());
                        ConfigFile.setValue(0, dbType, "password", texPassword.getText());
                        ConfigFile.setValue(0, dbType, "host", texHost.getText());
                        ConfigFile.setValue(0, dbType, "port", texPort.getText());
                        ConfigFile.setValue(0, "options", "dbtype", temp);
                        urlStr = "tomcat6//bin//startserver.bat";
                        if (NewActionListener.ExecBat(urlStr) != "error") {
                            JOptionPane.showMessageDialog(null, res.getString("frame1.dialog3.content"));
                        } else {
                            JOptionPane.showMessageDialog(null, res.getString("frame1.dialog4.content"));
                        }
                    } else {
                        JOptionPane.showMessageDialog(null, res.getString("frame1.dialog4.content"));
                    }
                    jSave.setEnabled(false);
                }
            });
            this.jClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NewActionListener.this.frame.dispose();
                }
            });
            labDBType.setBounds(50, 20, 100, 20);
            chebox.setBounds(190, 20, 150, 20);
            labDBName.setBounds(50, 48, 100, 20);
            texDBName.setBounds(190, 48, 150, 20);
            labUserName.setBounds(50, 76, 100, 20);
            texUserName.setBounds(190, 76, 150, 20);
            labPassword.setBounds(50, 104, 100, 20);
            texPassword.setBounds(190, 104, 150, 20);
            labHost.setBounds(50, 132, 100, 20);
            texHost.setBounds(190, 132, 150, 20);
            labPort.setBounds(50, 160, 100, 20);
            texPort.setBounds(190, 160, 150, 20);
            testConn.setBounds(20, 14, 130, 20);
            jSave.setBounds(160, 14, 100, 20);
            this.jClose.setBounds(270, 14, 100, 20);
            panel1.add(labDBType);
            panel1.add(chebox);
            panel1.add(labDBName);
            panel1.add(texDBName);
            panel1.add(labUserName);
            panel1.add(texUserName);
            panel1.add(labPassword);
            panel1.add(texPassword);
            panel1.add(labHost);
            panel1.add(texHost);
            panel1.add(labPort);
            panel1.add(texPort);
            panel2.add(testConn);
            panel2.add(jSave);
            panel2.add(this.jClose);
            this.frame.add(panel1);
            this.frame.add(panel2);
            this.frame.setVisible(true);
        } else if (this.flag.equalsIgnoreCase("backDB")) {
            try {
                this.frame.getName();
                this.frame.dispose();
            }
            catch (Exception dbstr) {
                // empty catch block
            }
            this.frame = new ConfigDBBackPathJFrame(res.getString("menu.backDB"), FORM_IMAGE_PATH);
            this.frame.setLayout(null);
            JPanel panel1 = new JPanel();
            JPanel panel2 = new JPanel();
            panel1.setLayout(null);
            panel1.setBounds(30, 10, 389, 160);
            TitledBorder panel1Border = new TitledBorder(res.getString("frame3.title"));
            panel1Border.setTitleFont(new Font(FONT_STYLE, 1, 12));
            panel1.setBorder(panel1Border);
            panel2.setLayout(null);
            panel2.setBounds(30, 160, 389, 50);
            JLabel labTitle = new JLabel(res.getString("frame3.labtitle"));
            String tex = res.getString("frame3.texare");
            tex = ReplaceChar.replace(tex, "ss", "\r\n");
            JTextArea texare = new JTextArea(tex);
            texare.setEditable(false);
            this.fc = new JFileChooser();
            this.txtfile = new JTextField(20);
            this.txtfile.setColumns(14);
            this.txtfile.setEnabled(false);
            this.btnSelect = new JButton(res.getString("frame3.btnselect"));
            this.txtfile.setText(ConfigFile.getValue(0, "options", "backup_path"));
            this.btnSelect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == NewActionListener.this.btnSelect) {
                        NewActionListener.this.fc.setFileSelectionMode(1);
                        int intRetVal = NewActionListener.this.fc.showSaveDialog(NewActionListener.this.frame);
                        if (intRetVal == 0) {
                            NewActionListener.this.txtfile.setText(NewActionListener.this.fc.getSelectedFile().getPath());
                        }
                    }
                }
            });
            JButton jSave = new JButton(res.getString("frame1.save"));
            this.jClose = new JButton(res.getString("frame1.close"));
            jSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (NewActionListener.this.txtfile.getText().length() < 1) {
                        JOptionPane.showMessageDialog(null, res.getString("frame3.dialog1.content"));
                    } else {
                        File file = new File(NewActionListener.this.txtfile.getText());
                        if (file.exists()) {
                            ConfigFile.setValue(0, "options", "backup_path", NewActionListener.this.txtfile.getText());
                            JOptionPane.showMessageDialog(null, res.getString("frame1.dialog3.content"));
                        } else {
                            JOptionPane.showMessageDialog(null, res.getString("frame3.dialog1.content"));
                        }
                    }
                }
            });
            this.jClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NewActionListener.this.frame.dispose();
                }
            });
            labTitle.setBounds(20, 20, 200, 20);
            this.txtfile.setBounds(20, 45, 230, 20);
            this.btnSelect.setBounds(260, 45, 100, 20);
            texare.setBounds(20, 70, 350, 80);
            jSave.setBounds(70, 18, 100, 20);
            this.jClose.setBounds(210, 18, 100, 20);
            panel1.add(labTitle);
            panel1.add(this.txtfile);
            panel1.add(this.btnSelect);
            panel1.add(texare);
            panel2.add(jSave);
            panel2.add(this.jClose);
            this.frame.add(panel1);
            this.frame.add(panel2);
            this.frame.setVisible(true);
        } else if (this.flag.equalsIgnoreCase("startServer") || this.flag.equalsIgnoreCase("stopServer")) {
            String operateTime = ConfigFile.getValue(0, "options", "operate_time");
            String tempStartTime = operateTime.equals("0") ? DateFormatUtil.getCurrentTime() : operateTime;
            long startT = DateFormatUtil.fromDateStringToLong(tempStartTime);
            long endT = DateFormatUtil.fromDateStringToLong(DateFormatUtil.getCurrentTime());
            long ss = (endT - startT) / 1000L;
            long temp = 0L;
            if (this.flag.trim().equalsIgnoreCase("startServer")) {
                if (operateTime.equals("0") || ss >= 15L) {
                    String urlStr = "";
                    urlStr = "tomcat6//bin//startserver.bat";
                    if (NewActionListener.ExecBat(urlStr) != "error") {
                        this.menuitem.setLabel(res.getString("menu.stopServer"));
                        this.menuitem.setName("stopServer");
                        JOptionPane.showMessageDialog(null, res.getString("frame1.dialog3.content"));
                    } else {
                        JOptionPane.showMessageDialog(null, res.getString("frame1.dialog4.content"));
                    }
                    ConfigFile.setValue(0, "options", "operate_time", DateFormatUtil.getCurrentTime());
                } else if (ss < 0L) {
                    String dialogStr = res.getString("frame1.dialog6.content");
                    ConfigFile.setValue(0, "options", "operate_time", DateFormatUtil.getCurrentTime());
                    JOptionPane.showMessageDialog(null, ReplaceChar.replace(dialogStr, "ss", "15"));
                } else {
                    temp = 15L - ss;
                    String dialogStr = res.getString("frame1.dialog6.content");
                    JOptionPane.showMessageDialog(null, ReplaceChar.replace(dialogStr, "ss", String.valueOf(temp)));
                }
            } else if (this.flag.trim().equalsIgnoreCase("stopServer")) {
                if (operateTime.equals("0") || ss >= 20L) {
                    String urlStr = "";
                    urlStr = "tomcat6//bin//stopserver.bat";
                    if (NewActionListener.ExecBat(urlStr) != "error") {
                        this.menuitem.setLabel(res.getString("menu.startServer"));
                        this.menuitem.setName("startServer");
                        JOptionPane.showMessageDialog(null, res.getString("frame1.dialog3.content"));
                    } else {
                        JOptionPane.showMessageDialog(null, res.getString("frame1.dialog4.content"));
                    }
                    ConfigFile.setValue(0, "options", "operate_time", DateFormatUtil.getCurrentTime());
                } else if (ss < 0L) {
                    String dialogStr = res.getString("frame1.dialog6.content");
                    ConfigFile.setValue(0, "options", "operate_time", DateFormatUtil.getCurrentTime());
                    JOptionPane.showMessageDialog(null, ReplaceChar.replace(dialogStr, "ss", "20"));
                } else {
                    temp = 20L - ss;
                    String dialogStr = res.getString("frame1.dialog6.content");
                    JOptionPane.showMessageDialog(null, ReplaceChar.replace(dialogStr, "ss", String.valueOf(temp)));
                }
            }
        } else if (this.flag.equalsIgnoreCase("restoreDB")) {
            try {
                this.frame.getName();
                this.frame.dispose();
            }
            catch (Exception operateTime) {
                // empty catch block
            }
            this.frame = new RestoreDBJFrame(res.getString("menu.rebuildDB"), FORM_IMAGE_PATH);
            this.frame.setLayout(null);
            JPanel restoreInfoPanel = new JPanel();
            JPanel operatePanel = new JPanel();
            restoreInfoPanel.setLayout(null);
            operatePanel.setLayout(null);
            TitledBorder activateLicBorder = new TitledBorder(res.getString("menu.rebuildDB"));
            activateLicBorder.setTitleFont(new Font(FONT_STYLE, 1, 12));
            restoreInfoPanel.setBorder(activateLicBorder);
            restoreInfoPanel.setBounds(10, 10, 425, 254);
            operatePanel.setBounds(10, 260, 425, 40);
            final ProgressBarRestore newContentPane = new ProgressBarRestore(res.getString("frame4.update"));
            JButton startButton = newContentPane.getStartButton();
            JProgressBar progressBar = newContentPane.getProgressBar();
            JTextArea taskOutput = newContentPane.getTaskOutput();
            newContentPane.setRes(res);
            BaseDBBackupUtil.PATH_NOT_FIND_TIP = res.getString("frame4.dailog6.content");
            newContentPane.setOpaque(true);
            JLabel pname = new JLabel(res.getString("frame4.pname"));
            this.fc = new JFileChooser();
            this.txtfile = new JTextField(24);
            this.txtfile.setEditable(false);
            this.btnSelect = new JButton(res.getString("frame3.btnselect"));
            this.btnSelect.setPreferredSize(new Dimension(90, 25));
            this.btnSelect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int intRetVal;
                    if (newContentPane.isRestore() && e.getSource() == NewActionListener.this.btnSelect && (intRetVal = NewActionListener.this.fc.showSaveDialog(NewActionListener.this.frame)) == 0) {
                        NewActionListener.this.txtfile.setText(NewActionListener.this.fc.getSelectedFile().getPath());
                        dbBackupTxtFile = NewActionListener.this.fc.getSelectedFile().getPath();
                    }
                }
            });
            this.jClose = new JButton(res.getString("frame1.close"));
            this.jClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (newContentPane.isRestore()) {
                        dbBackupTxtFile = "";
                        NewActionListener.this.frame.dispose();
                    }
                }
            });
            JScrollPane jsp = new JScrollPane(taskOutput, 20, 31);
            pname.setBounds(12, 18, 401, 20);
            this.txtfile.setBounds(12, 45, 295, 20);
            this.btnSelect.setBounds(313, 45, 100, 20);
            progressBar.setBounds(12, 75, 401, 20);
            jsp.setBounds(12, 100, 401, 140);
            restoreInfoPanel.add(pname);
            restoreInfoPanel.add(this.txtfile);
            restoreInfoPanel.add(this.btnSelect);
            restoreInfoPanel.add(progressBar);
            restoreInfoPanel.add(jsp);
            restoreInfoPanel.setVisible(true);
            startButton.setBounds(67, 10, 100, 20);
            this.jClose.setBounds(257, 10, 100, 20);
            operatePanel.add(startButton);
            operatePanel.add(this.jClose);
            operatePanel.setVisible(true);
            this.frame.add(restoreInfoPanel);
            this.frame.add(operatePanel);
            this.frame.setSize(450, 340);
            this.frame.setVisible(true);
        } else if (this.flag.equalsIgnoreCase("activation")) {
            try {
                this.frame.getName();
                this.frame.dispose();
            }
            catch (Exception restoreInfoPanel) {
                // empty catch block
            }
            this.frame = new ActivationJFrame(res.getString("menu.activation"), FORM_IMAGE_PATH);
            this.frame.setLayout(null);
            JPanel activateLicInfoPanel = new JPanel();
            JPanel buttonPanel = new JPanel();
            JPanel modelLicInfoPanel = new JPanel();
            activateLicInfoPanel.setLayout(null);
            buttonPanel.setLayout(null);
            modelLicInfoPanel.setLayout(null);
            activateLicInfoPanel.setBounds(10, 10, 425, 254);
            TitledBorder activateLicBorder = new TitledBorder(res.getString("frame1.activationLic"));
            activateLicBorder.setTitleFont(new Font(FONT_STYLE, 1, 12));
            activateLicInfoPanel.setBorder(activateLicBorder);
            buttonPanel.setBounds(10, 264, 425, 23);
            modelLicInfoPanel.setBounds(10, 287, 425, 88);
            TitledBorder modelLicBorder = new TitledBorder(res.getString("frame1.modelLic"));
            modelLicBorder.setTitleFont(new Font(FONT_STYLE, 1, 12));
            modelLicInfoPanel.setBorder(modelLicBorder);
            JLabel companyNameLab = new JLabel(res.getString("frame5.companyNameText"));
            final MJTextField companyNameText = new MJTextField(this.myCopy, this.myPaste, this.myCut);
            JLabel modelLab = new JLabel(res.getString("frame5.model"));
            final JComboBox<String> modelBox = new JComboBox<String>();
            String onlineNote = res.getString("frame5.onlineNote");
            onlineNote = ReplaceChar.replace(onlineNote, "{0}", "\r\n");
            final JLabel onlineLab = new JLabel(onlineNote);
            final MJTextField snText = new MJTextField(this.myCopy, this.myPaste, this.myCut);
            final JRadioButton onlineButton = new JRadioButton(res.getString("frame5.onlineActivate"));
            onlineButton.setSelected(true);
            final JRadioButton fileButton = new JRadioButton(res.getString("frame5.fileActivate"));
            JRadioButton phoneButton = new JRadioButton(res.getString("frame5.phoneActivate"));
            ButtonGroup buttonGroup = new ButtonGroup();
            final JLabel upkLab = new JLabel(res.getString("frame5.upk"));
            final JTextField upkText = new JTextField();
            final JLabel fileLabel = new JLabel(res.getString("frame1.activateFile"));
            fileLabel.setVisible(false);
            final JTextField filePath = new JTextField();
            this.fc = new JFileChooser();
            this.btnSelect = new JButton(res.getString("frame3.btnselect"));
            final JLabel activateLab = new JLabel(res.getString("frame5.authorization"));
            final JTextField activateText = new JTextField();
            JButton activateButton = new JButton(res.getString("menu.activation"));
            JButton closeButton = new JButton(res.getString("frame1.close"));
            final JLabel accLicInfo = new JLabel();
            final JLabel vidLicInfo = new JLabel();
            final JLabel eleLicInfo = new JLabel();
            final JLabel visLicInfo = new JLabel();
            final JLabel accadvancedLicInfo = new JLabel();
            NewActionListener.setLabelText(accLicInfo, vidLicInfo, eleLicInfo, visLicInfo, accadvancedLicInfo);
            upkText.setEditable(false);
            upkText.setBackground(Color.white);
            buttonGroup.add(onlineButton);
            buttonGroup.add(fileButton);
            buttonGroup.add(phoneButton);
            modelBox.setBackground(Color.white);
            modelBox.addItem(res.getString("frame5.acc"));
            modelBox.addItem(res.getString("frame5.vid"));
            modelBox.addItem(res.getString("frame5.ele"));
            modelBox.addItem(res.getString("frame5.vis"));
            modelBox.addItem(res.getString("frame5.park"));
            modelBox.addItem(res.getString("frame5.accAdvanced"));
            companyNameLab.setFont(new Font(FONT_STYLE, 0, 12));
            companyNameText.setFont(new Font(FONT_STYLE, 0, 12));
            modelLab.setFont(new Font(FONT_STYLE, 0, 12));
            onlineLab.setFont(new Font(FONT_STYLE, 0, 12));
            upkLab.setFont(new Font(FONT_STYLE, 0, 12));
            activateLab.setFont(new Font(FONT_STYLE, 0, 12));
            fileLabel.setFont(new Font(FONT_STYLE, 0, 12));
            activateButton.setFont(new Font(FONT_STYLE, 1, 12));
            closeButton.setFont(new Font(FONT_STYLE, 1, 12));
            accLicInfo.setFont(new Font(FONT_STYLE, 0, 12));
            vidLicInfo.setFont(new Font(FONT_STYLE, 0, 12));
            eleLicInfo.setFont(new Font(FONT_STYLE, 0, 12));
            visLicInfo.setFont(new Font(FONT_STYLE, 0, 12));
            accadvancedLicInfo.setFont(new Font(FONT_STYLE, 0, 12));
            companyNameText.setBorder(BorderFactory.createLineBorder(ConstUtil.INPUT_BORDER_COLOR));
            snText.setBorder(BorderFactory.createLineBorder(ConstUtil.INPUT_BORDER_COLOR));
            filePath.setBorder(BorderFactory.createLineBorder(ConstUtil.INPUT_BORDER_COLOR));
            upkText.setBorder(BorderFactory.createLineBorder(ConstUtil.INPUT_BORDER_COLOR));
            activateText.setBorder(BorderFactory.createLineBorder(ConstUtil.INPUT_BORDER_COLOR));
            int modelLabY = 0;
            String companyNameShow = ConfigFile.getValue(0, "company_name", "companyName_show");
            if ("true".equals(companyNameShow)) {
                this.frame.setSize(450, 421);
                companyNameLab.setBounds(12, 18, 401, 20);
                int companyNameTextY = ReplaceChar.sumCoord(18, 20, 3);
                companyNameText.setBounds(12, companyNameTextY, 401, 20);
                modelLabY = ReplaceChar.sumCoord(companyNameTextY, 20, 3);
                activateLicInfoPanel.add(companyNameLab);
                activateLicInfoPanel.add(companyNameText);
            } else {
                this.frame.setSize(450, 375);
                activateLicInfoPanel.setBounds(10, 10, 425, 208);
                buttonPanel.setBounds(10, 218, 425, 23);
                modelLicInfoPanel.setBounds(10, 241, 425, 88);
                modelLabY = 18;
            }
            modelLab.setBounds(12, modelLabY, 401, 20);
            int modelBoxY = ReplaceChar.sumCoord(modelLabY, 20, 3);
            modelBox.setBounds(12, modelBoxY, 401, 20);
            int snTextY = ReplaceChar.sumCoord(modelBoxY, 20, 3);
            snText.setBounds(12, snTextY, 401, 20);
            int radioButtonY = ReplaceChar.sumCoord(snTextY, 20, 3);
            onlineButton.setBounds(12, radioButtonY, 120, 20);
            int fileButtonX = ReplaceChar.sumCoord(12, 132, 5);
            fileButton.setBounds(fileButtonX, radioButtonY, 120, 20);
            int phoneButtonX = ReplaceChar.sumCoord(fileButtonX, 112, 5);
            phoneButton.setBounds(phoneButtonX, radioButtonY, 120, 20);
            int onlineLabY = ReplaceChar.sumCoord(radioButtonY, 20, 3);
            onlineLab.setBounds(12, onlineLabY, 401, 20);
            upkLab.setBounds(12, onlineLabY, 401, 20);
            int upkTextY = ReplaceChar.sumCoord(onlineLabY, 20, 3);
            upkText.setBounds(12, upkTextY, 401, 20);
            int activateLabY = ReplaceChar.sumCoord(upkTextY, 20, 3);
            activateLab.setBounds(12, activateLabY, 401, 20);
            fileLabel.setBounds(12, activateLabY, 401, 20);
            int activateTextY = ReplaceChar.sumCoord(activateLabY, 20, 3);
            activateText.setBounds(12, activateTextY, 401, 20);
            filePath.setBounds(12, activateTextY, 295, 20);
            int btnSelectX = ReplaceChar.sumCoord(12, 295, 5);
            this.btnSelect.setBounds(btnSelectX, activateTextY, 100, 20);
            activateButton.setBounds(95, 3, 100, 20);
            closeButton.setBounds(231, 3, 100, 20);
            vidLicInfo.setBounds(42, 18, 170, 20);
            eleLicInfo.setBounds(252, 18, 170, 20);
            accLicInfo.setBounds(42, 40, 170, 20);
            visLicInfo.setBounds(252, 40, 170, 20);
            accadvancedLicInfo.setBounds(42, 62, 270, 20);
            activateLicInfoPanel.add(modelLab);
            activateLicInfoPanel.add(modelBox);
            activateLicInfoPanel.add(snText);
            activateLicInfoPanel.add(onlineButton);
            activateLicInfoPanel.add(fileButton);
            activateLicInfoPanel.add(phoneButton);
            activateLicInfoPanel.add(onlineLab);
            activateLicInfoPanel.add(upkLab);
            activateLicInfoPanel.add(upkText);
            activateLicInfoPanel.add(activateLab);
            activateLicInfoPanel.add(activateText);
            activateLicInfoPanel.add(fileLabel);
            activateLicInfoPanel.add(filePath);
            activateLicInfoPanel.add(this.btnSelect);
            modelLicInfoPanel.add(accLicInfo);
            modelLicInfoPanel.add(eleLicInfo);
            modelLicInfoPanel.add(vidLicInfo);
            modelLicInfoPanel.add(visLicInfo);
            modelLicInfoPanel.add(accadvancedLicInfo);
            buttonPanel.add(activateButton);
            buttonPanel.add(closeButton);
            activateLicInfoPanel.setVisible(true);
            buttonPanel.setVisible(true);
            modelLicInfoPanel.setVisible(true);
            upkLab.setVisible(false);
            upkText.setVisible(false);
            activateLab.setVisible(false);
            activateText.setVisible(false);
            filePath.setVisible(false);
            this.btnSelect.setVisible(false);
            this.frame.add(activateLicInfoPanel);
            this.frame.add(buttonPanel);
            this.frame.add(modelLicInfoPanel);
            this.frame.setVisible(true);
            companyNameText.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                    if (companyNameText.getText().length() >= 50 && e.getKeyChar() != '\b') {
                        e.setKeyChar('\u0000');
                    }
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }
            });
            onlineButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    upkLab.setVisible(false);
                    upkText.setVisible(false);
                    activateLab.setVisible(false);
                    activateText.setVisible(false);
                    fileLabel.setVisible(false);
                    filePath.setVisible(false);
                    NewActionListener.this.btnSelect.setVisible(false);
                    onlineLab.setVisible(true);
                }
            });
            fileButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    activateLab.setVisible(false);
                    activateText.setVisible(false);
                    onlineLab.setVisible(false);
                    upkLab.setVisible(true);
                    upkText.setVisible(true);
                    fileLabel.setVisible(true);
                    filePath.setVisible(true);
                    NewActionListener.this.btnSelect.setVisible(true);
                }
            });
            phoneButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    upkLab.setVisible(true);
                    upkText.setVisible(true);
                    activateLab.setVisible(true);
                    activateText.setVisible(true);
                    fileLabel.setVisible(false);
                    NewActionListener.this.btnSelect.setVisible(false);
                    filePath.setVisible(false);
                    onlineLab.setVisible(false);
                }
            });
            snText.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    Document doc = e.getDocument();
                    try {
                        NewActionListener.snListnerEvent(new JTextField(doc.getText(0, doc.getLength())), modelBox, companyNameText, upkText);
                    }
                    catch (BadLocationException e1) {
                        e1.printStackTrace();
                    }
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    Document doc = e.getDocument();
                    try {
                        NewActionListener.snListnerEvent(new JTextField(doc.getText(0, doc.getLength())), modelBox, companyNameText, upkText);
                    }
                    catch (BadLocationException e1) {
                        e1.printStackTrace();
                    }
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    Document doc = e.getDocument();
                    try {
                        NewActionListener.snListnerEvent(new JTextField(doc.getText(0, doc.getLength())), modelBox, companyNameText, upkText);
                    }
                    catch (BadLocationException e1) {
                        e1.printStackTrace();
                    }
                }
            });
            snText.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                    if (snText.getText().length() >= 53 && e.getKeyChar() != '\b') {
                        e.setKeyChar('\u0000');
                    }
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }
            });
            this.btnSelect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int intRetVal;
                    if (e.getSource() == NewActionListener.this.btnSelect && (intRetVal = NewActionListener.this.fc.showSaveDialog(NewActionListener.this.frame)) == 0) {
                        filePath.setText(NewActionListener.this.fc.getSelectedFile().getPath());
                    }
                }
            });
            activateButton.addActionListener(new ActionListener(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        Map<String, Integer> retMap;
                        String snStr;
                        String authNumber;
                        block28: {
                            authNumber = "";
                            boolean contentVirify = ReplaceChar.snFormatVerify(snText.getText().trim());
                            if (!contentVirify) {
                                JOptionPane.showMessageDialog(null, res.getString("frame5.dialog10.content"));
                                return;
                            }
                            snStr = snText.getText().trim().replace("-", "");
                            String str = "";
                            if ("".equals(snStr)) {
                                JOptionPane.showMessageDialog(null, res.getString("frame5.dialog6.content"));
                                return;
                            }
                            if (onlineButton.isSelected()) {
                                String upkStr = upkText.getText();
                                if (!"".equals(upkStr)) {
                                    URLConnection webUrlRequest = WebUrlRequestBuilder.webUrlRequest(upkStr);
                                    try {
                                        authNumber = WebUrlRequestBuilder.readLine(webUrlRequest.getInputStream()).toArray()[0].toString();
                                    }
                                    catch (Exception e1) {
                                        authNumber = "";
                                    }
                                }
                            } else {
                                if (fileButton.isSelected()) {
                                    if (filePath.getText() != null && !"".equals(filePath.getText())) {
                                        BufferedReader bufferedReader = null;
                                        try {
                                            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath.getText()), "utf8"));
                                            StringBuffer stringBuffer = new StringBuffer();
                                            while (true) {
                                                if ((str = bufferedReader.readLine()) == null) {
                                                    authNumber = stringBuffer.toString();
                                                    break block28;
                                                }
                                                stringBuffer.append(str);
                                            }
                                        }
                                        finally {
                                            if (bufferedReader != null) {
                                                bufferedReader.close();
                                            }
                                        }
                                    }
                                    JOptionPane.showMessageDialog(null, res.getString("frame5.dialog5.content"));
                                    return;
                                }
                                authNumber = activateText.getText();
                            }
                        }
                        if ((retMap = DBOPUtil.getIdByCompanyName(companyNameText.getText())).get("connRet") == 0) {
                            JOptionPane.showMessageDialog(null, res.getString("frame5.dialog12.content"));
                            return;
                        }
                        Boolean compareRet = false;
                        if (authNumber.contains("-")) {
                            authNumber = authNumber.replace("-", "");
                        }
                        if (!"".equals(snStr) && ReplaceChar.authNumberFormatVerify(authNumber) && !upkText.getText().equals(authNumber)) {
                            compareRet = CompareSnAndAuthNumber.compareSnAndAuthNumber(snStr, authNumber);
                        }
                        if (!compareRet.booleanValue()) {
                            JOptionPane.showMessageDialog(null, res.getString("frame5.dialog4.content"));
                            return;
                        }
                        int curModel = LicenseUtil.checkByLicense(snStr).get("limitModule");
                        int companyId = retMap.get("result");
                        if (companyId > 0) {
                            DBOPUtil.updateCompanyNameToDB(companyId, companyNameText.getText());
                        } else {
                            DBOPUtil.insertCompanyNameToDB(companyNameText.getText());
                        }
                        NewActionListener.setLabelText(accLicInfo, vidLicInfo, eleLicInfo, visLicInfo, accadvancedLicInfo);
                        try {
                            if (!"zh_CN".equals(currLanguage) && !"zh_TW".equals(currLanguage)) {
                                JOptionPane.showMessageDialog(null, String.valueOf(NewActionListener.getModel(curModel - 1)) + " " + res.getString("frame5.dialog3.content"));
                                return;
                            }
                            JOptionPane.showMessageDialog(null, String.valueOf(NewActionListener.getModel(curModel - 1)) + res.getString("frame5.dialog3.content"));
                            return;
                        }
                        catch (Exception e1) {
                            JOptionPane.showMessageDialog(null, res.getString("frame5.dialog8.content"));
                            return;
                        }
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                        return;
                    }
                    catch (NativeException e3) {
                        e3.printStackTrace();
                        return;
                    }
                    catch (IllegalAccessException e2) {
                        e2.printStackTrace();
                    }
                }
            });
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NewActionListener.this.frame.dispose();
                }
            });
        }
    }

    protected static String ExecBat(String batPath) {
        String resStr;
        block13: {
            BufferedReader read = null;
            Process pro = null;
            resStr = "";
            try {
                try {
                    pro = Runtime.getRuntime().exec(batPath);
                    read = new BufferedReader(new InputStreamReader(pro.getInputStream()));
                    while (read.readLine() != null) {
                        resStr = read.readLine();
                    }
                }
                catch (IOException e) {
                    resStr = "error";
                    if (read == null) break block13;
                    try {
                        read.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
            finally {
                if (read != null) {
                    try {
                        read.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
        return resStr;
    }

    public static void snListnerEvent(JTextField snText, JComboBox modelBox, JTextField companyNameText, JTextField upkText) {
        if (snText.getText().length() == 53) {
            byte[] strBuffer = new byte[1024];
            boolean contentVirify = false;
            boolean checkCRC16Flag = false;
            try {
                int index = modelBox.getSelectedIndex();
                contentVirify = ReplaceChar.snFormatVerify(snText.getText().trim());
                if (contentVirify) {
                    String snStr = snText.getText().trim().replace("-", "");
                    if ("true".equals(ConfigFile.getValue(0, "company_name", "companyName_show"))) {
                        if (LicenseUtil.getCRC16(snStr).equals(LicenseUtil.createCRC16(companyNameText.getText()))) {
                            checkCRC16Flag = true;
                        }
                    } else {
                        checkCRC16Flag = true;
                    }
                    if (checkCRC16Flag) {
                        int curModel = LicenseUtil.checkByLicense(snStr).get("limitModule");
                        if (index + 1 == curModel) {
                            String upkStr = LicenseUtil.createUPK(strBuffer, snStr);
                            if ("1".equals(upkStr)) {
                                JOptionPane.showMessageDialog(null, res.getString("frame5.dialog7.content"));
                            } else if (!"".equals(upkStr) && !"1".equals(upkStr)) {
                                upkStr = ReplaceChar.replaceRung(upkStr);
                                upkText.setText(upkStr);
                            } else {
                                JOptionPane.showMessageDialog(null, res.getString("frame5.dialog1.content"));
                            }
                        } else {
                            JOptionPane.showMessageDialog(null, res.getString("frame5.dialog9.content"));
                        }
                    } else {
                        JOptionPane.showMessageDialog(null, res.getString("frame5.dialog11.content"));
                    }
                } else {
                    JOptionPane.showMessageDialog(null, res.getString("frame5.dialog10.content"));
                }
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(null, res.getString("frame5.dialog8.content"));
                e1.printStackTrace();
            }
        }
    }

    public static void setLabelText(JLabel accLicInfo, JLabel vidLicInfo, JLabel eleLicInfo, JLabel visLicInfo, JLabel accadvancedLicInfo) {
        Map<String, Map<String, Map<String, Integer>>> licenseMap = LicenseUtil.getLicenseInfo();
        if (Integer.parseInt(licenseMap.get("moduleList").get("acc").get("controlCount").toString()) > 0 && Integer.parseInt(licenseMap.get("moduleList").get("acc").get("modelLicensed").toString()) > 0) {
            int devCount = Integer.parseInt(licenseMap.get("moduleList").get("acc").get("controlCount").toString());
            if ("zh_CN".equals(currLanguage) || "zh_TW".equals(currLanguage)) {
                accLicInfo.setText(String.valueOf(res.getString("frame5.acc")) + "\uff1a" + devCount + res.getString("frame1.devices"));
            } else {
                accLicInfo.setText(String.valueOf(res.getString("frame5.acc")) + "\uff1a" + devCount + " " + res.getString("frame1.devices"));
            }
        } else {
            accLicInfo.setText(String.valueOf(res.getString("frame5.acc")) + "\uff1a" + res.getString("frame1.unAuthorized"));
        }
        if (Integer.parseInt(licenseMap.get("moduleList").get("vid").get("controlCount").toString()) > 0 && Integer.parseInt(licenseMap.get("moduleList").get("vid").get("modelLicensed").toString()) > 0) {
            int channelCount = Integer.parseInt(licenseMap.get("moduleList").get("vid").get("controlCount").toString());
            if ("zh_CN".equals(currLanguage) || "zh_TW".equals(currLanguage)) {
                vidLicInfo.setText(String.valueOf(res.getString("frame5.vid")) + "\uff1a" + channelCount + res.getString("frame1.channel"));
            } else {
                vidLicInfo.setText(String.valueOf(res.getString("frame5.vid")) + "\uff1a" + channelCount + " " + res.getString("frame1.channel"));
            }
        } else {
            vidLicInfo.setText(String.valueOf(res.getString("frame5.vid")) + "\uff1a" + res.getString("frame1.unAuthorized"));
        }
        if (Integer.parseInt(licenseMap.get("moduleList").get("ele").get("controlCount").toString()) > 0 && Integer.parseInt(licenseMap.get("moduleList").get("ele").get("modelLicensed").toString()) > 0) {
            eleLicInfo.setText(String.valueOf(res.getString("frame5.ele")) + "\uff1a" + res.getString("frame1.authorized"));
        } else {
            eleLicInfo.setText(String.valueOf(res.getString("frame5.ele")) + "\uff1a" + res.getString("frame1.unAuthorized"));
        }
        if (Integer.parseInt(licenseMap.get("moduleList").get("vis").get("controlCount").toString()) > 0 && Integer.parseInt(licenseMap.get("moduleList").get("vis").get("modelLicensed").toString()) > 0) {
            visLicInfo.setText(String.valueOf(res.getString("frame5.vis")) + "\uff1a" + res.getString("frame1.authorized"));
        } else {
            visLicInfo.setText(String.valueOf(res.getString("frame5.vis")) + "\uff1a" + res.getString("frame1.unAuthorized"));
        }
        if (Integer.parseInt(licenseMap.get("moduleList").get("accAdvanced").get("controlCount").toString()) > 0 && Integer.parseInt(licenseMap.get("moduleList").get("accAdvanced").get("modelLicensed").toString()) > 0) {
            accadvancedLicInfo.setText(String.valueOf(res.getString("frame5.accAdvanced")) + "\uff1a" + res.getString("frame1.authorized"));
        } else {
            accadvancedLicInfo.setText(String.valueOf(res.getString("frame5.accAdvanced")) + "\uff1a" + res.getString("frame1.unAuthorized"));
        }
    }

    public static String getModel(int key) {
        String[] array = new String[]{res.getString("frame5.acc"), res.getString("frame5.vid"), res.getString("frame5.ele"), res.getString("frame5.vis"), res.getString("frame5.park"), res.getString("frame5.accAdvanced")};
        return array[key];
    }

    public static String setPathAndName(String txtPath) {
        String result = txtPath;
        if (txtPath.contains(" ")) {
            result = "\"" + result + "\"";
        }
        return result;
    }
}

