/*
 * Decompiled with CFR 0.152.
 */
package com.zk.thread;

import com.zk.util.ConfigFile;
import com.zk.util.CopyFileUtil;
import com.zk.util.ServiceUtil;
import com.zk.util.Validator;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class WatchDogThread
implements Runnable {
    private Logger logger = Logger.getLogger(WatchDogThread.class);
    private long sleepTime = Long.parseLong(ConfigFile.getValue("../conf/services.ini".replace("/", File.separator), "watchdog", "sleeptime"));
    private long optionSleepTime = Long.parseLong(ConfigFile.getValue("../conf/services.ini".replace("/", File.separator), "watchdog", "optionsleeptime"));
    private int restartNum_Tomcat = 0;
    private int restartNum_ISSOnline = 0;
    private int restartNum_Finger = 0;
    private int restartNum_PostgreSQL = 0;
    private int restartNum_Redis = 0;
    private int restartNum_micro = 0;
    private long websleepTime = Long.parseLong(ConfigFile.getValue("../conf/services.ini".replace("/", File.separator), "watchdog", "websleeptime"));

    @Override
    public void run() {
        while (true) {
            try {
                this.logger.info((Object)this.sleepTime);
                Thread.sleep(Validator.isNotNull(this.sleepTime) ? this.sleepTime : 30000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.logger.info((Object)"*****started *****");
            boolean regRedis = ServiceUtil.executeCmdReg("BioSecurity Redis Service");
            this.logger.error((Object)("*****" + regRedis + "*****"));
            if (!regRedis) {
                String s = System.getProperty("user.dir");
                String s1 = s.substring(0, s.lastIndexOf("\\"));
                try {
                    String command = String.valueOf(s1) + "\\bin\\redisServiceReStart.bat";
                    Process p1 = Runtime.getRuntime().exec(command);
                    this.logger.info((Object)("*****" + command + " *****"));
                }
                catch (IOException e) {
                    this.logger.error((Object)("*****" + s1 + " *****"));
                    e.printStackTrace();
                }
            }
            try {
                Thread.sleep(Validator.isNotNull(this.websleepTime) ? this.websleepTime : 60000L);
                this.isLostFile();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            String services = ConfigFile.getValue("../conf/services.ini".replace("/", File.separator), "watchdog", "services");
            List<String> serviceList = Arrays.asList(services.split(","));
            for (String serviceName : serviceList) {
                String serviceState = ServiceUtil.getServiceState(serviceName);
                if (serviceState.equals("STOPPED")) {
                    this.logger.error((Object)("*****" + serviceName + ":" + serviceState + " is UnInstall!!!*****"));
                    try {
                        this.executeCounter(serviceName);
                        this.logger.error((Object)("*****" + serviceName + " is Stopped!!!*****"));
                        ServiceUtil.startService(serviceName);
                        if (ServiceUtil.getServiceState(serviceName).equals("STOPPED")) {
                            this.logger.error((Object)("*****" + serviceName + " Restart Failed!!!*****"));
                        } else {
                            this.logger.info((Object)("*****" + serviceName + " Restart Success!!!*****"));
                        }
                        Thread.sleep(Validator.isNotNull(this.optionSleepTime) ? this.optionSleepTime : 300000L);
                    }
                    catch (InterruptedException e) {
                        this.logger.error((Object)("*****" + serviceName + " Restart Failed!!!*****"), (Throwable)e);
                    }
                    continue;
                }
                if (serviceState.equals("UNSTABLE") && this.restartNum_Tomcat < 1) {
                    try {
                        this.executeCounter(serviceName);
                        this.logger.error((Object)("*****" + serviceName + " is UnStable!!!*****"));
                        ServiceUtil.reStartService(serviceName);
                        Thread.sleep(Validator.isNotNull(this.optionSleepTime) ? this.optionSleepTime : 300000L);
                    }
                    catch (InterruptedException e) {
                        this.logger.error((Object)("*****" + serviceName + " Restart Failed!!!*****"), (Throwable)e);
                    }
                    continue;
                }
                if (serviceState.equals("RUNNING")) {
                    this.emptyCounter(serviceName);
                    continue;
                }
                if (!serviceState.equals("UNINSTALL")) continue;
                this.emptyCounter(serviceName);
                this.logger.error((Object)("*****" + serviceName + " is UnInstall!!!*****"));
            }
            this.logger.info((Object)"=======================5 minutes end===========================");
        }
    }

    private void executeCounter(String serviceName) {
        if (serviceName.equals("BioSecurity ISSOnline Service")) {
            this.restartNum_ISSOnline = this.restartNum_ISSOnline == 1 ? this.restartNum_ISSOnline : this.restartNum_ISSOnline + 1;
        } else if (serviceName.equals("BioSecurity Finger Service")) {
            this.restartNum_Finger = this.restartNum_Finger == 1 ? this.restartNum_Finger : this.restartNum_Finger + 1;
        } else if (serviceName.equals("BioSecurity Redis Service")) {
            this.restartNum_Redis = this.restartNum_Redis == 1 ? this.restartNum_Redis : this.restartNum_Redis + 1;
        } else if (serviceName.equals("BioSecurity PostgreSQL Service")) {
            this.restartNum_PostgreSQL = this.restartNum_PostgreSQL == 1 ? this.restartNum_PostgreSQL : this.restartNum_PostgreSQL + 1;
        } else if (serviceName.equals("BioSecurityTomcat")) {
            this.restartNum_Tomcat = this.restartNum_Tomcat == 1 ? this.restartNum_Tomcat : this.restartNum_Tomcat + 1;
        }
    }

    private void emptyCounter(String serviceName) {
        if (serviceName.equals("BioSecurity ISSOnline Service")) {
            this.restartNum_ISSOnline = 0;
        } else if (serviceName.equals("BioSecurity Finger Service")) {
            this.restartNum_Finger = 0;
        } else if (serviceName.equals("BioSecurity Redis Service")) {
            this.restartNum_Redis = 0;
        } else if (serviceName.equals("BioSecurity PostgreSQL Service")) {
            this.restartNum_PostgreSQL = 0;
        } else if (serviceName.equals("BioSecurityTomcat")) {
            this.restartNum_Tomcat = 0;
        } else if (serviceName.equals("Biosecurity MicroServer")) {
            this.restartNum_micro = 0;
        }
    }

    public void isLostFile() {
        File webFile = new File("../../tomcat/webapps/ROOT/WEB-INF/web.xml");
        if (!webFile.exists()) {
            System.out.println("web\u6587\u4ef6\u4e0d\u5b58\u5728");
            this.logger.error((Object)"*****web\u6587\u4ef6\u4e0d\u5b58\u5728!*****");
            boolean isRestore = CopyFileUtil.copyFile("../batFile/web.xml", webFile);
            if (isRestore) {
                ServiceUtil.reStartService("BioSecurityTomcat");
                this.logger.error((Object)"*****web\u6587\u4ef6\u5df2\u8fd8\u539f!*****");
            }
        }
    }
}

