/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.com.interfaces;

import org.xvolks.jnative.Native;
import org.xvolks.jnative.com.interfaces.IUnknown;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.util.ole.Ole32;
import org.xvolks.jnative.util.windows.structures.GUID;

public abstract class IDispatch
extends IUnknown
implements Runnable {
    private static final int DISPATCH_METHOD = 1;
    private static final int DISPATCH_PROPERTYGET = 2;
    private static final int DISPATCH_PROPERTYPUT = 4;

    private native Object comInvoke(int var1, int var2, Object[] var3);

    public native Object syncExec(Runnable var1);

    private native long GetIDsOfNames(String var1, int var2) throws IllegalArgumentException;

    public long getIDsOfNames(String name, int cNames) {
        return this.GetIDsOfNames(name, cNames);
    }

    @Native
    private IDispatch(IDispatch owner, int pIDispatch) throws Throwable {
        super(null, null, owner.getHWnd(), owner.getOwnerThreadId(), pIDispatch);
    }

    public IDispatch(String progId, String iid) throws Throwable {
        super(progId, iid, 0, 0);
        this.syncExec(new Runnable(){

            public void run() {
                IDispatch.this.getLogger().debug("in syncExec");
            }
        });
        this.getLogger().debug("syncExec is working great.");
    }

    protected GUID getClassID(String clientName) throws NativeException, IllegalAccessException {
        GUID guid = Ole32.CLSIDFromProgID(clientName);
        if (guid == null && (guid = Ole32.CLSIDFromString(clientName)) == null) {
            throw new IllegalArgumentException("Illegal progId : " + clientName);
        }
        return guid;
    }

    public Object getProperty(int dispIdMember) {
        return this.invoke(dispIdMember, 2, null);
    }

    public void setProperty(int dispIdMember, Object value) {
        this.invoke(dispIdMember, 4, new Object[]{value});
    }

    public Object invoke(int dispIdMember, Object[] params) {
        return this.invoke(dispIdMember, 1, params);
    }

    public Object invoke(int dispIdMember, int wFlags, Object[] params) {
        return this.comInvoke(dispIdMember, wFlags, params);
    }
}

