/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.misc;

import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.basicStructures.AbstractBasicData;
import org.xvolks.jnative.misc.basicStructures.DWORD;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.MemoryBlockFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PRINTPAGERANGE
extends AbstractBasicData<PRINTPAGERANGE> {
    public DWORD nFromPage;
    public DWORD nToPage;

    public PRINTPAGERANGE() {
        super(null);
        try {
            this.createPointer();
        }
        catch (NativeException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Pointer createPointer() throws NativeException {
        if (this.pointer == null) {
            this.pointer = new Pointer(MemoryBlockFactory.createMemoryBlock(this.getSizeOf()));
        }
        return this.pointer;
    }

    private void fromPointer() throws NativeException {
        this.offset = 0;
        this.nFromPage = new DWORD(this.getNextInt());
        this.nToPage = new DWORD(this.getNextInt());
        this.offset = 0;
    }

    private void toPointer() throws NativeException {
        this.offset = 0;
        this.offset += this.pointer.setIntAt(this.offset, this.nFromPage.getValue());
        this.pointer.setIntAt(this.offset, this.nToPage.getValue());
        this.offset = 0;
    }

    @Override
    public int getSizeOf() {
        return PRINTPAGERANGE.sizeOf();
    }

    public static int sizeOf() {
        return DWORD.sizeOf() * 2;
    }

    @Override
    public PRINTPAGERANGE getValueFromPointer() throws NativeException {
        this.fromPointer();
        return this;
    }

    @Override
    public PRINTPAGERANGE getValue() {
        try {
            this.toPointer();
        }
        catch (NativeException ex) {
            ex.printStackTrace();
        }
        return this;
    }
}

