/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.util.windows.hooks;

import org.xvolks.jnative.JNative;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.MSG;
import org.xvolks.jnative.misc.basicStructures.DWORD;
import org.xvolks.jnative.misc.basicStructures.HWND;
import org.xvolks.jnative.misc.basicStructures.LPARAM;
import org.xvolks.jnative.misc.basicStructures.UINT;
import org.xvolks.jnative.misc.basicStructures.WPARAM;
import org.xvolks.jnative.util.Callback;
import org.xvolks.jnative.util.Kernel32;
import org.xvolks.jnative.util.User32;
import org.xvolks.jnative.util.constants.winuser.WH;
import org.xvolks.jnative.util.constants.winuser.WM;

public class GlobalNativeHook
implements Runnable,
Callback {
    private WH hookType;
    private int myAddress = -1;
    private int hHook;
    private boolean doHook = false;
    private DWORD hookThreadId;
    private int callbackAddress;
    private DWORD dwProcessId;
    private int hModule;
    private Thread thread;
    public static final int HC_ACTION = 0;
    private volatile Object syncObj = new Object();

    public GlobalNativeHook() {
        this(0, null, 0);
    }

    public GlobalNativeHook(int callbackAddress) {
        this(callbackAddress, null, 0);
    }

    public GlobalNativeHook(int callbackAddress, DWORD dwProcessId) {
        this(callbackAddress, dwProcessId, 0);
    }

    public GlobalNativeHook(int callbackAddress, DWORD dwProcessId, int hModule) {
        this.dwProcessId = dwProcessId;
        this.hModule = hModule;
        this.callbackAddress = callbackAddress;
    }

    public void dispose() throws Exception {
        this.unHook();
        if (this.myAddress != 0) {
            JNative.releaseCallback(this);
        }
    }

    protected void addShutDownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                try {
                    GlobalNativeHook.this.dispose();
                    JNative.unLoadAllLibraries();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    public int getHookHandle() {
        return this.hHook;
    }

    public void setHModule(int hModule) {
        this.hModule = hModule;
    }

    public void setDwProcessId(DWORD dwProcessId) {
        this.dwProcessId = dwProcessId;
    }

    public void setCallback(int callbackAddr) throws NativeException, IllegalAccessException, InterruptedException {
        this.callbackAddress = callbackAddr;
    }

    public boolean isHooked() {
        return this.doHook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean hook(WH hookType) throws NativeException, IllegalAccessException, InterruptedException {
        if (this.callbackAddress == 0) {
            throw new IllegalArgumentException("Callback address must not be null!");
        }
        if (this.dwProcessId == null) {
            this.dwProcessId = new DWORD(0);
        }
        if (this.isHooked()) {
            this.unHook();
        }
        this.hookType = hookType;
        this.doHook = true;
        this.thread = new Thread(this);
        this.thread.start();
        Object object = this.syncObj;
        synchronized (object) {
            this.syncObj.wait();
        }
        return this.isHooked();
    }

    public synchronized boolean unHook() throws NativeException, IllegalAccessException, InterruptedException {
        if (!this.isHooked()) {
            return false;
        }
        if (this.hookThreadId != null) {
            User32.PostThreadMessage(this.hookThreadId, new UINT(WM.WM_QUIT.getValue()), new WPARAM(0), new LPARAM(0));
        }
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.join();
        }
        this.doHook = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block23: {
            block22: {
                if (!this.isHooked()) {
                    throw new RuntimeException("Do not call run() manually, use hook() method instead!");
                }
                this.hHook = User32.SetWindowsHookEx(this.hookType.getValue(), this.callbackAddress, this.hModule, this.dwProcessId);
                if (this.hHook != 0) {
                    JNative.getLogger().log("Hook established: hHook = " + this.hHook + ", callbackAddress = " + this.callbackAddress + ", hModule = " + this.hModule + ", dwProcessId = " + this.dwProcessId.getValue());
                    this.hookThreadId = Kernel32.GetCurrentThreadId();
                    Object object = this.syncObj;
                    synchronized (object) {
                        this.syncObj.notify();
                    }
                    MSG msg = new MSG();
                    HWND hwnd = new HWND(0);
                    while (User32.GetMessage(msg, hwnd, 0, 0) > 0) {
                        User32.TranslateMessage(msg);
                        User32.DispatchMessage(msg);
                        msg.getPointer().zeroMemory();
                    }
                    break block22;
                }
                JNative.getLogger().log("Could not establish Hook!");
            }
            Object var4_6 = null;
            this.doHook = false;
            this.hookThreadId = null;
            if (this.hHook == 0) break block23;
            try {
                User32.UnhookWindowsHookEx(this.hHook);
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
            catch (NativeException ex) {
                ex.printStackTrace();
            }
        }
        Object object = this.syncObj;
        synchronized (object) {
            this.syncObj.notify();
        }
        {
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            catch (NativeException ex) {
                throw new RuntimeException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.doHook = false;
            this.hookThreadId = null;
            if (this.hHook != 0) {
                try {
                    User32.UnhookWindowsHookEx(this.hHook);
                }
                catch (IllegalAccessException ex) {
                    ex.printStackTrace();
                }
                catch (NativeException ex) {
                    ex.printStackTrace();
                }
            }
            Object object2 = this.syncObj;
            synchronized (object2) {
                this.syncObj.notify();
            }
            throw throwable;
        }
    }

    public int callback(long[] values) {
        try {
            return User32.CallNextHookEx(this.hHook, (int)values[0], (int)values[1], (int)values[2]);
        }
        catch (NativeException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        return 0;
    }

    public int getCallbackAddress() throws NativeException {
        if (this.myAddress == -1) {
            this.myAddress = JNative.createCallback(3, this);
        }
        return this.myAddress;
    }
}

