/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.misc;

import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.basicStructures.DWORD;
import org.xvolks.jnative.util.Kernel32;

public class WindowsVersion {
    private static DWORD dword = null;
    private static boolean m_bSupportsUnicode = false;
    private static boolean m_bSupportsNewVersion = false;

    public String toString() {
        String ret = "Windows Version Info:\n";
        try {
            ret = ret + "Major Version: " + WindowsVersion.getMajorVersion() + "\n";
            ret = ret + "Minor Version: " + WindowsVersion.getMinorVersion() + "\n";
            ret = ret + "Build: " + WindowsVersion.getBuild() + "\n";
            ret = ret + "NT: " + WindowsVersion.isNT() + "\n";
            ret = ret + "Supports Unicode: " + WindowsVersion.supportsUnicode() + "\n";
            ret = ret + "Supports new version: " + WindowsVersion.supportsNewVersion() + "\n";
            return ret;
        }
        catch (NativeException e) {
            return e.toString();
        }
    }

    public static boolean supportsUnicode() {
        return m_bSupportsUnicode;
    }

    public static boolean supportsNewVersion() {
        return m_bSupportsNewVersion;
    }

    public static boolean isNT() throws NativeException {
        return (WindowsVersion.getBuild() & Integer.MIN_VALUE) == 0;
    }

    public static int getMajorVersion() throws NativeException {
        if (dword != null) {
            return dword.getPointer().getAsByte(0);
        }
        return -1;
    }

    public static int getMinorVersion() throws NativeException {
        if (dword != null) {
            return dword.getPointer().getAsByte(1);
        }
        return -1;
    }

    public static int getBuild() throws NativeException {
        if (dword != null) {
            return dword.getPointer().getAsShort(2);
        }
        return -1;
    }

    static {
        try {
            dword = Kernel32.GetVersion();
            if (WindowsVersion.isNT()) {
                m_bSupportsUnicode = true;
                if (WindowsVersion.getMajorVersion() >= 5) {
                    m_bSupportsNewVersion = true;
                }
            } else if (WindowsVersion.getMajorVersion() == 4 && WindowsVersion.getMinorVersion() == 90) {
                m_bSupportsNewVersion = true;
            }
        }
        catch (NativeException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

