/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.util;

import org.xvolks.jnative.JNative;
import org.xvolks.jnative.Type;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.ITEMID;
import org.xvolks.jnative.misc.NOTIFYICONDATA;
import org.xvolks.jnative.misc.SHELLEXECUTEINFO;
import org.xvolks.jnative.misc.WindowsVersion;
import org.xvolks.jnative.misc.basicStructures.DWORD;
import org.xvolks.jnative.misc.basicStructures.FILEINFO;
import org.xvolks.jnative.misc.basicStructures.HWND;

public class Shell32 {
    public static final String DLL_NAME = "shell32.dll";
    private static String mLastErrorCode = "0";
    public static final int SHGFI_LARGEICON = 0;
    public static final int SHGFI_SMALLICON = 1;
    public static final int SHGFI_OPENICON = 2;
    public static final int SHGFI_SHELLICONSIZE = 4;
    public static final int SHGFI_PIDL = 8;
    public static final int SHGFI_USEFILEATTRIBUTES = 16;
    public static final int SHGFI_ICON = 256;
    public static final int SHGFI_DISPLAYNAME = 512;
    public static final int SHGFI_TYPENAME = 1024;
    public static final int SHGFI_ATTRIBUTES = 2048;
    public static final int SHGFI_ICONLOCATION = 4096;
    public static final int SHGFI_EXETYPE = 8192;
    public static final int EXE_WIN16 = 17742;
    public static final int EXE_DOS16 = 23117;
    public static final int EXE_WIN32 = 17744;
    public static final int SHGFI_SYSICONINDEX = 16384;
    public static final int SHGFI_LINKOVERLAY = 32768;
    public static final int SHGFI_SELECTED = 65536;
    public static final int DROPEFFECT_COPY = 1;
    public static final int DROPEFFECT_MOVE = 2;
    public static final int DROPEFFECT_LINK = 4;
    public static final int SFGAO_CANCOPY = 1;
    public static final int SFGAO_CANMOVE = 2;
    public static final int SFGAO_CANLINK = 4;
    public static final int SFGAO_CANRENAME = 16;
    public static final int SFGAO_CANDELETE = 32;
    public static final int SFGAO_HASPROPSHEET = 64;
    public static final int SFGAO_DROPTARGET = 256;
    public static final int SFGAO_CAPABILITYMASK = 375;
    public static final int SFGAO_LINK = 65536;
    public static final int SFGAO_SHARE = 131072;
    public static final int SFGAO_READONLY = 262144;
    public static final int SFGAO_GHOSTED = 524288;
    public static final int SFGAO_DISPLAYATTRMASK = 983040;
    public static final int SFGAO_FILESYSANCESTOR = 0x10000000;
    public static final int SFGAO_FOLDER = 0x20000000;
    public static final int SFGAO_FILESYSTEM = 0x40000000;
    public static final int SFGAO_HASSUBFOLDER = Integer.MIN_VALUE;
    public static final int SFGAO_CONTENTSMASK = Integer.MIN_VALUE;
    public static final int SFGAO_VALIDATE = 0x1000000;
    public static final int SFGAO_REMOVABLE = 0x2000000;
    public static final int SFGAO_COMPRESSED = 0x4000000;
    public static final int CSIDL_DESKTOP = 0;
    public static final int CSIDL_INTERNET = 1;
    public static final int CSIDL_PROGRAMS = 2;
    public static final int CSIDL_CONTROLS = 3;
    public static final int CSIDL_PRINTERS = 4;
    public static final int CSIDL_PERSONAL = 5;
    public static final int CSIDL_FAVORITES = 6;
    public static final int CSIDL_STARTUP = 7;
    public static final int CSIDL_RECENT = 8;
    public static final int CSIDL_SENDTO = 9;
    public static final int CSIDL_BITBUCKET = 10;
    public static final int CSIDL_STARTMENU = 11;
    public static final int CSIDL_MYMUSIC = 13;
    public static final int CSIDL_MYVIDEO = 14;
    public static final int CSIDL_DESKTOPDIRECTORY = 16;
    public static final int CSIDL_DRIVES = 17;
    public static final int CSIDL_NETWORK = 18;
    public static final int CSIDL_NETHOOD = 19;
    public static final int CSIDL_FONTS = 20;
    public static final int CSIDL_TEMPLATES = 21;
    public static final int CSIDL_COMMON_STARTMENU = 22;
    public static final int CSIDL_COMMON_PROGRAMS = 23;
    public static final int CSIDL_COMMON_STARTUP = 24;
    public static final int CSIDL_COMMON_DESKTOPDIRECTORY = 25;
    public static final int CSIDL_APPDATA = 26;
    public static final int CSIDL_PRINTHOOD = 27;
    public static final int CSIDL_LOCAL_APPDATA = 28;
    public static final int CSIDL_COMMON_FAVORITES = 31;
    public static final int CSIDL_INTERNET_CACHE = 32;
    public static final int CSIDL_COOKIES = 33;
    public static final int CSIDL_HISTORY = 34;
    public static final int CSIDL_COMMON_APPDATA = 35;
    public static final int CSIDL_WINDOWS = 36;
    public static final int CSIDL_SYSTEM = 37;
    public static final int CSIDL_PROGRAM_FILES = 38;
    public static final int CSIDL_MYPICTURES = 39;
    public static final int CSIDL_PROFILE = 40;
    public static final int CSIDL_SYSTEMX86 = 41;
    public static final int CSIDL_PROGRAM_FILES_COMMON = 43;
    public static final int CSIDL_COMMON_TEMPLATES = 45;
    public static final int CSIDL_COMMON_DOCUMENTS = 46;
    public static final int CSIDL_COMMON_ADMINTOOLS = 47;
    public static final int CSIDL_ADMINTOOLS = 48;

    public static boolean SHGetSpecialFolderLocation(HWND hwndOwner, int nFolder, ITEMID ppidl) throws NativeException, IllegalAccessException {
        JNative SHGetSpecialFolderLocation = new JNative(DLL_NAME, "SHGetSpecialFolderLocation");
        SHGetSpecialFolderLocation.setRetVal(Type.INT);
        int pos = 0;
        SHGetSpecialFolderLocation.setParameter(pos++, (Integer)hwndOwner.getValue());
        SHGetSpecialFolderLocation.setParameter(pos++, nFolder);
        SHGetSpecialFolderLocation.setParameter(pos++, ppidl.getPointer());
        SHGetSpecialFolderLocation.invoke();
        pos = SHGetSpecialFolderLocation.getRetValAsInt();
        return pos != 0;
    }

    public static DWORD SHGetFileInfo(String pszPath, DWORD dwFileAttributes, FILEINFO psfi, int cbFileInfo, int uFlags) throws NativeException, IllegalAccessException {
        JNative SHGetFileInfo = new JNative(DLL_NAME, "SHGetFileInfo");
        SHGetFileInfo.setRetVal(Type.INT);
        int pos = 0;
        try {
            Integer.parseInt(pszPath);
            SHGetFileInfo.setParameter(pos++, Type.INT, pszPath);
        }
        catch (NumberFormatException e) {
            SHGetFileInfo.setParameter(pos++, pszPath);
        }
        SHGetFileInfo.setParameter(pos++, dwFileAttributes.getValue());
        SHGetFileInfo.setParameter(pos++, psfi.getPointer());
        SHGetFileInfo.setParameter(pos++, cbFileInfo);
        SHGetFileInfo.setParameter(pos++, uFlags);
        SHGetFileInfo.invoke();
        pos = SHGetFileInfo.getRetValAsInt();
        return new DWORD(pos);
    }

    public static boolean Shell_NotifyIcon(int dwMessage, NOTIFYICONDATA lpdata) throws NativeException, IllegalAccessException {
        JNative nShell_NotifyIcon = new JNative(DLL_NAME, "Shell_NotifyIcon" + (WindowsVersion.supportsUnicode() ? "W" : "A"));
        nShell_NotifyIcon.setRetVal(Type.INT);
        int i = 0;
        nShell_NotifyIcon.setParameter(i++, dwMessage);
        nShell_NotifyIcon.setParameter(i++, lpdata.getValue().getPointer());
        nShell_NotifyIcon.invoke();
        return nShell_NotifyIcon.getRetValAsInt() != 0;
    }

    public static boolean ShellExecuteEx(SHELLEXECUTEINFO lpExecInfo) throws NativeException, IllegalAccessException {
        JNative ShellExecuteEx = new JNative(DLL_NAME, "ShellExecuteEx");
        ShellExecuteEx.setRetVal(Type.INT);
        int pos = 0;
        ShellExecuteEx.setParameter(pos++, lpExecInfo.createPointer());
        ShellExecuteEx.invoke();
        pos = ShellExecuteEx.getRetValAsInt();
        return pos != 0;
    }
}

