/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.util.ole;

import org.xvolks.jnative.JNative;
import org.xvolks.jnative.Type;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.logging.JNativeLogger;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.MemoryBlockFactory;
import org.xvolks.jnative.util.ole.Oleaut32;
import org.xvolks.jnative.util.windows.structures.GUID;

public class Ole32 {
    public static final String DLL_NAME = "ole32.dll";

    public static final GUID CLSIDFromString(String lpsz) throws NativeException, IllegalAccessException {
        JNative CLSIDFromString = new JNative(DLL_NAME, "CLSIDFromString");
        CLSIDFromString.setRetVal(Type.INT);
        Pointer p = new Pointer(MemoryBlockFactory.createMemoryBlock(16));
        Pointer bstr = Oleaut32.SysAllocString(lpsz);
        CLSIDFromString.setParameter(0, bstr);
        CLSIDFromString.setParameter(1, p);
        CLSIDFromString.invoke();
        int ret = CLSIDFromString.getRetValAsInt();
        if (ret != 0) {
            JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, "CLSIDFromString returned " + ret);
        }
        GUID guid = new GUID();
        guid.setValue(p.getMemory(), 0);
        return guid;
    }

    public static final GUID CLSIDFromProgID(String lpsz) throws NativeException, IllegalAccessException {
        JNative CLSIDFromString = new JNative(DLL_NAME, "CLSIDFromProgID");
        CLSIDFromString.setRetVal(Type.INT);
        Pointer p = new Pointer(MemoryBlockFactory.createMemoryBlock(16));
        Pointer bstr = Oleaut32.SysAllocString(lpsz);
        CLSIDFromString.setParameter(0, bstr);
        CLSIDFromString.setParameter(1, p);
        CLSIDFromString.invoke();
        int ret = CLSIDFromString.getRetValAsInt();
        if (ret != 0) {
            JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, "CLSIDFromString returned " + ret);
            return null;
        }
        GUID guid = new GUID();
        guid.setValue(p.getMemory(), 0);
        return guid;
    }
}

