/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security.ruleset;

import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.BlockedException;
import com.sun.deploy.security.ruleset.Rule;
import com.sun.deploy.security.ruleset.RuleAction;
import com.sun.deploy.security.ruleset.RuleId;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.VersionID;
import com.sun.deploy.util.VersionString;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RuleSetParser
extends DefaultHandler {
    List ruleList = new ArrayList();
    String idTitle;
    String idLocation;
    String idCertAlgorithm;
    String idCertHash;
    String idChecksumAlgorithm;
    String idChecksumHash;
    String actionPerms;
    String actionVersion;
    String actionMessage;
    String DRSVersion;
    String DRSHref;
    RuleAction actionRule;
    RuleId idRule;
    boolean inRuleSet;
    boolean inRule;
    boolean inId;
    boolean inMessage;
    boolean inAction;

    public Rule[] parse(InputStream inputStream, int n) throws BlockedException {
        Rule[] ruleArray = new Rule[]{};
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance("com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl", null);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(inputStream, (DefaultHandler)this);
            ruleArray = this.ruleList.toArray(new Rule[0]);
            if (this.DRSVersion == null) {
                String string = ResourceManager.getString("deployment.blocked.ruleset.spec.version", this.DRSVersion);
                Trace.println("Deployment Rule Set parsing error: ruleset version required attribute missing.", TraceLevel.RULESET);
                throw new BlockedException(string, null);
            }
            VersionString versionString = new VersionString(this.DRSVersion);
            if (!versionString.contains(new VersionID("1.0"))) {
                String string = ResourceManager.getString("deployment.blocked.ruleset.spec.version", this.DRSVersion);
                Trace.println("Deployment Rule Set parsing error: ruleset version: " + versionString + " not supported.", TraceLevel.RULESET);
                throw new BlockedException(string, null);
            }
        }
        catch (SAXException sAXException) {
            Trace.println("exception parsing ruleset file: " + sAXException, TraceLevel.RULESET);
            Trace.ignored(sAXException);
            String string = ResourceManager.getString("deployment.blocked.ruleset.exception");
            throw new BlockedException(string, sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Trace.println("exception parsing ruleset file: " + parserConfigurationException, TraceLevel.RULESET);
            Trace.ignored(parserConfigurationException);
            String string = ResourceManager.getString("deployment.blocked.ruleset.exception");
            throw new BlockedException(string, parserConfigurationException);
        }
        catch (IOException iOException) {
            Trace.println("exception parsing ruleset file: " + iOException, TraceLevel.RULESET);
            Trace.ignored(iOException);
            String string = ResourceManager.getString("deployment.blocked.ruleset.exception");
            throw new BlockedException(string, iOException);
        }
        int n2 = ruleArray.length;
        Trace.println("RuleSetParser.parse() returning " + n2 + " rules:", TraceLevel.RULESET);
        for (int i = 0; i < n2; ++i) {
            Trace.println(ruleArray[i].toString(), TraceLevel.RULESET);
        }
        return ruleArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equalsIgnoreCase("ruleset")) {
            this.inRuleSet = true;
            this.DRSVersion = attributes.getValue("version");
            this.DRSHref = attributes.getValue("href");
            return;
        } else if (string3.equalsIgnoreCase("rule")) {
            if (!this.inRuleSet) {
                throw new SAXException("element " + string3 + " is invalid outsize of ruleset element.");
            }
            this.inRule = true;
            this.idRule = null;
            this.actionRule = null;
            return;
        } else if (string3.equalsIgnoreCase("id")) {
            if (!this.inRule) {
                throw new SAXException("element " + string3 + " is invalid outsize of rule element.");
            }
            this.idLocation = attributes.getValue("location");
            this.idTitle = attributes.getValue("title");
            this.idCertHash = null;
            this.idCertAlgorithm = null;
            this.idChecksumHash = null;
            this.idChecksumAlgorithm = null;
            this.inId = true;
            return;
        } else if (string3.equalsIgnoreCase("action")) {
            if (!this.inRule) {
                throw new SAXException("element " + string3 + " is invalid outsize of rule element.");
            }
            this.inAction = true;
            this.actionPerms = attributes.getValue("permission");
            if (!(this.actionPerms == null || this.actionPerms.equalsIgnoreCase("run") || this.actionPerms.equalsIgnoreCase("block") || this.actionPerms.equalsIgnoreCase("default"))) {
                throw new SAXException("value " + this.actionPerms + " is invalid value for permission attribute.");
            }
            this.actionVersion = attributes.getValue("version");
            if (!this.isValidJavaVersion(this.actionVersion)) {
                throw new SAXException("value " + this.actionVersion + " is invalid value for version attribute.");
            }
            this.actionMessage = null;
            return;
        } else if (string3.equalsIgnoreCase("certificate")) {
            if (!this.inId) throw new SAXException("element " + string3 + " is invalid outsize of id element.");
            this.idCertHash = attributes.getValue("hash");
            if (this.idCertHash == null) {
                throw new SAXException("<certificate> element must have hash attribute.");
            }
            this.idCertHash = this.idCertHash.replaceAll(":", "");
            this.idCertAlgorithm = attributes.getValue("algorithm");
            return;
        } else if (string3.equalsIgnoreCase("checksum")) {
            if (!this.inId) throw new SAXException("element " + string3 + " is invalid outsize of id element.");
            this.idChecksumHash = attributes.getValue("hash");
            if (this.idChecksumHash == null) {
                throw new SAXException("<checksum> element must have hash attribute.");
            }
            this.idChecksumAlgorithm = attributes.getValue("algorithm");
            return;
        } else if (string3.equalsIgnoreCase("message")) {
            if (!this.inAction) {
                throw new SAXException("element " + string3 + " is invalid outsize of action element.");
            }
            String string4 = attributes.getValue("locale");
            if (string4 != null && !string4.equals(Locale.getDefault().toString())) return;
            this.inMessage = true;
            return;
        } else {
            Trace.println("element name " + string3 + " is unregognized and will be ignored.", TraceLevel.RULESET);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equalsIgnoreCase("ruleset")) {
            this.inRuleSet = false;
        } else if (string3.equalsIgnoreCase("rule")) {
            if (this.inRule) {
                if (this.idRule == null || this.actionRule == null) {
                    throw new SAXException("<rule> element must have both <id> and <action> sub-elements.");
                }
                this.validateRule(this.idRule, this.actionRule);
                Rule rule = new Rule(this.idRule, this.actionRule);
                this.idRule = null;
                this.actionRule = null;
                this.ruleList.add(rule);
            }
            this.inRule = false;
        } else if (string3.equalsIgnoreCase("id")) {
            this.idRule = new RuleId(this.idTitle, this.idLocation, this.idCertAlgorithm, this.idCertHash, this.idChecksumAlgorithm, this.idChecksumHash);
            this.idLocation = null;
            this.idTitle = null;
            this.idCertHash = null;
            this.idCertAlgorithm = null;
            this.idChecksumHash = null;
            this.idChecksumAlgorithm = null;
            this.inId = false;
        } else if (string3.equalsIgnoreCase("action")) {
            this.inAction = false;
            this.actionRule = new RuleAction(this.actionPerms, this.actionVersion, this.actionMessage);
            this.actionPerms = null;
            this.actionVersion = null;
            this.actionMessage = null;
        } else if (!string3.equalsIgnoreCase("certificate") && string3.equalsIgnoreCase("message")) {
            this.inMessage = false;
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        if (this.inMessage) {
            this.actionMessage = string;
        }
    }

    private void validateRule(RuleId ruleId, RuleAction ruleAction) {
        int n;
        String string;
        int n2;
        boolean bl = false;
        if (ruleAction.isRun() && ruleId.location == null && ruleId.certHash == null && ruleId.checksumHash == null) {
            Trace.println("Deployment Rule Set invalid rule: run rule must must have either location, certificate, or checksum.", TraceLevel.RULESET);
            bl = true;
        }
        if (ruleAction.isDefault() && ruleId.title != null && ruleId.location == null && ruleId.certHash == null && ruleId.checksumHash == null) {
            Trace.println("Deployment Rule Set invalid rule: default rule with title must have either location, certificate, or checksum.", TraceLevel.RULESET);
            bl = true;
        }
        if (this.actionRule.isRun() && this.idLocation != null && this.idRule.certHash == null && this.idRule.checksumHash == null && !this.idLocation.startsWith("https")) {
            Trace.println("It is recommended to use https protocol when defining a run rule based solely on location", TraceLevel.RULESET);
        }
        if (!bl && ruleId.certHash != null) {
            n2 = ruleId.certHash.length();
            string = ruleId.certHash;
            if (n2 == 0) {
                Trace.println("Deployment Rule Set invalid rule: certificate hash empty String.", TraceLevel.RULESET);
                bl = true;
            } else if ((ruleId.certAlgorithm == null || ruleId.certAlgorithm.equals("SHA-256")) && n2 != 64) {
                Trace.println("Deployment Rule Set invalid rule: certificate hash for SHA-256 not 64 characters.", TraceLevel.RULESET);
                bl = true;
            }
            if (!bl) {
                for (n = 0; n < n2; ++n) {
                    char c = string.charAt(n);
                    if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F') continue;
                    Trace.println("Deployment Rule Set invalid rule: certificate hash contains invalid characters.", TraceLevel.RULESET);
                    bl = true;
                    break;
                }
            }
        }
        if (!bl && ruleId.checksumHash != null && (n2 = ruleId.checksumHash.length()) == 0) {
            Trace.println("Deployment Rule Set invalid rule: checksum hash empty String.", TraceLevel.RULESET);
            bl = true;
        }
        if (!bl && ruleId.title != null) {
            n2 = ruleId.title.length();
            if (n2 == 0) {
                Trace.println("Deployment Rule Set invalid rule: title is empty String", TraceLevel.RULESET);
                bl = true;
            } else if (n2 > 140) {
                Trace.println("Deployment Rule Set invalid rule: title exceeds 140 characters.", TraceLevel.RULESET);
                bl = true;
            }
        }
        if (!bl && ruleId.location != null) {
            n2 = ruleId.location.length();
            if (n2 > 256) {
                Trace.println("Deployment Rule Set invalid rule: location exceeds 256 characters.", TraceLevel.RULESET);
                bl = true;
            } else {
                string = null;
                n = ruleId.location.indexOf("://");
                if (n > 0) {
                    string = ruleId.location.substring(0, n);
                }
                if (!(string == null || "http".equals(string) || "https".equals(string) || "file".equals(string))) {
                    Trace.println("Deployment Rule Set invalid rule: location uses invalid protocol: " + string, TraceLevel.RULESET);
                    bl = true;
                }
            }
        }
        if (bl) {
            String string2 = ResourceManager.getString("deployment.blocked.ruleset.invalid.rule");
            throw new BlockedException(string2, null);
        }
    }

    private boolean isValidJavaVersion(String string) {
        if (string == null) {
            return true;
        }
        if (string.equals("SECURE")) {
            return true;
        }
        if (string.startsWith("SECURE-")) {
            char c;
            String string2 = string.substring("SECURE-".length());
            if (string2 == null) {
                return false;
            }
            return string2.length() >= 3 && string2.startsWith("1.") && (c = string2.charAt(2)) >= '3' && c <= '9';
        }
        VersionString versionString = new VersionString(string);
        return versionString != null;
    }
}

