/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper;

import [Ljava.lang.String;;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.tanukisoftware.wrapper.WrapperListener;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.WrapperPrintStream;
import org.tanukisoftware.wrapper.WrapperSystemPropertyUtil;

public class WrapperJarApp
implements WrapperListener,
Runnable {
    private static WrapperPrintStream m_outInfo;
    private static WrapperPrintStream m_outError;
    private static WrapperPrintStream m_outDebug;
    private Method m_mainMethod;
    private String[] m_appArgs;
    private boolean m_mainStarted;
    private boolean m_mainComplete;
    private Integer m_mainExitCode;
    private boolean m_ignoreMainExceptions;
    private boolean m_startComplete;
    private boolean m_initFailed;
    private String m_initError;
    private boolean m_initShowUsage;
    private Throwable m_initException;

    protected WrapperJarApp(String[] args) {
        String[] appArgs;
        Class wmClass = WrapperManager.class;
        m_outInfo = new WrapperPrintStream(System.out, "WrapperJarApp: ");
        m_outError = new WrapperPrintStream(System.out, "WrapperJarApp Error: ");
        m_outDebug = new WrapperPrintStream(System.out, "WrapperJarApp Debug: ");
        if (args.length < 1) {
            this.m_initFailed = true;
            this.m_initError = WrapperManager.getRes().getString("Not enough argments.  Minimum {0} required.", "1");
            this.m_initShowUsage = true;
            appArgs = new String[]{};
        } else {
            File file = new File(args[0]);
            if (!file.exists()) {
                this.m_initFailed = true;
                this.m_initError = WrapperManager.getRes().getString("Unable to locate the jar file {0}", args[0]);
                this.m_initShowUsage = true;
            } else {
                JarFile jarFile;
                File parent = file.getParentFile();
                try {
                    jarFile = new JarFile(file);
                }
                catch (IOException e) {
                    this.m_initFailed = true;
                    this.m_initError = WrapperManager.getRes().getString("Unable to open the jar file {0} : {1}", args[0], e);
                    jarFile = null;
                }
                if (!this.m_initFailed) {
                    Manifest manifest;
                    try {
                        manifest = jarFile.getManifest();
                    }
                    catch (IOException e) {
                        this.m_initFailed = true;
                        this.m_initError = WrapperManager.getRes().getString("Unable to access the jar''s manifest file {0} : {1}", args[0], e);
                        manifest = null;
                    }
                    if (!this.m_initFailed) {
                        Attributes attributes = manifest.getMainAttributes();
                        String mainClassName = attributes.getValue("Main-Class");
                        if (mainClassName == null) {
                            this.m_initFailed = true;
                            this.m_initError = WrapperManager.getRes().getString("The Main-Class was not specified correctly in the jar file''s manifest file.  Please make sure all required meta information is being set.");
                        } else {
                            URL[] classURLs;
                            String classPath = attributes.getValue("Class-Path");
                            if (WrapperManager.isDebugEnabled()) {
                                m_outDebug.println("Jar Main-Class: " + mainClassName);
                            }
                            if (classPath != null && !classPath.equals("")) {
                                if (WrapperManager.isDebugEnabled()) {
                                    m_outDebug.println(WrapperManager.getRes().getString("Jar Classpath: {0}", classPath));
                                }
                                StringTokenizer st = new StringTokenizer(classPath, " \n\r");
                                classURLs = new URL[st.countTokens() + 1];
                                try {
                                    classURLs[0] = new URL("file:" + file.getAbsolutePath());
                                }
                                catch (MalformedURLException e) {
                                    this.m_initFailed = true;
                                    this.m_initError = WrapperManager.getRes().getString("Unable to add jar to classpath: {0}", e);
                                }
                                if (!this.m_initFailed) {
                                    if (WrapperManager.isDebugEnabled()) {
                                        m_outDebug.println(WrapperManager.getRes().getString("    Classpath[0]=") + classURLs[0]);
                                    }
                                    int i = 1;
                                    while (st.hasMoreTokens()) {
                                        String classEntry = st.nextToken();
                                        try {
                                            classURLs[i] = new URL("file:" + new File(parent, classEntry).getAbsolutePath());
                                        }
                                        catch (MalformedURLException e) {
                                            this.m_initFailed = true;
                                            this.m_initError = WrapperManager.getRes().getString("Malformed classpath in the jar''s manifest file {0} : {1}", args[0], e);
                                        }
                                        if (!this.m_initFailed && WrapperManager.isDebugEnabled()) {
                                            m_outDebug.println(WrapperManager.getRes().getString("    Classpath[{0}]=", new Integer(i)) + classURLs[i]);
                                        }
                                        ++i;
                                    }
                                }
                            } else {
                                if (WrapperManager.isDebugEnabled()) {
                                    m_outDebug.println(WrapperManager.getRes().getString("Jar Classpath: Not specified."));
                                }
                                classURLs = new URL[1];
                                try {
                                    classURLs[0] = new URL("file:" + file.getAbsolutePath());
                                }
                                catch (MalformedURLException e) {
                                    this.m_initFailed = true;
                                    this.m_initError = WrapperManager.getRes().getString("Unable to add jar to classpath: {0}", e);
                                }
                                if (!this.m_initFailed && WrapperManager.isDebugEnabled()) {
                                    m_outDebug.println(WrapperManager.getRes().getString("    Classpath[0]=") + classURLs[0]);
                                }
                            }
                            if (!this.m_initFailed) {
                                Class<?> mainClass;
                                URLClassLoader cl = URLClassLoader.newInstance(classURLs, this.getClass().getClassLoader());
                                try {
                                    mainClass = Class.forName(mainClassName, true, cl);
                                }
                                catch (ClassNotFoundException e) {
                                    this.m_initFailed = true;
                                    this.m_initError = WrapperManager.getRes().getString("Unable to locate the class {0} : {1}", mainClassName, e);
                                    mainClass = null;
                                }
                                catch (ExceptionInInitializerError e) {
                                    this.m_initFailed = true;
                                    this.m_initError = WrapperManager.getRes().getString("Class {0} found but could not be initialized due to:", mainClassName);
                                    this.m_initException = e;
                                    mainClass = null;
                                }
                                catch (LinkageError e) {
                                    this.m_initFailed = true;
                                    this.m_initError = WrapperManager.getRes().getString("Class {0} found but could not be initialized: {1}", mainClassName, e);
                                    mainClass = null;
                                }
                                if (!this.m_initFailed) {
                                    int modifiers;
                                    try {
                                        this.m_mainMethod = mainClass.getMethod("main", String;.class);
                                    }
                                    catch (NoSuchMethodException e) {
                                        this.m_initFailed = true;
                                        this.m_initError = WrapperManager.getRes().getString("Unable to locate a public static main method in class {0} : {1}", args[0], e);
                                    }
                                    catch (SecurityException e) {
                                        this.m_initFailed = true;
                                        this.m_initError = WrapperManager.getRes().getString("Unable to locate a public static main method in class {0} : {1}", args[0], e);
                                    }
                                    if (!(this.m_initFailed || Modifier.isPublic(modifiers = this.m_mainMethod.getModifiers()) && Modifier.isStatic(modifiers))) {
                                        this.m_initFailed = true;
                                        this.m_initError = WrapperManager.getRes().getString("The main method in class {0} must be declared public and static.", args[0]);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            appArgs = new String[args.length - 1];
            System.arraycopy(args, 1, appArgs, 0, appArgs.length);
        }
        WrapperManager.start(this, appArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Throwable t;
        block22: {
            WrapperJarApp wrapperJarApp = this;
            synchronized (wrapperJarApp) {
                this.m_mainStarted = true;
                this.notifyAll();
            }
            t = null;
            try {
                if (WrapperManager.isDebugEnabled()) {
                    m_outDebug.println(WrapperManager.getRes().getString("invoking main method"));
                }
                try {
                    this.m_mainMethod.invoke(null, new Object[]{this.m_appArgs});
                }
                finally {
                    Thread.currentThread().setPriority(10);
                }
                if (WrapperManager.isDebugEnabled()) {
                    m_outDebug.println(WrapperManager.getRes().getString("main method completed"));
                }
                WrapperJarApp wrapperJarApp2 = this;
                synchronized (wrapperJarApp2) {
                    this.m_mainComplete = true;
                    this.notifyAll();
                }
                return;
            }
            catch (IllegalAccessException e) {
                t = e;
            }
            catch (IllegalArgumentException e) {
                t = e;
            }
            catch (InvocationTargetException e) {
                t = e.getTargetException();
                if (t != null) break block22;
                t = e;
            }
        }
        m_outInfo.println();
        m_outError.println(WrapperManager.getRes().getString("Encountered an error running main:"));
        t.printStackTrace(m_outError);
        WrapperJarApp wrapperJarApp = this;
        synchronized (wrapperJarApp) {
            if (this.m_ignoreMainExceptions) {
                if (!this.m_startComplete) {
                    this.m_mainComplete = true;
                    this.notifyAll();
                }
                return;
            }
            if (this.m_startComplete) {
                WrapperManager.stop(1);
                return;
            }
            this.m_mainComplete = true;
            this.m_mainExitCode = new Integer(1);
            this.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer start(String[] args) {
        int maxLoops;
        if (this.m_initFailed) {
            if (this.m_initError != null) {
                m_outError.println(this.m_initError);
            }
            if (this.m_initException != null) {
                this.m_initException.printStackTrace(m_outError);
            }
            if (this.m_initShowUsage) {
                this.showUsage();
            }
            return new Integer(1);
        }
        boolean waitForStartMain = WrapperSystemPropertyUtil.getBooleanProperty(WrapperJarApp.class.getName() + ".waitForStartMain", false);
        this.m_ignoreMainExceptions = WrapperSystemPropertyUtil.getBooleanProperty(WrapperJarApp.class.getName() + ".ignoreMainExceptions", false);
        int maxStartMainWait = WrapperSystemPropertyUtil.getIntProperty(WrapperJarApp.class.getName() + ".maxStartMainWait", 2);
        maxStartMainWait = Math.max(1, maxStartMainWait);
        if (waitForStartMain) {
            maxLoops = Integer.MAX_VALUE;
            if (WrapperManager.isDebugEnabled()) {
                m_outDebug.println(WrapperManager.getRes().getString("start(args) Will wait indefinitely for the main method to complete."));
            }
        } else {
            maxLoops = maxStartMainWait;
            if (WrapperManager.isDebugEnabled()) {
                m_outDebug.println(WrapperManager.getRes().getString("start(args) Will wait up to {0} seconds for the main method to complete.", new Integer(maxLoops)));
            }
        }
        Thread mainThread = new Thread((Runnable)this, "WrapperJarAppMain");
        WrapperJarApp wrapperJarApp = this;
        synchronized (wrapperJarApp) {
            this.m_appArgs = args;
            mainThread.start();
            Thread.currentThread().setPriority(10);
            while (!this.m_mainStarted) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException e) {}
            }
            for (int loops = 0; loops < maxLoops && !this.m_mainComplete; ++loops) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (this.m_mainComplete) continue;
                WrapperManager.signalStarting(5000);
            }
            this.m_startComplete = true;
            if (WrapperManager.isDebugEnabled()) {
                m_outDebug.println(WrapperManager.getRes().getString("start(args) end.  Main Completed={0}, exitCode={1}", new Boolean(this.m_mainComplete), this.m_mainExitCode));
            }
            return this.m_mainExitCode;
        }
    }

    public int stop(int exitCode) {
        if (WrapperManager.isDebugEnabled()) {
            m_outDebug.println("stop(" + exitCode + ")");
        }
        return exitCode;
    }

    public void controlEvent(int event) {
        if (event == 202 && (WrapperManager.isLaunchedAsService() || WrapperManager.isIgnoreUserLogoffs())) {
            m_outInfo.println(WrapperManager.getRes().getString("User logged out.  Ignored."));
        } else {
            if (WrapperManager.isDebugEnabled()) {
                m_outDebug.println(WrapperManager.getRes().getString("controlEvent({0}) Stopping", new Integer(event)));
            }
            WrapperManager.stop(0);
        }
    }

    protected void showUsage() {
        System.out.println();
        System.out.println(WrapperManager.getRes().getString("WrapperJarApp Usage:"));
        System.out.println(WrapperManager.getRes().getString("  java org.tanukisoftware.wrapper.WrapperJarApp {jar_file} [app_arguments]"));
        System.out.println();
        System.out.println(WrapperManager.getRes().getString("Where:"));
        System.out.println(WrapperManager.getRes().getString("  jar_file:       The jar file to run."));
        System.out.println(WrapperManager.getRes().getString("  app_arguments:  The arguments that would normally be passed to the"));
        System.out.println(WrapperManager.getRes().getString("                  application."));
    }

    public static void main(String[] args) {
        new WrapperJarApp(args);
    }
}

