CREATE TABLE [dbo].[acc_antiback](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[change_operator] [nvarchar](50)  NULL,
	[change_time] [datetime] NULL,
	[create_operator] [nvarchar](50)  NULL,
	[create_time] [datetime] NULL,
	[delete_operator] [nvarchar](50)  NULL,
	[delete_time] [datetime] NULL,
	[status] [smallint] NOT NULL CONSTRAINT [default_value_acc_antiback_status]  DEFAULT ('0'),
	[device_id] [int] NULL,
	[one_mode] [bit] NOT NULL CONSTRAINT [default_value_acc_antiback_one_mode]  DEFAULT ('False'),
	[two_mode] [bit] NOT NULL CONSTRAINT [default_value_acc_antiback_two_mode]  DEFAULT ('False'),
	[three_mode] [bit] NOT NULL CONSTRAINT [default_value_acc_antiback_three_mode]  DEFAULT ('False'),
	[four_mode] [bit] NOT NULL CONSTRAINT [default_value_acc_antiback_four_mode]  DEFAULT ('False'),
	[five_mode] [bit] NOT NULL CONSTRAINT [default_value_acc_antiback_five_mode]  DEFAULT ('False'),
	[six_mode] [bit] NOT NULL CONSTRAINT [default_value_acc_antiback_six_mode]  DEFAULT ('False'),
	[seven_mode] [bit] NOT NULL CONSTRAINT [default_value_acc_antiback_seven_mode]  DEFAULT ('False'),
	[eight_mode] [bit] NOT NULL CONSTRAINT [default_value_acc_antiback_eight_mode]  DEFAULT ('False'),
	[nine_mode] [bit] NOT NULL CONSTRAINT [default_value_acc_antiback_nine_mode]  DEFAULT ('False'),
        [AntibackType] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
;

CREATE TABLE [dbo].[acc_door](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[change_operator] [nvarchar](50)  NULL,
	[change_time] [datetime] NULL,
	[create_operator] [nvarchar](50)  NULL,
	[create_time] [datetime] NULL,
	[delete_operator] [nvarchar](50)  NULL,
	[delete_time] [datetime] NULL,
	[status] [int] NOT NULL CONSTRAINT [default_value_acc_door_status]  DEFAULT ('0'),
	[device_id] [int] NULL,
	[door_no] [smallint] NULL,
	[door_name] [nvarchar](30)  NULL CONSTRAINT [default_value_acc_door_door_name]  DEFAULT (''),
	[lock_delay] [int] NULL CONSTRAINT [default_value_acc_door_lock_delay]  DEFAULT ('5'),
	[back_lock] [bit] NOT NULL CONSTRAINT [default_value_acc_door_back_lock]  DEFAULT ('True'),
	[sensor_delay] [int] NULL CONSTRAINT [default_value_acc_door_sensor_delay]  DEFAULT ('15'),
	[opendoor_type] [int] NULL CONSTRAINT [default_value_acc_door_opendoor_type]  DEFAULT ('6'),
	[inout_state] [int] NULL CONSTRAINT [default_value_acc_door_inout_state]  DEFAULT ('0'),
	[lock_active_id] [int] NULL CONSTRAINT [default_value_acc_door_lock_active_id]  DEFAULT ('1'),
	[long_open_id] [int] NULL,
	[wiegand_fmt_id] [int] NULL CONSTRAINT [default_value_acc_door_wiegand_fmt_id]  DEFAULT ('1'),
	[card_intervaltime] [int] NULL CONSTRAINT [default_value_acc_door_card_intervaltime]  DEFAULT ('2'),
	[reader_type] [int] NULL CONSTRAINT [default_value_acc_door_reader_type]  DEFAULT ('0'),
	[is_att] [bit] NOT NULL CONSTRAINT [default_value_acc_door_is_att]  DEFAULT ('False'),
	[force_pwd] [nvarchar](100)  NULL CONSTRAINT [default_value_acc_door_force_pwd]  DEFAULT (''),
	[supper_pwd] [nvarchar](100)  NULL CONSTRAINT [default_value_acc_door_supper_pwd]  DEFAULT (''),
	[door_sensor_status] [int] NULL CONSTRAINT [default_value_acc_door_door_sensor_status]  DEFAULT ('0'),
	[map_id] [int] NULL,
	[duration_apb] [int] NULL,
       [reader_io_state] [int] NULL DEFAULT ('0'),
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
;
ALTER TABLE [dbo].[acc_door]  WITH CHECK ADD CONSTRAINT CK__acc_door__card_intervaltime CHECK  (([card_intervaltime]>=(0)));
ALTER TABLE [dbo].[acc_door]  WITH CHECK ADD CONSTRAINT CK__acc_door__door_no CHECK  (([door_no]>=(0)));
ALTER TABLE [dbo].[acc_door]  WITH CHECK ADD CONSTRAINT CK__acc_door__lock_delay CHECK  (([lock_delay]>=(0)));
ALTER TABLE [dbo].[acc_door]  WITH CHECK ADD CONSTRAINT CK__acc_door__sensor_delay CHECK  (([sensor_delay]>=(0)));


CREATE TABLE [dbo].[acc_firstopen](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[change_operator] [nvarchar](50)  NULL,
	[change_time] [datetime] NULL,
	[create_operator] [nvarchar](50)  NULL,
	[create_time] [datetime] NULL,
	[delete_operator] [nvarchar](50)  NULL,
	[delete_time] [datetime] NULL,
	[status] [int] NOT NULL CONSTRAINT [default_value_acc_firstopen_status]  DEFAULT ('0'),
	[door_id] [int] NULL CONSTRAINT [default_value_acc_firstopen_door_id]  DEFAULT ('1'),
	[timeseg_id] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
;

CREATE TABLE [dbo].[acc_firstopen_emp](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[accfirstopen_id] [int] NULL,
	[employee_id] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY],
UNIQUE NONCLUSTERED 
(
	[accfirstopen_id] ASC,
	[employee_id] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
;

CREATE TABLE [dbo].[acc_holidays](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[change_operator] [nvarchar](50)  NULL,
	[change_time] [datetime] NULL,
	[create_operator] [nvarchar](50)  NULL,
	[create_time] [datetime] NULL,
	[delete_operator] [nvarchar](50)  NULL,
	[delete_time] [datetime] NULL,
	[status] [int] NOT NULL CONSTRAINT [default_value_acc_holidays_status]  DEFAULT ('0'),
	[holiday_name] [nvarchar](30)  NULL CONSTRAINT [default_value_acc_holidays_holiday_name]  DEFAULT (''),
	[holiday_type] [int] NULL CONSTRAINT [default_value_acc_holidays_holiday_type]  DEFAULT ('1'),
	[start_date] [datetime] NOT NULL,
	[end_date] [datetime] NOT NULL,
	[loop_by_year] [int] NULL CONSTRAINT [default_value_acc_holidays_loop_by_year]  DEFAULT ('2'),
	[memo] [nvarchar](70)  NULL CONSTRAINT [default_value_acc_holidays_memo]  DEFAULT (''),
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY],
UNIQUE NONCLUSTERED 
(
	[holiday_name] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
;

CREATE TABLE [dbo].[acc_interlock](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[change_operator] [nvarchar](50)  NULL,
	[change_time] [int] NULL,
	[create_operator] [nvarchar](50)  NULL,
	[create_time] [datetime] NULL,
	[delete_operator] [nvarchar](50)  NULL,
	[delete_time] [datetime] NULL,
	[status] [int] NOT NULL CONSTRAINT [default_value_acc_interlock_status]  DEFAULT ('0'),
	[device_id] [int] NULL,
	[one_mode] [bit] NOT NULL CONSTRAINT [default_value_acc_interlock_one_mode]  DEFAULT ('False'),
	[two_mode] [bit] NOT NULL CONSTRAINT [default_value_acc_interlock_two_mode]  DEFAULT ('False'),
	[three_mode] [bit] NOT NULL CONSTRAINT [default_value_acc_interlock_three_mode]  DEFAULT ('False'),
	[four_mode] [bit] NOT NULL CONSTRAINT [default_value_acc_interlock_four_mode]  DEFAULT ('False'),
	[InterlockType] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY],
UNIQUE NONCLUSTERED 
(
	[device_id] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
;

CREATE TABLE [dbo].[acc_levelset](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[change_operator] [nvarchar](30)  NULL,
	[change_time] [datetime] NULL,
	[create_operator] [nvarchar](30)  NULL,
	[create_time] [datetime] NULL,
	[delete_operator] [nvarchar](30)  NULL,
	[delete_time] [datetime] NULL,
	[status] [smallint] NOT NULL CONSTRAINT [default_value_acc_levelset_status]  DEFAULT ('0'),
	[level_name] [nvarchar](30)  NULL CONSTRAINT [default_value_acc_levelset_level_name]  DEFAULT (''),
	[level_timeseg_id] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY],
UNIQUE NONCLUSTERED 
(
	[level_name] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
;

CREATE TABLE [dbo].[acc_levelset_door_group](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[acclevelset_id] [int] NOT NULL,
	[accdoor_id] [int] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY],
UNIQUE NONCLUSTERED 
(
	[acclevelset_id] ASC,
	[accdoor_id] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
;

CREATE TABLE [dbo].[acc_levelset_emp](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[acclevelset_id] [int] NOT NULL,
	[employee_id] [int] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY],
UNIQUE NONCLUSTERED 
(
	[acclevelset_id] ASC,
	[employee_id] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
;

CREATE TABLE [dbo].[acc_linkageio](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[change_operator] [nvarchar](50)  NULL,
	[change_time] [datetime] NULL,
	[create_operator] [nvarchar](50)  NULL,
	[create_time] [datetime] NULL,
	[delete_operator] [nvarchar](50)  NULL,
	[delete_time] [nvarchar](50)  NULL,
	[status] [int] NULL CONSTRAINT [default_value_acc_linkageio_status]  DEFAULT ('0'),
	[linkage_name] [nvarchar](50)  NULL,
	[device_id] [int] NULL,
	[trigger_opt] [int] NULL CONSTRAINT [default_value_acc_linkageio_trigger_opt]  DEFAULT ('0'),
	[in_address_hide] [int] NULL,
	[in_address] [int] NULL CONSTRAINT [default_value_acc_linkageio_in_address]  DEFAULT ('0'),
	[out_type_hide] [int] NULL,
	[out_address_hide] [int] NULL,
	[out_address] [int] NULL,
	[action_type] [int] NULL,
	[delay_time] [int] NULL CONSTRAINT [default_value_acc_linkageio_action_type]  DEFAULT ('0'),
	[video_linkageio_id] [int] NULL CONSTRAINT [default_value_acc_linkageio_delay_time]  DEFAULT ('20'),
	[lchannel_num] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY],
UNIQUE NONCLUSTERED 
(
	[linkage_name] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
;

CREATE TABLE [dbo].[acc_map](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[change_operator] [nvarchar](50)  NULL,
	[change_time] [datetime] NULL,
	[create_operator] [nvarchar](50)  NULL,
	[create_time] [datetime] NULL,
	[delete_operator] [nvarchar](50)  NULL,
	[delete_time] [datetime] NULL,
	[status] [int] NOT NULL CONSTRAINT [default_value_acc_map_status]  DEFAULT ('0'),
	[map_name] [nvarchar](30)  NULL CONSTRAINT [default_value_acc_map_map_name]  DEFAULT (''),
	[map_path] [nvarchar](max)  NULL,
	[area_id] [int] NULL,
	[width] [int] NULL CONSTRAINT [default_value_acc_map_width]  DEFAULT ('0'),
	[height] [int] NULL CONSTRAINT [default_value_acc_map_height]  DEFAULT ('0'),
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY],
UNIQUE NONCLUSTERED 
(
	[map_name] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
;

CREATE TABLE [dbo].[acc_mapdoorpos](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[change_operator] [nvarchar](50)  NULL,
	[change_time] [datetime] NULL,
	[create_operator] [nvarchar](50)  NULL,
	[create_time] [datetime] NULL,
	[delete_operator] [nvarchar](50)  NULL,
	[delete_time] [datetime] NULL,
	[status] [int] NOT NULL CONSTRAINT [default_value_acc_mapdoorpos_status]  DEFAULT ('0'),
	[map_door_id] [int] NULL,
	[map_id] [int] NULL,
	[width] [int] NULL CONSTRAINT [default_value_acc_mapdoorpos_width]  DEFAULT ('40'),
	[left] [int] NULL,
	[top] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
;

CREATE TABLE [dbo].[acc_monitor_log](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[change_operator] [nvarchar](50)  NULL,
	[change_time] [datetime] NULL,
	[create_operator] [nvarchar](50)  NULL,
	[create_time] [datetime] NULL,
	[delete_operator] [nvarchar](50)  NULL,
	[delete_time] [datetime] NULL,
	[status] [int] NOT NULL CONSTRAINT [default_value_acc_monitor_log_status]  DEFAULT ('0'),
	[log_tag] [int] NULL,
	[time] [datetime] NULL,
	[pin] [nvarchar](50)  NULL,
	[card_no] [nvarchar](50)  NULL,
	[device_id] [int] NULL,
	[device_sn] [nvarchar](50)  NULL,
	[device_name] [nvarchar](50)  NULL,	
	[verified] [int] NULL CONSTRAINT [default_value_acc_monitor_log_verified]  DEFAULT ('200'),
	[state] [int] NULL,
	[event_type] [int] NULL,	
        [description] [nvarchar](200) NULL,
        [event_point_type] [int] NULL DEFAULT ('-1'),
        [event_point_id] [int] NULL DEFAULT ('-1'),
        [event_point_name] [nvarchar](200) NULL,
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY],
 CONSTRAINT [time_pin] UNIQUE NONCLUSTERED 
(
	[time] ASC,
	[pin] ASC,
	[card_no] ASC,
	[device_id] ASC,
	[verified] ASC,
	[state] ASC,
	[event_type] ASC,
        [description] ASC,
        [event_point_type] ASC,
        [event_point_id] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
;

CREATE TABLE [dbo].[acc_morecardempgroup](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[change_operator] [nvarchar](50)  NULL,
	[change_time] [datetime] NULL,
	[create_operator] [nvarchar](50)  NULL,
	[create_time] [datetime] NULL,
	[delete_operator] [nvarchar](50)  NULL,
	[delete_time] [datetime] NULL,
	[status] [int] NOT NULL CONSTRAINT [default_value_acc_morecardempgroup_status]  DEFAULT ('0'),
	[group_name] [nvarchar](50)  NULL,
	[memo] [nvarchar](50)  NULL,
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY],
UNIQUE NONCLUSTERED 
(
	[group_name] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
;

CREATE TABLE [dbo].[acc_morecardgroup](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[change_operator] [nvarchar](50)  NULL,
	[change_time] [datetime] NULL,
	[create_operator] [nvarchar](50)  NULL,
	[create_time] [datetime] NULL,
	[delete_operator] [nvarchar](50)  NULL,
	[delete_time] [datetime] NULL,
	[status] [int] NOT NULL CONSTRAINT [default_value_acc_morecardgroup_status]  DEFAULT ('0'),
	[comb_id] [int] NULL,
	[group_id] [int] NULL,
	[opener_number] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
;

CREATE TABLE [dbo].[acc_morecardset](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[change_operator] [nvarchar](50)  NULL,
	[change_time] [datetime] NULL,
	[create_operator] [nvarchar](50)  NULL,
	[create_time] [datetime] NULL,
	[delete_operator] [nvarchar](50)  NULL,
	[delete_time] [datetime] NULL,
	[status] [int] NOT NULL CONSTRAINT [default_value_acc_morecardset_status]  DEFAULT ('0'),
	[door_id] [int] NULL,
	[comb_name] [nvarchar](50)  NULL,
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY],
UNIQUE NONCLUSTERED 
(
	[comb_name] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
;

CREATE TABLE [dbo].[acc_timeseg](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[change_operator] [nvarchar](50)  NULL,
	[change_time] [datetime] NULL,
	[create_operator] [nvarchar](50)  NULL,
	[create_time] [datetime] NULL,
	[delete_operator] [nvarchar](50)  NULL,
	[delete_time] [datetime] NULL,
	[status] [int] NOT NULL CONSTRAINT [default_value_acc_timeseg_status]  DEFAULT ('0'),
	[timeseg_name] [nvarchar](50)  NULL,
	[memo] [nvarchar](70)  NULL CONSTRAINT [default_value_acc_timeseg_memo]  DEFAULT (''),
	[sunday_start1] [datetime] NOT NULL CONSTRAINT [default_value_acc_timeseg_sunday_start1]  DEFAULT ('00:00'),
	[sunday_end1] [datetime] NULL DEFAULT ('00:00'),
	[sunday_start2] [datetime] NULL DEFAULT ('00:00'),
	[sunday_end2] [datetime] NULL DEFAULT ('00:00'),
	[sunday_start3] [datetime] NULL DEFAULT ('00:00'),
	[sunday_end3] [datetime] NULL DEFAULT ('00:00'),
	[monday_start1] [datetime] NULL DEFAULT ('00:00'),
	[monday_end1] [datetime] NULL DEFAULT ('00:00'),
	[monday_start2] [datetime] NULL DEFAULT ('00:00'),
	[monday_end2] [datetime] NULL DEFAULT ('00:00'),
	[monday_start3] [datetime] NULL DEFAULT ('00:00'),
	[monday_end3] [datetime] NULL DEFAULT ('00:00'),
	[tuesday_start1] [datetime] NULL DEFAULT ('00:00'),
	[tuesday_end1] [datetime] NULL DEFAULT ('00:00'),
	[tuesday_start2] [datetime] NULL DEFAULT ('00:00'),
	[tuesday_end2] [datetime] NULL DEFAULT ('00:00'),
	[tuesday_start3] [datetime] NULL DEFAULT ('00:00'),
	[tuesday_end3] [datetime] NULL DEFAULT ('00:00'),
	[wednesday_start1] [datetime] NULL DEFAULT ('00:00'),
	[wednesday_end1] [datetime] NULL DEFAULT ('00:00'),
	[wednesday_start2] [datetime] NULL DEFAULT ('00:00'),
	[wednesday_end2] [datetime] NULL DEFAULT ('00:00'),
	[wednesday_start3] [datetime] NULL DEFAULT ('00:00'),
	[wednesday_end3] [datetime] NULL DEFAULT ('00:00'),
	[thursday_start1] [datetime] NULL DEFAULT ('00:00'),
	[thursday_end1] [datetime] NULL DEFAULT ('00:00'),
	[thursday_start2] [datetime] NULL DEFAULT ('00:00'),
	[thursday_end2] [datetime] NULL DEFAULT ('00:00'),
	[thursday_start3] [datetime] NULL DEFAULT ('00:00'),
	[thursday_end3] [datetime] NULL DEFAULT ('00:00'),
	[friday_start1] [datetime] NULL DEFAULT ('00:00'),
	[friday_end1] [datetime] NULL DEFAULT ('00:00'),
	[friday_start2] [datetime] NULL DEFAULT ('00:00'),
	[friday_end2] [datetime] NULL DEFAULT ('00:00'),
	[friday_start3] [datetime] NULL DEFAULT ('00:00'),
	[friday_end3] [datetime] NULL DEFAULT ('00:00'),
	[saturday_start1] [datetime] NULL DEFAULT ('00:00'),
	[saturday_end1] [datetime] NULL DEFAULT ('00:00'),
	[saturday_start2] [datetime] NULL DEFAULT ('00:00'),
	[saturday_end2] [datetime] NULL DEFAULT ('00:00'),
	[saturday_start3] [datetime] NULL DEFAULT ('00:00'),
	[saturday_end3] [datetime] NULL DEFAULT ('00:00'),
	[holidaytype1_start1] [datetime] NULL DEFAULT ('00:00'),
	[holidaytype1_end1] [datetime] NULL DEFAULT ('00:00'),
	[holidaytype1_start2] [datetime] NULL DEFAULT ('00:00'),
	[holidaytype1_end2] [datetime] NULL DEFAULT ('00:00'),
	[holidaytype1_start3] [datetime] NULL DEFAULT ('00:00'),
	[holidaytype1_end3] [datetime] NULL DEFAULT ('00:00'),
	[holidaytype2_start1] [datetime] NULL DEFAULT ('00:00'),
	[holidaytype2_end1] [datetime] NULL DEFAULT ('00:00'),
	[holidaytype2_start2] [datetime] NULL DEFAULT ('00:00'),
	[holidaytype2_end2] [datetime] NULL DEFAULT ('00:00'),
	[holidaytype2_start3] [datetime] NULL DEFAULT ('00:00'),
	[holidaytype2_end3] [datetime] NULL DEFAULT ('00:00'),
	[holidaytype3_start1] [datetime] NULL DEFAULT ('00:00'),
	[holidaytype3_end1] [datetime] NULL DEFAULT ('00:00'),
	[holidaytype3_start2] [datetime] NULL DEFAULT ('00:00'),
	[holidaytype3_end2] [datetime] NULL DEFAULT ('00:00'),
	[holidaytype3_start3] [datetime] NULL DEFAULT ('00:00'),
	[holidaytype3_end3] [datetime] NULL DEFAULT ('00:00'),
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY],
UNIQUE NONCLUSTERED 
(
	[timeseg_name] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
;

CREATE TABLE [dbo].[acc_wiegandfmt](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[change_operator] [nvarchar](50)  NULL,
	[change_time] [datetime] NULL,
	[create_operator] [nvarchar](50)  NULL,
	[create_time] [datetime] NULL,
	[delete_operator] [nvarchar](50)  NULL,
	[delete_time] [datetime] NULL,
	[status] [int] NULL,
	[wiegand_name] [nvarchar](30)  NOT NULL CONSTRAINT [default_value_acc_wiegandfmt_wiegand_name]  DEFAULT (''),
	[wiegand_count] [int] NULL,
	[odd_start] [int] NULL,
	[odd_count] [int] NULL,
	[even_start] [int] NULL,
	[even_count] [int] NULL,
	[cid_start] [int] NULL,
	[cid_count] [int] NULL,
	[comp_start] [int] NULL,
	[comp_count] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
;

CREATE TABLE [dbo].[action_log](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[action_time] [datetime] NULL,
	[user_id] [int] NULL,
	[content_type_id] [int] NULL,
	[object_id] [int] NULL,
	[object_repr] [nvarchar](50)  NULL,
	[action_flag] [int] NULL,
	[change_message] [nvarchar](500)  NULL,
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
;

CREATE TABLE [dbo].[areaadmin](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[user_id] [int] NULL,
	[area_id] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
;

CREATE TABLE [dbo].[AttParam](
	[PARANAME] [nvarchar](20)  NOT NULL,
	[PARATYPE] [nvarchar](2)  NULL,
	[PARAVALUE] [nvarchar](100)  NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[PARANAME] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
;

CREATE TABLE [dbo].[auth_group](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[name] [nvarchar](50)  NULL,
	[Permission] [nvarchar](max)  NULL,
	[Remark] [nvarchar](max)  NULL,
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY],
UNIQUE NONCLUSTERED 
(
	[name] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
;

CREATE TABLE [dbo].[auth_user](
	[id] [int] IDENTITY(1,1) NOT NULL primary key,
	[username] [nvarchar](50)  NULL,
	[password] [nvarchar](50)  NULL,
	[Status] [int] NULL,
	[last_login] [datetime] NULL,
	[RoleID] [int] NULL,
	[Remark] [nvarchar](max)  NULL
) ON [PRIMARY]
;

CREATE TABLE [dbo].[CHECKINOUT](
	[USERID] [int] NOT NULL,
	[CHECKTIME] [datetime] NOT NULL DEFAULT (getdate()),
	[CHECKTYPE] [nvarchar](1)  NULL DEFAULT ('I'),
	[VERIFYCODE] [int] NULL DEFAULT ((0)),
	[SENSORID] [nvarchar](5)  NULL,
	[LOGID] [int] IDENTITY(1,1) NOT NULL,
	[MachineId] [int] NULL,
	[UserExtFmt] [int] NULL,
	[WorkCode] [int] NULL,
	[Memoinfo] [nvarchar](20)  NULL,
	[sn] [nvarchar](20)  NULL,
 CONSTRAINT [USERCHECKTIME1] PRIMARY KEY CLUSTERED 
(
	[USERID] ASC,
	[CHECKTIME] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
;

CREATE TABLE [dbo].[DEPARTMENTS](
	[DEPTID] [int] IDENTITY(1,1) NOT NULL,
	[DEPTNAME] [nvarchar](30)  NULL,
	[SUPDEPTID] [int] NOT NULL DEFAULT ((1)),
	[InheritParentSch] [smallint] NULL DEFAULT ((1)),
	[InheritDeptSch] [smallint] NULL DEFAULT ((1)),
	[InheritDeptSchClass] [smallint] NULL DEFAULT ((1)),
	[AutoSchPlan] [smallint] NULL DEFAULT ((1)),
	[InLate] [smallint] NULL DEFAULT ((1)),
	[OutEarly] [smallint] NULL DEFAULT ((1)),
	[InheritDeptRule] [smallint] NULL DEFAULT ((1)),
	[MinAutoSchInterval] [int] NULL DEFAULT ((24)),
	[RegisterOT] [smallint] NULL DEFAULT ((1)),
	[DefaultSchId] [int] NOT NULL DEFAULT ((1)),
	[ATT] [smallint] NULL DEFAULT ((1)),
	[Holiday] [smallint] NULL DEFAULT ((1)),
	[OverTime] [smallint] NULL DEFAULT ((1)),
	[change_operator] [nvarchar](50)  NULL,
	[change_time] [datetime] NULL,
	[create_operator] [nvarchar](50)  NULL,
	[create_time] [datetime] NULL,
	[delete_operator] [nvarchar](50)  NULL,
	[delete_time] [datetime] NULL,
	[status] [int] NULL,
	[code] [nvarchar](50)  NULL,
	[type] [nvarchar](50)  NULL,
	[invalidate] [datetime] NULL,
 CONSTRAINT [DEPTID] PRIMARY KEY CLUSTERED 
(
	[DEPTID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
;

CREATE TABLE [dbo].[deptadmin](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[user_id] [int] NULL,
	[dept_id] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
;

CREATE TABLE [dbo].[devcmds](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[change_operator] [nvarchar](50)  NULL,
	[change_time] [datetime] NULL,
	[create_operator] [nvarchar](50)  NULL,
	[create_time] [datetime] NULL,
	[delete_operator] [nvarchar](50)  NULL,
	[delete_time] [datetime] NULL,
	[status] [int] NOT NULL CONSTRAINT [default_value_devcmds_status]  DEFAULT ('0'),
	[SN_id] [int] NULL,
	[CmdOperate_id] [int] NULL,
	[CmdContent] [text]  NOT NULL,
	[CmdCommitTime] [datetime] NOT NULL CONSTRAINT [default_value_devcmds_CmdCommitTime]  DEFAULT ('2011-07-15 16:06:23.608000'),
	[CmdTransTime] [datetime] NULL,
	[CmdOverTime] [datetime] NULL,
	[CmdReturn] [int] NULL,
	[CmdReturnContent] [nvarchar](50)  NULL,
	[CmdImmediately] [bit] NOT NULL CONSTRAINT [default_value_devcmds_CmdImmediately]  DEFAULT ('False'),
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
;

CREATE TABLE [dbo].[FaceTemp](
	[TEMPLATEID] [int] IDENTITY(1,1) NOT NULL,
	[USERNO] [nvarchar](24)  NULL,
	[SIZE] [int] NULL DEFAULT ((0)),
	[pin] [int] NULL DEFAULT ((0)),
	[FACEID] [int] NULL DEFAULT ((0)),
	[VALID] [int] NULL DEFAULT ((0)),
	[RESERVE] [int] NULL DEFAULT ((0)),
	[ACTIVETIME] [int] NULL DEFAULT ((0)),
	[VFCOUNT] [int] NULL DEFAULT ((0)),
	[TEMPLATE] [image] NULL,
PRIMARY KEY CLUSTERED 
(
	[TEMPLATEID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
;

CREATE TABLE [dbo].[Machines](
	[ID] [int] IDENTITY(1,1) NOT NULL primary key,
	[MachineAlias] [nvarchar](20)  NULL,
	[ConnectType] [int] NULL,
	[IP] [nvarchar](20)  NULL,
	[SerialPort] [int] NULL DEFAULT ((1)),
	[Port] [int] NULL DEFAULT ('4370'),
	[Baudrate] [int] NULL,
	[MachineNumber] [int] NOT NULL DEFAULT ((1)),
	[IsHost] [bit] NOT NULL,
	[Enabled] [bit] NOT NULL DEFAULT ('True'),
	[CommPassword] [nvarchar](12)  NULL,
	[UILanguage] [smallint] NULL DEFAULT ((-1)),
	[DateFormat] [smallint] NULL DEFAULT ((-1)),
	[InOutRecordWarn] [smallint] NULL DEFAULT ((-1)),
	[Idle] [smallint] NULL DEFAULT ((-1)),
	[Voice] [smallint] NULL DEFAULT ((-1)),
	[managercount] [smallint] NULL DEFAULT ((-1)),
	[usercount] [smallint] NULL DEFAULT ((-1)),
	[fingercount] [smallint] NULL DEFAULT ((-1)),
	[SecretCount] [smallint] NULL DEFAULT ((-1)),
	[FirmwareVersion] [nvarchar](20)  NULL,
	[ProductType] [nvarchar](20)  NULL,
	[LockControl] [smallint] NULL DEFAULT ((-1)),
	[Purpose] [smallint] NULL,
	[ProduceKind] [int] NULL,
	[sn] [nvarchar](20)  NULL,
	[PhotoStamp] [nvarchar](20)  NULL,
	[IsIfChangeConfigServer2] [int] NULL,
	[pushver] [int] NULL,
	[change_operator] [nvarchar](50)  NULL,
	[change_time] [datetime] NULL,
	[create_operator] [nvarchar](50)  NULL,
	[create_time] [datetime] NULL,
	[delete_operator] [nvarchar](50)  NULL,
	[delete_time] [datetime] NULL,
	[status] [int] NULL DEFAULT ((0)),
	[device_type] [int] NULL,
	[last_activity] [datetime] NULL,
	[trans_times] [nvarchar](50)  NULL,
	[TransInterval] [int] NULL,
	[log_stamp] [nvarchar](50)  NULL,
	[oplog_stamp] [image] NULL,
	[photo_stamp] [image] NULL,
	[UpdateDB] [nvarchar](50)  NULL DEFAULT ('1111101000'),
	[device_name] [nvarchar](50)  NULL,
	[transaction_count] [int] NULL,
	[main_time] [nvarchar](50)  NULL,
	[max_user_count] [int] NULL,
	[max_finger_count] [int] NULL,
	[max_attlog_count] [int] NULL,
	[alg_ver] [nvarchar](50)  NULL,
	[flash_size] [nvarchar](50)  NULL,
	[free_flash_size] [nvarchar](50)  NULL,
	[language] [nvarchar](50)  NULL,
	[lng_encode] [nvarchar](50)  NULL DEFAULT ('utf8'),
	[volume] [nvarchar](50)  NULL,
	[is_tft] [nvarchar](50)  NULL,
	[platform] [nvarchar](50)  NULL,
	[brightness] [nvarchar](50)  NULL,
	[oem_vendor] [nvarchar](50)  NULL,
	[city] [nvarchar](50)  NULL,
	[AccFun] [int] NULL DEFAULT ('0'),
	[TZAdj] [int] NULL DEFAULT ('8'),
	[comm_type] [int] NULL,
	[agent_ipaddress] [nvarchar](50)  NULL,
	[subnet_mask] [nvarchar](50)  NULL,
	[gateway] [nvarchar](50)  NULL,
	[area_id] [int] NULL,
	[acpanel_type] [int] NULL DEFAULT ('2'),
	[sync_time] [bit] NOT NULL DEFAULT ('True'),
	[four_to_two] [bit] NOT NULL DEFAULT ('False'),
	[video_login] [nvarchar](50)  NULL,
	[fp_mthreshold] [int] NULL,
	[Fpversion] [int] NULL,
	[max_comm_size] [int] NULL CONSTRAINT [default_value_iclock_max_comm_size]  DEFAULT ('40'),
	[max_comm_count] [int] NULL CONSTRAINT [default_value_iclock_max_comm_count]  DEFAULT ('20'),
	[realtime] [bit] NOT NULL CONSTRAINT [default_value_iclock_realtime]  DEFAULT ('True'),
	[delay] [int] NULL CONSTRAINT [default_value_iclock_delay]  DEFAULT ('10'),
	[encrypt] [bit] NOT NULL CONSTRAINT [default_value_iclock_encrypt]  DEFAULT ('False'),
	[dstime_id] [int] NULL,
	[door_count] [int] NULL,
	[reader_count] [int] NULL,
	[aux_in_count] [int] NULL,
	[aux_out_count] [int] NULL,
	[IsOnlyRFMachine] [int] NULL,
	[alias] [nvarchar](50)  NULL,
	[ipaddress] [nvarchar](50)  NULL,
	[com_port] [smallint] NULL,
	[com_address] [smallint] NULL DEFAULT ('1')
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
;

CREATE TABLE [dbo].[personnel_area](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[change_operator] [nvarchar](50)  NULL,
	[change_time] [datetime] NULL,
	[create_operator] [nvarchar](50)  NULL,
	[create_time] [datetime] NULL,
	[delete_operator] [nvarchar](50)  NULL,
	[delete_time] [datetime] NULL,
	[status] [smallint] NOT NULL CONSTRAINT [default_value_personnel_area_status]  DEFAULT ('0'),
	[areaid] [nvarchar](50)  NULL,
	[areaname] [nvarchar](50)  NULL,
	[parent_id] [int] NULL DEFAULT ((0)),
	[remark] [nvarchar](50)  NULL,
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
;

CREATE TABLE [dbo].[personnel_issuecard](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[change_operator] [nvarchar](50)  NULL,
	[change_time] [datetime] NULL,
	[create_operator] [nvarchar](50)  NULL,
	[create_time] [datetime] NULL,
	[delete_operator] [nvarchar](50)  NULL,
	[delete_time] [datetime] NULL,
	[status] [int] NULL,
	[UserID_id] [int] NULL,
	[cardno] [nvarchar](50)  NULL,
	[effectivenessdate] [datetime] NULL,
	[isvalid] [bit] NOT NULL DEFAULT ('1'),
	[cardpwd] [nvarchar](50)  NULL,
	[failuredate] [datetime] NULL,
	[cardstatus] [nvarchar](50)  NULL DEFAULT ('1'),
	[issuedate] [datetime] NULL DEFAULT ('2011-07-15'),
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
;

CREATE TABLE [dbo].[TEMPLATE](
	[TEMPLATEID] [int] IDENTITY(1,1) NOT NULL,
	[USERID] [int] NOT NULL,
	[FINGERID] [int] NOT NULL DEFAULT ('0'),
	[TEMPLATE] [image] NULL,
	[TEMPLATE2] [image] NULL,
	[BITMAPPICTURE] [image] NULL,
	[BITMAPPICTURE2] [image] NULL,
	[BITMAPPICTURE3] [image] NULL,
	[BITMAPPICTURE4] [image] NULL,
	[USETYPE] [smallint] NULL,
	[EMACHINENUM] [nvarchar](3)  NULL,
	[TEMPLATE1] [image] NULL,
	[Flag] [smallint] NULL,
	[DivisionFP] [smallint] NULL,
	[TEMPLATE4] [image] NULL,
	[TEMPLATE3] [image] NULL,
	[change_operator] [nvarchar](50)  NULL,
	[change_time] [datetime] NULL,
	[create_operator] [nvarchar](50)  NULL,
	[create_time] [datetime] NULL,
	[delete_operator] [nvarchar](50)  NULL,
	[delete_time] [datetime] NULL,
	[status] [int] NULL,
	[Valid] [int] NULL DEFAULT ('1'),
	[Fpversion] [nvarchar](50)  NULL,
	[bio_type] [int] NULL DEFAULT ('0'),
	[SN] [int] NULL,
	[UTime] [datetime] NULL,
PRIMARY KEY CLUSTERED 
(
	[TEMPLATEID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
;

CREATE TABLE [dbo].[USERINFO](
	[USERID] [int] IDENTITY(1,1) NOT NULL,
	[Badgenumber] [nvarchar](50)  NULL,
	[SSN] [nvarchar](20)  NULL,
	[Name] [nvarchar](50)  NULL,
	[Gender] [nvarchar](8)  NULL,
	[TITLE] [nvarchar](20)  NULL,
	[PAGER] [nvarchar](20)  NULL,
	[BIRTHDAY] [datetime] NULL,
	[HIREDDAY] [datetime] NULL,
	[street] [nvarchar](80)  NULL,
	[CITY] [nvarchar](50)  NULL,
	[STATE] [nvarchar](50)  NULL,
	[ZIP] [nvarchar](50)  NULL,
	[OPHONE] [nvarchar](20)  NULL,
	[FPHONE] [nvarchar](20)  NULL,
	[VERIFICATIONMETHOD] [smallint] NULL,
	[DEFAULTDEPTID] [int] NULL DEFAULT ((1)),
	[SECURITYFLAGS] [smallint] NULL,
	[ATT] [smallint] NOT NULL DEFAULT ((1)),
	[INLATE] [smallint] NOT NULL DEFAULT ((1)),
	[OUTEARLY] [smallint] NOT NULL DEFAULT ((1)),
	[OVERTIME] [smallint] NOT NULL DEFAULT ((1)),
	[SEP] [smallint] NOT NULL DEFAULT ((1)),
	[HOLIDAY] [smallint] NOT NULL DEFAULT ((1)),
	[MINZU] [nvarchar](8)  NULL,
	[PASSWORD] [nvarchar](20)  NULL,
	[LUNCHDURATION] [smallint] NULL,
	[PHOTO] [image] NULL,
	[mverifypass] [nvarchar](10)  NULL,
	[Notes] [image] NULL,
	[privilege] [int] NULL DEFAULT ((0)),
	[InheritDeptSch] [smallint] NULL,
	[InheritDeptSchClass] [smallint] NULL,
	[AutoSchPlan] [smallint] NULL DEFAULT ((1)),
	[MinAutoSchInterval] [int] NULL DEFAULT ((24)),
	[RegisterOT] [smallint] NULL DEFAULT ((1)),
	[InheritDeptRule] [smallint] NULL,
	[EMPRIVILEGE] [smallint] NULL,
	[CardNo] [nvarchar](20)  NULL,
	[change_operator] [nvarchar](50)  NULL,
	[change_time] [datetime] NULL,
	[create_operator] [nvarchar](50)  NULL,
	[create_time] [datetime] NULL,
	[delete_operator] [nvarchar](50)  NULL,
	[delete_time] [datetime] NULL,
	[status] [int] NULL DEFAULT ('0'),
	[lastname] [nvarchar](50)  NULL,
	[AccGroup] [int] NULL,
	[TimeZones] [nvarchar](50)  NULL,
	[identitycard] [nvarchar](50)  NULL,
	[UTime] [datetime] NULL,
	[Education] [nvarchar](50)  NULL,
	[OffDuty] [int] NULL,
	[DelTag] [int] NULL,
	[morecard_group_id] [int] NULL,
	[set_valid_time] [bit] NULL,
	[acc_startdate] [datetime] NULL,
	[acc_enddate] [datetime] NULL,
	[birthplace] [nvarchar](50)  NULL,
	[Political] [nvarchar](50)  NULL,
	[contry] [nvarchar](50)  NULL,
	[hiretype] [int] NULL,
	[email] [nvarchar](50)  NULL,
	[firedate] [datetime] NULL,
	[isatt] [bit] NULL,
	[homeaddress] [nvarchar](50)  NULL,
	[emptype] [int] NULL,
	[bankcode1] [nvarchar](50)  NULL,
	[bankcode2] [nvarchar](50)  NULL,
	[isblacklist] [int] NULL,
	[Iuser1] [int] NULL,
	[Iuser2] [int] NULL,
	[Iuser3] [int] NULL,
	[Iuser4] [int] NULL,
	[Iuser5] [int] NULL,
	[Cuser1] [nvarchar](50)  NULL,
	[Cuser2] [nvarchar](50)  NULL,
	[Cuser3] [nvarchar](50)  NULL,
	[Cuser4] [nvarchar](50)  NULL,
	[Cuser5] [nvarchar](50)  NULL,
	[Duser1] [datetime] NULL,
	[Duser2] [datetime] NULL,
	[Duser3] [datetime] NULL,
	[Duser4] [datetime] NULL,
	[Duser5] [datetime] NULL,
PRIMARY KEY CLUSTERED 
(
	[USERID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
;


insert into departments(deptname,supdeptid,code) values('CompanyName',0,'1');

insert into personnel_area(areaid,areaname,parent_id) values('1','AreaName',0);
insert into acc_timeseg(timeseg_name,sunday_start1,sunday_end1,sunday_start2,sunday_end2,sunday_start3,sunday_end3,monday_start1,monday_end1,monday_start2,monday_end2,monday_start3,monday_end3,tuesday_start1,tuesday_end1,tuesday_start2,tuesday_end2,tuesday_start3,tuesday_end3,wednesday_start1,wednesday_end1,wednesday_start2,wednesday_end2,wednesday_start3,wednesday_end3,thursday_start1,thursday_end1,thursday_start2,thursday_end2,thursday_start3,thursday_end3,friday_start1,friday_end1,friday_start2,friday_end2,friday_start3,friday_end3,saturday_start1,saturday_end1,saturday_start2,saturday_end2,saturday_start3,saturday_end3,holidaytype1_start1,holidaytype1_end1,holidaytype1_start2,holidaytype1_end2,holidaytype1_start3,holidaytype1_end3,holidaytype2_start1,holidaytype2_end1,holidaytype2_start2,holidaytype2_end2,holidaytype2_start3,holidaytype2_end3,holidaytype3_start1,holidaytype3_end1,holidaytype3_start2,holidaytype3_end2,holidaytype3_start3,holidaytype3_end3) values('24-Hour-Accessible','00:00','23:59','00:00','00:00','00:00','00:00','00:00','23:59','00:00','00:00','00:00','00:00','00:00','23:59','00:00','00:00','00:00','00:00','00:00','23:59','00:00','00:00','00:00','00:00','00:00','23:59','00:00','00:00','00:00','00:00','00:00','23:59','00:00','00:00','00:00','00:00','00:00','23:59','00:00','00:00','00:00','00:00','00:00','23:59','00:00','00:00','00:00','00:00','00:00','23:59','00:00','00:00','00:00','00:00','00:00','23:59','00:00','00:00','00:00','00:00');
