/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class LinkedList<E>
extends AbstractSequentialList<E>
implements List<E>,
Deque<E>,
Cloneable,
Serializable {
    transient int size = 0;
    transient Node<E> first;
    transient Node<E> last;
    private static final long serialVersionUID = 876323262645176354L;

    public LinkedList() {
    }

    public LinkedList(Collection<? extends E> collection) {
        this();
        this.addAll(collection);
    }

    private void linkFirst(E e) {
        Node<E> node = this.first;
        Node<E> node2 = new Node<E>(null, e, node);
        this.first = node2;
        if (node == null) {
            this.last = node2;
        } else {
            node.prev = node2;
        }
        ++this.size;
        ++this.modCount;
    }

    void linkLast(E e) {
        Node<E> node = this.last;
        Node<E> node2 = new Node<E>(node, e, null);
        this.last = node2;
        if (node == null) {
            this.first = node2;
        } else {
            node.next = node2;
        }
        ++this.size;
        ++this.modCount;
    }

    void linkBefore(E e, Node<E> node) {
        Node node2 = node.prev;
        Node node3 = new Node(node2, e, node);
        node.prev = node3;
        if (node2 == null) {
            this.first = node3;
        } else {
            node2.next = node3;
        }
        ++this.size;
        ++this.modCount;
    }

    private E unlinkFirst(Node<E> node) {
        Object e = node.item;
        Node node2 = node.next;
        node.item = null;
        node.next = null;
        this.first = node2;
        if (node2 == null) {
            this.last = null;
        } else {
            node2.prev = null;
        }
        --this.size;
        ++this.modCount;
        return e;
    }

    private E unlinkLast(Node<E> node) {
        Object e = node.item;
        Node node2 = node.prev;
        node.item = null;
        node.prev = null;
        this.last = node2;
        if (node2 == null) {
            this.first = null;
        } else {
            node2.next = null;
        }
        --this.size;
        ++this.modCount;
        return e;
    }

    E unlink(Node<E> node) {
        Object e = node.item;
        Node node2 = node.next;
        Node node3 = node.prev;
        if (node3 == null) {
            this.first = node2;
        } else {
            node3.next = node2;
            node.prev = null;
        }
        if (node2 == null) {
            this.last = node3;
        } else {
            node2.prev = node3;
            node.next = null;
        }
        node.item = null;
        --this.size;
        ++this.modCount;
        return e;
    }

    @Override
    public E getFirst() {
        Node<E> node = this.first;
        if (node == null) {
            throw new NoSuchElementException();
        }
        return node.item;
    }

    @Override
    public E getLast() {
        Node<E> node = this.last;
        if (node == null) {
            throw new NoSuchElementException();
        }
        return node.item;
    }

    @Override
    public E removeFirst() {
        Node<E> node = this.first;
        if (node == null) {
            throw new NoSuchElementException();
        }
        return this.unlinkFirst(node);
    }

    @Override
    public E removeLast() {
        Node<E> node = this.last;
        if (node == null) {
            throw new NoSuchElementException();
        }
        return this.unlinkLast(node);
    }

    @Override
    public void addFirst(E e) {
        this.linkFirst(e);
    }

    @Override
    public void addLast(E e) {
        this.linkLast(e);
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean add(E e) {
        this.linkLast(e);
        return true;
    }

    @Override
    public boolean remove(Object object) {
        if (object == null) {
            Node<E> node = this.first;
            while (node != null) {
                if (node.item == null) {
                    this.unlink(node);
                    return true;
                }
                node = node.next;
            }
        } else {
            Node<E> node = this.first;
            while (node != null) {
                if (object.equals(node.item)) {
                    this.unlink(node);
                    return true;
                }
                node = node.next;
            }
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        return this.addAll(this.size, collection);
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        Node<Object> node;
        Node<E> node2;
        this.checkPositionIndex(n);
        Object[] objectArray = collection.toArray();
        int n2 = objectArray.length;
        if (n2 == 0) {
            return false;
        }
        if (n == this.size) {
            node2 = null;
            node = this.last;
        } else {
            node2 = this.node(n);
            node = node2.prev;
        }
        Object[] objectArray2 = objectArray;
        int n3 = objectArray2.length;
        for (int i = 0; i < n3; ++i) {
            Object object;
            Object object2 = object = objectArray2[i];
            Node<Object> node3 = new Node<Object>(node, object2, null);
            if (node == null) {
                this.first = node3;
            } else {
                node.next = node3;
            }
            node = node3;
        }
        if (node2 == null) {
            this.last = node;
        } else {
            node.next = node2;
            node2.prev = node;
        }
        this.size += n2;
        ++this.modCount;
        return true;
    }

    @Override
    public void clear() {
        Node<E> node = this.first;
        while (node != null) {
            Node node2 = node.next;
            node.item = null;
            node.next = null;
            node.prev = null;
            node = node2;
        }
        this.last = null;
        this.first = null;
        this.size = 0;
        ++this.modCount;
    }

    @Override
    public E get(int n) {
        this.checkElementIndex(n);
        return this.node((int)n).item;
    }

    @Override
    public E set(int n, E e) {
        this.checkElementIndex(n);
        Node<E> node = this.node(n);
        Object e2 = node.item;
        node.item = e;
        return e2;
    }

    @Override
    public void add(int n, E e) {
        this.checkPositionIndex(n);
        if (n == this.size) {
            this.linkLast(e);
        } else {
            this.linkBefore(e, this.node(n));
        }
    }

    @Override
    public E remove(int n) {
        this.checkElementIndex(n);
        return this.unlink(this.node(n));
    }

    private boolean isElementIndex(int n) {
        return n >= 0 && n < this.size;
    }

    private boolean isPositionIndex(int n) {
        return n >= 0 && n <= this.size;
    }

    private String outOfBoundsMsg(int n) {
        return "Index: " + n + ", Size: " + this.size;
    }

    private void checkElementIndex(int n) {
        if (!this.isElementIndex(n)) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(n));
        }
    }

    private void checkPositionIndex(int n) {
        if (!this.isPositionIndex(n)) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(n));
        }
    }

    Node<E> node(int n) {
        if (n < this.size >> 1) {
            Node<E> node = this.first;
            for (int i = 0; i < n; ++i) {
                node = node.next;
            }
            return node;
        }
        Node<E> node = this.last;
        for (int i = this.size - 1; i > n; --i) {
            node = node.prev;
        }
        return node;
    }

    @Override
    public int indexOf(Object object) {
        int n = 0;
        if (object == null) {
            Node<E> node = this.first;
            while (node != null) {
                if (node.item == null) {
                    return n;
                }
                ++n;
                node = node.next;
            }
        } else {
            Node<E> node = this.first;
            while (node != null) {
                if (object.equals(node.item)) {
                    return n;
                }
                ++n;
                node = node.next;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        int n = this.size;
        if (object == null) {
            Node<E> node = this.last;
            while (node != null) {
                --n;
                if (node.item == null) {
                    return n;
                }
                node = node.prev;
            }
        } else {
            Node<E> node = this.last;
            while (node != null) {
                --n;
                if (object.equals(node.item)) {
                    return n;
                }
                node = node.prev;
            }
        }
        return -1;
    }

    @Override
    public E peek() {
        Node<E> node = this.first;
        return node == null ? null : (E)node.item;
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public E poll() {
        Node<E> node = this.first;
        return node == null ? null : (E)this.unlinkFirst(node);
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public boolean offer(E e) {
        return this.add(e);
    }

    @Override
    public boolean offerFirst(E e) {
        this.addFirst(e);
        return true;
    }

    @Override
    public boolean offerLast(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public E peekFirst() {
        Node<E> node = this.first;
        return node == null ? null : (E)node.item;
    }

    @Override
    public E peekLast() {
        Node<E> node = this.last;
        return node == null ? null : (E)node.item;
    }

    @Override
    public E pollFirst() {
        Node<E> node = this.first;
        return node == null ? null : (E)this.unlinkFirst(node);
    }

    @Override
    public E pollLast() {
        Node<E> node = this.last;
        return node == null ? null : (E)this.unlinkLast(node);
    }

    @Override
    public void push(E e) {
        this.addFirst(e);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public boolean removeFirstOccurrence(Object object) {
        return this.remove(object);
    }

    @Override
    public boolean removeLastOccurrence(Object object) {
        if (object == null) {
            Node<E> node = this.last;
            while (node != null) {
                if (node.item == null) {
                    this.unlink(node);
                    return true;
                }
                node = node.prev;
            }
        } else {
            Node<E> node = this.last;
            while (node != null) {
                if (object.equals(node.item)) {
                    this.unlink(node);
                    return true;
                }
                node = node.prev;
            }
        }
        return false;
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        this.checkPositionIndex(n);
        return new ListItr(n);
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new DescendingIterator();
    }

    private LinkedList<E> superClone() {
        try {
            return (LinkedList)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Object clone() {
        LinkedList linkedList = this.superClone();
        linkedList.last = null;
        linkedList.first = null;
        linkedList.size = 0;
        linkedList.modCount = 0;
        Node<E> node = this.first;
        while (node != null) {
            linkedList.add(node.item);
            node = node.next;
        }
        return linkedList;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.size];
        int n = 0;
        Node<E> node = this.first;
        while (node != null) {
            objectArray[n++] = node.item;
            node = node.next;
        }
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        if (objectArray.length < this.size) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.size);
        }
        int n = 0;
        T[] TArray = objectArray;
        Node<E> node = this.first;
        while (node != null) {
            TArray[n++] = node.item;
            node = node.next;
        }
        if (objectArray.length > this.size) {
            objectArray[this.size] = null;
        }
        return objectArray;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        Node<E> node = this.first;
        while (node != null) {
            objectOutputStream.writeObject(node.item);
            node = node.next;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            this.linkLast(objectInputStream.readObject());
        }
    }

    private class DescendingIterator
    implements Iterator<E> {
        private final ListItr itr;

        private DescendingIterator() {
            this.itr = new ListItr(LinkedList.this.size());
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasPrevious();
        }

        @Override
        public E next() {
            return this.itr.previous();
        }

        @Override
        public void remove() {
            this.itr.remove();
        }
    }

    private class ListItr
    implements ListIterator<E> {
        private Node<E> lastReturned = null;
        private Node<E> next;
        private int nextIndex;
        private int expectedModCount;

        ListItr(int n) {
            this.expectedModCount = LinkedList.this.modCount;
            this.next = n == LinkedList.this.size ? null : LinkedList.this.node(n);
            this.nextIndex = n;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < LinkedList.this.size;
        }

        @Override
        public E next() {
            this.checkForComodification();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next;
            this.next = this.next.next;
            ++this.nextIndex;
            return this.lastReturned.item;
        }

        @Override
        public boolean hasPrevious() {
            return this.nextIndex > 0;
        }

        @Override
        public E previous() {
            this.checkForComodification();
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.next = this.next == null ? LinkedList.this.last : this.next.prev;
            this.lastReturned = this.next;
            --this.nextIndex;
            return this.lastReturned.item;
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex - 1;
        }

        @Override
        public void remove() {
            this.checkForComodification();
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            Node node = this.lastReturned.next;
            LinkedList.this.unlink(this.lastReturned);
            if (this.next == this.lastReturned) {
                this.next = node;
            } else {
                --this.nextIndex;
            }
            this.lastReturned = null;
            ++this.expectedModCount;
        }

        @Override
        public void set(E e) {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            this.lastReturned.item = e;
        }

        @Override
        public void add(E e) {
            this.checkForComodification();
            this.lastReturned = null;
            if (this.next == null) {
                LinkedList.this.linkLast(e);
            } else {
                LinkedList.this.linkBefore(e, this.next);
            }
            ++this.nextIndex;
            ++this.expectedModCount;
        }

        final void checkForComodification() {
            if (LinkedList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private static class Node<E> {
        E item;
        Node<E> next;
        Node<E> prev;

        Node(Node<E> node, E e, Node<E> node2) {
            this.item = e;
            this.next = node2;
            this.prev = node;
        }
    }
}

