/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.BuiltInProperties;
import com.sun.deploy.config.ClientConfig;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.Platform;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.VersionID;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;

public class SecurityBaseline {
    private static String baseline_131 = "1.3.1_21";
    private static String baseline_142 = "1.4.2_43";
    private static String baseline_150 = "1.5.0_61";
    private static String baseline_160 = "1.6.0_71";
    private static String baseline_170 = "1.7.0_51";
    private static String baseline_180 = "1.8.0";
    private static volatile boolean baselines_initialized = false;
    private static final boolean DEBUG = Config.getBooleanProperty("deployment.baseline.debug");
    private static final long UPDATE_INTERVAL = DEBUG ? 10000 : 86400000;
    private static final long THREAD_SLEEP_INTERVAL = DEBUG ? 1000 : 30000;
    private static final String BASELINE_FILENAME = "baseline.versions";
    private static final String UPDATE_TIMESTAMP = "update.timestamp";
    private static final File securityDir = new File(Config.getUserHome(), "security");
    private static final File baselineFile = new File(securityDir, "baseline.versions");
    private static final File blacklistFile = new File(Config.getDynamicBlacklistFile());
    private static final File blacklistCertsFile = new File(Config.getDynamicBlacklistCertsFile());
    private static final File updateTimestampFile = new File(securityDir, "update.timestamp");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void initialize_baselines() {
        block20: {
            if (!baselines_initialized && baselineFile.exists()) {
                BufferedReader bufferedReader;
                block19: {
                    bufferedReader = null;
                    long l = System.currentTimeMillis();
                    bufferedReader = new BufferedReader(new FileReader(baselineFile));
                    boolean bl = false;
                    while (!bl) {
                        String string = bufferedReader.readLine();
                        if (string == null) {
                            bl = true;
                            continue;
                        }
                        if (string.startsWith("1.8")) {
                            baseline_180 = string;
                            Platform.get().cacheSecurityBaseline("1.8.0", baseline_180);
                            continue;
                        }
                        if (string.startsWith("1.7")) {
                            baseline_170 = string;
                            Platform.get().cacheSecurityBaseline("1.7.0", baseline_170);
                            continue;
                        }
                        if (string.startsWith("1.6")) {
                            baseline_160 = string;
                            Platform.get().cacheSecurityBaseline("1.6.0", baseline_160);
                            continue;
                        }
                        if (string.startsWith("1.5")) {
                            baseline_150 = string;
                            Platform.get().cacheSecurityBaseline("1.5.0", baseline_150);
                            continue;
                        }
                        if (string.startsWith("1.4.2")) {
                            baseline_142 = string;
                            Platform.get().cacheSecurityBaseline("1.4.2", baseline_142);
                            continue;
                        }
                        if (!string.startsWith("1.3.1")) continue;
                        baseline_131 = string;
                        Platform.get().cacheSecurityBaseline("1.3.1", baseline_131);
                    }
                    if (!DEBUG) break block19;
                    Trace.println("It took " + (System.currentTimeMillis() - l) + " Ms. to read baseline file", TraceLevel.BASIC);
                }
                Object var6_5 = null;
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    break block20;
                }
                catch (IOException iOException) {
                    Trace.ignored(iOException);
                }
                break block20;
                {
                    catch (Exception exception) {
                        Trace.ignored(exception);
                        Object var6_6 = null;
                        try {
                            if (bufferedReader != null) {
                                bufferedReader.close();
                            }
                            break block20;
                        }
                        catch (IOException iOException) {
                            Trace.ignored(iOException);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                    }
                    catch (IOException iOException) {
                        Trace.ignored(iOException);
                    }
                    throw throwable;
                }
            }
        }
        baselines_initialized = true;
    }

    public static String getBaselineVersion(String string) {
        if (!baselines_initialized) {
            SecurityBaseline.initialize_baselines();
        }
        String string2 = string.startsWith("1.8") ? baseline_180 : (string.startsWith("1.7") ? baseline_170 : (string.startsWith("1.6") ? baseline_160 : (string.startsWith("1.5") ? baseline_150 : (string.startsWith("1.4.2") ? baseline_142 : (string.startsWith("1.3.1") ? baseline_131 : "1.7.0_51")))));
        if (DEBUG) {
            Trace.println("for requested version: " + string + "baseline version is: " + string2, TraceLevel.SECURITY);
        }
        return string2;
    }

    public static boolean satisfiesSecurityBaseline(String string) {
        if (!Config.isExpirationCheckEnabled()) {
            return true;
        }
        VersionID versionID = new VersionID(string);
        VersionID versionID2 = new VersionID(SecurityBaseline.getBaselineVersion(string));
        if (versionID.isGreaterThanOrEqual(versionID2)) {
            return true;
        }
        return versionID.equals(JREInfo.getLatestVersion(true));
    }

    public static boolean satisfiesBaselineStrictly(String string) {
        return SecurityBaseline.satisfiesBaselineStrictly(string, SecurityBaseline.getBaselineVersion(string));
    }

    public static boolean satisfiesBaselineStrictly(String string, String string2) {
        if (!Config.isExpirationCheckEnabled()) {
            return true;
        }
        int n = (string = string.replace(".ea", "-ea")).indexOf("-");
        String string3 = n > 0 ? string.substring(0, n) : string;
        VersionID versionID = new VersionID(string3);
        VersionID versionID2 = new VersionID(string2);
        boolean bl = versionID.isGreaterThanOrEqual(versionID2);
        if (DEBUG) {
            Trace.println("strictly satisfied=" + bl + "  for version: " + string + "  baseline is: " + SecurityBaseline.getBaselineVersion(string));
        }
        return bl;
    }

    public static String getDeployVersion() {
        return "10.51.2.13";
    }

    public static String getDeployNoBuildVersion() {
        return "10.51.2";
    }

    public static String getDeployNoDotVersion() {
        return "10512";
    }

    public static String getCurrentVersion() {
        return "1.7.0_51";
    }

    public static String getCurrentNoDotVersion() {
        return "170";
    }

    private static synchronized void checkForUpdates(boolean bl) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                if (SecurityBaseline.checkForUpdate(Config.getStringProperty("deployment.baseline.url"), baselineFile)) {
                    Config config;
                    baselines_initialized = false;
                    SecurityBaseline.initialize_baselines();
                    if (SecurityBaseline.isExpired() && (config = Config.get()) instanceof ClientConfig) {
                        ((ClientConfig)config).storeConfig();
                    }
                }
            }
        });
        thread.setDaemon(!bl);
        thread.start();
        Thread thread2 = new Thread(new Runnable(){

            public void run() {
                SecurityBaseline.checkForUpdate(Config.getStringProperty("deployment.blacklist.url"), blacklistFile);
            }
        });
        thread2.setDaemon(!bl);
        thread2.start();
        Thread thread3 = new Thread(new Runnable(){

            public void run() {
                SecurityBaseline.checkForUpdate(Config.getStringProperty("deployment.blacklisted.certs.url"), blacklistCertsFile);
            }
        });
        thread3.setDaemon(!bl);
        thread3.start();
        try {
            thread.join();
            thread2.join();
            thread3.join();
            SecurityBaseline.setLastChecked(new Date().getTime());
        }
        catch (InterruptedException interruptedException) {
            Trace.ignored(interruptedException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean checkForUpdate(String var0, File var1_1) {
        if (var0 == null) return false;
        if (var0.length() <= 0) return false;
        var2_2 = 0L;
        var4_3 = 0L;
        if (var1_1.exists()) {
            var2_2 = var1_1.lastModified();
        }
        var6_4 = null;
        var7_5 = null;
        try {
            Trace.println("Checking for update at: " + var0, TraceLevel.NETWORK);
            var8_6 = new URL(var0);
            var9_8 = var8_6.openConnection();
            var9_8.setUseCaches(false);
            var4_3 = var9_8.getLastModified();
            if (var4_3 < var2_2) ** GOTO lbl87
            Trace.println("Updating file at: " + var1_1 + " from url: " + var0, TraceLevel.NETWORK);
            var6_4 = var9_8.getInputStream();
            var7_5 = new FileOutputStream(var1_1);
            var10_9 = new byte[8192];
            while ((var11_10 = var6_4.read(var10_9)) != -1) {
                var7_5.write(var10_9, 0, var11_10);
            }
            var12_11 = true;
            var14_12 = null;
            if (var7_5 == null) ** GOTO lbl80
            ** GOTO lbl71
        }
        catch (Exception var8_7) {
            Trace.ignored(var8_7);
            var14_14 = null;
            if (var7_5 != null) {
                try {
                    var7_5.close();
                }
                catch (Exception var15_18) {
                    Trace.ignored(var15_18);
                }
                if (var4_3 > 0L) {
                    var1_1.setLastModified(var4_3);
                }
            }
            if (var6_4 == null) return false;
            try {
                var6_4.close();
                return false;
            }
            catch (Exception var15_18) {
                Trace.ignored(var15_18);
                return false;
            }
        }
        {
            block27: {
                block28: {
                    block26: {
                        catch (Throwable var13_20) {
                            block24: {
                                block25: {
                                    var14_15 = null;
                                    if (var7_5 == null) break block24;
                                    ** try [egrp 2[TRYBLOCK] [5 : 224->232)] { 
lbl55:
                                    // 1 sources

                                    var7_5.close();
                                    break block25;
lbl57:
                                    // 1 sources

                                    catch (Exception var15_19) {
                                        Trace.ignored(var15_19);
                                    }
                                }
                                if (var4_3 > 0L) {
                                    var1_1.setLastModified(var4_3);
                                }
                            }
                            if (var6_4 == null) throw var13_20;
                            ** try [egrp 3[TRYBLOCK] [6 : 258->266)] { 
lbl66:
                            // 1 sources

                            var6_4.close();
                            throw var13_20;
lbl68:
                            // 1 sources

                            catch (Exception var15_19) {
                                Trace.ignored(var15_19);
                            }
                            throw var13_20;
                        }
lbl71:
                        // 1 sources

                        ** try [egrp 2[TRYBLOCK] [5 : 224->232)] { 
lbl72:
                        // 1 sources

                        var7_5.close();
                        break block26;
lbl74:
                        // 1 sources

                        catch (Exception var15_16) {
                            Trace.ignored(var15_16);
                        }
                    }
                    if (var4_3 > 0L) {
                        var1_1.setLastModified(var4_3);
                    }
lbl80:
                    // 4 sources

                    if (var6_4 == null) return var12_11;
                    try {}
                    catch (Exception var15_16) {
                        Trace.ignored(var15_16);
                        return var12_11;
                    }
                    var6_4.close();
                    return var12_11;
lbl87:
                    // 1 sources

                    var14_13 = null;
                    if (var7_5 == null) break block27;
                    ** try [egrp 2[TRYBLOCK] [5 : 224->232)] { 
lbl90:
                    // 1 sources

                    var7_5.close();
                    break block28;
lbl92:
                    // 1 sources

                    catch (Exception var15_17) {
                        Trace.ignored(var15_17);
                    }
                }
                if (var4_3 > 0L) {
                    var1_1.setLastModified(var4_3);
                }
            }
            if (var6_4 == null) return false;
            try {}
            catch (Exception var15_17) {}
            Trace.ignored(var15_17);
            return false;
            var6_4.close();
            return false;
        }
    }

    private static long getLastChecked() {
        if (updateTimestampFile.exists()) {
            return updateTimestampFile.lastModified();
        }
        return 0L;
    }

    private static void setLastChecked(long l) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(updateTimestampFile);
            ((OutputStream)fileOutputStream).write(46);
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void backgroundUpdate() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                long l = new Date().getTime();
                if (l > SecurityBaseline.getLastChecked() + UPDATE_INTERVAL) {
                    try {
                        Thread.sleep(THREAD_SLEEP_INTERVAL);
                        SecurityBaseline.checkForUpdates(false);
                    }
                    catch (Exception exception) {
                        Trace.ignored(exception);
                    }
                }
                if (DEBUG) {
                    Trace.println("Baseline/Blacklist thread exiting time: " + (new Date().getTime() - l), TraceLevel.BASIC);
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    public static void forceBaselineUpdate() {
        SecurityBaseline.checkForUpdates(true);
        SecurityBaseline.initialize_baselines();
    }

    public static boolean isExpired() {
        Comparable<Date> comparable;
        if (!Config.isExpirationCheckEnabled()) {
            return false;
        }
        if (Config.isJavaVersionAtLeast15() && (comparable = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (System.getenv("JRE_NOTEXPIRED") != null) {
                    return Boolean.FALSE;
                }
                if (System.getenv("JRE_EXPIRED") != null) {
                    return Boolean.TRUE;
                }
                return null;
            }
        })) != null) {
            return (Boolean)comparable;
        }
        comparable = new Date(BuiltInProperties.expirationTime);
        if (((Date)comparable).before(new Date())) {
            return true;
        }
        return !SecurityBaseline.satisfiesBaselineStrictly(JREInfo.getLatest());
    }

    static {
        securityDir.mkdirs();
        SecurityBaseline.backgroundUpdate();
    }
}

