/*
 * Decompiled with CFR 0.152.
 */
package com.zk.util;

import com.zk.util.ConfigFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xvolks.jnative.JNative;
import org.xvolks.jnative.Type;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.MemoryBlockFactory;

public class LicenseUtil {
    private static int hcommpro = 0;

    public LicenseUtil() {
        hcommpro = 0;
    }

    public static String getCRC16(String serialNum) {
        return LicenseUtil.getCrc16FromSN(serialNum);
    }

    public static String createCRC16(String companyName) {
        String result;
        block12: {
            JNative checkNative = null;
            Pointer companyNamePtr = null;
            result = null;
            try {
                try {
                    companyNamePtr = new Pointer(MemoryBlockFactory.createMemoryBlock((int)512));
                    companyNamePtr.setMemory(companyName.getBytes("UTF-8"));
                    checkNative = new JNative("checklic.dll", "ZKCrc16");
                    checkNative.setRetVal(Type.INT);
                    checkNative.setParameter(0, companyNamePtr);
                    checkNative.setParameter(1, Type.INT, String.valueOf(companyName.length()));
                    checkNative.invoke();
                    result = checkNative.getRetVal();
                }
                catch (Exception e) {
                    result = "-1";
                    if (checkNative == null) break block12;
                    try {
                        companyNamePtr.dispose();
                        checkNative.dispose();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (checkNative != null) {
                    try {
                        companyNamePtr.dispose();
                        checkNative.dispose();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return result;
    }

    public static String createUPK(byte[] UPK, String serialNum) throws NativeException, IllegalAccessException {
        String upkStr;
        block8: {
            JNative checkNative = null;
            Pointer upkPtr = null;
            Pointer serialNumPtr = null;
            upkStr = null;
            try {
                try {
                    serialNumPtr = new Pointer(MemoryBlockFactory.createMemoryBlock((int)1024));
                    upkPtr = new Pointer(MemoryBlockFactory.createMemoryBlock((int)1024));
                    serialNumPtr.setMemory(serialNum);
                    checkNative = new JNative("checklic.dll", "ZKCheckLicense");
                    String lenSerialNum = String.valueOf(serialNum.length());
                    checkNative.setRetVal(Type.INT);
                    checkNative.setParameter(0, serialNumPtr);
                    checkNative.setParameter(1, Type.INT, lenSerialNum);
                    checkNative.setParameter(2, upkPtr);
                    checkNative.invoke();
                    hcommpro = checkNative.getRetValAsInt();
                    if (hcommpro > 1) {
                        upkStr = upkPtr.getAsString();
                        break block8;
                    }
                    upkStr = "";
                }
                catch (Exception e) {
                    upkStr = "1";
                    if (checkNative != null) {
                        upkPtr.dispose();
                        serialNumPtr.dispose();
                        checkNative.dispose();
                    }
                }
            }
            finally {
                if (checkNative != null) {
                    upkPtr.dispose();
                    serialNumPtr.dispose();
                    checkNative.dispose();
                }
            }
        }
        return upkStr;
    }

    public static String getCrc16FromSN(String serialNum) {
        String CompanyNameCrc16;
        block13: {
            JNative checkNative = null;
            Pointer serialNumPtr = null;
            Pointer licInfoPtr = null;
            int result = -1;
            CompanyNameCrc16 = "";
            try {
                try {
                    serialNumPtr = new Pointer(MemoryBlockFactory.createMemoryBlock((int)serialNum.length()));
                    serialNumPtr.setMemory(serialNum);
                    licInfoPtr = new Pointer(MemoryBlockFactory.createMemoryBlock((int)1024));
                    checkNative = new JNative("checklic.dll", "ZKGetLicenseInfoEx");
                    String lenSerialNum = String.valueOf(serialNum.length());
                    checkNative.setRetVal(Type.INT);
                    checkNative.setParameter(0, serialNumPtr);
                    checkNative.setParameter(1, Type.INT, lenSerialNum);
                    checkNative.setParameter(2, licInfoPtr);
                    checkNative.setParameter(3, Type.INT, String.valueOf(1024));
                    checkNative.invoke();
                    result = checkNative.getRetValAsInt();
                    if (result == 1) {
                        String[] params = licInfoPtr.getAsString().split("\\t");
                        CompanyNameCrc16 = params[params.length - 1].split("=")[1];
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (checkNative == null) break block13;
                    try {
                        serialNumPtr.dispose();
                        checkNative.dispose();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (checkNative != null) {
                    try {
                        serialNumPtr.dispose();
                        checkNative.dispose();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return CompanyNameCrc16;
    }

    public static Map<String, Integer> checkByLicense(String licenseStr) {
        JNative checkNative = null;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        Pointer licensePtr = null;
        Pointer licInfoPtr = null;
        try {
            try {
                licensePtr = new Pointer(MemoryBlockFactory.createMemoryBlock((int)licenseStr.length()));
                licensePtr.setMemory(licenseStr);
                licInfoPtr = new Pointer(MemoryBlockFactory.createMemoryBlock((int)1024));
                checkNative = new JNative("checklic.dll", "ZKGetLicenseInfoEx");
                checkNative.setRetVal(Type.INT);
                checkNative.setParameter(0, licensePtr);
                checkNative.setParameter(1, Type.INT, String.valueOf(licenseStr.length()));
                checkNative.setParameter(2, licInfoPtr);
                checkNative.setParameter(3, Type.INT, String.valueOf(1024));
                checkNative.invoke();
                String[] params = licInfoPtr.getAsString().split("\t");
                int i = 0;
                while (i < params.length) {
                    if (params[i].contains("LicenseID")) {
                        map.put("licenseId", Integer.parseInt(params[i].split("=")[1]));
                    } else if (params[i].contains("Major")) {
                        map.put("major", Integer.parseInt(params[i].split("=")[1]));
                    } else if (params[i].contains("Minor")) {
                        map.put("minor", Integer.parseInt(params[i].split("=")[1]));
                    } else if (params[i].contains("LicenseType")) {
                        map.put("licenseType", Integer.parseInt(params[i].split("=")[1]));
                    } else if (params[i].contains("LimitNumberOfDays")) {
                        map.put("dayNum", Integer.parseInt(params[i].split("=")[1]));
                    } else if (params[i].contains("Module") && !params[i].contains("CountModule")) {
                        map.put("limitModule", Integer.parseInt(params[i].split("=")[1]));
                    } else if (params[i].contains("CountModule")) {
                        map.put("limitDevices", Integer.parseInt(params[i].split("=")[1]));
                    } else if (params[i].contains("ProductCode")) {
                        map.put("productCode", Integer.parseInt(params[i].split("=")[1]));
                    } else if (params[i].contains("CompanyNameCrc16")) {
                        map.put("companyNameCrc16", Integer.parseInt(params[i].split("=")[1]));
                    }
                    ++i;
                }
                map.put("retVal", checkNative.getRetVal() == "" ? -1 : Integer.parseInt(checkNative.getRetVal()));
            }
            catch (Exception e) {
                HashMap<String, Integer> hashMap = map;
                if (checkNative != null) {
                    try {
                        licensePtr.dispose();
                        checkNative.dispose();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
                return hashMap;
            }
        }
        finally {
            if (checkNative != null) {
                try {
                    licensePtr.dispose();
                    checkNative.dispose();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return map;
    }

    public static Map<String, Integer> checkLicenseLegal(String licenseStr) {
        JNative checkNative = null;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        Pointer licensePtr = null;
        Pointer upkPtr = null;
        try {
            try {
                licensePtr = new Pointer(MemoryBlockFactory.createMemoryBlock((int)licenseStr.length()));
                licensePtr.setMemory(licenseStr);
                upkPtr = new Pointer(MemoryBlockFactory.createMemoryBlock((int)1024));
                checkNative = new JNative("checklic.dll", "ZKCheckLicense");
                checkNative.setRetVal(Type.INT);
                checkNative.setParameter(0, licensePtr);
                checkNative.setParameter(1, Type.INT, String.valueOf(licenseStr.length()));
                checkNative.setParameter(2, upkPtr);
                checkNative.invoke();
                map.put("retVal", checkNative.getRetVal() == "" ? -1 : Integer.parseInt(checkNative.getRetVal()));
            }
            catch (Exception e) {
                HashMap<String, Integer> hashMap = map;
                if (checkNative != null) {
                    try {
                        licensePtr.dispose();
                        checkNative.dispose();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
                return hashMap;
            }
        }
        finally {
            if (checkNative != null) {
                try {
                    licensePtr.dispose();
                    checkNative.dispose();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return map;
    }

    public static Map<String, String> getLicenseNum() {
        HashMap<String, String> retMap = new HashMap<String, String>();
        List<String> modelList = LicenseUtil.getLicModel();
        int i = 0;
        while (i < modelList.size()) {
            String ret = ConfigFile.getValue(1, "license_info", modelList.get(i));
            if (ret != null && !"".equals(ret)) {
                retMap.put(modelList.get(i), ret);
            } else {
                retMap.put(modelList.get(i), "");
            }
            ++i;
        }
        return retMap;
    }

    public static Map<String, Map<String, Map<String, Integer>>> getLicenseInfo() {
        HashMap<String, Map<String, Map<String, Integer>>> licenseMap = new HashMap<String, Map<String, Map<String, Integer>>>();
        HashMap moduleMap = new HashMap();
        HashMap<String, Integer> subMap = new HashMap<String, Integer>();
        int accDevCount = 0;
        int accModelLicensed = 0;
        int vidChanelCount = 0;
        int vidModelLicensed = 0;
        int visModelOpen = 0;
        int visModelLicensed = 0;
        int eleModelOpen = 0;
        int eleModelLicensed = 0;
        int parkModelOpen = 0;
        int parkModelLicensed = 0;
        int accAdvancedModelOpen = 0;
        int accAdvancedModelLicensed = 0;
        int modelId = 0;
        Map<String, String> licNumMap = LicenseUtil.getLicenseNum();
        for (String licNumKey : licNumMap.keySet()) {
            String licNum = licNumMap.get(licNumKey);
            if (licNum != null && !"".equals(licNum)) {
                try {
                    Map<String, Integer> licenseInfoMap;
                    Map<String, Integer> checkLicMap = LicenseUtil.checkLicenseLegal(licNum);
                    if (checkLicMap.get("retVal") > 0 && (modelId = (licenseInfoMap = LicenseUtil.checkByLicense(licNum)).get("limitModule").intValue()) != 0) {
                        if ("acc_license".equals(licNumKey)) {
                            accDevCount = licenseInfoMap.get("limitDevices");
                            accModelLicensed = 1;
                        } else if ("vid_license".equals(licNumKey)) {
                            vidChanelCount = licenseInfoMap.get("limitDevices");
                            vidModelLicensed = 1;
                        } else if ("vis_license".equals(licNumKey)) {
                            visModelOpen = 1;
                            visModelLicensed = 1;
                        } else if ("ele_license".equals(licNumKey)) {
                            eleModelOpen = 1;
                            eleModelLicensed = 1;
                        } else if ("park_license".equals(licNumKey)) {
                            parkModelOpen = 1;
                            parkModelLicensed = 1;
                        } else if ("accadvanced_license".equals(licNumKey)) {
                            accAdvancedModelOpen = 1;
                            accAdvancedModelLicensed = 1;
                        }
                    }
                    subMap.put("controlCount", accDevCount);
                    subMap.put("modelLicensed", accModelLicensed);
                    moduleMap.put("acc", subMap);
                    subMap = new HashMap();
                    subMap.put("controlCount", vidChanelCount);
                    subMap.put("modelLicensed", vidModelLicensed);
                    moduleMap.put("vid", subMap);
                    subMap = new HashMap();
                    subMap.put("controlCount", visModelOpen);
                    subMap.put("modelLicensed", visModelLicensed);
                    moduleMap.put("vis", subMap);
                    subMap = new HashMap();
                    subMap.put("controlCount", eleModelOpen);
                    subMap.put("modelLicensed", eleModelLicensed);
                    moduleMap.put("ele", subMap);
                    subMap = new HashMap();
                    subMap.put("controlCount", parkModelOpen);
                    subMap.put("modelLicensed", parkModelLicensed);
                    moduleMap.put("park", subMap);
                    subMap = new HashMap();
                    subMap.put("controlCount", accAdvancedModelOpen);
                    subMap.put("modelLicensed", accAdvancedModelLicensed);
                    moduleMap.put("accAdvanced", subMap);
                    subMap = new HashMap();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            subMap.put("controlCount", accDevCount);
            subMap.put("modelLicensed", accModelLicensed);
            moduleMap.put("acc", subMap);
            subMap = new HashMap();
            subMap.put("controlCount", vidChanelCount);
            subMap.put("modelLicensed", vidModelLicensed);
            moduleMap.put("vid", subMap);
            subMap = new HashMap();
            subMap.put("controlCount", visModelOpen);
            subMap.put("modelLicensed", visModelLicensed);
            moduleMap.put("vis", subMap);
            subMap = new HashMap();
            subMap.put("controlCount", eleModelOpen);
            subMap.put("modelLicensed", eleModelLicensed);
            moduleMap.put("ele", subMap);
            subMap = new HashMap();
            subMap.put("controlCount", parkModelOpen);
            subMap.put("modelLicensed", parkModelLicensed);
            moduleMap.put("park", subMap);
            subMap = new HashMap();
            subMap.put("controlCount", accAdvancedModelOpen);
            subMap.put("modelLicensed", accAdvancedModelLicensed);
            moduleMap.put("accAdvanced", subMap);
            subMap = new HashMap();
        }
        licenseMap.put("moduleList", moduleMap);
        return licenseMap;
    }

    public static List<String> getLicModel() {
        ArrayList<String> modelList = new ArrayList<String>();
        modelList.add("acc_license");
        modelList.add("vid_license");
        modelList.add("ele_license");
        modelList.add("vis_license");
        modelList.add("park_license");
        modelList.add("accadvanced_license");
        return modelList;
    }

    public static String getModel(int key) {
        String[] modelArray = new String[]{"acc_license", "vid_license", "ele_license", "vis_license", "park_license", "accadvanced_license"};
        return modelArray[key - 1];
    }
}

