/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.BFILE;
import oracle.sql.Datum;

class BfileAccessor
extends Accessor {
    static final int maxLength = 530;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Feb_23_16:42:12_PST_2010";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    BfileAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl) throws SQLException {
        this.init(oracleStatement, 114, 114, s2, bl);
        this.initForDataAccess(n3, n2, null);
    }

    BfileAccessor(OracleStatement oracleStatement, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, short s2) throws SQLException {
        this.init(oracleStatement, 114, 114, s2, false);
        this.initForDescribe(114, n2, bl, n3, n4, n5, n6, n7, s2, null);
        this.initForDataAccess(0, n2, null);
    }

    @Override
    void initForDataAccess(int n2, int n3, String string) throws SQLException {
        if (n2 != 0) {
            this.externalType = n2;
        }
        this.internalTypeMaxLength = 530;
        if (n3 > 0 && n3 < this.internalTypeMaxLength) {
            this.internalTypeMaxLength = n3;
        }
        this.byteLength = this.internalTypeMaxLength;
    }

    @Override
    Object getObject(int n2) throws SQLException {
        return this.getBFILE(n2);
    }

    @Override
    Object getObject(int n2, Map map) throws SQLException {
        return this.getBFILE(n2);
    }

    @Override
    Datum getOracleObject(int n2) throws SQLException {
        return this.getBFILE(n2);
    }

    @Override
    BFILE getBFILE(int n2) throws SQLException {
        BFILE bFILE = null;
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            int n3 = this.columnIndex + this.byteLength * n2;
            short s2 = this.rowSpaceIndicator[this.lengthIndex + n2];
            byte[] byArray = new byte[s2];
            System.arraycopy(this.rowSpaceByte, n3, byArray, 0, s2);
            bFILE = new BFILE(this.statement.connection, byArray);
            if (this.lobPrefetchSizeForThisColumn != -1) {
                bFILE.setLength(this.prefetchedLobSize[n2]);
            }
        }
        return bFILE;
    }

    @Override
    InputStream getAsciiStream(int n2) throws SQLException {
        BFILE bFILE = this.getBFILE(n2);
        if (bFILE == null) {
            return null;
        }
        return bFILE.asciiStreamValue();
    }

    @Override
    Reader getCharacterStream(int n2) throws SQLException {
        BFILE bFILE = this.getBFILE(n2);
        if (bFILE == null) {
            return null;
        }
        return bFILE.characterStreamValue();
    }

    @Override
    InputStream getBinaryStream(int n2) throws SQLException {
        BFILE bFILE = this.getBFILE(n2);
        if (bFILE == null) {
            return null;
        }
        return bFILE.getBinaryStream();
    }

    @Override
    byte[] privateGetBytes(int n2) throws SQLException {
        return super.getBytes(n2);
    }

    @Override
    byte[] getBytes(int n2) throws SQLException {
        BFILE bFILE = this.getBFILE(n2);
        if (bFILE == null) {
            return null;
        }
        InputStream inputStream = bFILE.getBinaryStream();
        int n3 = 4096;
        int n4 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n3);
        byte[] byArray = new byte[n3];
        try {
            while ((n4 = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n4);
            }
        }
        catch (IOException iOException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 151);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return byteArrayOutputStream.toByteArray();
    }
}

