/*
 * Decompiled with CFR 0.152.
 */
package com.zk.util;

import com.zk.util.BaseDBBackupUtil;
import com.zk.util.ConfigFile;
import com.zk.util.DBBackupTread;
import com.zk.util.DBRestoreTread;
import com.zk.util.NewActionListener;
import com.zk.util.PreRestoreDBUtil;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Random;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;

public class ProgressBarRestore
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private JProgressBar progressBar;
    private JButton startButton;
    private JTextArea taskOutput;
    private Task task;
    private ResourceBundle res;
    private String result = "";
    private boolean restore = true;

    public ProgressBarRestore(String tip) {
        super(new BorderLayout());
        this.startButton = new JButton(tip);
        this.startButton.setActionCommand("start");
        this.startButton.addActionListener(this);
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setPreferredSize(new Dimension(363, 25));
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.taskOutput = new JTextArea(7, 32);
        this.taskOutput.setMargin(new Insets(5, 5, 5, 5));
        this.taskOutput.setEditable(false);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.startButton.setEnabled(false);
        this.task = new Task();
        this.task.addPropertyChangeListener(this);
        this.task.execute();
        this.taskOutput.setText("");
        this.restore = false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress" == evt.getPropertyName()) {
            int progress = (Integer)evt.getNewValue();
            this.progressBar.setValue(progress);
            this.prinitTask(String.format(this.res.getString("frame4.dailog15.content"), this.task.getProgress()));
        }
    }

    private void prinitTask(String content) {
        if (content == null || "".equals(content)) {
            return;
        }
        if (this.taskOutput.getText() != null && !"".equals(this.taskOutput.getText())) {
            content = "\n" + content;
        }
        this.taskOutput.append(content);
        this.taskOutput.scrollRectToVisible(new Rectangle(0, this.taskOutput.getHeight() + 12, 0, 0));
    }

    public void setRes(ResourceBundle res) {
        this.res = res;
    }

    public boolean isRestore() {
        return this.restore;
    }

    public JButton getStartButton() {
        return this.startButton;
    }

    public void setStartButton(JButton startButton) {
        this.startButton = startButton;
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void setProgressBar(JProgressBar progressBar) {
        this.progressBar = progressBar;
    }

    public JTextArea getTaskOutput() {
        return this.taskOutput;
    }

    public void setTaskOutput(JTextArea taskOutput) {
        this.taskOutput = taskOutput;
    }

    class Task
    extends SwingWorker<Void, Void> {
        private int progress = 0;

        Task() {
        }

        @Override
        public Void doInBackground() {
            if (!BaseDBBackupUtil.isServer()) {
                JOptionPane.showMessageDialog(null, ProgressBarRestore.this.res.getString("frame4.dailog17.content"));
                ProgressBarRestore.this.restore = true;
                return null;
            }
            if (NewActionListener.dbBackupTxtFile != null && !"".equals(NewActionListener.dbBackupTxtFile)) {
                int choice;
                String str = NewActionListener.dbBackupTxtFile;
                String dbtype = ConfigFile.getValue(0, "options", "dbtype");
                if (dbtype.equals("mysql") && !str.toLowerCase().endsWith(".sql")) {
                    JOptionPane.showMessageDialog(null, ProgressBarRestore.this.res.getString("frame4.dialog1.content"));
                    ProgressBarRestore.this.restore = true;
                    return null;
                }
                if (dbtype.equals("sqlserver") && !str.toLowerCase().endsWith(".bak")) {
                    JOptionPane.showMessageDialog(null, ProgressBarRestore.this.res.getString("frame4.dialog1.content"));
                    ProgressBarRestore.this.restore = true;
                    return null;
                }
                if (dbtype.equals("oracle") && !str.toLowerCase().endsWith(".dmp")) {
                    JOptionPane.showMessageDialog(null, ProgressBarRestore.this.res.getString("frame4.dialog1.content"));
                    ProgressBarRestore.this.restore = true;
                    return null;
                }
                int result = PreRestoreDBUtil.canRestore(NewActionListener.dbBackupTxtFile);
                if (result == NewActionListener.RESTOREDB_STATE_HIGH) {
                    JOptionPane.showMessageDialog(null, ProgressBarRestore.this.res.getString("frame4.dialog2.content"));
                    ProgressBarRestore.this.restore = true;
                    return null;
                }
                if (result == NewActionListener.RESTOREDB_STATE_LOW) {
                    JOptionPane.showMessageDialog(null, ProgressBarRestore.this.res.getString("frame4.dialog3.content"));
                    ProgressBarRestore.this.restore = true;
                    return null;
                }
                if (result == -1 && (choice = JOptionPane.showConfirmDialog(null, ProgressBarRestore.this.res.getString("frame4.dailog5.content"), "", 0)) != 0) {
                    ProgressBarRestore.this.restore = true;
                    return null;
                }
            } else {
                JOptionPane.showMessageDialog(null, ProgressBarRestore.this.res.getString("frame4.dialog1.content"));
                ProgressBarRestore.this.restore = true;
                return null;
            }
            Random random = new Random();
            this.setProgress(0);
            DBRestoreTread dbRestoreTread = new DBRestoreTread();
            DBBackupTread dbBackupTread = new DBBackupTread();
            dbBackupTread.setRes(ProgressBarRestore.this.res);
            dbRestoreTread.setRes(ProgressBarRestore.this.res);
            dbBackupTread.start();
            boolean backup = false;
            boolean finish = false;
            while (this.progress < 50) {
                try {
                    Thread.sleep(random.nextInt(1000));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!dbBackupTread.isAlive()) {
                    backup = true;
                    ProgressBarRestore.this.result = dbBackupTread.getResult();
                    ProgressBarRestore.this.prinitTask(ProgressBarRestore.this.result);
                    this.progress = 50;
                    this.setProgress(50);
                    dbRestoreTread.start();
                    break;
                }
                if (dbBackupTread.isAlive() && dbBackupTread.getInteraction() < 0) {
                    try {
                        while (dbBackupTread.getInteraction() == -1) {
                            Thread.sleep(500L);
                        }
                        if (dbBackupTread.getInteraction() == -2) {
                            finish = true;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.progress >= 49) continue;
                this.progress += random.nextInt(10);
                if (this.progress >= 49) {
                    this.progress = 49;
                }
                this.setProgress(Math.min(this.progress, 49));
            }
            if (!finish) {
                while (this.progress < 100) {
                    try {
                        Thread.sleep(random.nextInt(1000));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (backup && !dbRestoreTread.isAlive()) {
                        this.progress = 100;
                        this.setProgress(100);
                        ProgressBarRestore.this.result = dbRestoreTread.getResult();
                        ProgressBarRestore.this.restore = true;
                    }
                    if (this.progress >= 99) continue;
                    this.progress += random.nextInt(10);
                    if (this.progress >= 99) {
                        this.progress = 99;
                    }
                    this.setProgress(Math.min(this.progress, 99));
                }
            } else {
                ProgressBarRestore.this.prinitTask(ProgressBarRestore.this.res.getString("frame4.dailog16.content"));
                ProgressBarRestore.this.restore = true;
            }
            return null;
        }

        public void setUpProgress(int progress) {
            this.progress = progress;
        }

        @Override
        public void done() {
            if (this.progress != 0) {
                Toolkit.getDefaultToolkit().beep();
                ProgressBarRestore.this.prinitTask(ProgressBarRestore.this.result);
            }
            ProgressBarRestore.this.startButton.setEnabled(true);
        }
    }
}

