/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.com.typebrowser.gui.panels;

import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JTable;

public class TableColumnAdjuster
implements ComponentListener {
    private JTable table;
    int oldWidth = -1;
    int oldHeight = -1;

    public TableColumnAdjuster(JTable table) {
        if (table.getParent() == null) {
            throw new IllegalStateException("add table to JScrollPane before constructing TableColumnAdjuster");
        }
        table.getParent().getParent().addComponentListener(this);
        this.table = table;
        table.setAutoResizeMode(0);
        this.adjustColumns();
    }

    public void componentResized(ComponentEvent e) {
        if (this.oldWidth == this.table.getParent().getWidth() && this.oldHeight == this.table.getParent().getHeight()) {
            return;
        }
        this.adjustColumns();
        this.oldWidth = this.table.getParent().getWidth();
        this.oldHeight = this.table.getParent().getHeight();
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    private void adjustColumns() {
        int averageWidth = this.table.getParent().getWidth() / this.table.getColumnCount();
        for (int c = 0; c < this.table.getColumnCount(); ++c) {
            this.table.getColumnModel().getColumn(c).setPreferredWidth(averageWidth);
            this.table.getColumnModel().getColumn(c).setWidth(averageWidth);
        }
    }
}

