/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.util;

import org.xvolks.jnative.JNative;
import org.xvolks.jnative.Type;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.BITMAP;
import org.xvolks.jnative.misc.BITMAPINFOHEADER;
import org.xvolks.jnative.misc.POINT;
import org.xvolks.jnative.misc.basicStructures.DC;
import org.xvolks.jnative.misc.basicStructures.DWORD;
import org.xvolks.jnative.misc.basicStructures.LONG;
import org.xvolks.jnative.pointers.NullPointer;
import org.xvolks.jnative.pointers.Pointer;

public class Gdi32 {
    public static final String DLL_NAME = "Gdi32.dll";
    public static final int DIB_RGB_COLORS = 0;
    public static final int SRCCOPY = 0xCC0020;
    public static final int PS_SOLID = 0;
    public static final int PS_DASH = 1;
    public static final int PS_DOT = 2;
    public static final int PS_DASHDOT = 3;
    public static final int PS_DASHDOTDOT = 4;
    public static final int PS_NULL = 5;
    public static final int PS_USERSTYLE = 7;
    public static final int PS_INSIDEFRAME = 6;

    public static LONG GetStockObject(int fnObject) throws NativeException, IllegalAccessException {
        JNative getStockObject = new JNative(DLL_NAME, "GetStockObject");
        getStockObject.setRetVal(Type.INT);
        getStockObject.setParameter(0, fnObject);
        getStockObject.invoke();
        return new LONG(getStockObject.getRetValAsInt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int GetObject(int handle, int size, BITMAP info) throws NativeException, IllegalAccessException {
        int n;
        block2: {
            JNative GetObject = new JNative(DLL_NAME, "GetObjectA");
            try {
                GetObject.setRetVal(Type.INT);
                GetObject.setParameter(0, handle);
                GetObject.setParameter(1, size);
                GetObject.setParameter(2, info.getPointer());
                GetObject.invoke();
                n = GetObject.getRetValAsInt();
                Object var6_5 = null;
                if (GetObject == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var6_6 = null;
                    if (GetObject == null) break block3;
                    GetObject.dispose();
                }
                throw throwable;
            }
            GetObject.dispose();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean DeleteDC(DC hdc) throws NativeException, IllegalAccessException {
        boolean bl;
        block2: {
            JNative DeleteDC = new JNative(DLL_NAME, "DeleteDC");
            try {
                DeleteDC.setRetVal(Type.INT);
                DeleteDC.setParameter(0, hdc.getValue());
                DeleteDC.invoke();
                bl = DeleteDC.getRetValAsInt() != 0;
                Object var4_3 = null;
                if (DeleteDC == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var4_4 = null;
                    if (DeleteDC == null) break block3;
                    DeleteDC.dispose();
                }
                throw throwable;
            }
            DeleteDC.dispose();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DC CreateCompatibleDC(DC hdc) throws NativeException, IllegalAccessException {
        DC dC;
        block2: {
            JNative CreateCompatibleDC = new JNative(DLL_NAME, "CreateCompatibleDC");
            try {
                CreateCompatibleDC.setRetVal(Type.INT);
                CreateCompatibleDC.setParameter(0, hdc.getValue());
                CreateCompatibleDC.invoke();
                dC = new DC(CreateCompatibleDC.getRetValAsInt());
                Object var4_3 = null;
                if (CreateCompatibleDC == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var4_4 = null;
                    if (CreateCompatibleDC == null) break block3;
                    CreateCompatibleDC.dispose();
                }
                throw throwable;
            }
            CreateCompatibleDC.dispose();
        }
        return dC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int GetDIBits(DC hdc, int hbmp, int uStartScan, int cScanLines, Pointer lpvBits, BITMAPINFOHEADER lpbi, int uUsage) throws NativeException, IllegalAccessException {
        int n;
        block2: {
            JNative GetDIBits = new JNative(DLL_NAME, "GetDIBits");
            try {
                GetDIBits.setRetVal(Type.INT);
                int i = 0;
                GetDIBits.setParameter(i++, hdc.getValue());
                GetDIBits.setParameter(i++, hbmp);
                GetDIBits.setParameter(i++, uStartScan);
                GetDIBits.setParameter(i++, cScanLines);
                GetDIBits.setParameter(i++, lpvBits);
                GetDIBits.setParameter(i++, lpbi.getPointer());
                GetDIBits.setParameter(i++, uUsage);
                GetDIBits.invoke();
                n = GetDIBits.getRetValAsInt();
                Object var11_10 = null;
                if (GetDIBits == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var11_11 = null;
                    if (GetDIBits == null) break block3;
                    GetDIBits.dispose();
                }
                throw throwable;
            }
            GetDIBits.dispose();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean BitBlt(DC hdcDest, int nXDest, int nYDest, int nWidth, int nHeight, DC hdcSrc, int nXSrc, int nYSrc, int dwRop) throws NativeException, IllegalAccessException {
        boolean bl;
        block2: {
            JNative BitBlt = new JNative(DLL_NAME, "BitBlt");
            try {
                BitBlt.setRetVal(Type.INT);
                int i = 0;
                BitBlt.setParameter(i++, hdcDest.getValue());
                BitBlt.setParameter(i++, nXDest);
                BitBlt.setParameter(i++, nYDest);
                BitBlt.setParameter(i++, nWidth);
                BitBlt.setParameter(i++, nHeight);
                BitBlt.setParameter(i++, hdcSrc.getValue());
                BitBlt.setParameter(i++, nXSrc);
                BitBlt.setParameter(i++, nYSrc);
                BitBlt.setParameter(i++, dwRop);
                BitBlt.invoke();
                bl = BitBlt.getRetValAsInt() != 0;
                Object var13_12 = null;
                if (BitBlt == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var13_13 = null;
                    if (BitBlt == null) break block3;
                    BitBlt.dispose();
                }
                throw throwable;
            }
            BitBlt.dispose();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int SelectObject(DC hdc, int hgdiobj) throws NativeException, IllegalAccessException {
        int n;
        block2: {
            JNative SelectObject = new JNative(DLL_NAME, "SelectObject");
            try {
                SelectObject.setRetVal(Type.INT);
                int i = 0;
                SelectObject.setParameter(i++, hdc.getValue());
                SelectObject.setParameter(i++, hgdiobj);
                SelectObject.invoke();
                n = SelectObject.getRetValAsInt();
                Object var6_5 = null;
                if (SelectObject == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var6_6 = null;
                    if (SelectObject == null) break block3;
                    SelectObject.dispose();
                }
                throw throwable;
            }
            SelectObject.dispose();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean DeleteObject(int hObject) throws NativeException, IllegalAccessException {
        boolean bl;
        block2: {
            JNative DeleteObject = new JNative(DLL_NAME, "DeleteObject");
            try {
                DeleteObject.setRetVal(Type.INT);
                DeleteObject.setParameter(0, hObject);
                DeleteObject.invoke();
                bl = DeleteObject.getRetValAsInt() != 0;
                Object var4_3 = null;
                if (DeleteObject == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var4_4 = null;
                    if (DeleteObject == null) break block3;
                    DeleteObject.dispose();
                }
                throw throwable;
            }
            DeleteObject.dispose();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int CreateCompatibleBitmap(DC hdc, int nWidth, int nHeight) throws NativeException, IllegalAccessException {
        int n;
        block2: {
            JNative CreateCompatibleBitmap = new JNative(DLL_NAME, "CreateCompatibleBitmap");
            try {
                CreateCompatibleBitmap.setRetVal(Type.INT);
                int i = 0;
                CreateCompatibleBitmap.setParameter(i++, hdc.getValue());
                CreateCompatibleBitmap.setParameter(i++, nWidth);
                CreateCompatibleBitmap.setParameter(i++, nHeight);
                CreateCompatibleBitmap.invoke();
                n = CreateCompatibleBitmap.getRetValAsInt();
                Object var7_6 = null;
                if (CreateCompatibleBitmap == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var7_7 = null;
                    if (CreateCompatibleBitmap == null) break block3;
                    CreateCompatibleBitmap.dispose();
                }
                throw throwable;
            }
            CreateCompatibleBitmap.dispose();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int GetBitmapBits(int hbmp, int cbBuffer, Pointer lpvBits) throws NativeException, IllegalAccessException {
        int n;
        block2: {
            JNative GetBitmapBits = new JNative(DLL_NAME, "GetBitmapBits");
            try {
                GetBitmapBits.setRetVal(Type.INT);
                int i = 0;
                GetBitmapBits.setParameter(i++, hbmp);
                GetBitmapBits.setParameter(i++, cbBuffer);
                GetBitmapBits.setParameter(i++, lpvBits);
                GetBitmapBits.invoke();
                n = GetBitmapBits.getRetValAsInt();
                Object var7_6 = null;
                if (GetBitmapBits == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var7_7 = null;
                    if (GetBitmapBits == null) break block3;
                    GetBitmapBits.dispose();
                }
                throw throwable;
            }
            GetBitmapBits.dispose();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int SetBkMode(DC hdc, int iBkMode) throws NativeException, IllegalAccessException {
        int n;
        block2: {
            JNative SetBkMode = new JNative(DLL_NAME, "SetBkMode");
            try {
                SetBkMode.setRetVal(Type.INT);
                int i = 0;
                SetBkMode.setParameter(i++, hdc.getValue());
                SetBkMode.setParameter(i++, iBkMode);
                SetBkMode.invoke();
                n = SetBkMode.getRetValAsInt();
                Object var6_5 = null;
                if (SetBkMode == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var6_6 = null;
                    if (SetBkMode == null) break block3;
                    SetBkMode.dispose();
                }
                throw throwable;
            }
            SetBkMode.dispose();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean TextOut(DC hdc, int nXStart, int nYStart, String lpString, int cbString) throws NativeException, IllegalAccessException {
        boolean bl;
        block2: {
            JNative TextOut = new JNative(DLL_NAME, "TextOutA");
            try {
                TextOut.setRetVal(Type.INT);
                int i = 0;
                TextOut.setParameter(i++, hdc.getValue());
                TextOut.setParameter(i++, nXStart);
                TextOut.setParameter(i++, nYStart);
                TextOut.setParameter(i++, lpString);
                TextOut.setParameter(i++, cbString);
                TextOut.invoke();
                bl = TextOut.getRetValAsInt() != 0;
                Object var9_8 = null;
                if (TextOut == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var9_9 = null;
                    if (TextOut == null) break block3;
                    TextOut.dispose();
                }
                throw throwable;
            }
            TextOut.dispose();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean Rectangle(DC hdc, int nLeftRect, int nTopRect, int nRightRect, int nBottomRect) throws NativeException, IllegalAccessException {
        boolean bl;
        block2: {
            JNative Rectangle2 = new JNative(DLL_NAME, "Rectangle");
            try {
                Rectangle2.setRetVal(Type.INT);
                int i = 0;
                Rectangle2.setParameter(i++, hdc.getValue());
                Rectangle2.setParameter(i++, nLeftRect);
                Rectangle2.setParameter(i++, nTopRect);
                Rectangle2.setParameter(i++, nRightRect);
                Rectangle2.setParameter(i++, nBottomRect);
                Rectangle2.invoke();
                bl = Rectangle2.getRetValAsInt() != 0;
                Object var9_8 = null;
                if (Rectangle2 == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var9_9 = null;
                    if (Rectangle2 == null) break block3;
                    Rectangle2.dispose();
                }
                throw throwable;
            }
            Rectangle2.dispose();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DWORD SetDCBrushColor(DC hdc, DWORD crColor) throws NativeException, IllegalAccessException {
        DWORD dWORD;
        block2: {
            JNative SetDCBrushColor = new JNative(DLL_NAME, "SetDCBrushColor");
            try {
                SetDCBrushColor.setRetVal(Type.INT);
                int i = 0;
                SetDCBrushColor.setParameter(i++, hdc.getValue());
                SetDCBrushColor.setParameter(i++, crColor.getValue());
                SetDCBrushColor.invoke();
                dWORD = new DWORD(SetDCBrushColor.getRetValAsInt());
                Object var6_5 = null;
                if (SetDCBrushColor == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var6_6 = null;
                    if (SetDCBrushColor == null) break block3;
                    SetDCBrushColor.dispose();
                }
                throw throwable;
            }
            SetDCBrushColor.dispose();
        }
        return dWORD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean EndPath(DC hdc) throws NativeException, IllegalAccessException {
        boolean bl;
        block2: {
            JNative EndPath = new JNative(DLL_NAME, "EndPath");
            try {
                EndPath.setRetVal(Type.INT);
                EndPath.setParameter(0, hdc.getValue());
                EndPath.invoke();
                bl = EndPath.getRetValAsInt() != 0;
                Object var4_3 = null;
                if (EndPath == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var4_4 = null;
                    if (EndPath == null) break block3;
                    EndPath.dispose();
                }
                throw throwable;
            }
            EndPath.dispose();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean BeginPath(DC hdc) throws NativeException, IllegalAccessException {
        boolean bl;
        block2: {
            JNative BeginPath = new JNative(DLL_NAME, "BeginPath");
            try {
                BeginPath.setRetVal(Type.INT);
                BeginPath.setParameter(0, hdc.getValue());
                BeginPath.invoke();
                bl = BeginPath.getRetValAsInt() != 0;
                Object var4_3 = null;
                if (BeginPath == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var4_4 = null;
                    if (BeginPath == null) break block3;
                    BeginPath.dispose();
                }
                throw throwable;
            }
            BeginPath.dispose();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int SaveDC(DC hdc) throws NativeException, IllegalAccessException {
        int n;
        block2: {
            JNative SaveDC = new JNative(DLL_NAME, "SaveDC");
            try {
                SaveDC.setRetVal(Type.INT);
                SaveDC.setParameter(0, hdc.getValue());
                SaveDC.invoke();
                n = SaveDC.getRetValAsInt();
                Object var4_3 = null;
                if (SaveDC == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var4_4 = null;
                    if (SaveDC == null) break block3;
                    SaveDC.dispose();
                }
                throw throwable;
            }
            SaveDC.dispose();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean RestoreDC(DC hdc, int savedDC) throws NativeException, IllegalAccessException {
        boolean bl;
        block2: {
            JNative RestoreDC = new JNative(DLL_NAME, "RestoreDC");
            try {
                RestoreDC.setRetVal(Type.INT);
                RestoreDC.setParameter(0, hdc.getValue());
                RestoreDC.setParameter(1, savedDC);
                RestoreDC.invoke();
                bl = RestoreDC.getRetValAsInt() != 0;
                Object var5_4 = null;
                if (RestoreDC == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var5_5 = null;
                    if (RestoreDC == null) break block3;
                    RestoreDC.dispose();
                }
                throw throwable;
            }
            RestoreDC.dispose();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DWORD SetTextColor(DC hdc, DWORD color) throws NativeException, IllegalAccessException {
        DWORD dWORD;
        block2: {
            JNative TextOut = new JNative(DLL_NAME, "SetTextColor");
            try {
                TextOut.setRetVal(Type.INT);
                int i = 0;
                TextOut.setParameter(i++, hdc.getValue());
                TextOut.setParameter(i++, color.getValue());
                TextOut.invoke();
                dWORD = new DWORD(TextOut.getRetValAsInt());
                Object var6_5 = null;
                if (TextOut == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var6_6 = null;
                    if (TextOut == null) break block3;
                    TextOut.dispose();
                }
                throw throwable;
            }
            TextOut.dispose();
        }
        return dWORD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int CreatePen(int fnPenStyle, int nWidth, int crColor) throws NativeException, IllegalAccessException {
        int n;
        block2: {
            JNative CreatePen = new JNative(DLL_NAME, "CreatePen");
            try {
                CreatePen.setRetVal(Type.INT);
                int i = 0;
                CreatePen.setParameter(i++, fnPenStyle);
                CreatePen.setParameter(i++, nWidth);
                CreatePen.setParameter(i++, crColor);
                CreatePen.invoke();
                n = CreatePen.getRetValAsInt();
                Object var7_6 = null;
                if (CreatePen == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var7_7 = null;
                    if (CreatePen == null) break block3;
                    CreatePen.dispose();
                }
                throw throwable;
            }
            CreatePen.dispose();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean MoveToEx(DC hdc, int X, int Y, POINT lpPointer) throws NativeException, IllegalAccessException {
        boolean bl;
        block2: {
            JNative MoveToEx = new JNative(DLL_NAME, "MoveToEx");
            try {
                MoveToEx.setRetVal(Type.INT);
                int i = 0;
                MoveToEx.setParameter(i++, hdc.getValue());
                MoveToEx.setParameter(i++, X);
                MoveToEx.setParameter(i++, Y);
                MoveToEx.setParameter(i++, lpPointer == null ? NullPointer.NULL.getPointer() : lpPointer.getPointer().getPointer());
                MoveToEx.invoke();
                bl = MoveToEx.getRetValAsInt() != 0;
                Object var8_7 = null;
                if (MoveToEx == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var8_8 = null;
                    if (MoveToEx == null) break block3;
                    MoveToEx.dispose();
                }
                throw throwable;
            }
            MoveToEx.dispose();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean LineTo(DC hdc, int nXEnd, int nYEnd) throws NativeException, IllegalAccessException {
        boolean bl;
        block2: {
            JNative LineTo = new JNative(DLL_NAME, "LineTo");
            try {
                LineTo.setRetVal(Type.INT);
                int i = 0;
                LineTo.setParameter(i++, hdc.getValue());
                LineTo.setParameter(i++, nXEnd);
                LineTo.setParameter(i++, nYEnd);
                LineTo.invoke();
                bl = LineTo.getRetValAsInt() != 0;
                Object var7_6 = null;
                if (LineTo == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var7_7 = null;
                    if (LineTo == null) break block3;
                    LineTo.dispose();
                }
                throw throwable;
            }
            LineTo.dispose();
        }
        return bl;
    }
}

