/*
 * Decompiled with CFR 0.152.
 */
package com.zk.thread;

import com.zk.util.ConfigFile;
import com.zk.util.ServiceUtil;
import com.zk.util.Validator;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class WatchDogThread
implements Runnable {
    private Logger logger = Logger.getLogger(WatchDogThread.class);
    private long sleepTime = Long.parseLong(ConfigFile.getValue("../conf/services.ini".replace("/", File.separator), "watchdog", "sleeptime"));
    private long optionOleepTime = Long.parseLong(ConfigFile.getValue("../conf/services.ini".replace("/", File.separator), "watchdog", "optionsleeptime"));
    private int restartNum_Tomcat = 0;
    private int restartNum_ISSOnline = 0;
    private int restartNum_Finger = 0;
    private int restartNum_PostgreSQL = 0;
    private int restartNum_Redis = 0;

    @Override
    public void run() {
        while (true) {
            try {
                this.logger.info((Object)this.sleepTime);
                Thread.sleep(Validator.isNotNull(this.sleepTime) ? this.sleepTime : 30000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            String services = ConfigFile.getValue("../conf/services.ini".replace("/", File.separator), "watchdog", "services");
            List<String> serviceList = Arrays.asList(services.split(","));
            for (String serviceName : serviceList) {
                String serviceState = ServiceUtil.getServiceState(serviceName);
                if (serviceState.equals("STOPPED")) {
                    try {
                        this.executeCounter(serviceName);
                        this.logger.error((Object)("*****" + serviceName + " is Stopped!!!*****"));
                        ServiceUtil.startService(serviceName);
                        if (ServiceUtil.getServiceState(serviceName).equals("STOPPED")) {
                            this.logger.error((Object)("*****" + serviceName + " Restart Failed!!!*****"));
                        } else {
                            this.logger.info((Object)("*****" + serviceName + " Restart Success!!!*****"));
                        }
                        Thread.sleep(Validator.isNotNull(this.optionOleepTime) ? this.optionOleepTime : 300000L);
                    }
                    catch (InterruptedException e) {
                        this.logger.error((Object)("*****" + serviceName + " Restart Failed!!!*****"), (Throwable)e);
                    }
                    continue;
                }
                if (serviceState.equals("UNSTABLE") && this.restartNum_Tomcat < 3) {
                    try {
                        this.executeCounter(serviceName);
                        this.logger.error((Object)("*****" + serviceName + " is UnStable!!!*****"));
                        ServiceUtil.reStartService(serviceName);
                        Thread.sleep(Validator.isNotNull(this.optionOleepTime) ? this.optionOleepTime : 300000L);
                    }
                    catch (InterruptedException e) {
                        this.logger.error((Object)("*****" + serviceName + " Restart Failed!!!*****"), (Throwable)e);
                    }
                    continue;
                }
                if (serviceState.equals("RUNNING")) {
                    this.emptyCounter(serviceName);
                    continue;
                }
                if (!serviceState.equals("UNINSTALL")) continue;
                this.emptyCounter(serviceName);
                this.logger.error((Object)("*****" + serviceName + " is UnInstall!!!*****"));
            }
            this.logger.info((Object)"==================================================");
        }
    }

    private void executeCounter(String serviceName) {
        if (serviceName.equals("BioSecurity ISSOnline Service")) {
            this.restartNum_ISSOnline = this.restartNum_ISSOnline == 3 ? this.restartNum_ISSOnline : this.restartNum_ISSOnline + 1;
        } else if (serviceName.equals("BioSecurity Finger Service")) {
            this.restartNum_Finger = this.restartNum_Finger == 3 ? this.restartNum_Finger : this.restartNum_Finger + 1;
        } else if (serviceName.equals("BioSecurity Redis Service")) {
            this.restartNum_Redis = this.restartNum_Redis == 3 ? this.restartNum_Redis : this.restartNum_Redis + 1;
        } else if (serviceName.equals("BioSecurity PostgreSQL Service")) {
            this.restartNum_PostgreSQL = this.restartNum_PostgreSQL == 3 ? this.restartNum_PostgreSQL : this.restartNum_PostgreSQL + 1;
        } else if (serviceName.equals("BioSecurityTomcat")) {
            this.restartNum_Tomcat = this.restartNum_Tomcat == 3 ? this.restartNum_Tomcat : this.restartNum_Tomcat + 1;
        }
    }

    private void emptyCounter(String serviceName) {
        if (serviceName.equals("BioSecurity ISSOnline Service")) {
            this.restartNum_ISSOnline = 0;
        } else if (serviceName.equals("BioSecurity Finger Service")) {
            this.restartNum_Finger = 0;
        } else if (serviceName.equals("BioSecurity Redis Service")) {
            this.restartNum_Redis = 0;
        } else if (serviceName.equals("BioSecurity PostgreSQL Service")) {
            this.restartNum_PostgreSQL = 0;
        } else if (serviceName.equals("BioSecurityTomcat")) {
            this.restartNum_Tomcat = 0;
        }
    }
}

