/*
 * Decompiled with CFR 0.152.
 */
package com.zk.util;

import com.zk.util.ResourceUtil;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.springframework.core.io.Resource;

public class OpSystemUtil {
    private static final Logger logger = Logger.getLogger(OpSystemUtil.class);
    private static String tempDir = null;

    static {
        String sysTemp = System.getProperty("java.io.tmpdir");
        long temp = Math.abs(new Random().nextLong());
        tempDir = String.valueOf(sysTemp) + temp;
        File f = new File(tempDir);
        f.mkdir();
        System.out.println("create temp dir:" + tempDir);
        OpSystemUtil.addJavaLibPath(tempDir);
    }

    public static String jdkBit() {
        return System.getProperty("sun.arch.data.model");
    }

    public static boolean isJdk64() {
        return OpSystemUtil.jdkBit().equals("64");
    }

    private static File copyResourceToDir(Resource dllResource, String destFileName) {
        File destFile = null;
        try {
            InputStream input = dllResource.getInputStream();
            destFile = new File(destFileName);
            FileUtils.copyInputStreamToFile((InputStream)input, (File)destFile);
            return destFile;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            return destFile;
        }
    }

    private static void loadResourceLibrary(Resource dllResource) {
        String fileName = null;
        File destFile = null;
        try {
            fileName = dllResource.getFilename();
            InputStream input = dllResource.getInputStream();
            destFile = new File(String.valueOf(tempDir) + File.separator + fileName);
            FileUtils.copyInputStreamToFile((InputStream)input, (File)destFile);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
        if (destFile != null) {
            try {
                System.load(destFile.getPath());
            }
            catch (Throwable e) {
                logger.error(e.getMessage(), e);
            }
        } else {
            logger.error("can not copy temp file, load dll fail!");
        }
    }

    public static void loadLibrary(String dllClassPath) {
        Resource dllResource = ResourceUtil.getResource(dllClassPath);
        OpSystemUtil.loadResourceLibrary(dllResource);
    }

    public static void CopyToJavaLibraryPath(String libPath) {
        System.out.println("user.dir-----------------------:" + System.getProperty("user.dir"));
        Resource[] dllResources = ResourceUtil.loadResources(String.valueOf(libPath) + "/*.dll");
        System.out.println("libPath-------------------:" + libPath);
        Resource[] resourceArray = dllResources;
        int n = dllResources.length;
        int n2 = 0;
        while (n2 < n) {
            Resource dllResource = resourceArray[n2];
            System.out.println("dllResource-------------------:" + dllResource);
            System.out.println("tempDir-------------------:" + tempDir);
            String fileName = dllResource.getFilename();
            String destFileName = String.valueOf(tempDir) + File.separator + fileName;
            System.out.println("destFileName-------------------:" + destFileName);
            OpSystemUtil.copyResourceToDir(dllResource, destFileName);
            ++n2;
        }
    }

    public static void addJavaLibPath(String path) {
        String p = System.getProperty("java.library.path");
        System.out.println(String.format("ori java.library.path before add path:%s is--> %s", path, p));
        System.setProperty("java.library.path", String.valueOf(path) + ";" + p);
        try {
            Field fieldSysPath = ClassLoader.class.getDeclaredField("sys_paths");
            fieldSysPath.setAccessible(true);
            fieldSysPath.set(null, null);
            System.out.println(String.format("new java.library.path after add path:%s is--> %s", path, System.getProperty("java.library.path")));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get permissions to set library path");
        }
    }

    public static void main(String[] args) {
        String arch = System.getProperty("sun.arch.data.model");
        String os = System.getProperty("os.name");
        System.out.println(arch);
        System.out.println(os);
        System.out.println(OpSystemUtil.isJdk64());
    }
}

