/*
 * Decompiled with CFR 0.152.
 */
package sun.security.internal.spec;

import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import sun.security.internal.spec.TlsMasterSecretParameterSpec;

@Deprecated
public class TlsKeyMaterialParameterSpec
implements AlgorithmParameterSpec {
    private final SecretKey masterSecret;
    private final int majorVersion;
    private final int minorVersion;
    private final byte[] clientRandom;
    private final byte[] serverRandom;
    private final String cipherAlgorithm;
    private final int cipherKeyLength;
    private final int ivLength;
    private final int macKeyLength;
    private final int expandedCipherKeyLength;
    private final String prfHashAlg;
    private final int prfHashLength;
    private final int prfBlockSize;

    public TlsKeyMaterialParameterSpec(SecretKey secretKey, int n, int n2, byte[] byArray, byte[] byArray2, String string, int n3, int n4, int n5, int n6, String string2, int n7, int n8) {
        if (!secretKey.getAlgorithm().equals("TlsMasterSecret")) {
            throw new IllegalArgumentException("Not a TLS master secret");
        }
        if (string == null) {
            throw new NullPointerException();
        }
        this.masterSecret = secretKey;
        this.majorVersion = TlsMasterSecretParameterSpec.checkVersion(n);
        this.minorVersion = TlsMasterSecretParameterSpec.checkVersion(n2);
        this.clientRandom = (byte[])byArray.clone();
        this.serverRandom = (byte[])byArray2.clone();
        this.cipherAlgorithm = string;
        this.cipherKeyLength = TlsKeyMaterialParameterSpec.checkSign(n3);
        this.expandedCipherKeyLength = TlsKeyMaterialParameterSpec.checkSign(n4);
        this.ivLength = TlsKeyMaterialParameterSpec.checkSign(n5);
        this.macKeyLength = TlsKeyMaterialParameterSpec.checkSign(n6);
        this.prfHashAlg = string2;
        this.prfHashLength = n7;
        this.prfBlockSize = n8;
    }

    private static int checkSign(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Value must not be negative");
        }
        return n;
    }

    public SecretKey getMasterSecret() {
        return this.masterSecret;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public byte[] getClientRandom() {
        return (byte[])this.clientRandom.clone();
    }

    public byte[] getServerRandom() {
        return (byte[])this.serverRandom.clone();
    }

    public String getCipherAlgorithm() {
        return this.cipherAlgorithm;
    }

    public int getCipherKeyLength() {
        return this.cipherKeyLength;
    }

    public int getExpandedCipherKeyLength() {
        if (this.majorVersion >= 3 && this.minorVersion >= 2) {
            return 0;
        }
        return this.expandedCipherKeyLength;
    }

    public int getIvLength() {
        if (this.majorVersion >= 3 && this.minorVersion >= 2) {
            return 0;
        }
        return this.ivLength;
    }

    public int getMacKeyLength() {
        return this.macKeyLength;
    }

    public String getPRFHashAlg() {
        return this.prfHashAlg;
    }

    public int getPRFHashLength() {
        return this.prfHashLength;
    }

    public int getPRFBlockSize() {
        return this.prfBlockSize;
    }
}

