/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control;

import java.lang.ref.WeakReference;
import javafx.collections.ListChangeListener;

public class WeakListChangeListener<T>
implements ListChangeListener<T> {
    private final WeakReference<ListChangeListener<T>> ref;

    public WeakListChangeListener(ListChangeListener<T> listChangeListener) {
        if (listChangeListener == null) {
            throw new NullPointerException("Listener must be specified.");
        }
        this.ref = new WeakReference<ListChangeListener<ListChangeListener<T>>>(listChangeListener);
    }

    @Override
    public void onChanged(ListChangeListener.Change<? extends T> change) {
        ListChangeListener listChangeListener = (ListChangeListener)this.ref.get();
        if (listChangeListener != null) {
            listChangeListener.onChanged(change);
        } else {
            change.getList().removeListener(this);
        }
    }
}

