/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.util;

import org.xvolks.jnative.JNative;
import org.xvolks.jnative.Type;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.ICONINFO;
import org.xvolks.jnative.misc.MSG;
import org.xvolks.jnative.misc.PAINTSTRUCT;
import org.xvolks.jnative.misc.POINT;
import org.xvolks.jnative.misc.WNDCLASS;
import org.xvolks.jnative.misc.WNDCLASSEX;
import org.xvolks.jnative.misc.basicStructures.DC;
import org.xvolks.jnative.misc.basicStructures.DWORD;
import org.xvolks.jnative.misc.basicStructures.HANDLE;
import org.xvolks.jnative.misc.basicStructures.HWND;
import org.xvolks.jnative.misc.basicStructures.LONG;
import org.xvolks.jnative.misc.basicStructures.LPARAM;
import org.xvolks.jnative.misc.basicStructures.LRECT;
import org.xvolks.jnative.misc.basicStructures.LRESULT;
import org.xvolks.jnative.misc.basicStructures.UINT;
import org.xvolks.jnative.misc.basicStructures.WPARAM;
import org.xvolks.jnative.pointers.NullPointer;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.MemoryBlockFactory;
import org.xvolks.jnative.util.Callback;
import org.xvolks.jnative.util.Kernel32;
import org.xvolks.jnative.util.windows.structures.DEV_BROADCAST_HANDLE;
import org.xvolks.jnative.util.windows.structures.GUID;

public class User32 {
    public static final String DLL_NAME = "User32.dll";
    public static final int SWP_FRAMECHANGED = 32;
    public static final int SWP_DRAWFRAME = 32;
    public static final int SWP_HIDEWINDOW = 128;
    public static final int SWP_NOACTIVATE = 16;
    public static final int SWP_NOCOPYBITS = 256;
    public static final int SWP_NOMOVE = 2;
    public static final int SWP_NOOWNERZORDER = 512;
    public static final int SWP_NOREDRAW = 8;
    public static final int SWP_NOREPOSITION = 512;
    public static final int SWP_NOSIZE = 1;
    public static final int SWP_NOZORDER = 4;
    public static final int SWP_SHOWWINDOW = 64;
    public static final HWND HWND_TOP = new HWND(0);
    public static final HWND HWND_TOPMOST = new HWND(-1);
    public static final HWND HWND_NOTOPMOST = new HWND(-2);
    public static final HWND HWND_BOTTOM = new HWND(1);
    public static final int IDI_APPLICATION = 32512;
    public static final int IDI_ASTERISK = 32516;
    public static final int IDI_ERROR = 32513;
    public static final int IDI_EXCLAMATION = 32515;
    public static final int IDI_HAND = 32513;
    public static final int IDI_INFORMATION = 32516;
    public static final int IDI_QUESTION = 32514;
    public static final int IDI_WARNING = 32515;
    public static final int IDI_WINLOGO = 32517;
    public static final int IDI_SHIELD = 32518;
    public static final int MOD_ALT = 1;
    public static final int MOD_CONTROL = 2;
    public static final int MOD_SHIFT = 4;
    public static final int MOD_WIN = 8;
    public static final int CWP_ALL = 0;
    public static final int CWP_SKIPDISABLED = 2;
    public static final int CWP_SKIPINVISIBLE = 1;
    public static final int CWP_SKIPTRANSPARENT = 4;
    public static final int MF_BYCOMMAND = 0;
    public static final int MF_BYPOSITION = 1024;
    public static final int MF_REMOVE = 4096;
    public static final int DEVICE_NOTIFY_WINDOW_HANDLE = 0;
    public static final int DEVICE_NOTIFY_SERVICE_HANDLE = 1;
    public static final int DEVICE_NOTIFY_ALL_INTERFACE_CLASSES = 4;

    public static boolean IsWindowVisible(HWND hWnd) throws NativeException, IllegalAccessException {
        JNative jNative = new JNative(DLL_NAME, "IsWindowVisible");
        jNative.setRetVal(Type.INT);
        jNative.setParameter(0, (Integer)hWnd.getValue());
        jNative.invoke();
        return jNative.getRetValAsInt() != 0;
    }

    public static boolean UnhookWinEvent(int hWinEventHook) throws NativeException, IllegalAccessException {
        JNative jNative = new JNative(DLL_NAME, "UnhookWinEvent");
        jNative.setRetVal(Type.INT);
        jNative.setParameter(0, hWinEventHook);
        jNative.invoke();
        return jNative.getRetValAsInt() != 0;
    }

    public static int SetWinEventHook(UINT eventMin, UINT eventMax, int hmodWinEventProc, int lpfnWinEventProc, DWORD idProcess, DWORD idThread, UINT dwflags) throws NativeException, IllegalAccessException {
        JNative jNative = new JNative(DLL_NAME, "SetWinEventHook");
        int i = 0;
        jNative.setRetVal(Type.INT);
        jNative.setParameter(i++, eventMin.getValue().shortValue());
        jNative.setParameter(i++, eventMax.getValue().shortValue());
        jNative.setParameter(i++, hmodWinEventProc);
        jNative.setParameter(i++, lpfnWinEventProc);
        jNative.setParameter(i++, idProcess.getValue());
        jNative.setParameter(i++, idThread.getValue());
        jNative.setParameter(i++, dwflags.getValue().shortValue());
        jNative.invoke();
        return jNative.getRetValAsInt();
    }

    public static boolean IsIconic(HWND hWnd) throws NativeException, IllegalAccessException {
        JNative jNative = new JNative(DLL_NAME, "IsIconic");
        jNative.setRetVal(Type.INT);
        jNative.setParameter(0, (Integer)hWnd.getValue());
        jNative.invoke();
        return jNative.getRetValAsInt() != 0;
    }

    public static boolean FlashWindow(HWND hWnd, boolean bInvert) throws NativeException, IllegalAccessException {
        JNative jNative = new JNative(DLL_NAME, "FlashWindow");
        jNative.setRetVal(Type.INT);
        jNative.setParameter(0, (Integer)hWnd.getValue());
        jNative.setParameter(1, Type.INT, bInvert ? "1" : "0");
        jNative.invoke();
        return jNative.getRetValAsInt() != 0;
    }

    public static boolean MessageBeep(int uType) throws NativeException, IllegalAccessException {
        JNative jNative = new JNative(DLL_NAME, "MessageBeep");
        jNative.setRetVal(Type.INT);
        jNative.setParameter(0, uType);
        jNative.invoke();
        return jNative.getRetValAsInt() != 0;
    }

    public static HANDLE GetSystemMenu(HWND hWnd, boolean bRevert) throws NativeException, IllegalAccessException {
        JNative jNative = new JNative(DLL_NAME, "GetSystemMenu");
        jNative.setRetVal(Type.INT);
        jNative.setParameter(0, (Integer)hWnd.getValue());
        jNative.setParameter(1, Type.INT, bRevert ? "1" : "0");
        jNative.invoke();
        return new HANDLE(jNative.getRetValAsInt());
    }

    public static boolean DeleteMenu(HANDLE hMenu, UINT uPosition, UINT uFlags) throws NativeException, IllegalAccessException {
        JNative jNative = new JNative(DLL_NAME, "DeleteMenu");
        jNative.setRetVal(Type.INT);
        jNative.setParameter(0, hMenu.getValue());
        jNative.setParameter(1, uPosition.getValue().shortValue());
        jNative.setParameter(2, uFlags.getValue().shortValue());
        jNative.invoke();
        return jNative.getRetValAsInt() != 0;
    }

    public static boolean RemoveMenu(HANDLE hMenu, UINT uPosition, UINT uFlags) throws NativeException, IllegalAccessException {
        JNative jNative = new JNative(DLL_NAME, "RemoveMenu");
        jNative.setRetVal(Type.INT);
        jNative.setParameter(0, hMenu.getValue());
        jNative.setParameter(1, uPosition.getValue().shortValue());
        jNative.setParameter(2, uFlags.getValue().shortValue());
        jNative.invoke();
        return jNative.getRetValAsInt() != 0;
    }

    public static boolean GetClientRect(HWND hWnd, LRECT lpRect) throws NativeException, IllegalAccessException {
        JNative GetClientRect = new JNative(DLL_NAME, "GetClientRect");
        GetClientRect.setRetVal(Type.INT);
        GetClientRect.setParameter(0, (Integer)hWnd.getValue());
        GetClientRect.setParameter(1, lpRect.getPointer().getPointer());
        GetClientRect.invoke();
        return GetClientRect.getRetValAsInt() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean EndPaint(HWND hWnd, PAINTSTRUCT lpPaint) throws NativeException, IllegalAccessException {
        boolean bl;
        block2: {
            JNative EndPaint = new JNative(DLL_NAME, "EndPaint");
            try {
                EndPaint.setRetVal(Type.INT);
                EndPaint.setParameter(0, (Integer)hWnd.getValue());
                EndPaint.setParameter(1, lpPaint == null ? NullPointer.NULL.getPointer() : lpPaint.getPointer().getPointer());
                EndPaint.invoke();
                bl = EndPaint.getRetValAsInt() != 0;
                Object var5_4 = null;
                if (EndPaint == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var5_5 = null;
                    if (EndPaint == null) break block3;
                    EndPaint.dispose();
                }
                throw throwable;
            }
            EndPaint.dispose();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DC BeginPaint(HWND hWnd, PAINTSTRUCT lpPaint) throws NativeException, IllegalAccessException {
        DC dC;
        block2: {
            JNative BeginPaint = new JNative(DLL_NAME, "BeginPaint");
            try {
                BeginPaint.setRetVal(Type.INT);
                BeginPaint.setParameter(0, (Integer)hWnd.getValue());
                BeginPaint.setParameter(1, lpPaint == null ? NullPointer.NULL.getPointer() : lpPaint.getPointer().getPointer());
                BeginPaint.invoke();
                dC = new DC(BeginPaint.getRetValAsInt());
                Object var5_4 = null;
                if (BeginPaint == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var5_5 = null;
                    if (BeginPaint == null) break block3;
                    BeginPaint.dispose();
                }
                throw throwable;
            }
            BeginPaint.dispose();
        }
        return dC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean ValidateRect(HWND hWnd, LRECT lprcUpdate) throws NativeException, IllegalAccessException {
        boolean bl;
        block2: {
            JNative ValidateRect = new JNative(DLL_NAME, "ValidateRect");
            try {
                ValidateRect.setRetVal(Type.INT);
                ValidateRect.setParameter(0, (Integer)hWnd.getValue());
                ValidateRect.setParameter(1, lprcUpdate == null ? NullPointer.NULL.getPointer() : lprcUpdate.getPointer().getPointer());
                ValidateRect.invoke();
                bl = ValidateRect.getRetValAsInt() != 0;
                Object var5_4 = null;
                if (ValidateRect == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var5_5 = null;
                    if (ValidateRect == null) break block3;
                    ValidateRect.dispose();
                }
                throw throwable;
            }
            ValidateRect.dispose();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean RedrawWindow(HWND hWnd, LRECT lprcUpdate, int hrgnUpdate, UINT flags) throws NativeException, IllegalAccessException {
        boolean bl;
        block2: {
            JNative RedrawWindow = new JNative(DLL_NAME, "RedrawWindow");
            try {
                RedrawWindow.setRetVal(Type.INT);
                RedrawWindow.setParameter(0, (Integer)hWnd.getValue());
                RedrawWindow.setParameter(1, lprcUpdate == null ? NullPointer.NULL.getPointer() : lprcUpdate.getPointer().getPointer());
                RedrawWindow.setParameter(2, hrgnUpdate);
                RedrawWindow.setParameter(3, flags.getValue().shortValue());
                RedrawWindow.invoke();
                bl = RedrawWindow.getRetValAsInt() != 0;
                Object var7_6 = null;
                if (RedrawWindow == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var7_7 = null;
                    if (RedrawWindow == null) break block3;
                    RedrawWindow.dispose();
                }
                throw throwable;
            }
            RedrawWindow.dispose();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void SwitchToThisWindow(HWND hWnd, boolean fAltTab) throws NativeException, IllegalAccessException {
        JNative SwitchToThisWindow = new JNative(DLL_NAME, "SwitchToThisWindow");
        try {
            SwitchToThisWindow.setRetVal(Type.INT);
            SwitchToThisWindow.setParameter(0, (Integer)hWnd.getValue());
            SwitchToThisWindow.setParameter(1, Type.INT, fAltTab ? "1" : "0");
            SwitchToThisWindow.invoke();
            Object var4_3 = null;
            if (SwitchToThisWindow == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (SwitchToThisWindow == null) throw throwable;
            SwitchToThisWindow.dispose();
            throw throwable;
        }
        SwitchToThisWindow.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean BringWindowToTop(HWND hWnd) throws NativeException, IllegalAccessException {
        boolean bl;
        block2: {
            JNative BringWindowToTop = new JNative(DLL_NAME, "BringWindowToTop");
            try {
                BringWindowToTop.setRetVal(Type.INT);
                BringWindowToTop.setParameter(0, (Integer)hWnd.getValue());
                BringWindowToTop.invoke();
                bl = BringWindowToTop.getRetValAsInt() != 0;
                Object var4_3 = null;
                if (BringWindowToTop == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var4_4 = null;
                    if (BringWindowToTop == null) break block3;
                    BringWindowToTop.dispose();
                }
                throw throwable;
            }
            BringWindowToTop.dispose();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean PostThreadMessage(DWORD idThread, UINT Msg, WPARAM wParam, LPARAM lParam) throws NativeException, IllegalAccessException {
        boolean bl;
        block2: {
            JNative PostThreadMessage = new JNative(DLL_NAME, "PostThreadMessageA");
            try {
                PostThreadMessage.setRetVal(Type.INT);
                PostThreadMessage.setParameter(0, idThread.getValue());
                PostThreadMessage.setParameter(1, Msg.getValue().shortValue());
                PostThreadMessage.setParameter(2, wParam.getValue());
                PostThreadMessage.setParameter(3, lParam.getValue());
                PostThreadMessage.invoke();
                bl = PostThreadMessage.getRetValAsInt() != 0;
                Object var7_6 = null;
                if (PostThreadMessage == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var7_7 = null;
                    if (PostThreadMessage == null) break block3;
                    PostThreadMessage.dispose();
                }
                throw throwable;
            }
            PostThreadMessage.dispose();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int GetAsyncKeyState(int vKey) throws NativeException, IllegalAccessException {
        int n;
        block2: {
            JNative GetAsyncKeyState = new JNative(DLL_NAME, "GetAsyncKeyState");
            try {
                GetAsyncKeyState.setRetVal(Type.INT);
                GetAsyncKeyState.setParameter(0, vKey);
                GetAsyncKeyState.invoke();
                n = GetAsyncKeyState.getRetValAsInt();
                Object var4_3 = null;
                if (GetAsyncKeyState == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var4_4 = null;
                    if (GetAsyncKeyState == null) break block3;
                    GetAsyncKeyState.dispose();
                }
                throw throwable;
            }
            GetAsyncKeyState.dispose();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HWND WindowFromPoint(POINT pt) throws NativeException, IllegalAccessException {
        HWND hWND;
        block2: {
            JNative WindowFromPoint = new JNative(DLL_NAME, "WindowFromPoint");
            try {
                WindowFromPoint.setRetVal(Type.INT);
                WindowFromPoint.setParameter(0, pt.getX());
                WindowFromPoint.setParameter(1, pt.getY());
                WindowFromPoint.invoke();
                hWND = new HWND(WindowFromPoint.getRetValAsInt());
                Object var4_3 = null;
                if (WindowFromPoint == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var4_4 = null;
                    if (WindowFromPoint == null) break block3;
                    WindowFromPoint.dispose();
                }
                throw throwable;
            }
            WindowFromPoint.dispose();
        }
        return hWND;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HWND ChildWindowFromPointEx(HWND hwnd, POINT pt, int uFlags) throws NativeException, IllegalAccessException {
        HWND hWND;
        block2: {
            JNative ChildWindowFromPointEx = new JNative(DLL_NAME, "ChildWindowFromPointEx");
            try {
                ChildWindowFromPointEx.setRetVal(Type.INT);
                int pos = 0;
                ChildWindowFromPointEx.setParameter(pos++, (Integer)hwnd.getValue());
                ChildWindowFromPointEx.setParameter(pos++, pt.getX());
                ChildWindowFromPointEx.setParameter(pos++, pt.getY());
                ChildWindowFromPointEx.setParameter(pos++, uFlags);
                ChildWindowFromPointEx.invoke();
                hWND = new HWND(ChildWindowFromPointEx.getRetValAsInt());
                Object var7_6 = null;
                if (ChildWindowFromPointEx == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var7_7 = null;
                    if (ChildWindowFromPointEx == null) break block3;
                    ChildWindowFromPointEx.dispose();
                }
                throw throwable;
            }
            ChildWindowFromPointEx.dispose();
        }
        return hWND;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean InvalidateRect(HWND hWnd, LRECT lpRect, boolean bErase) throws NativeException, IllegalAccessException {
        boolean bl;
        block2: {
            JNative InvalidateRect = new JNative(DLL_NAME, "InvalidateRect");
            try {
                InvalidateRect.setRetVal(Type.INT);
                int pos = 0;
                InvalidateRect.setParameter(pos++, (Integer)hWnd.getValue());
                InvalidateRect.setParameter(pos++, lpRect == null ? NullPointer.NULL.getPointer() : lpRect.getPointer().getPointer());
                InvalidateRect.setParameter(pos++, Type.INT, bErase ? "1" : "0");
                InvalidateRect.invoke();
                bl = InvalidateRect.getRetValAsInt() != 0;
                Object var7_6 = null;
                if (InvalidateRect == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var7_7 = null;
                    if (InvalidateRect == null) break block3;
                    InvalidateRect.dispose();
                }
                throw throwable;
            }
            InvalidateRect.dispose();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean UpdateLayeredWindow(HWND hwnd, DC hdcDst, POINT pptDst, int psize, DC hdcSrc, POINT pptSrc, DWORD crKey, int pblend, DWORD dwFlags) throws NativeException, IllegalAccessException {
        boolean bl;
        block2: {
            JNative UpdateLayeredWindow = new JNative(DLL_NAME, "UpdateLayeredWindow");
            try {
                UpdateLayeredWindow.setRetVal(Type.INT);
                int pos = 0;
                UpdateLayeredWindow.setParameter(pos++, (Integer)hwnd.getValue());
                UpdateLayeredWindow.setParameter(pos++, hdcDst == null ? NullPointer.NULL.getPointer() : hdcDst.getValue().intValue());
                UpdateLayeredWindow.setParameter(pos++, pptDst == null ? NullPointer.NULL : pptDst.getValue().getPointer());
                UpdateLayeredWindow.setParameter(pos++, psize);
                UpdateLayeredWindow.setParameter(pos++, hdcSrc == null ? NullPointer.NULL.getPointer() : hdcSrc.getValue().intValue());
                UpdateLayeredWindow.setParameter(pos++, pptSrc == null ? NullPointer.NULL : pptSrc.getValue().getPointer());
                UpdateLayeredWindow.setParameter(pos++, crKey.getValue());
                UpdateLayeredWindow.setParameter(pos++, pblend);
                UpdateLayeredWindow.setParameter(pos++, dwFlags.getValue());
                UpdateLayeredWindow.invoke();
                bl = UpdateLayeredWindow.getRetValAsInt() != 0;
                Object var13_12 = null;
                if (UpdateLayeredWindow == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var13_13 = null;
                    if (UpdateLayeredWindow == null) break block3;
                    UpdateLayeredWindow.dispose();
                }
                throw throwable;
            }
            UpdateLayeredWindow.dispose();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean SetLayeredWindowAttributes(HWND hwnd, int crKey, byte bAlpha, DWORD dwFlags) throws NativeException, IllegalAccessException {
        boolean bl;
        block2: {
            JNative SetLayeredWindowAttributes = new JNative(DLL_NAME, "SetLayeredWindowAttributes");
            try {
                SetLayeredWindowAttributes.setRetVal(Type.INT);
                int pos = 0;
                SetLayeredWindowAttributes.setParameter(pos++, (Integer)hwnd.getValue());
                SetLayeredWindowAttributes.setParameter(pos++, crKey);
                SetLayeredWindowAttributes.setParameter(pos++, bAlpha);
                SetLayeredWindowAttributes.setParameter(pos++, dwFlags.getValue());
                SetLayeredWindowAttributes.invoke();
                bl = SetLayeredWindowAttributes.getRetValAsInt() != 0;
                Object var8_7 = null;
                if (SetLayeredWindowAttributes == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var8_8 = null;
                    if (SetLayeredWindowAttributes == null) break block3;
                    SetLayeredWindowAttributes.dispose();
                }
                throw throwable;
            }
            SetLayeredWindowAttributes.dispose();
        }
        return bl;
    }

    public static boolean GetCursorPos(POINT p) throws NativeException, IllegalAccessException {
        JNative GetCursorPos = new JNative(DLL_NAME, "GetCursorPos");
        GetCursorPos.setRetVal(Type.INT);
        GetCursorPos.setParameter(0, p.getPointer());
        GetCursorPos.invoke();
        p.getValueFromPointer();
        return GetCursorPos.getRetValAsInt() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HWND GetDesktopWindow() throws NativeException, IllegalAccessException {
        HWND hWND;
        block2: {
            JNative GetDesktopWindow = new JNative(DLL_NAME, "GetDesktopWindow");
            try {
                GetDesktopWindow.setRetVal(Type.INT);
                GetDesktopWindow.invoke();
                hWND = new HWND(GetDesktopWindow.getRetValAsInt());
                Object var3_2 = null;
                if (GetDesktopWindow == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var3_3 = null;
                    if (GetDesktopWindow == null) break block3;
                    GetDesktopWindow.dispose();
                }
                throw throwable;
            }
            GetDesktopWindow.dispose();
        }
        return hWND;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean GetIconInfo(LONG hIcon, ICONINFO piconinfo) throws NativeException, IllegalAccessException {
        boolean bl;
        block2: {
            JNative GetIconInfo = new JNative(DLL_NAME, "GetIconInfo");
            try {
                GetIconInfo.setRetVal(Type.INT);
                GetIconInfo.setParameter(0, hIcon.getValue());
                GetIconInfo.setParameter(1, piconinfo.getPointer());
                GetIconInfo.invoke();
                bl = GetIconInfo.getRetValAsInt() != 0;
                Object var5_4 = null;
                if (GetIconInfo == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var5_5 = null;
                    if (GetIconInfo == null) break block3;
                    GetIconInfo.dispose();
                }
                throw throwable;
            }
            GetIconInfo.dispose();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int ReleaseDC(HWND hwnd, DC hdc) throws NativeException, IllegalAccessException {
        int n;
        block2: {
            JNative ReleaseDC = new JNative(DLL_NAME, "ReleaseDC");
            try {
                ReleaseDC.setRetVal(Type.INT);
                ReleaseDC.setParameter(0, (Integer)hwnd.getValue());
                ReleaseDC.setParameter(1, hdc.getValue());
                ReleaseDC.invoke();
                n = ReleaseDC.getRetValAsInt();
                Object var5_4 = null;
                if (ReleaseDC == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var5_5 = null;
                    if (ReleaseDC == null) break block3;
                    ReleaseDC.dispose();
                }
                throw throwable;
            }
            ReleaseDC.dispose();
        }
        return n;
    }

    public static DC GetDC(HWND hwnd) throws NativeException, IllegalAccessException {
        JNative GetDC = new JNative(DLL_NAME, "GetDC");
        GetDC.setRetVal(Type.INT);
        GetDC.setParameter(0, (Integer)hwnd.getValue());
        GetDC.invoke();
        return new DC(GetDC.getRetValAsInt());
    }

    public static DC GetWindowDC(HWND hwnd) throws NativeException, IllegalAccessException {
        JNative GetWindowDC = new JNative(DLL_NAME, "GetWindowDC");
        GetWindowDC.setRetVal(Type.INT);
        GetWindowDC.setParameter(0, (Integer)hwnd.getValue());
        GetWindowDC.invoke();
        return new DC(GetWindowDC.getRetValAsInt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int GetWindowThreadProcessId(HWND hwnd) throws NativeException, IllegalAccessException {
        int n;
        if (hwnd == null) {
            return -1;
        }
        Pointer nBufferGWT = null;
        try {
            JNative getProcessHandle = new JNative(DLL_NAME, "GetWindowThreadProcessId");
            getProcessHandle.setRetVal(Type.INT);
            nBufferGWT = new Pointer(MemoryBlockFactory.createMemoryBlock(4));
            getProcessHandle.setParameter(0, (Integer)hwnd.getValue());
            getProcessHandle.setParameter(1, nBufferGWT);
            getProcessHandle.invoke();
            n = nBufferGWT.getAsInt(0);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                if (nBufferGWT != null) {
                    nBufferGWT.dispose();
                }
                nBufferGWT = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            throw throwable;
        }
        try {
            if (nBufferGWT != null) {
                nBufferGWT.dispose();
            }
            nBufferGWT = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HWND FindWindow(String className, String windowName) throws NativeException, IllegalAccessException {
        HWND hWND;
        block2: {
            JNative _FindWindow = new JNative(DLL_NAME, "FindWindowA");
            try {
                _FindWindow.setRetVal(Type.INT);
                _FindWindow.setParameter(0, Type.STRING, className);
                _FindWindow.setParameter(1, Type.STRING, windowName);
                _FindWindow.invoke();
                int valRet = Integer.parseInt(_FindWindow.getRetVal());
                hWND = new HWND(valRet);
                Object var6_5 = null;
                if (_FindWindow == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var6_6 = null;
                    if (_FindWindow == null) break block3;
                    _FindWindow.dispose();
                }
                throw throwable;
            }
            _FindWindow.dispose();
        }
        return hWND;
    }

    public static LRESULT CallWindowProc(LONG lpPrevWndFunc, HWND hwnd, int msg, WPARAM wparam, LPARAM lparam) throws NativeException, IllegalAccessException {
        JNative CallWindowProcA = new JNative(DLL_NAME, "CallWindowProcA");
        CallWindowProcA.setRetVal(Type.INT);
        int i = 0;
        CallWindowProcA.setParameter(i++, lpPrevWndFunc.getValue());
        CallWindowProcA.setParameter(i++, (Integer)hwnd.getValue());
        CallWindowProcA.setParameter(i++, msg);
        CallWindowProcA.setParameter(i++, wparam.getValue());
        CallWindowProcA.setParameter(i++, lparam.getValue());
        CallWindowProcA.invoke();
        return new LRESULT(CallWindowProcA.getRetValAsInt());
    }

    public static int CallWindowProc(int lpPrevWndFunc, int hwnd, int msg, int wparam, int lparam) throws NativeException, IllegalAccessException {
        JNative CallWindowProcA = new JNative(DLL_NAME, "CallWindowProcA");
        CallWindowProcA.setRetVal(Type.INT);
        int i = 0;
        CallWindowProcA.setParameter(i++, lpPrevWndFunc);
        CallWindowProcA.setParameter(i++, hwnd);
        CallWindowProcA.setParameter(i++, msg);
        CallWindowProcA.setParameter(i++, wparam);
        CallWindowProcA.setParameter(i++, lparam);
        CallWindowProcA.invoke();
        return CallWindowProcA.getRetValAsInt();
    }

    public static LRESULT DefWindowProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam) throws NativeException, IllegalAccessException {
        JNative DefWindowProc = new JNative(DLL_NAME, "DefWindowProcA");
        DefWindowProc.setRetVal(Type.INT);
        DefWindowProc.setParameter(0, Type.INT, hwnd.getValueAsString());
        DefWindowProc.setParameter(1, Type.INT, msg.getValueAsString());
        DefWindowProc.setParameter(2, Type.INT, wparam.getValueAsString());
        DefWindowProc.setParameter(3, Type.INT, lparam.getValueAsString());
        DefWindowProc.invoke();
        return new LRESULT(DefWindowProc.getRetValAsInt());
    }

    public static int DefWindowProc(int hwnd, int msg, int wparam, int lparam) throws NativeException, IllegalAccessException {
        JNative DefWindowProc = new JNative(DLL_NAME, "DefWindowProcA");
        DefWindowProc.setRetVal(Type.INT);
        DefWindowProc.setParameter(0, hwnd);
        DefWindowProc.setParameter(1, msg);
        DefWindowProc.setParameter(2, wparam);
        DefWindowProc.setParameter(3, lparam);
        DefWindowProc.invoke();
        return DefWindowProc.getRetValAsInt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean UpdateWindow(HWND hwnd) throws NativeException, IllegalAccessException {
        boolean bl;
        block2: {
            JNative dm = new JNative(DLL_NAME, "UpdateWindow");
            try {
                dm.setRetVal(Type.INT);
                dm.setParameter(0, (Integer)hwnd.getValue());
                dm.invoke();
                bl = dm.getRetValAsInt() != 0;
                Object var4_3 = null;
                if (dm == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var4_4 = null;
                    if (dm == null) break block3;
                    dm.dispose();
                }
                throw throwable;
            }
            dm.dispose();
        }
        return bl;
    }

    public static void DispatchMessage(MSG msg) throws NativeException, IllegalAccessException {
        JNative dm = new JNative(DLL_NAME, "DispatchMessageA");
        dm.setParameter(0, msg.getValue().getPointer());
        dm.invoke();
        dm.dispose();
    }

    public static void TranslateMessage(MSG msg) throws NativeException, IllegalAccessException {
        JNative dm = new JNative(DLL_NAME, "TranslateMessage");
        dm.setParameter(0, msg.getValue().getPointer());
        dm.invoke();
        dm.dispose();
    }

    public static int PeekMessage(MSG msg, HWND hwnd, int minMSG, int maxMSG, int removeMsg) throws NativeException, IllegalAccessException {
        JNative gm = new JNative(DLL_NAME, "PeekMessageA");
        gm.setRetVal(Type.INT);
        gm.setParameter(0, msg.getValue().getPointer());
        gm.setParameter(1, Type.INT, hwnd.getValueAsString());
        gm.setParameter(2, Type.INT, "" + minMSG);
        gm.setParameter(3, Type.INT, "" + maxMSG);
        gm.setParameter(4, Type.INT, "" + removeMsg);
        gm.invoke();
        int ret = gm.getRetValAsInt();
        gm.dispose();
        return ret;
    }

    public static int GetMessage(MSG msg, HWND hwnd, int minMSG, int maxMSG) throws NativeException, IllegalAccessException {
        JNative gm = new JNative(DLL_NAME, "GetMessageA");
        gm.setRetVal(Type.INT);
        gm.setParameter(0, msg.getValue().getPointer());
        gm.setParameter(1, (Integer)hwnd.getValue());
        gm.setParameter(2, minMSG);
        gm.setParameter(3, maxMSG);
        gm.invoke();
        int ret = gm.getRetValAsInt();
        gm.dispose();
        return ret;
    }

    public static boolean ShowWindow(HWND hwnd, int nCmdShow) throws NativeException, IllegalAccessException {
        JNative w = new JNative(DLL_NAME, "ShowWindow");
        w.setRetVal(Type.INT);
        w.setParameter(0, (Integer)hwnd.getValue());
        w.setParameter(1, nCmdShow);
        w.invoke();
        return w.getRetValAsInt() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean DestroyWindow(HWND hWnd) throws NativeException, IllegalAccessException {
        boolean bl;
        block3: {
            if (hWnd == null) {
                return false;
            }
            JNative n = null;
            try {
                n = new JNative(DLL_NAME, "DestroyWindow");
                n.setRetVal(Type.INT);
                n.setParameter(0, (Integer)hWnd.getValue());
                n.invoke();
                bl = n.getRetValAsInt() != 0;
                Object var4_3 = null;
                if (n == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var4_4 = null;
                    if (n == null) break block4;
                    n.dispose();
                }
                throw throwable;
            }
            n.dispose();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int CreateWindowEx(int dwExStyle, String lpClassName, String lpWindowName, int dwStyle, int x, int y, int nWidth, int nHeight, int hWndParent, int hMenu, int hInstance, int lParam) throws NativeException, IllegalAccessException {
        int n;
        block4: {
            JNative n2 = null;
            try {
                n2 = new JNative(DLL_NAME, "CreateWindowExA");
                n2.setRetVal(Type.INT);
                int i = 0;
                n2.setParameter(i++, Type.INT, "" + dwExStyle);
                n2.setParameter(i++, Type.STRING, lpClassName);
                if (lpWindowName == null) {
                    n2.setParameter(i++, 0);
                } else {
                    n2.setParameter(i++, Type.STRING, lpWindowName);
                }
                n2.setParameter(i++, Type.INT, "" + dwStyle);
                n2.setParameter(i++, Type.INT, "" + x);
                n2.setParameter(i++, Type.INT, "" + y);
                n2.setParameter(i++, Type.INT, "" + nWidth);
                n2.setParameter(i++, Type.INT, "" + nHeight);
                n2.setParameter(i++, Type.INT, "" + hWndParent);
                n2.setParameter(i++, Type.INT, "" + hMenu);
                n2.setParameter(i++, Type.INT, "" + (hInstance == 0 ? JNative.getCurrentModule() : hInstance));
                n2.setParameter(i++, Type.INT, "" + lParam);
                n2.invoke();
                n = Integer.parseInt(n2.getRetVal());
                Object var16_15 = null;
                if (n2 == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var16_16 = null;
                    if (n2 == null) break block5;
                    n2.dispose();
                }
                throw throwable;
            }
            n2.dispose();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int CreateWindowEx(int dwExStyle, LONG lpClassName, String lpWindowName, int dwStyle, int x, int y, int nWidth, int nHeight, int hWndParent, int hMenu, int hInstance, int lParam) throws NativeException, IllegalAccessException {
        int n;
        block4: {
            JNative n2 = null;
            try {
                n2 = new JNative(DLL_NAME, "CreateWindowExA");
                n2.setRetVal(Type.INT);
                int i = 0;
                n2.setParameter(i++, dwExStyle);
                n2.setParameter(i++, lpClassName.getValue());
                if (lpWindowName == null) {
                    n2.setParameter(i++, 0);
                } else {
                    n2.setParameter(i++, lpWindowName);
                }
                n2.setParameter(i++, dwStyle);
                n2.setParameter(i++, x);
                n2.setParameter(i++, y);
                n2.setParameter(i++, nWidth);
                n2.setParameter(i++, nHeight);
                n2.setParameter(i++, hWndParent);
                n2.setParameter(i++, hMenu);
                n2.setParameter(i++, hInstance == 0 ? JNative.getCurrentModule() : hInstance);
                n2.setParameter(i++, lParam);
                n2.invoke();
                n = n2.getRetValAsInt();
                Object var16_15 = null;
                if (n2 == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var16_16 = null;
                    if (n2 == null) break block5;
                    n2.dispose();
                }
                throw throwable;
            }
            n2.dispose();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int MessageBox(int parentHandle, String message, String caption, int buttons) throws NativeException, IllegalAccessException {
        int n;
        block2: {
            JNative n2 = null;
            try {
                n2 = new JNative(DLL_NAME, "MessageBoxA");
                n2.setRetVal(Type.INT);
                int i = 0;
                n2.setParameter(i++, Type.INT, "" + parentHandle);
                n2.setParameter(i++, Type.STRING, message);
                n2.setParameter(i++, Type.STRING, caption);
                n2.setParameter(i++, Type.INT, "" + buttons);
                n2.invoke();
                n = Integer.parseInt(n2.getRetVal());
                Object var8_7 = null;
                if (n2 == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var8_8 = null;
                    if (n2 == null) break block3;
                    n2.dispose();
                }
                throw throwable;
            }
            n2.dispose();
        }
        return n;
    }

    public static boolean EnumWindows(Callback lpEnumFunc, int lParam) throws NativeException, IllegalAccessException {
        JNative nEnumWindows = new JNative(DLL_NAME, "EnumWindows", false);
        nEnumWindows.setRetVal(Type.INT);
        nEnumWindows.setParameter(0, lpEnumFunc.getCallbackAddress());
        nEnumWindows.setParameter(1, lParam);
        nEnumWindows.invoke();
        return !"0".equals(nEnumWindows.getRetVal());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String GetWindowText(HWND hwnd) throws NativeException, IllegalAccessException {
        String string;
        block5: {
            Pointer nBufferGWT;
            block3: {
                String string2;
                block4: {
                    JNative nGetWindowText = new JNative(DLL_NAME, "GetWindowTextA");
                    nBufferGWT = new Pointer(MemoryBlockFactory.createMemoryBlock(512));
                    try {
                        nGetWindowText.setRetVal(Type.INT);
                        nGetWindowText.setParameter(0, (Integer)hwnd.getValue());
                        nGetWindowText.setParameter(1, nBufferGWT);
                        nGetWindowText.setParameter(2, nBufferGWT.getSize());
                        nGetWindowText.invoke();
                        if (!"0".equals(nGetWindowText.getRetVal())) break block3;
                        string2 = "";
                        Object var5_5 = null;
                        if (nBufferGWT == null) break block4;
                    }
                    catch (Throwable throwable) {
                        block6: {
                            Object var5_7 = null;
                            if (nBufferGWT == null) break block6;
                            nBufferGWT.dispose();
                        }
                        throw throwable;
                    }
                    nBufferGWT.dispose();
                }
                return string2;
            }
            string = nBufferGWT.getAsString();
            Object var5_6 = null;
            if (nBufferGWT == null) break block5;
            nBufferGWT.dispose();
        }
        return string;
    }

    public static HANDLE LoadImage(LONG hinst, String lpszName, int uType, int cxDesired, int cyDesired, int fuLoad) throws Exception {
        JNative LoadImage = new JNative(DLL_NAME, "LoadImageA");
        LoadImage.setRetVal(Type.INT);
        int i = 0;
        LoadImage.setParameter(i++, hinst.getValue());
        LoadImage.setParameter(i++, lpszName);
        LoadImage.setParameter(i++, uType);
        LoadImage.setParameter(i++, cxDesired);
        LoadImage.setParameter(i++, cyDesired);
        LoadImage.setParameter(i++, fuLoad);
        LoadImage.invoke();
        int ret = LoadImage.getRetValAsInt();
        LoadImage.dispose();
        return new HANDLE(ret);
    }

    public static LONG SetCursor(LONG hCursor) throws NativeException, IllegalAccessException {
        JNative SetCursor = new JNative(DLL_NAME, "SetCursor");
        SetCursor.setRetVal(Type.INT);
        SetCursor.setParameter(0, hCursor.getValue());
        SetCursor.invoke();
        int ret = SetCursor.getRetValAsInt();
        SetCursor.dispose();
        return new LONG(ret);
    }

    public static boolean SetSystemCursor(LONG hcur, DWORD id) throws NativeException, IllegalAccessException {
        JNative SetSystemCursor = new JNative(DLL_NAME, "SetSystemCursor");
        SetSystemCursor.setRetVal(Type.INT);
        SetSystemCursor.setParameter(0, hcur.getValue());
        SetSystemCursor.setParameter(1, id.getValue());
        SetSystemCursor.invoke();
        int ret = SetSystemCursor.getRetValAsInt();
        SetSystemCursor.dispose();
        return ret != 0;
    }

    public static DWORD GetClassLong(HWND hwnd, int nIndex) throws NativeException, IllegalAccessException {
        JNative GetClassLong = new JNative(DLL_NAME, "GetClassLongA");
        GetClassLong.setRetVal(Type.INT);
        GetClassLong.setParameter(0, (Integer)hwnd.getValue());
        GetClassLong.setParameter(1, nIndex);
        GetClassLong.invoke();
        int ret = GetClassLong.getRetValAsInt();
        return new DWORD(ret);
    }

    public static DWORD SetClassLong(HWND hwnd, int nIndex, LONG dwNewLong) throws NativeException, IllegalAccessException {
        JNative SetClassLong = new JNative(DLL_NAME, "SetClassLongA");
        SetClassLong.setRetVal(Type.INT);
        int i = 0;
        SetClassLong.setParameter(i++, (Integer)hwnd.getValue());
        SetClassLong.setParameter(i++, nIndex);
        SetClassLong.setParameter(i++, dwNewLong.getValue());
        SetClassLong.invoke();
        return new DWORD(SetClassLong.getRetValAsInt());
    }

    public static LONG LoadCursorFromFile(String lpFileName) throws NativeException, IllegalAccessException {
        JNative LoadCursorFromFile = new JNative(DLL_NAME, "LoadCursorFromFileA");
        LoadCursorFromFile.setRetVal(Type.INT);
        LoadCursorFromFile.setParameter(0, lpFileName);
        LoadCursorFromFile.invoke();
        int ret = LoadCursorFromFile.getRetValAsInt();
        LoadCursorFromFile.dispose();
        return new LONG(ret);
    }

    public static int SetWindowLong(HWND hwnd, int nIndex, LONG dwNewLong) throws NativeException, IllegalAccessException {
        if (hwnd == null) {
            return 0;
        }
        JNative _setWindowLong = new JNative(DLL_NAME, "SetWindowLongA");
        _setWindowLong.setRetVal(Type.INT);
        _setWindowLong.setParameter(0, (Integer)hwnd.getValue());
        _setWindowLong.setParameter(1, nIndex);
        _setWindowLong.setParameter(2, dwNewLong.getValue());
        _setWindowLong.invoke();
        int ret = _setWindowLong.getRetValAsInt();
        _setWindowLong.dispose();
        return ret;
    }

    public static boolean UnhookWindowsHookEx(int hHook) throws NativeException, IllegalAccessException {
        JNative UnhookWindowsHookEx = new JNative(DLL_NAME, "UnhookWindowsHookEx");
        UnhookWindowsHookEx.setRetVal(Type.INT);
        UnhookWindowsHookEx.setParameter(0, hHook);
        UnhookWindowsHookEx.invoke();
        int ret = UnhookWindowsHookEx.getRetValAsInt();
        UnhookWindowsHookEx.dispose();
        return ret != 0;
    }

    public static int SetWindowsHookEx(int idHook, int lpfn, int hMod, DWORD dwThreadId) throws NativeException, IllegalAccessException {
        JNative SetWindowsHookEx = new JNative(DLL_NAME, "SetWindowsHookExA");
        SetWindowsHookEx.setRetVal(Type.INT);
        int pos = 0;
        SetWindowsHookEx.setParameter(pos++, idHook);
        SetWindowsHookEx.setParameter(pos++, lpfn);
        SetWindowsHookEx.setParameter(pos++, hMod);
        SetWindowsHookEx.setParameter(pos++, dwThreadId.getValue());
        SetWindowsHookEx.invoke();
        pos = SetWindowsHookEx.getRetValAsInt();
        SetWindowsHookEx.dispose();
        return pos;
    }

    public static int CallNextHookEx(int hhk, int nCode, int wParam, int lParam) throws NativeException, IllegalAccessException {
        JNative CallNextHookEx = new JNative(DLL_NAME, "CallNextHookEx");
        CallNextHookEx.setRetVal(Type.INT);
        int pos = 0;
        CallNextHookEx.setParameter(pos++, hhk);
        CallNextHookEx.setParameter(pos++, nCode);
        CallNextHookEx.setParameter(pos++, wParam);
        CallNextHookEx.setParameter(pos++, lParam);
        CallNextHookEx.invoke();
        pos = CallNextHookEx.getRetValAsInt();
        CallNextHookEx.dispose();
        return pos;
    }

    public static LONG RegisterClass(WNDCLASS lpWndClass) throws NativeException, IllegalAccessException {
        JNative registerClass = new JNative(DLL_NAME, "RegisterClassA");
        registerClass.setRetVal(Type.INT);
        registerClass.setParameter(0, lpWndClass.createPointer());
        registerClass.invoke();
        int i = registerClass.getRetValAsInt();
        registerClass.dispose();
        return new LONG(i);
    }

    public static LONG RegisterClassEx(WNDCLASSEX lpWndClass) throws NativeException, IllegalAccessException {
        JNative RegisterClassEx = new JNative(DLL_NAME, "RegisterClassExA");
        RegisterClassEx.setRetVal(Type.INT);
        RegisterClassEx.setParameter(0, lpWndClass.createPointer());
        RegisterClassEx.invoke();
        int i = RegisterClassEx.getRetValAsInt();
        RegisterClassEx.dispose();
        return new LONG(i);
    }

    public static int GetClassName(HWND hWnd, Pointer lpClassName, int nMaxCount) throws NativeException, IllegalAccessException {
        JNative GetClassName = new JNative(DLL_NAME, "GetClassNameA");
        GetClassName.setRetVal(Type.INT);
        int i = 0;
        GetClassName.setParameter(i++, (Integer)hWnd.getValue());
        GetClassName.setParameter(i++, lpClassName);
        GetClassName.setParameter(i++, nMaxCount);
        GetClassName.invoke();
        i = GetClassName.getRetValAsInt();
        GetClassName.dispose();
        return i;
    }

    public static boolean GetClassInfo(int hInstance, String lpClassName, WNDCLASS lpWndClass) throws NativeException, IllegalAccessException {
        JNative GetClassInfo = new JNative(DLL_NAME, "GetClassInfoA");
        GetClassInfo.setRetVal(Type.INT);
        int i = 0;
        GetClassInfo.setParameter(i++, hInstance);
        GetClassInfo.setParameter(i++, lpClassName);
        GetClassInfo.setParameter(i++, lpWndClass.createPointer());
        GetClassInfo.invoke();
        i = GetClassInfo.getRetValAsInt();
        GetClassInfo.dispose();
        return i != 0;
    }

    public static boolean GetClassInfoEx(int hInstance, String lpClassName, WNDCLASSEX lpWndClass) throws NativeException, IllegalAccessException {
        JNative GetClassInfo = new JNative(DLL_NAME, "GetClassInfoExA");
        GetClassInfo.setRetVal(Type.INT);
        int i = 0;
        GetClassInfo.setParameter(i++, hInstance);
        GetClassInfo.setParameter(i++, lpClassName);
        GetClassInfo.setParameter(i++, lpWndClass.createPointer());
        GetClassInfo.invoke();
        i = GetClassInfo.getRetValAsInt();
        GetClassInfo.dispose();
        return i != 0;
    }

    public static LONG LoadIcon(LONG hInstance, String lpIconName) throws NativeException, IllegalAccessException {
        JNative loadIcon = new JNative(DLL_NAME, "LoadIconA");
        loadIcon.setRetVal(Type.INT);
        loadIcon.setParameter(0, hInstance.getValue());
        loadIcon.setParameter(1, lpIconName);
        loadIcon.invoke();
        int ret = loadIcon.getRetValAsInt();
        loadIcon.dispose();
        return new LONG(ret);
    }

    public static LONG LoadIcon(LONG hInstance, int ressource) throws NativeException, IllegalAccessException {
        JNative loadIcon = new JNative(DLL_NAME, "LoadIconA");
        loadIcon.setRetVal(Type.INT);
        loadIcon.setParameter(0, hInstance.getValue());
        loadIcon.setParameter(1, ressource);
        loadIcon.invoke();
        int ret = loadIcon.getRetValAsInt();
        loadIcon.dispose();
        return new LONG(ret);
    }

    public static LRESULT SendMessage(HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam) throws NativeException, IllegalAccessException {
        JNative SendMessage = new JNative(DLL_NAME, "SendMessageA");
        SendMessage.setRetVal(Type.INT);
        int pos = 0;
        SendMessage.setParameter(pos++, (Integer)hWnd.getValue());
        SendMessage.setParameter(pos++, Msg.getValue().shortValue());
        SendMessage.setParameter(pos++, wParam.getValue());
        SendMessage.setParameter(pos++, lParam.getValue());
        SendMessage.invoke();
        pos = SendMessage.getRetValAsInt();
        SendMessage.dispose();
        return new LRESULT(pos);
    }

    public static boolean PostMessage(HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam) throws NativeException, IllegalAccessException {
        JNative SendMessage = new JNative(DLL_NAME, "PostMessageA");
        SendMessage.setRetVal(Type.INT);
        int pos = 0;
        SendMessage.setParameter(pos++, (Integer)hWnd.getValue());
        SendMessage.setParameter(pos++, Msg.getValue().shortValue());
        SendMessage.setParameter(pos++, wParam.getValue());
        SendMessage.setParameter(pos++, lParam.getValue());
        SendMessage.invoke();
        pos = SendMessage.getRetValAsInt();
        SendMessage.dispose();
        return pos != 0;
    }

    public static LONG CreateIcon(LONG hInstance, int nWidth, int nHeight, int cPlanes, int cBitsPixel, int[] lpbANDbits, int[] lpbXORbits) throws NativeException, IllegalAccessException {
        int i;
        JNative createIcon = new JNative(DLL_NAME, "CreateIcon");
        Pointer p = new Pointer(MemoryBlockFactory.createMemoryBlock(lpbXORbits.length * 4));
        for (i = 0; i < lpbXORbits.length; ++i) {
            p.setIntAt(i * 4, lpbXORbits[i]);
        }
        createIcon.setRetVal(Type.INT);
        i = 0;
        createIcon.setParameter(i++, hInstance.getValue());
        createIcon.setParameter(i++, nWidth);
        createIcon.setParameter(i++, nHeight);
        createIcon.setParameter(i++, cPlanes);
        createIcon.setParameter(i++, cBitsPixel);
        createIcon.setParameter(i++, p);
        createIcon.setParameter(i++, p);
        createIcon.invoke();
        i = createIcon.getRetValAsInt();
        createIcon.dispose();
        return new LONG(i);
    }

    public static LONG GetWindowLong(HWND hWnd, int nIndex) throws NativeException, IllegalAccessException {
        JNative GetWindowLong = new JNative(DLL_NAME, "GetWindowLongA");
        GetWindowLong.setRetVal(Type.INT);
        int pos = 0;
        GetWindowLong.setParameter(pos++, (Integer)hWnd.getValue());
        GetWindowLong.setParameter(pos++, nIndex);
        GetWindowLong.invoke();
        pos = GetWindowLong.getRetValAsInt();
        GetWindowLong.dispose();
        return new LONG(pos);
    }

    public static boolean AttachThreadInput(int idAttach, int idAttachTo, boolean fAttach) throws NativeException, IllegalAccessException {
        JNative AttachThreadInput = new JNative(DLL_NAME, "AttachThreadInput");
        AttachThreadInput.setRetVal(Type.INT);
        int pos = 0;
        AttachThreadInput.setParameter(pos++, idAttach);
        AttachThreadInput.setParameter(pos++, idAttachTo);
        AttachThreadInput.setParameter(pos++, fAttach ? "1" : "0");
        AttachThreadInput.invoke();
        pos = AttachThreadInput.getRetValAsInt();
        AttachThreadInput.dispose();
        return pos != 0;
    }

    public static HWND GetForegroundWindow() throws NativeException, IllegalAccessException {
        JNative GetForegroundWindow = new JNative(DLL_NAME, "GetForegroundWindow");
        GetForegroundWindow.setRetVal(Type.INT);
        GetForegroundWindow.invoke();
        int ret = GetForegroundWindow.getRetValAsInt();
        GetForegroundWindow.dispose();
        return new HWND(ret);
    }

    public static HWND GetActiveWindow() throws NativeException, IllegalAccessException {
        JNative GetActiveWindow = new JNative(DLL_NAME, "GetActiveWindow");
        GetActiveWindow.setRetVal(Type.INT);
        GetActiveWindow.invoke();
        int ret = GetActiveWindow.getRetValAsInt();
        GetActiveWindow.dispose();
        return new HWND(ret);
    }

    public static HWND SetActiveWindow(HWND hWnd) throws NativeException, IllegalAccessException {
        JNative SetActiveWindow = new JNative(DLL_NAME, "SetActiveWindow");
        SetActiveWindow.setRetVal(Type.INT);
        int pos = 0;
        SetActiveWindow.setParameter(pos++, (Integer)hWnd.getValue());
        SetActiveWindow.invoke();
        pos = SetActiveWindow.getRetValAsInt();
        SetActiveWindow.dispose();
        return new HWND(pos);
    }

    public static boolean SetForegroundWindow(HWND hWnd) throws NativeException, IllegalAccessException {
        JNative SetForegroundWindow = new JNative(DLL_NAME, "SetForegroundWindow");
        SetForegroundWindow.setRetVal(Type.INT);
        int pos = 0;
        SetForegroundWindow.setParameter(pos++, (Integer)hWnd.getValue());
        SetForegroundWindow.invoke();
        pos = SetForegroundWindow.getRetValAsInt();
        SetForegroundWindow.dispose();
        return pos != 0;
    }

    public static boolean DestroyIcon(LONG hIcon) throws NativeException, IllegalAccessException {
        JNative DestroyIcon = new JNative(DLL_NAME, "DestroyIcon");
        DestroyIcon.setRetVal(Type.INT);
        int pos = 0;
        DestroyIcon.setParameter(0, hIcon.getValue());
        DestroyIcon.invoke();
        pos = DestroyIcon.getRetValAsInt();
        DestroyIcon.dispose();
        return pos != 0;
    }

    public static int RegisterWindowMessage(String lpString) throws NativeException, IllegalAccessException {
        JNative RegisterWindowMessage = new JNative(DLL_NAME, "RegisterWindowMessageA");
        RegisterWindowMessage.setRetVal(Type.INT);
        int pos = 0;
        RegisterWindowMessage.setParameter(pos++, lpString);
        RegisterWindowMessage.invoke();
        pos = RegisterWindowMessage.getRetValAsInt();
        RegisterWindowMessage.dispose();
        return pos;
    }

    public static boolean SetWindowPos(HWND hWnd, HWND hWndInsertAfter, int X, int Y, int cx, int cy, int uFlags) throws NativeException, IllegalAccessException {
        JNative SetWindowPos = new JNative(DLL_NAME, "SetWindowPos");
        SetWindowPos.setRetVal(Type.INT);
        int pos = 0;
        SetWindowPos.setParameter(pos++, (Integer)hWnd.getValue());
        SetWindowPos.setParameter(pos++, (Integer)hWndInsertAfter.getValue());
        SetWindowPos.setParameter(pos++, X);
        SetWindowPos.setParameter(pos++, Y);
        SetWindowPos.setParameter(pos++, cx);
        SetWindowPos.setParameter(pos++, cy);
        SetWindowPos.setParameter(pos++, uFlags);
        SetWindowPos.invoke();
        pos = SetWindowPos.getRetValAsInt();
        SetWindowPos.dispose();
        return pos != 0;
    }

    public static boolean RegisterHotKey(HWND hWnd, int id, int fsModifiers, int vk) throws NativeException, IllegalAccessException {
        JNative RegisterHotKey = new JNative(DLL_NAME, "RegisterHotKey");
        RegisterHotKey.setRetVal(Type.INT);
        int pos = 0;
        RegisterHotKey.setParameter(pos++, (Integer)hWnd.getValue());
        RegisterHotKey.setParameter(pos++, id);
        RegisterHotKey.setParameter(pos++, fsModifiers);
        RegisterHotKey.setParameter(pos++, vk);
        RegisterHotKey.invoke();
        pos = RegisterHotKey.getRetValAsInt();
        RegisterHotKey.dispose();
        return pos != 0;
    }

    public static boolean UnregisterHotKey(HWND hWnd, int id) throws NativeException, IllegalAccessException {
        JNative UnregisterHotKey = new JNative(DLL_NAME, "UnregisterHotKey");
        UnregisterHotKey.setRetVal(Type.INT);
        int pos = 0;
        UnregisterHotKey.setParameter(pos++, (Integer)hWnd.getValue());
        UnregisterHotKey.setParameter(pos++, id);
        UnregisterHotKey.invoke();
        pos = UnregisterHotKey.getRetValAsInt();
        UnregisterHotKey.dispose();
        return pos != 0;
    }

    public static boolean GetWindowRect(HWND hwnd, LRECT rect) throws NativeException, IllegalAccessException {
        JNative GetWindowRect = new JNative(DLL_NAME, "GetWindowRect");
        GetWindowRect.setRetVal(Type.INT);
        int pos = 0;
        GetWindowRect.setParameter(pos++, (Integer)hwnd.getValue());
        GetWindowRect.setParameter(pos++, rect.getPointer());
        GetWindowRect.invoke();
        pos = GetWindowRect.getRetValAsInt();
        GetWindowRect.dispose();
        return pos != 0;
    }

    public static HANDLE RegisterDeviceNotification(HANDLE hRecipient, int Flags) throws NativeException, IllegalAccessException {
        JNative registerDeviceNotification = new JNative(DLL_NAME, "RegisterDeviceNotificationA");
        registerDeviceNotification.setRetVal(Type.INT);
        int pos = 0;
        DEV_BROADCAST_HANDLE dbh = new DEV_BROADCAST_HANDLE(5, GUID.GUID_IO_MEDIA_ARRIVAL);
        registerDeviceNotification.setParameter(pos++, hRecipient.getValue());
        registerDeviceNotification.setParameter(pos++, dbh.getPointer());
        registerDeviceNotification.setParameter(pos++, Flags);
        registerDeviceNotification.invoke();
        int retValAsInt = registerDeviceNotification.getRetValAsInt();
        if (retValAsInt == 0) {
            JNative.getLogger().log("GetLastError " + Kernel32.GetLastError());
        }
        JNative.getLogger().log("return value : " + retValAsInt);
        return dbh.getDbch_hdevnotify();
    }

    public static int CreateCursor(HANDLE hInst, int xHotSpot, int yHotSpot, int nWidth, int nHeight, Pointer pvANDPlane, Pointer pvXORPlane) throws NativeException, IllegalAccessException {
        JNative CreateCursor = new JNative(DLL_NAME, "CreateCursor");
        CreateCursor.setRetVal(Type.INT);
        int pos = 0;
        CreateCursor.setParameter(pos++, hInst.getValue());
        CreateCursor.setParameter(pos++, xHotSpot);
        CreateCursor.setParameter(pos++, yHotSpot);
        CreateCursor.setParameter(pos++, nWidth);
        CreateCursor.setParameter(pos++, nHeight);
        CreateCursor.setParameter(pos++, pvANDPlane.getPointer());
        CreateCursor.setParameter(pos++, pvXORPlane.getPointer());
        CreateCursor.invoke();
        return CreateCursor.getRetValAsInt();
    }

    public static boolean DestroyCursor(int hCursor) throws NativeException, IllegalAccessException {
        JNative DestroyCursor = new JNative(DLL_NAME, "DestroyCursor");
        DestroyCursor.setRetVal(Type.INT);
        int pos = 0;
        DestroyCursor.setParameter(pos++, hCursor);
        DestroyCursor.invoke();
        pos = DestroyCursor.getRetValAsInt();
        return pos != 0;
    }

    public static HWND FindWindowEx(HWND hwndParent, HWND hwndChildAfter, String className, String windowName) throws NativeException, IllegalAccessException {
        JNative FindWindowEx = new JNative(DLL_NAME, "FindWindowExA");
        FindWindowEx.setRetVal(Type.INT);
        FindWindowEx.setParameter(0, (Integer)hwndParent.getValue());
        FindWindowEx.setParameter(1, (Integer)hwndChildAfter.getValue());
        FindWindowEx.setParameter(2, className);
        FindWindowEx.setParameter(3, windowName);
        FindWindowEx.invoke();
        return new HWND(FindWindowEx.getRetValAsInt());
    }

    public static boolean EnumChildWindows(HWND hWndParent, Callback lpEnumFunc, int lParam) throws NativeException, IllegalAccessException {
        JNative nEnumWindows = new JNative(DLL_NAME, "EnumChildWindows", false);
        nEnumWindows.setRetVal(Type.INT);
        nEnumWindows.setParameter(0, (Integer)hWndParent.getValue());
        nEnumWindows.setParameter(1, lpEnumFunc.getCallbackAddress());
        nEnumWindows.setParameter(2, lParam);
        nEnumWindows.invoke();
        return !"0".equals(nEnumWindows.getRetVal());
    }
}

