/*
 * Decompiled with CFR 0.152.
 */
package com.zk.util;

import com.zk.util.BaseDBBackupUtil;
import com.zk.util.ConfigFile;
import java.io.File;
import java.io.RandomAccessFile;
import java.net.URI;

public class PreRestoreDBUtil {
    private static int RESTOREDB_STATE_OK = 1;
    private static int RESTOREDB_STATE_HIGH = 2;
    private static int RESTOREDB_STATE_LOW = 3;
    private static int ERROR = -1;
    private static String systemVersion;
    private static String txtSystemVersion;

    static {
        txtSystemVersion = null;
    }

    public static int canRestore(String filePath) {
        try {
            systemVersion = BaseDBBackupUtil.getSystemVersion();
            if (systemVersion == null || "".equals(systemVersion)) {
                return ERROR;
            }
            File file = new File(filePath);
            if (filePath.contains(" ")) {
                URI uri = file.toURI();
                file = new File(uri);
            }
            txtSystemVersion = null;
            PreRestoreDBUtil.getTxtVersion(file);
            if (txtSystemVersion == null) {
                return ERROR;
            }
            if (systemVersion.trim().compareTo(txtSystemVersion.trim()) == 0) {
                return RESTOREDB_STATE_OK;
            }
            if (systemVersion.trim().compareTo(txtSystemVersion.trim()) > 0) {
                return RESTOREDB_STATE_HIGH;
            }
            return RESTOREDB_STATE_LOW;
        }
        catch (Exception e) {
            e.printStackTrace();
            return ERROR;
        }
    }

    private static void getTxtVersion(File file) {
        try {
            String iniType = ConfigFile.getValue(0, "options", "dbtype");
            if (iniType.equals("oracle")) {
                String name = file.getName();
                txtSystemVersion = name.substring(name.lastIndexOf("_") + 1, name.toLowerCase().lastIndexOf(".dmp"));
            } else {
                RandomAccessFile randomFile = new RandomAccessFile(file, "r");
                String line = null;
                long begin = randomFile.length() > 300L ? randomFile.length() - 300L : 0L;
                randomFile.seek(begin);
                while ((line = randomFile.readLine()) != null) {
                    if (!line.contains("-- Database version")) continue;
                    txtSystemVersion = line.split("-- Database version")[1].trim();
                    break;
                }
                randomFile.close();
            }
        }
        catch (Exception e) {
            txtSystemVersion = null;
            e.printStackTrace();
        }
    }
}

