/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.util;

import java.util.ArrayList;
import org.xvolks.jnative.JNative;
import org.xvolks.jnative.Type;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.HKEY;
import org.xvolks.jnative.misc.REGSAM;
import org.xvolks.jnative.misc.TOKEN_PRIVILEGES;
import org.xvolks.jnative.misc.basicStructures.DWORD;
import org.xvolks.jnative.misc.basicStructures.HANDLE;
import org.xvolks.jnative.misc.basicStructures.LONG;
import org.xvolks.jnative.misc.registry.REGTYPE;
import org.xvolks.jnative.misc.registry.RegData;
import org.xvolks.jnative.misc.registry.RegKey;
import org.xvolks.jnative.misc.registry.RegQueryKey;
import org.xvolks.jnative.misc.registry.RegValue;
import org.xvolks.jnative.misc.registry.RegValueTypes;
import org.xvolks.jnative.pointers.NullPointer;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.MemoryBlockFactory;
import org.xvolks.jnative.util.StructConverter;

public class Advapi32 {
    public static final String DLL_NAME = "Advapi32.dll";
    private static String mLastErrorCode = "0";
    public static final int STANDARD_RIGHTS_REQUIRED = 983040;
    public static final int SC_MANAGER_CONNECT = 1;
    public static final int SC_MANAGER_CREATE_SERVICE = 2;
    public static final int SC_MANAGER_ENUMERATE_SERVICE = 4;
    public static final int SC_MANAGER_LOCK = 8;
    public static final int SC_MANAGER_MODIFY_BOOT_CONFIG = 32;
    public static final int SC_MANAGER_QUERY_LOCK_STATUS = 16;
    public static final int SC_MANAGER_ALL_ACCESS = 983103;
    public static final int SERVICE_FILE_SYSTEM_DRIVER = 2;
    public static final int SERVICE_KERNEL_DRIVER = 1;
    public static final int SERVICE_WIN32_OWN_PROCESS = 16;
    public static final int SERVICE_WIN32_SHARE_PROCESS = 32;
    public static final int SERVICE_INTERACTIVE_PROCESS = 256;
    public static final int SERVICE_AUTO_START = 2;
    public static final int SERVICE_BOOT_START = 0;
    public static final int SERVICE_DEMAND_START = 3;
    public static final int SERVICE_DISABLED = 4;
    public static final int SERVICE_SYSTEM_START = 1;
    public static final int SERVICE_ERROR_CRITICAL = 3;
    public static final int SERVICE_ERROR_IGNORE = 0;
    public static final int SERVICE_ERROR_NORMAL = 1;
    public static final int SERVICE_ERROR_SEVERE = 2;
    public static final int SERVICE_STOP_CUSTOM = 0x20000000;
    public static final int SERVICE_STOP_PLANNED = 0x40000000;
    public static final int SERVICE_STOP_UNPLANNED = 0x10000000;
    public static final int SERVICE_CONTROL_CONTINUE = 3;
    public static final int SERVICE_CONTROL_INTERROGATE = 4;
    public static final int SERVICE_CONTROL_NETBINDADD = 7;
    public static final int SERVICE_CONTROL_NETBINDDISABLE = 10;
    public static final int SERVICE_CONTROL_NETBINDENABLE = 9;
    public static final int SERVICE_CONTROL_NETBINDREMOVE = 8;
    public static final int SERVICE_CONTROL_PARAMCHANGE = 6;
    public static final int SERVICE_CONTROL_PAUSE = 2;
    public static final int SERVICE_CONTROL_STOP = 1;
    public static final int SERVICE_QUERY_CONFIG = 1;
    public static final int SERVICE_CHANGE_CONFIG = 2;
    public static final int SERVICE_QUERY_STATUS = 4;
    public static final int SERVICE_ENUMERATE_DEPENDENTS = 8;
    public static final int SERVICE_START = 16;
    public static final int SERVICE_STOP = 32;
    public static final int SERVICE_PAUSE_CONTINUE = 64;
    public static final int SERVICE_INTERROGATE = 128;
    public static final int SERVICE_USER_DEFINED_CONTROL = 256;
    public static final int SERVICE_ALL_ACCESS = 983551;
    static int cpt = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean StartService(int hService, int dwNumServiceArgs, String[] lpServiceArgVectors) throws NativeException, IllegalAccessException {
        boolean bl;
        JNative StartService = new JNative(DLL_NAME, "StartServiceA");
        Pointer arrayOfLPCSTR = null;
        ArrayList<Pointer> savedPointers = new ArrayList<Pointer>();
        try {
            StartService.setRetVal(Type.INT);
            int i = 0;
            StartService.setParameter(i++, hService);
            StartService.setParameter(i++, dwNumServiceArgs);
            if (lpServiceArgVectors != null) {
                arrayOfLPCSTR = new Pointer(MemoryBlockFactory.createMemoryBlock(lpServiceArgVectors.length * 4));
                int j = 0;
                for (String s : lpServiceArgVectors) {
                    Pointer p = new Pointer(MemoryBlockFactory.createMemoryBlock(s.length() + 1));
                    p.setMemory(s);
                    arrayOfLPCSTR.setIntAt(j, p.getPointer());
                    j += 4;
                    savedPointers.add(p);
                }
                StartService.setParameter(i++, arrayOfLPCSTR);
            } else {
                StartService.setParameter(i++, 0);
            }
            StartService.invoke();
            bl = StartService.getRetValAsInt() != 0;
            Object var14_13 = null;
        }
        catch (Throwable throwable) {
            block8: {
                Object var14_14 = null;
                for (Pointer p : savedPointers) {
                    if (p == null) continue;
                    p.dispose();
                }
                if (arrayOfLPCSTR == null) break block8;
                arrayOfLPCSTR.dispose();
            }
            throw throwable;
        }
        for (Pointer p : savedPointers) {
            if (p == null) continue;
            p.dispose();
        }
        if (arrayOfLPCSTR != null) {
            arrayOfLPCSTR.dispose();
        }
        return bl;
    }

    public static boolean ControlService(int hService, DWORD dwControl, Pointer pControlParams) throws NativeException, IllegalAccessException {
        JNative ControlService = new JNative(DLL_NAME, "ControlService");
        ControlService.setRetVal(Type.INT);
        int i = 0;
        ControlService.setParameter(i++, hService);
        ControlService.setParameter(i++, dwControl.getValue());
        ControlService.setParameter(i++, pControlParams);
        ControlService.invoke();
        return ControlService.getRetValAsInt() != 0;
    }

    public static boolean UnlockServiceDatabase(int ScLock) throws NativeException, IllegalAccessException {
        JNative UnlockServiceDatabase = new JNative(DLL_NAME, "UnlockServiceDatabase");
        UnlockServiceDatabase.setRetVal(Type.INT);
        int i = 0;
        UnlockServiceDatabase.setParameter(i++, ScLock);
        UnlockServiceDatabase.invoke();
        return UnlockServiceDatabase.getRetValAsInt() != 0;
    }

    public static int LockServiceDatabase(int hSCManager) throws NativeException, IllegalAccessException {
        JNative LockServiceDatabase = new JNative(DLL_NAME, "LockServiceDatabase");
        LockServiceDatabase.setRetVal(Type.INT);
        int i = 0;
        LockServiceDatabase.setParameter(i++, hSCManager);
        LockServiceDatabase.invoke();
        return LockServiceDatabase.getRetValAsInt();
    }

    public static boolean ChangeServiceConfig(int hService, DWORD dwServiceType, DWORD dwStartType, DWORD dwErrorControl, String lpBinaryPathName, String lpLoadOrderGroup, DWORD lpdwTagId, String lpDependencies, String lpServiceStartName, String lpPassword, String lpDisplayName) throws NativeException, IllegalAccessException {
        JNative ChangeServiceConfig = new JNative(DLL_NAME, "ChangeServiceConfigA");
        ChangeServiceConfig.setRetVal(Type.INT);
        int i = 0;
        ChangeServiceConfig.setParameter(i++, hService);
        ChangeServiceConfig.setParameter(i++, dwServiceType.getValue());
        ChangeServiceConfig.setParameter(i++, dwStartType.getValue());
        ChangeServiceConfig.setParameter(i++, dwErrorControl.getValue());
        ChangeServiceConfig.setParameter(i++, lpBinaryPathName);
        ChangeServiceConfig.setParameter(i++, lpLoadOrderGroup);
        ChangeServiceConfig.setParameter(i++, lpdwTagId.getValue());
        ChangeServiceConfig.setParameter(i++, lpDependencies);
        ChangeServiceConfig.setParameter(i++, lpServiceStartName);
        ChangeServiceConfig.setParameter(i++, lpPassword);
        ChangeServiceConfig.setParameter(i++, lpDisplayName);
        ChangeServiceConfig.invoke();
        return ChangeServiceConfig.getRetValAsInt() != 0;
    }

    public static int OpenService(int hSCManager, String lpServiceName, DWORD dwDesiredAccess) throws NativeException, IllegalAccessException {
        JNative OpenService = new JNative(DLL_NAME, "OpenServiceA");
        OpenService.setRetVal(Type.INT);
        int i = 0;
        OpenService.setParameter(i++, hSCManager);
        OpenService.setParameter(i++, lpServiceName);
        OpenService.setParameter(i++, dwDesiredAccess.getValue());
        OpenService.invoke();
        return OpenService.getRetValAsInt();
    }

    public static boolean DeleteService(int hSCObject) throws NativeException, IllegalAccessException {
        JNative DeleteService = new JNative(DLL_NAME, "DeleteService");
        DeleteService.setRetVal(Type.INT);
        int i = 0;
        DeleteService.setParameter(i++, hSCObject);
        DeleteService.invoke();
        return DeleteService.getRetValAsInt() != 0;
    }

    public static boolean CloseServiceHandle(int hSCObject) throws NativeException, IllegalAccessException {
        JNative CloseServiceHandle = new JNative(DLL_NAME, "CloseServiceHandle");
        CloseServiceHandle.setRetVal(Type.INT);
        int i = 0;
        CloseServiceHandle.setParameter(i++, hSCObject);
        CloseServiceHandle.invoke();
        return CloseServiceHandle.getRetValAsInt() != 0;
    }

    public static int OpenSCManager(String lpMachineName, String lpDatabaseName, DWORD dwDesiredAccess) throws NativeException, IllegalAccessException {
        JNative OpenSCManager = new JNative(DLL_NAME, "OpenSCManagerA");
        OpenSCManager.setRetVal(Type.INT);
        int i = 0;
        OpenSCManager.setParameter(i++, lpMachineName);
        OpenSCManager.setParameter(i++, lpDatabaseName);
        OpenSCManager.setParameter(i++, dwDesiredAccess.getValue());
        OpenSCManager.invoke();
        return OpenSCManager.getRetValAsInt();
    }

    public static int CreateService(int hSCManager, String lpServiceName, String lpDisplayName, DWORD dwDesiredAccess, DWORD dwServiceType, DWORD dwStartType, DWORD dwErrorControl, String lpBinaryPathName, String lpLoadOrderGroup, DWORD lpdwTagId, String lpDependencies, String lpServiceStartName, String lpPassword) throws NativeException, IllegalAccessException {
        JNative CreateService = new JNative(DLL_NAME, "CreateServiceA");
        CreateService.setRetVal(Type.INT);
        int i = 0;
        CreateService.setParameter(i++, hSCManager);
        CreateService.setParameter(i++, lpServiceName);
        CreateService.setParameter(i++, lpDisplayName);
        CreateService.setParameter(i++, dwDesiredAccess.getValue());
        CreateService.setParameter(i++, dwServiceType.getValue());
        CreateService.setParameter(i++, dwStartType.getValue());
        CreateService.setParameter(i++, dwErrorControl.getValue());
        CreateService.setParameter(i++, lpBinaryPathName);
        CreateService.setParameter(i++, lpLoadOrderGroup);
        CreateService.setParameter(i++, lpdwTagId.getValue());
        CreateService.setParameter(i++, lpDependencies);
        CreateService.setParameter(i++, lpServiceStartName);
        CreateService.setParameter(i++, lpPassword);
        CreateService.invoke();
        return CreateService.getRetValAsInt();
    }

    public static boolean AdjustTokenPrivileges(HANDLE TokenHandle, boolean DisableAllPrivileges, TOKEN_PRIVILEGES NewState) throws NativeException, IllegalAccessException {
        JNative nAdjustTokenPrivileges = new JNative(DLL_NAME, "AdjustTokenPrivileges");
        nAdjustTokenPrivileges.setRetVal(Type.INT);
        int i = 0;
        nAdjustTokenPrivileges.setParameter(i++, TokenHandle.getValue());
        nAdjustTokenPrivileges.setParameter(i++, DisableAllPrivileges ? -1 : 0);
        nAdjustTokenPrivileges.setParameter(i++, NewState.getPointer());
        nAdjustTokenPrivileges.setParameter(i++, 0);
        nAdjustTokenPrivileges.setParameter(i++, NullPointer.NULL);
        nAdjustTokenPrivileges.setParameter(i++, 0);
        nAdjustTokenPrivileges.invoke();
        return nAdjustTokenPrivileges.getRetValAsInt() != 0;
    }

    public static boolean LookupPrivilegeValue(String lpSystemName, String lpName, LONG lpLuid) throws NativeException, IllegalAccessException {
        JNative nLookupPrivilegeValue = new JNative(DLL_NAME, "LookupPrivilegeValueA");
        nLookupPrivilegeValue.setRetVal(Type.INT);
        int i = 0;
        nLookupPrivilegeValue.setParameter(i++, lpSystemName);
        nLookupPrivilegeValue.setParameter(i++, lpName);
        nLookupPrivilegeValue.setParameter(i++, lpLuid.getPointer());
        nLookupPrivilegeValue.invoke();
        return nLookupPrivilegeValue.getRetValAsInt() != 0;
    }

    public static boolean OpenProcessToken(HANDLE ProcessHandle2, int DesiredAccess, HANDLE TokenHandle) throws NativeException, IllegalAccessException {
        JNative nOpenProcessToken = new JNative(DLL_NAME, "OpenProcessToken");
        nOpenProcessToken.setRetVal(Type.INT);
        int i = 0;
        nOpenProcessToken.setParameter(i++, ProcessHandle2.getValue());
        nOpenProcessToken.setParameter(i++, DesiredAccess);
        nOpenProcessToken.setParameter(i++, TokenHandle.getPointer());
        nOpenProcessToken.invoke();
        return nOpenProcessToken.getRetValAsInt() != 0;
    }

    public static boolean RegDeleteValue(HKEY hKey, String lpSubKey) throws NativeException, IllegalAccessException {
        JNative nRegDeleteValue = new JNative(DLL_NAME, "RegDeleteValueA");
        nRegDeleteValue.setRetVal(Type.INT);
        int i = 0;
        nRegDeleteValue.setParameter(i++, hKey.getValue());
        nRegDeleteValue.setParameter(i++, Type.STRING, lpSubKey);
        nRegDeleteValue.invoke();
        return nRegDeleteValue.getRetValAsInt() != 0;
    }

    public static boolean RegDeleteKey(HKEY hKey, String lpSubKey) throws NativeException, IllegalAccessException {
        JNative nRegDeleteKey = new JNative(DLL_NAME, "RegDeleteKeyA");
        nRegDeleteKey.setRetVal(Type.INT);
        int i = 0;
        nRegDeleteKey.setParameter(i++, hKey.getValue());
        nRegDeleteKey.setParameter(i++, Type.STRING, lpSubKey);
        nRegDeleteKey.invoke();
        return nRegDeleteKey.getRetValAsInt() != 0;
    }

    public static boolean RegSetValueEx(HKEY hKey, String lpValueName, String value, REGTYPE type) throws Exception {
        JNative nRegSetValueExA = new JNative(DLL_NAME, "RegSetValueExA");
        nRegSetValueExA.setRetVal(Type.INT);
        int i = 0;
        nRegSetValueExA.setParameter(i++, hKey.getValue());
        nRegSetValueExA.setParameter(i++, Type.STRING, lpValueName);
        nRegSetValueExA.setParameter(i++, 0);
        nRegSetValueExA.setParameter(i++, type.getValue());
        if (type.equals(REGTYPE.REG_DWORD)) {
            nRegSetValueExA.setParameter(i++, Type.STRING, StructConverter.getBytes(Integer.parseInt(value)));
            nRegSetValueExA.setParameter(i++, type.getSize());
        } else {
            nRegSetValueExA.setParameter(i++, Type.STRING, value);
            nRegSetValueExA.setParameter(i++, value.length());
        }
        nRegSetValueExA.invoke();
        mLastErrorCode = nRegSetValueExA.getRetVal();
        return "0".equals(mLastErrorCode);
    }

    public static HKEY RegCreateKeyEx(HKEY hKey, String lpSubKey, REGSAM samDesired) throws NativeException, IllegalAccessException {
        JNative nRegCreateKeyEx = new JNative(DLL_NAME, "RegCreateKeyExA");
        nRegCreateKeyEx.setRetVal(Type.INT);
        HKEY phkResult = new HKEY(0);
        int i = 0;
        nRegCreateKeyEx.setParameter(i++, hKey.getValue());
        nRegCreateKeyEx.setParameter(i++, Type.STRING, lpSubKey);
        nRegCreateKeyEx.setParameter(i++, 0);
        nRegCreateKeyEx.setParameter(i++, 0);
        nRegCreateKeyEx.setParameter(i++, 0);
        nRegCreateKeyEx.setParameter(i++, samDesired.getValue());
        nRegCreateKeyEx.setParameter(i++, 0);
        nRegCreateKeyEx.setParameter(i++, phkResult.getPointer());
        nRegCreateKeyEx.setParameter(i++, 0);
        nRegCreateKeyEx.invoke();
        mLastErrorCode = nRegCreateKeyEx.getRetVal();
        if ("0".equals(mLastErrorCode)) {
            return phkResult;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean doesKeyExist(HKEY base, String regKey) throws Exception {
        HKEY key;
        block6: {
            boolean bl;
            key = null;
            try {
                key = Advapi32.RegOpenKeyEx(base, regKey, REGSAM.KEY_READ);
                if (key == null) break block6;
                bl = true;
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                Advapi32.closeKey(key);
                throw throwable;
            }
            Advapi32.closeKey(key);
            return bl;
        }
        Object var5_6 = null;
        Advapi32.closeKey(key);
        return false;
    }

    public static void closeKey(HKEY key) {
        try {
            if (key != null) {
                Advapi32.RegCloseKey(key);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int getLastErrorCode() {
        try {
            return Integer.parseInt(mLastErrorCode);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static HKEY RegOpenKeyEx(HKEY key, String lpSubKey, REGSAM samDesired) throws NativeException, IllegalAccessException {
        JNative nRegOpenKeyEx = new JNative(DLL_NAME, "RegOpenKeyExA");
        nRegOpenKeyEx.setRetVal(Type.INT);
        HKEY phkResult = new HKEY(0);
        nRegOpenKeyEx.setParameter(0, key.getValue());
        nRegOpenKeyEx.setParameter(1, Type.STRING, lpSubKey);
        nRegOpenKeyEx.setParameter(2, 0);
        nRegOpenKeyEx.setParameter(3, samDesired.getValue());
        nRegOpenKeyEx.setParameter(4, phkResult.getPointer());
        nRegOpenKeyEx.invoke();
        mLastErrorCode = nRegOpenKeyEx.getRetVal();
        if ("0".equals(mLastErrorCode)) {
            return phkResult;
        }
        return null;
    }

    public static boolean RegCloseKey(HKEY hKey) throws NativeException, IllegalAccessException {
        JNative nRegCloseKey = new JNative(DLL_NAME, "RegCloseKey");
        nRegCloseKey.setRetVal(Type.INT);
        nRegCloseKey.setParameter(0, hKey.getValue());
        nRegCloseKey.invoke();
        mLastErrorCode = nRegCloseKey.getRetVal();
        return "0".equals(mLastErrorCode);
    }

    public static RegKey RegEnumKeyEx(HKEY hKey, int dwIndex, RegKey lKey) throws NativeException, IllegalAccessException {
        if (lKey == null) {
            lKey = new RegKey(255, 1024);
        }
        JNative nRegEnumKey = new JNative(DLL_NAME, "RegEnumKeyExA");
        nRegEnumKey.setRetVal(Type.INT);
        int cur = 0;
        nRegEnumKey.setParameter(cur++, hKey.getValue());
        nRegEnumKey.setParameter(cur++, dwIndex);
        nRegEnumKey.setParameter(cur++, lKey.getLpValueName());
        nRegEnumKey.setParameter(cur++, lKey.getLpcValueName().getPointer());
        nRegEnumKey.setParameter(cur++, NullPointer.NULL);
        nRegEnumKey.setParameter(cur++, lKey.getLpData());
        nRegEnumKey.setParameter(cur++, lKey.getLpcbData().getPointer());
        nRegEnumKey.setParameter(cur++, lKey.getLpLastWriteTime().getPointer());
        nRegEnumKey.invoke();
        mLastErrorCode = nRegEnumKey.getRetVal();
        lKey.setErrorCode(Advapi32.getLastErrorCode());
        return lKey;
    }

    public static RegQueryKey RegQueryInfoKey(HKEY hKey, RegQueryKey lKey) throws NativeException, IllegalAccessException {
        if (lKey == null) {
            lKey = new RegQueryKey(1024);
        }
        JNative nRegQueryInfoKey = new JNative(DLL_NAME, "RegQueryInfoKeyA");
        nRegQueryInfoKey.setRetVal(Type.INT);
        int cur = 0;
        nRegQueryInfoKey.setParameter(cur++, hKey.getValue());
        nRegQueryInfoKey.setParameter(cur++, lKey.getLpData());
        nRegQueryInfoKey.setParameter(cur++, lKey.getLpcbData().getPointer());
        nRegQueryInfoKey.setParameter(cur++, NullPointer.NULL);
        nRegQueryInfoKey.setParameter(cur++, lKey.getLpcSubKeys().getPointer());
        nRegQueryInfoKey.setParameter(cur++, lKey.getLpcMaxSubKeyLen().getPointer());
        nRegQueryInfoKey.setParameter(cur++, lKey.getLpcMaxClassLen().getPointer());
        nRegQueryInfoKey.setParameter(cur++, lKey.getLpcValues().getPointer());
        nRegQueryInfoKey.setParameter(cur++, lKey.getLpcMaxValueNameLen().getPointer());
        nRegQueryInfoKey.setParameter(cur++, lKey.getLpcMaxValueLen().getPointer());
        nRegQueryInfoKey.setParameter(cur++, lKey.getLpcbSecurityDescriptor().getPointer());
        nRegQueryInfoKey.setParameter(cur++, lKey.getLpLastWriteTime().getPointer());
        nRegQueryInfoKey.invoke();
        mLastErrorCode = nRegQueryInfoKey.getRetVal();
        lKey.setErrorCode(Advapi32.getLastErrorCode());
        return lKey;
    }

    public static RegData RegQueryValueEx(HKEY hKey, String lpValueName, RegData lRegData) throws NativeException, IllegalAccessException {
        if (lRegData == null) {
            lRegData = new RegData(1024);
        }
        JNative nRegQueryValueEx = new JNative(DLL_NAME, "RegQueryValueExA");
        nRegQueryValueEx.setRetVal(Type.INT);
        nRegQueryValueEx.setParameter(0, hKey.getValue());
        nRegQueryValueEx.setParameter(1, Type.STRING, lpValueName);
        nRegQueryValueEx.setParameter(2, NullPointer.NULL);
        nRegQueryValueEx.setParameter(3, lRegData.getLpType().getPointer());
        nRegQueryValueEx.setParameter(4, lRegData.getLpData());
        nRegQueryValueEx.setParameter(5, lRegData.getLpcbData().getPointer());
        nRegQueryValueEx.invoke();
        mLastErrorCode = nRegQueryValueEx.getRetVal();
        lRegData.setErrorCode(Advapi32.getLastErrorCode());
        return lRegData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final String RegQueryDefaultValue(HKEY parentKey, String leafKeyName) throws NativeException, IllegalAccessException {
        String value;
        HKEY hKey;
        block3: {
            String string;
            hKey = null;
            value = null;
            try {
                hKey = Advapi32.RegOpenKeyEx(parentKey, leafKeyName, REGSAM.KEY_READ);
                if (hKey != null) break block3;
                string = null;
                Object var6_6 = null;
                if (hKey == null) return string;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (hKey == null) throw throwable;
                Advapi32.RegCloseKey(hKey);
                hKey = null;
                throw throwable;
            }
            Advapi32.RegCloseKey(hKey);
            return string;
        }
        RegData data = Advapi32.RegQueryValueEx(hKey, null, null);
        value = data.getErrorCode() == 0 ? data.getLpData().getAsString() : null;
        Object var6_7 = null;
        if (hKey == null) return value;
        Advapi32.RegCloseKey(hKey);
        return value;
    }

    public static final boolean isKeyExists(HKEY hRootKey, String leafKey) throws NativeException, IllegalAccessException {
        HKEY hKey = Advapi32.RegOpenKeyEx(hRootKey, leafKey, REGSAM.KEY_READ);
        if (hKey == null) {
            return false;
        }
        Advapi32.RegCloseKey(hKey);
        return true;
    }

    public static RegData RegGetValue(HKEY hKey, String lpSubKey, String lpValue, int dwFlags, RegData lRegData) throws NativeException, IllegalAccessException {
        if (lRegData == null) {
            lRegData = new RegData(1024);
        }
        JNative nRegGetValue = new JNative(DLL_NAME, "RegGetValueA");
        nRegGetValue.setRetVal(Type.INT);
        int cur = 0;
        nRegGetValue.setParameter(cur++, hKey.getValue());
        if (lpSubKey == null) {
            nRegGetValue.setParameter(cur++, NullPointer.NULL);
        } else {
            nRegGetValue.setParameter(cur++, Type.STRING, lpSubKey);
        }
        if (lpValue == null) {
            nRegGetValue.setParameter(cur++, NullPointer.NULL);
        } else {
            nRegGetValue.setParameter(cur++, Type.STRING, lpValue);
        }
        nRegGetValue.setParameter(cur++, dwFlags);
        nRegGetValue.setParameter(cur++, lRegData.getLpType().getPointer());
        nRegGetValue.setParameter(cur++, lRegData.getLpData());
        nRegGetValue.setParameter(cur++, lRegData.getLpcbData().getPointer());
        nRegGetValue.invoke();
        mLastErrorCode = nRegGetValue.getRetVal();
        lRegData.setErrorCode(Advapi32.getLastErrorCode());
        return lRegData;
    }

    public static RegValue RegEnumValue(HKEY hKey, int dwIndex, RegValue lRegValue) throws NativeException, IllegalAccessException {
        if (lRegValue == null) {
            lRegValue = new RegValue(512, 1024);
        }
        JNative nRegEnumValue = new JNative(DLL_NAME, "RegEnumValueA");
        nRegEnumValue.setRetVal(Type.INT);
        nRegEnumValue.setParameter(0, hKey.getValue());
        nRegEnumValue.setParameter(1, dwIndex);
        nRegEnumValue.setParameter(2, lRegValue.getLpValueName());
        nRegEnumValue.setParameter(3, lRegValue.getLpcValueName().getPointer());
        nRegEnumValue.setParameter(4, NullPointer.NULL);
        nRegEnumValue.setParameter(5, lRegValue.getLpType().getPointer());
        nRegEnumValue.setParameter(6, lRegValue.getLpData());
        nRegEnumValue.setParameter(7, lRegValue.getLpcbData().getPointer());
        nRegEnumValue.invoke();
        mLastErrorCode = nRegEnumValue.getRetVal();
        lRegValue.setErrorCode(Advapi32.getLastErrorCode());
        return lRegValue;
    }

    public static void main(String[] args) throws NativeException, IllegalAccessException {
        JNative.getLogger().log("Testing Registry access");
        HKEY hKey = Advapi32.RegOpenKeyEx(HKEY.HKEY_CLASSES_ROOT, "CLSID", REGSAM.KEY_READ.or(REGSAM.KEY_QUERY_VALUE));
        if (hKey == null) {
            JNative.getLogger().log("error : " + Advapi32.getLastErrorCode());
            return;
        }
        JNative.getLogger().log("hKey : " + hKey.getValue());
        Advapi32.listKey(hKey);
        Advapi32.RegCloseKey(hKey);
    }

    public static void listKey(HKEY hKey) throws NativeException, IllegalAccessException {
        RegKey regKey;
        int i;
        if (cpt > 50) {
            return;
        }
        RegQueryKey lKey = Advapi32.RegQueryInfoKey(hKey, null);
        for (i = 0; i < lKey.getLpcValues().getValue(); ++i) {
            RegValue regValue = Advapi32.RegEnumValue(hKey, i, null);
            RegData lRegData = null;
            String keyValueName = regValue.getLpValueName().getAsString();
            if (keyValueName == null || keyValueName.length() == 0) {
                JNative.getLogger().log("Query value : (default)");
            } else {
                JNative.getLogger().log("Query value : " + keyValueName);
            }
            lRegData = Advapi32.RegQueryValueEx(hKey, keyValueName, null);
            String val = "";
            RegValueTypes valType = RegValueTypes.fromInt(lRegData.getLpType().getValue());
            switch (valType) {
                case REG_DWORD: {
                    val = lRegData.getLpData().getAsInt(0) + " - (0x" + Integer.toHexString(lRegData.getLpData().getAsInt(0)) + ")";
                    break;
                }
                case REG_DWORD_LITTLE_ENDIAN: {
                    val = lRegData.getLpData().getAsShort(0) + 256 * lRegData.getLpData().getAsShort(2) + "";
                    break;
                }
                case REG_BINARY: {
                    byte[] p = lRegData.getLpData().getMemory();
                    for (int j = 0; j < lRegData.getLpcbData().getValue(); ++j) {
                        val = val + "0x" + Integer.toHexString(p[j]) + ", ";
                    }
                    val = val.substring(0, val.length() - 2);
                    break;
                }
                default: {
                    val = lRegData.getLpData().getAsString();
                }
            }
            JNative.getLogger().log("Type : " + (Object)((Object)valType));
            JNative.getLogger().log("Value : " + val);
        }
        for (i = 0; i < lKey.getLpcSubKeys().getValue() && (regKey = Advapi32.RegEnumKeyEx(hKey, i, null)).getErrorCode() == 0 && cpt <= 50; ++i) {
            JNative.getLogger().log("Key : " + regKey.getLpValueName().getAsString());
            HKEY lhKey = Advapi32.RegOpenKeyEx(hKey, regKey.getLpValueName().getAsString(), REGSAM.KEY_READ.or(REGSAM.KEY_QUERY_VALUE));
            Advapi32.listKey(lhKey);
            Advapi32.RegCloseKey(lhKey);
        }
    }

    public static interface RRF_Values {
        public static final int RRF_RT_ANY = 65535;
        public static final int RRF_RT_DWORD = 24;
        public static final int RRF_RT_QWORD = 72;
        public static final int RRF_RT_REG_BINARY = 8;
        public static final int RRF_RT_REG_DWORD = 16;
        public static final int RRF_RT_REG_EXPAND_SZ = 4;
        public static final int RRF_RT_REG_MULTI_SZ = 32;
        public static final int RRF_RT_REG_NONE = 1;
        public static final int RRF_RT_REG_QWORD = 64;
        public static final int RRF_RT_REG_SZ = 2;
        public static final int RRF_NOEXPAND = 0x10000000;
        public static final int RRF_ZEROONFAILURE = 0x20000000;
    }
}

