/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.mapper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.Ascii;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.mapper.MappingData;
import org.apache.tomcat.util.http.mapper.WrapperMappingInfo;
import org.apache.tomcat.util.res.StringManager;

public final class Mapper {
    private static final Log log = LogFactory.getLog(Mapper.class);
    protected static final StringManager sm = StringManager.getManager((String)Mapper.class.getPackage().getName());
    protected Host[] hosts = new Host[0];
    protected String defaultHostName = null;
    protected ContextVersion context = new ContextVersion();

    public void setDefaultHostName(String defaultHostName) {
        this.defaultHostName = defaultHostName;
    }

    public synchronized void addHost(String name, String[] aliases, Object host) {
        MapElement[] newHosts = new Host[this.hosts.length + 1];
        Host newHost = new Host(name, host);
        if (Mapper.insertMap(this.hosts, newHosts, newHost)) {
            this.hosts = newHosts;
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("mapper.addHost.success", new Object[]{name}));
            }
        } else {
            Host duplicate = this.hosts[Mapper.find((MapElement[])this.hosts, name)];
            if (duplicate.object == host) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("mapper.addHost.sameHost", new Object[]{name}));
                }
                newHost = duplicate;
            } else {
                log.error((Object)sm.getString("mapper.duplicateHost", new Object[]{name, duplicate.getRealHostName()}));
                return;
            }
        }
        ArrayList<Host> newAliases = new ArrayList<Host>(aliases.length);
        for (String alias : aliases) {
            Host newAlias = new Host(alias, newHost);
            if (!this.addHostAliasImpl(newAlias)) continue;
            newAliases.add(newAlias);
        }
        newHost.addAliases(newAliases);
    }

    public synchronized void removeHost(String name) {
        Host host = (Host)Mapper.exactFind((MapElement[])this.hosts, (String)name);
        if (host == null || host.isAlias()) {
            return;
        }
        Host[] newHosts = (Host[])this.hosts.clone();
        int j = 0;
        for (int i = 0; i < newHosts.length; ++i) {
            if (newHosts[i].getRealHost() == host) continue;
            newHosts[j++] = newHosts[i];
        }
        this.hosts = Arrays.copyOf(newHosts, j);
    }

    public synchronized void addHostAlias(String name, String alias) {
        Host realHost = (Host)Mapper.exactFind((MapElement[])this.hosts, (String)name);
        if (realHost == null) {
            return;
        }
        Host newAlias = new Host(alias, realHost);
        if (this.addHostAliasImpl(newAlias)) {
            realHost.addAlias(newAlias);
        }
    }

    private boolean addHostAliasImpl(Host newAlias) {
        MapElement[] newHosts = new Host[this.hosts.length + 1];
        if (Mapper.insertMap(this.hosts, newHosts, newAlias)) {
            this.hosts = newHosts;
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("mapper.addHostAlias.success", new Object[]{newAlias.name, newAlias.getRealHostName()}));
            }
            return true;
        }
        Host duplicate = this.hosts[Mapper.find((MapElement[])this.hosts, newAlias.name)];
        if (duplicate.getRealHost() == newAlias.getRealHost()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("mapper.addHostAlias.sameHost", new Object[]{newAlias.name, newAlias.getRealHostName()}));
            }
            return false;
        }
        log.error((Object)sm.getString("mapper.duplicateHostAlias", new Object[]{newAlias.name, newAlias.getRealHostName(), duplicate.getRealHostName()}));
        return false;
    }

    public synchronized void removeHostAlias(String alias) {
        Host host = (Host)Mapper.exactFind((MapElement[])this.hosts, (String)alias);
        if (host == null || !host.isAlias()) {
            return;
        }
        MapElement[] newHosts = new Host[this.hosts.length - 1];
        if (Mapper.removeMap(this.hosts, newHosts, alias)) {
            this.hosts = newHosts;
            host.getRealHost().removeAlias(host);
        }
    }

    private void updateContextList(Host realHost, ContextList newContextList) {
        realHost.contextList = newContextList;
        for (Host alias : realHost.getAliases()) {
            alias.contextList = newContextList;
        }
    }

    public void setContext(String path, String[] welcomeResources, javax.naming.Context resources) {
        this.context.path = path;
        this.context.welcomeResources = welcomeResources;
        this.context.resources = resources;
    }

    @Deprecated
    public void addContextVersion(String hostName, Object host, String path, String version, Object context, String[] welcomeResources, javax.naming.Context resources) {
        this.addContextVersion(hostName, host, path, version, context, welcomeResources, resources, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContextVersion(String hostName, Object host, String path, String version, Object context, String[] welcomeResources, javax.naming.Context resources, Collection<WrapperMappingInfo> wrappers) {
        Host mappedHost = (Host)Mapper.exactFind((MapElement[])this.hosts, (String)hostName);
        if (mappedHost == null) {
            this.addHost(hostName, new String[0], host);
            mappedHost = (Host)Mapper.exactFind((MapElement[])this.hosts, (String)hostName);
            if (mappedHost == null) {
                log.error((Object)("No host found: " + hostName));
                return;
            }
        }
        if (mappedHost.isAlias()) {
            log.error((Object)("No host found: " + hostName));
            return;
        }
        int slashCount = Mapper.slashCount(path);
        Host host2 = mappedHost;
        synchronized (host2) {
            ContextVersion newContextVersion = new ContextVersion(version, context);
            newContextVersion.path = path;
            newContextVersion.slashCount = slashCount;
            newContextVersion.welcomeResources = welcomeResources;
            newContextVersion.resources = resources;
            if (wrappers != null) {
                this.addWrappers(newContextVersion, wrappers);
            }
            ContextList contextList = mappedHost.contextList;
            Context mappedContext = (Context)Mapper.exactFind((MapElement[])contextList.contexts, (String)path);
            if (mappedContext == null) {
                mappedContext = new Context(path, newContextVersion);
                ContextList newContextList = contextList.addContext(mappedContext, slashCount);
                if (newContextList != null) {
                    this.updateContextList(mappedHost, newContextList);
                }
            } else {
                MapElement[] contextVersions = mappedContext.versions;
                MapElement[] newContextVersions = new ContextVersion[contextVersions.length + 1];
                if (Mapper.insertMap(contextVersions, newContextVersions, newContextVersion)) {
                    mappedContext.versions = newContextVersions;
                } else {
                    int pos = Mapper.find(contextVersions, version);
                    if (pos >= 0 && ((ContextVersion)contextVersions[pos]).name.equals(version)) {
                        contextVersions[pos] = newContextVersion;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContextVersion(String hostName, String path, String version) {
        Host host = (Host)Mapper.exactFind((MapElement[])this.hosts, (String)hostName);
        if (host == null || host.isAlias()) {
            return;
        }
        Host host2 = host;
        synchronized (host2) {
            ContextList contextList = host.contextList;
            Context context = (Context)Mapper.exactFind((MapElement[])contextList.contexts, (String)path);
            if (context == null) {
                return;
            }
            MapElement[] contextVersions = context.versions;
            MapElement[] newContextVersions = new ContextVersion[contextVersions.length - 1];
            if (Mapper.removeMap(contextVersions, newContextVersions, version)) {
                if (newContextVersions.length == 0) {
                    ContextList newContextList = contextList.removeContext(path);
                    if (newContextList != null) {
                        this.updateContextList(host, newContextList);
                    }
                } else {
                    context.versions = newContextVersions;
                }
            }
        }
    }

    public void pauseContextVersion(Object ctxt, String hostName, String contextPath, String version) {
        ContextVersion contextVersion = this.findContextVersion(hostName, contextPath, version, true);
        if (contextVersion == null || !ctxt.equals(contextVersion.object)) {
            return;
        }
        contextVersion.markPaused();
    }

    private ContextVersion findContextVersion(String hostName, String contextPath, String version, boolean silent) {
        Host host = (Host)Mapper.exactFind((MapElement[])this.hosts, (String)hostName);
        if (host == null || host.isAlias()) {
            if (!silent) {
                log.error((Object)("No host found: " + hostName));
            }
            return null;
        }
        Context context = (Context)Mapper.exactFind((MapElement[])host.contextList.contexts, (String)contextPath);
        if (context == null) {
            if (!silent) {
                log.error((Object)("No context found: " + contextPath));
            }
            return null;
        }
        ContextVersion contextVersion = (ContextVersion)Mapper.exactFind((MapElement[])context.versions, (String)version);
        if (contextVersion == null) {
            if (!silent) {
                log.error((Object)("No context version found: " + contextPath + " " + version));
            }
            return null;
        }
        return contextVersion;
    }

    public void addWrapper(String hostName, String contextPath, String version, String path, Object wrapper, boolean jspWildCard, boolean resourceOnly) {
        ContextVersion contextVersion = this.findContextVersion(hostName, contextPath, version, false);
        if (contextVersion == null) {
            return;
        }
        this.addWrapper(contextVersion, path, wrapper, jspWildCard, resourceOnly);
    }

    public void addWrapper(String path, Object wrapper, boolean jspWildCard, boolean resourceOnly) {
        this.addWrapper(this.context, path, wrapper, jspWildCard, resourceOnly);
    }

    public void addWrappers(String hostName, String contextPath, String version, Collection<WrapperMappingInfo> wrappers) {
        ContextVersion contextVersion = this.findContextVersion(hostName, contextPath, version, false);
        if (contextVersion == null) {
            return;
        }
        this.addWrappers(contextVersion, wrappers);
    }

    private void addWrappers(ContextVersion contextVersion, Collection<WrapperMappingInfo> wrappers) {
        for (WrapperMappingInfo wrapper : wrappers) {
            this.addWrapper(contextVersion, wrapper.getMapping(), wrapper.getWrapper(), wrapper.isJspWildCard(), wrapper.isResourceOnly());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addWrapper(ContextVersion context, String path, Object wrapper, boolean jspWildCard, boolean resourceOnly) {
        ContextVersion contextVersion = context;
        synchronized (contextVersion) {
            if (path.endsWith("/*")) {
                MapElement[] oldWrappers = context.wildcardWrappers;
                MapElement[] newWrappers = new Wrapper[oldWrappers.length + 1];
                String name = path.substring(0, path.length() - 2);
                Wrapper newWrapper = new Wrapper(name, wrapper, jspWildCard, resourceOnly);
                if (Mapper.insertMap(oldWrappers, newWrappers, newWrapper)) {
                    context.wildcardWrappers = newWrappers;
                    int slashCount = Mapper.slashCount(newWrapper.name);
                    if (slashCount > context.nesting) {
                        context.nesting = slashCount;
                    }
                }
            } else if (path.startsWith("*.")) {
                MapElement[] oldWrappers = context.extensionWrappers;
                MapElement[] newWrappers = new Wrapper[oldWrappers.length + 1];
                String name = path.substring(2);
                Wrapper newWrapper = new Wrapper(name, wrapper, jspWildCard, resourceOnly);
                if (Mapper.insertMap(oldWrappers, newWrappers, newWrapper)) {
                    context.extensionWrappers = newWrappers;
                }
            } else if (path.equals("/")) {
                Wrapper newWrapper;
                context.defaultWrapper = newWrapper = new Wrapper("", wrapper, jspWildCard, resourceOnly);
            } else {
                MapElement[] oldWrappers = context.exactWrappers;
                MapElement[] newWrappers = new Wrapper[oldWrappers.length + 1];
                String name = path.length() == 0 ? "/" : path;
                Wrapper newWrapper = new Wrapper(name, wrapper, jspWildCard, resourceOnly);
                if (Mapper.insertMap(oldWrappers, newWrappers, newWrapper)) {
                    context.exactWrappers = newWrappers;
                }
            }
        }
    }

    public void removeWrapper(String path) {
        this.removeWrapper(this.context, path);
    }

    public void removeWrapper(String hostName, String contextPath, String version, String path) {
        ContextVersion contextVersion = this.findContextVersion(hostName, contextPath, version, true);
        if (contextVersion == null || contextVersion.isPaused()) {
            return;
        }
        this.removeWrapper(contextVersion, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeWrapper(ContextVersion context, String path) {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("mapper.removeWrapper", new Object[]{context.name, path}));
        }
        ContextVersion contextVersion = context;
        synchronized (contextVersion) {
            if (path.endsWith("/*")) {
                String name = path.substring(0, path.length() - 2);
                MapElement[] oldWrappers = context.wildcardWrappers;
                if (oldWrappers.length == 0) {
                    return;
                }
                MapElement[] newWrappers = new Wrapper[oldWrappers.length - 1];
                if (Mapper.removeMap(oldWrappers, newWrappers, name)) {
                    context.nesting = 0;
                    for (int i = 0; i < newWrappers.length; ++i) {
                        int slashCount = Mapper.slashCount(((Wrapper)newWrappers[i]).name);
                        if (slashCount <= context.nesting) continue;
                        context.nesting = slashCount;
                    }
                    context.wildcardWrappers = newWrappers;
                }
            } else if (path.startsWith("*.")) {
                String name = path.substring(2);
                MapElement[] oldWrappers = context.extensionWrappers;
                if (oldWrappers.length == 0) {
                    return;
                }
                MapElement[] newWrappers = new Wrapper[oldWrappers.length - 1];
                if (Mapper.removeMap(oldWrappers, newWrappers, name)) {
                    context.extensionWrappers = newWrappers;
                }
            } else if (path.equals("/")) {
                context.defaultWrapper = null;
            } else {
                String name = path.length() == 0 ? "/" : path;
                MapElement[] oldWrappers = context.exactWrappers;
                if (oldWrappers.length == 0) {
                    return;
                }
                MapElement[] newWrappers = new Wrapper[oldWrappers.length - 1];
                if (Mapper.removeMap(oldWrappers, newWrappers, name)) {
                    context.exactWrappers = newWrappers;
                }
            }
        }
    }

    public void addWelcomeFile(String hostName, String contextPath, String version, String welcomeFile) {
        ContextVersion contextVersion = this.findContextVersion(hostName, contextPath, version, false);
        if (contextVersion == null) {
            return;
        }
        int len = contextVersion.welcomeResources.length + 1;
        String[] newWelcomeResources = new String[len];
        System.arraycopy(contextVersion.welcomeResources, 0, newWelcomeResources, 0, len - 1);
        newWelcomeResources[len - 1] = welcomeFile;
        contextVersion.welcomeResources = newWelcomeResources;
    }

    public void removeWelcomeFile(String hostName, String contextPath, String version, String welcomeFile) {
        ContextVersion contextVersion = this.findContextVersion(hostName, contextPath, version, false);
        if (contextVersion == null || contextVersion.isPaused()) {
            return;
        }
        int match = -1;
        for (int i = 0; i < contextVersion.welcomeResources.length; ++i) {
            if (!welcomeFile.equals(contextVersion.welcomeResources[i])) continue;
            match = i;
            break;
        }
        if (match > -1) {
            int len = contextVersion.welcomeResources.length - 1;
            String[] newWelcomeResources = new String[len];
            System.arraycopy(contextVersion.welcomeResources, 0, newWelcomeResources, 0, match);
            if (match < len) {
                System.arraycopy(contextVersion.welcomeResources, match + 1, newWelcomeResources, match, len - match);
            }
            contextVersion.welcomeResources = newWelcomeResources;
        }
    }

    public void clearWelcomeFiles(String hostName, String contextPath, String version) {
        ContextVersion contextVersion = this.findContextVersion(hostName, contextPath, version, false);
        if (contextVersion == null) {
            return;
        }
        contextVersion.welcomeResources = new String[0];
    }

    public void map(MessageBytes host, MessageBytes uri, String version, MappingData mappingData) throws Exception {
        if (host.isNull()) {
            host.getCharChunk().append(this.defaultHostName);
        }
        host.toChars();
        uri.toChars();
        this.internalMap(host.getCharChunk(), uri.getCharChunk(), version, mappingData);
    }

    public void map(MessageBytes uri, MappingData mappingData) throws Exception {
        uri.toChars();
        CharChunk uricc = uri.getCharChunk();
        uricc.setLimit(-1);
        this.internalMapWrapper(this.context, uricc, mappingData);
    }

    private final void internalMap(CharChunk host, CharChunk uri, String version, MappingData mappingData) throws Exception {
        if (mappingData.host != null) {
            throw new AssertionError();
        }
        uri.setLimit(-1);
        MapElement[] hosts = this.hosts;
        Host mappedHost = (Host)Mapper.exactFindIgnoreCase((MapElement[])hosts, (CharChunk)host);
        if (mappedHost == null) {
            if (this.defaultHostName == null) {
                return;
            }
            mappedHost = (Host)Mapper.exactFind((MapElement[])hosts, (String)this.defaultHostName);
            if (mappedHost == null) {
                return;
            }
        }
        mappingData.host = mappedHost.object;
        ContextList contextList = mappedHost.contextList;
        MapElement[] contexts = contextList.contexts;
        int nesting = contextList.nesting;
        int pos = Mapper.find(contexts, uri);
        if (pos == -1) {
            return;
        }
        int lastSlash = -1;
        int uriEnd = uri.getEnd();
        int length = -1;
        boolean found = false;
        MapElement context = null;
        while (pos >= 0) {
            context = contexts[pos];
            if (uri.startsWith(((Context)context).name)) {
                length = ((Context)context).name.length();
                if (uri.getLength() == length) {
                    found = true;
                    break;
                }
                if (uri.startsWithIgnoreCase("/", length)) {
                    found = true;
                    break;
                }
            }
            lastSlash = lastSlash == -1 ? Mapper.nthSlash(uri, nesting + 1) : Mapper.lastSlash(uri);
            uri.setEnd(lastSlash);
            pos = Mapper.find(contexts, uri);
        }
        uri.setEnd(uriEnd);
        if (!found) {
            context = ((Context)contexts[0]).name.equals("") ? contexts[0] : null;
        }
        if (context == null) {
            return;
        }
        mappingData.contextPath.setString(((Context)context).name);
        ContextVersion contextVersion = null;
        MapElement[] contextVersions = ((Context)context).versions;
        int versionCount = contextVersions.length;
        if (versionCount > 1) {
            Object[] contextObjects = new Object[contextVersions.length];
            for (int i = 0; i < contextObjects.length; ++i) {
                contextObjects[i] = contextVersions[i].object;
            }
            mappingData.contexts = contextObjects;
            if (version != null) {
                contextVersion = (ContextVersion)Mapper.exactFind((MapElement[])contextVersions, (String)version);
            }
        }
        if (contextVersion == null) {
            contextVersion = contextVersions[versionCount - 1];
        }
        mappingData.context = contextVersion.object;
        mappingData.contextSlashCount = contextVersion.slashCount;
        if (!contextVersion.isPaused()) {
            this.internalMapWrapper(contextVersion, uri, mappingData);
        }
    }

    private final void internalMapWrapper(ContextVersion contextVersion, CharChunk path, MappingData mappingData) throws Exception {
        char[] buf;
        boolean checkWelcomeFiles;
        int pathOffset = path.getOffset();
        int pathEnd = path.getEnd();
        int servletPath = pathOffset;
        boolean noServletPath = false;
        int length = contextVersion.path.length();
        if (length != pathEnd - pathOffset) {
            servletPath = pathOffset + length;
        } else {
            noServletPath = true;
            path.append('/');
            pathOffset = path.getOffset();
            pathEnd = path.getEnd();
            servletPath = pathOffset + length;
        }
        path.setOffset(servletPath);
        Wrapper[] exactWrappers = contextVersion.exactWrappers;
        this.internalMapExactWrapper(exactWrappers, path, mappingData);
        boolean checkJspWelcomeFiles = false;
        Wrapper[] wildcardWrappers = contextVersion.wildcardWrappers;
        if (mappingData.wrapper == null) {
            this.internalMapWildcardWrapper(wildcardWrappers, contextVersion.nesting, path, mappingData);
            if (mappingData.wrapper != null && mappingData.jspWildCard) {
                char[] buf2 = path.getBuffer();
                if (buf2[pathEnd - 1] == '/') {
                    mappingData.wrapper = null;
                    checkJspWelcomeFiles = true;
                } else {
                    mappingData.wrapperPath.setChars(buf2, path.getStart(), path.getLength());
                    mappingData.pathInfo.recycle();
                }
            }
        }
        if (mappingData.wrapper == null && noServletPath) {
            mappingData.redirectPath.setChars(path.getBuffer(), pathOffset, pathEnd - pathOffset);
            path.setEnd(pathEnd - 1);
            return;
        }
        Wrapper[] extensionWrappers = contextVersion.extensionWrappers;
        if (mappingData.wrapper == null && !checkJspWelcomeFiles) {
            this.internalMapExtensionWrapper(extensionWrappers, path, mappingData, true);
        }
        if (mappingData.wrapper == null) {
            checkWelcomeFiles = checkJspWelcomeFiles;
            if (!checkWelcomeFiles) {
                buf = path.getBuffer();
                boolean bl = checkWelcomeFiles = buf[pathEnd - 1] == '/';
            }
            if (checkWelcomeFiles) {
                for (int i = 0; i < contextVersion.welcomeResources.length && mappingData.wrapper == null; ++i) {
                    path.setOffset(pathOffset);
                    path.setEnd(pathEnd);
                    path.append(contextVersion.welcomeResources[i], 0, contextVersion.welcomeResources[i].length());
                    path.setOffset(servletPath);
                    this.internalMapExactWrapper(exactWrappers, path, mappingData);
                    if (mappingData.wrapper == null) {
                        this.internalMapWildcardWrapper(wildcardWrappers, contextVersion.nesting, path, mappingData);
                    }
                    if (mappingData.wrapper != null || contextVersion.resources == null) continue;
                    Object file = null;
                    String pathStr = path.toString();
                    try {
                        file = contextVersion.resources.lookup(pathStr);
                    }
                    catch (NamingException nex) {
                        // empty catch block
                    }
                    if (file == null || file instanceof DirContext) continue;
                    this.internalMapExtensionWrapper(extensionWrappers, path, mappingData, true);
                    if (mappingData.wrapper != null || contextVersion.defaultWrapper == null) continue;
                    mappingData.wrapper = contextVersion.defaultWrapper.object;
                    mappingData.requestPath.setChars(path.getBuffer(), path.getStart(), path.getLength());
                    mappingData.wrapperPath.setChars(path.getBuffer(), path.getStart(), path.getLength());
                    mappingData.requestPath.setString(pathStr);
                    mappingData.wrapperPath.setString(pathStr);
                }
                path.setOffset(servletPath);
                path.setEnd(pathEnd);
            }
        }
        if (mappingData.wrapper == null) {
            checkWelcomeFiles = checkJspWelcomeFiles;
            if (!checkWelcomeFiles) {
                buf = path.getBuffer();
                boolean bl = checkWelcomeFiles = buf[pathEnd - 1] == '/';
            }
            if (checkWelcomeFiles) {
                for (int i = 0; i < contextVersion.welcomeResources.length && mappingData.wrapper == null; ++i) {
                    path.setOffset(pathOffset);
                    path.setEnd(pathEnd);
                    path.append(contextVersion.welcomeResources[i], 0, contextVersion.welcomeResources[i].length());
                    path.setOffset(servletPath);
                    this.internalMapExtensionWrapper(extensionWrappers, path, mappingData, false);
                }
                path.setOffset(servletPath);
                path.setEnd(pathEnd);
            }
        }
        if (mappingData.wrapper == null && !checkJspWelcomeFiles) {
            if (contextVersion.defaultWrapper != null) {
                mappingData.wrapper = contextVersion.defaultWrapper.object;
                mappingData.requestPath.setChars(path.getBuffer(), path.getStart(), path.getLength());
                mappingData.wrapperPath.setChars(path.getBuffer(), path.getStart(), path.getLength());
            }
            char[] buf3 = path.getBuffer();
            if (contextVersion.resources != null && buf3[pathEnd - 1] != '/') {
                Object file = null;
                String pathStr = path.toString();
                try {
                    file = contextVersion.resources.lookup(pathStr);
                }
                catch (NamingException nex) {
                    // empty catch block
                }
                if (file != null && file instanceof DirContext) {
                    path.setOffset(pathOffset);
                    path.append('/');
                    mappingData.redirectPath.setChars(path.getBuffer(), path.getStart(), path.getLength());
                } else {
                    mappingData.requestPath.setString(pathStr);
                    mappingData.wrapperPath.setString(pathStr);
                }
            }
        }
        path.setOffset(pathOffset);
        path.setEnd(pathEnd);
    }

    private final void internalMapExactWrapper(Wrapper[] wrappers, CharChunk path, MappingData mappingData) {
        Wrapper wrapper = (Wrapper)Mapper.exactFind((MapElement[])wrappers, (CharChunk)path);
        if (wrapper != null) {
            mappingData.requestPath.setString(wrapper.name);
            mappingData.wrapper = wrapper.object;
            if (path.equals("/")) {
                mappingData.pathInfo.setString("/");
                mappingData.wrapperPath.setString("");
                mappingData.contextPath.setString("");
            } else {
                mappingData.wrapperPath.setString(wrapper.name);
            }
        }
    }

    private final void internalMapWildcardWrapper(Wrapper[] wrappers, int nesting, CharChunk path, MappingData mappingData) {
        int pathEnd = path.getEnd();
        int lastSlash = -1;
        int length = -1;
        int pos = Mapper.find((MapElement[])wrappers, path);
        if (pos != -1) {
            boolean found = false;
            while (pos >= 0) {
                if (path.startsWith(wrappers[pos].name)) {
                    length = wrappers[pos].name.length();
                    if (path.getLength() == length) {
                        found = true;
                        break;
                    }
                    if (path.startsWithIgnoreCase("/", length)) {
                        found = true;
                        break;
                    }
                }
                lastSlash = lastSlash == -1 ? Mapper.nthSlash(path, nesting + 1) : Mapper.lastSlash(path);
                path.setEnd(lastSlash);
                pos = Mapper.find((MapElement[])wrappers, path);
            }
            path.setEnd(pathEnd);
            if (found) {
                mappingData.wrapperPath.setString(wrappers[pos].name);
                if (path.getLength() > length) {
                    mappingData.pathInfo.setChars(path.getBuffer(), path.getOffset() + length, path.getLength() - length);
                }
                mappingData.requestPath.setChars(path.getBuffer(), path.getOffset(), path.getLength());
                mappingData.wrapper = wrappers[pos].object;
                mappingData.jspWildCard = wrappers[pos].jspWildCard;
            }
        }
    }

    private final void internalMapExtensionWrapper(Wrapper[] wrappers, CharChunk path, MappingData mappingData, boolean resourceExpected) {
        char[] buf = path.getBuffer();
        int pathEnd = path.getEnd();
        int servletPath = path.getOffset();
        int slash = -1;
        for (int i = pathEnd - 1; i >= servletPath; --i) {
            if (buf[i] != '/') continue;
            slash = i;
            break;
        }
        if (slash >= 0) {
            int period = -1;
            for (int i = pathEnd - 1; i > slash; --i) {
                if (buf[i] != '.') continue;
                period = i;
                break;
            }
            if (period >= 0) {
                path.setOffset(period + 1);
                path.setEnd(pathEnd);
                Wrapper wrapper = (Wrapper)Mapper.exactFind((MapElement[])wrappers, (CharChunk)path);
                if (wrapper != null && (resourceExpected || !wrapper.resourceOnly)) {
                    mappingData.wrapperPath.setChars(buf, servletPath, pathEnd - servletPath);
                    mappingData.requestPath.setChars(buf, servletPath, pathEnd - servletPath);
                    mappingData.wrapper = wrapper.object;
                }
                path.setOffset(servletPath);
                path.setEnd(pathEnd);
            }
        }
    }

    private static final int find(MapElement[] map, CharChunk name) {
        return Mapper.find(map, name, name.getStart(), name.getEnd());
    }

    private static final int find(MapElement[] map, CharChunk name, int start, int end) {
        int a = 0;
        int b = map.length - 1;
        if (b == -1) {
            return -1;
        }
        if (Mapper.compare(name, start, end, map[0].name) < 0) {
            return -1;
        }
        if (b == 0) {
            return 0;
        }
        int i = 0;
        do {
            i = (b + a) / 2;
            int result = Mapper.compare(name, start, end, map[i].name);
            if (result == 1) {
                a = i;
                continue;
            }
            if (result == 0) {
                return i;
            }
            b = i;
        } while (b - a != 1);
        int result2 = Mapper.compare(name, start, end, map[b].name);
        if (result2 < 0) {
            return a;
        }
        return b;
    }

    private static final int findIgnoreCase(MapElement[] map, CharChunk name) {
        return Mapper.findIgnoreCase(map, name, name.getStart(), name.getEnd());
    }

    private static final int findIgnoreCase(MapElement[] map, CharChunk name, int start, int end) {
        int a = 0;
        int b = map.length - 1;
        if (b == -1) {
            return -1;
        }
        if (Mapper.compareIgnoreCase(name, start, end, map[0].name) < 0) {
            return -1;
        }
        if (b == 0) {
            return 0;
        }
        int i = 0;
        do {
            i = (b + a) / 2;
            int result = Mapper.compareIgnoreCase(name, start, end, map[i].name);
            if (result == 1) {
                a = i;
                continue;
            }
            if (result == 0) {
                return i;
            }
            b = i;
        } while (b - a != 1);
        int result2 = Mapper.compareIgnoreCase(name, start, end, map[b].name);
        if (result2 < 0) {
            return a;
        }
        return b;
    }

    private static final int find(MapElement[] map, String name) {
        int a = 0;
        int b = map.length - 1;
        if (b == -1) {
            return -1;
        }
        if (name.compareTo(map[0].name) < 0) {
            return -1;
        }
        if (b == 0) {
            return 0;
        }
        int i = 0;
        do {
            i = (b + a) / 2;
            int result = name.compareTo(map[i].name);
            if (result > 0) {
                a = i;
                continue;
            }
            if (result == 0) {
                return i;
            }
            b = i;
        } while (b - a != 1);
        int result2 = name.compareTo(map[b].name);
        if (result2 < 0) {
            return a;
        }
        return b;
    }

    private static final <E extends MapElement> E exactFind(E[] map, String name) {
        int pos = Mapper.find(map, name);
        if (pos >= 0) {
            E result = map[pos];
            if (name.equals(((MapElement)result).name)) {
                return result;
            }
        }
        return null;
    }

    private static final <E extends MapElement> E exactFind(E[] map, CharChunk name) {
        int pos = Mapper.find(map, name);
        if (pos >= 0) {
            E result = map[pos];
            if (name.equals(((MapElement)result).name)) {
                return result;
            }
        }
        return null;
    }

    private static final <E extends MapElement> E exactFindIgnoreCase(E[] map, CharChunk name) {
        int pos = Mapper.findIgnoreCase(map, name);
        if (pos >= 0) {
            E result = map[pos];
            if (name.equalsIgnoreCase(((MapElement)result).name)) {
                return result;
            }
        }
        return null;
    }

    private static final int compare(CharChunk name, int start, int end, String compareTo) {
        int result = 0;
        char[] c = name.getBuffer();
        int len = compareTo.length();
        if (end - start < len) {
            len = end - start;
        }
        for (int i = 0; i < len && result == 0; ++i) {
            if (c[i + start] > compareTo.charAt(i)) {
                result = 1;
                continue;
            }
            if (c[i + start] >= compareTo.charAt(i)) continue;
            result = -1;
        }
        if (result == 0) {
            if (compareTo.length() > end - start) {
                result = -1;
            } else if (compareTo.length() < end - start) {
                result = 1;
            }
        }
        return result;
    }

    private static final int compareIgnoreCase(CharChunk name, int start, int end, String compareTo) {
        int result = 0;
        char[] c = name.getBuffer();
        int len = compareTo.length();
        if (end - start < len) {
            len = end - start;
        }
        for (int i = 0; i < len && result == 0; ++i) {
            if (Ascii.toLower(c[i + start]) > Ascii.toLower(compareTo.charAt(i))) {
                result = 1;
                continue;
            }
            if (Ascii.toLower(c[i + start]) >= Ascii.toLower(compareTo.charAt(i))) continue;
            result = -1;
        }
        if (result == 0) {
            if (compareTo.length() > end - start) {
                result = -1;
            } else if (compareTo.length() < end - start) {
                result = 1;
            }
        }
        return result;
    }

    private static final int lastSlash(CharChunk name) {
        char[] c = name.getBuffer();
        int end = name.getEnd();
        int start = name.getStart();
        int pos = end;
        while (pos > start && c[--pos] != '/') {
        }
        return pos;
    }

    private static final int nthSlash(CharChunk name, int n) {
        int start;
        char[] c = name.getBuffer();
        int end = name.getEnd();
        int pos = start = name.getStart();
        int count = 0;
        while (pos < end) {
            if (c[pos++] != '/' || ++count != n) continue;
            --pos;
            break;
        }
        return pos;
    }

    private static final int slashCount(String name) {
        int pos = -1;
        int count = 0;
        while ((pos = name.indexOf(47, pos + 1)) != -1) {
            ++count;
        }
        return count;
    }

    private static final boolean insertMap(MapElement[] oldMap, MapElement[] newMap, MapElement newElement) {
        int pos = Mapper.find(oldMap, newElement.name);
        if (pos != -1 && newElement.name.equals(oldMap[pos].name)) {
            return false;
        }
        System.arraycopy(oldMap, 0, newMap, 0, pos + 1);
        newMap[pos + 1] = newElement;
        System.arraycopy(oldMap, pos + 1, newMap, pos + 2, oldMap.length - pos - 1);
        return true;
    }

    private static final boolean removeMap(MapElement[] oldMap, MapElement[] newMap, String name) {
        int pos = Mapper.find(oldMap, name);
        if (pos != -1 && name.equals(oldMap[pos].name)) {
            System.arraycopy(oldMap, 0, newMap, 0, pos);
            System.arraycopy(oldMap, pos + 1, newMap, pos, oldMap.length - pos - 1);
            return true;
        }
        return false;
    }

    protected static class Wrapper
    extends MapElement {
        public final boolean jspWildCard;
        public final boolean resourceOnly;

        public Wrapper(String name, Object wrapper, boolean jspWildCard, boolean resourceOnly) {
            super(name, wrapper);
            this.jspWildCard = jspWildCard;
            this.resourceOnly = resourceOnly;
        }
    }

    protected static final class ContextVersion
    extends MapElement {
        public String path = null;
        public int slashCount;
        public String[] welcomeResources = new String[0];
        public javax.naming.Context resources = null;
        public Wrapper defaultWrapper = null;
        public Wrapper[] exactWrappers = new Wrapper[0];
        public Wrapper[] wildcardWrappers = new Wrapper[0];
        public Wrapper[] extensionWrappers = new Wrapper[0];
        public int nesting = 0;
        private volatile boolean paused;

        public ContextVersion() {
            super(null, null);
        }

        public ContextVersion(String version, Object context) {
            super(version, context);
        }

        public boolean isPaused() {
            return this.paused;
        }

        public void markPaused() {
            this.paused = true;
        }
    }

    protected static final class Context
    extends MapElement {
        public volatile ContextVersion[] versions;

        public Context(String name, ContextVersion firstVersion) {
            super(name, null);
            this.versions = new ContextVersion[]{firstVersion};
        }
    }

    protected static final class ContextList {
        public final Context[] contexts;
        public final int nesting;

        public ContextList() {
            this(new Context[0], 0);
        }

        private ContextList(Context[] contexts, int nesting) {
            this.contexts = contexts;
            this.nesting = nesting;
        }

        public ContextList addContext(Context mappedContext, int slashCount) {
            MapElement[] newContexts = new Context[this.contexts.length + 1];
            if (Mapper.insertMap(this.contexts, newContexts, mappedContext)) {
                return new ContextList((Context[])newContexts, Math.max(this.nesting, slashCount));
            }
            return null;
        }

        public ContextList removeContext(String path) {
            MapElement[] newContexts = new Context[this.contexts.length - 1];
            if (Mapper.removeMap(this.contexts, newContexts, path)) {
                int newNesting = 0;
                for (MapElement context : newContexts) {
                    newNesting = Math.max(newNesting, Mapper.slashCount(((Context)context).name));
                }
                return new ContextList((Context[])newContexts, newNesting);
            }
            return null;
        }
    }

    protected static final class Host
    extends MapElement {
        public volatile ContextList contextList;
        private final Host realHost;
        private final List<Host> aliases;

        public Host(String name, Object host) {
            super(name, host);
            this.realHost = this;
            this.contextList = new ContextList();
            this.aliases = new CopyOnWriteArrayList<Host>();
        }

        public Host(String alias, Host realHost) {
            super(alias, realHost.object);
            this.realHost = realHost;
            this.contextList = realHost.contextList;
            this.aliases = null;
        }

        public boolean isAlias() {
            return this.realHost != this;
        }

        public Host getRealHost() {
            return this.realHost;
        }

        public String getRealHostName() {
            return this.realHost.name;
        }

        public Collection<Host> getAliases() {
            return this.aliases;
        }

        public void addAlias(Host alias) {
            this.aliases.add(alias);
        }

        public void addAliases(Collection<? extends Host> c) {
            this.aliases.addAll(c);
        }

        public void removeAlias(Host alias) {
            this.aliases.remove(alias);
        }
    }

    protected static abstract class MapElement {
        public final String name;
        public final Object object;

        public MapElement(String name, Object object) {
            this.name = name;
            this.object = object;
        }
    }
}

