/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.loops;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import sun.awt.image.BufImgSurfaceData;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.Blit;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.FillRect;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.loops.GraphicsPrimitiveMgr;
import sun.java2d.loops.RenderCache;
import sun.java2d.loops.SurfaceType;
import sun.java2d.pipe.Region;

public class BlitBg
extends GraphicsPrimitive {
    public static final String methodSignature = "BlitBg(...)".toString();
    public static final int primTypeID = BlitBg.makePrimTypeID();
    private static RenderCache blitcache = new RenderCache(20);

    public static BlitBg locate(SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        return (BlitBg)GraphicsPrimitiveMgr.locate(primTypeID, surfaceType, compositeType, surfaceType2);
    }

    public static BlitBg getFromCache(SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        Object object = blitcache.get(surfaceType, compositeType, surfaceType2);
        if (object != null) {
            return (BlitBg)object;
        }
        BlitBg blitBg = BlitBg.locate(surfaceType, compositeType, surfaceType2);
        if (blitBg == null) {
            System.out.println("blitbg loop not found for:");
            System.out.println("src:  " + surfaceType);
            System.out.println("comp: " + compositeType);
            System.out.println("dst:  " + surfaceType2);
        } else {
            blitcache.put(surfaceType, compositeType, surfaceType2, blitBg);
        }
        return blitBg;
    }

    protected BlitBg(SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        super(methodSignature, primTypeID, surfaceType, compositeType, surfaceType2);
    }

    public BlitBg(long l, SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        super(l, methodSignature, primTypeID, surfaceType, compositeType, surfaceType2);
    }

    public native void BlitBg(SurfaceData var1, SurfaceData var2, Composite var3, Region var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11);

    @Override
    public GraphicsPrimitive makePrimitive(SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        return new General(surfaceType, compositeType, surfaceType2);
    }

    @Override
    public GraphicsPrimitive traceWrap() {
        return new TraceBlitBg(this);
    }

    static {
        GraphicsPrimitiveMgr.registerGeneral(new BlitBg(null, null, null));
    }

    private static class General
    extends BlitBg {
        CompositeType compositeType;
        private static Font defaultFont = new Font("Dialog", 0, 12);

        public General(SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
            super(surfaceType, compositeType, surfaceType2);
            this.compositeType = compositeType;
        }

        @Override
        public void BlitBg(SurfaceData surfaceData, SurfaceData surfaceData2, Composite composite, Region region, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            boolean bl;
            ColorModel colorModel = surfaceData2.getColorModel();
            boolean bl2 = bl = n >>> 24 != 255;
            if (!colorModel.hasAlpha() && bl) {
                colorModel = ColorModel.getRGBdefault();
            }
            WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n6, n7);
            boolean bl3 = colorModel.isAlphaPremultiplied();
            BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, bl3, null);
            SurfaceData surfaceData3 = BufImgSurfaceData.createData(bufferedImage);
            Color color = new Color(n, bl);
            SunGraphics2D sunGraphics2D = new SunGraphics2D(surfaceData3, color, color, defaultFont);
            FillRect fillRect = FillRect.locate(SurfaceType.AnyColor, CompositeType.SrcNoEa, surfaceData3.getSurfaceType());
            Blit blit = Blit.getFromCache(surfaceData.getSurfaceType(), CompositeType.SrcOverNoEa, surfaceData3.getSurfaceType());
            Blit blit2 = Blit.getFromCache(surfaceData3.getSurfaceType(), this.compositeType, surfaceData2.getSurfaceType());
            fillRect.FillRect(sunGraphics2D, surfaceData3, 0, 0, n6, n7);
            blit.Blit(surfaceData, surfaceData3, AlphaComposite.SrcOver, null, n2, n3, 0, 0, n6, n7);
            blit2.Blit(surfaceData3, surfaceData2, composite, region, 0, 0, n4, n5, n6, n7);
        }
    }

    private static class TraceBlitBg
    extends BlitBg {
        BlitBg target;

        public TraceBlitBg(BlitBg blitBg) {
            super(blitBg.getSourceType(), blitBg.getCompositeType(), blitBg.getDestType());
            this.target = blitBg;
        }

        @Override
        public GraphicsPrimitive traceWrap() {
            return this;
        }

        @Override
        public void BlitBg(SurfaceData surfaceData, SurfaceData surfaceData2, Composite composite, Region region, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            TraceBlitBg.tracePrimitive(this.target);
            this.target.BlitBg(surfaceData, surfaceData2, composite, region, n, n2, n3, n4, n5, n6, n7);
        }
    }
}

