/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal;

import sun.org.mozilla.javascript.internal.Kit;

public class UintMap {
    private static final int A = -1640531527;
    private static final int EMPTY = -1;
    private static final int DELETED = -2;
    private transient int[] keys;
    private transient Object[] values;
    private int power;
    private int keyCount;
    private transient int occupiedCount;
    private transient int ivaluesShift;
    private static final boolean check = false;

    public UintMap() {
        this(4);
    }

    public UintMap(int n) {
        if (n < 0) {
            Kit.codeBug();
        }
        int n2 = n * 4 / 3;
        int n3 = 2;
        while (1 << n3 < n2) {
            ++n3;
        }
        this.power = n3;
    }

    public boolean isEmpty() {
        return this.keyCount == 0;
    }

    public int size() {
        return this.keyCount;
    }

    public boolean has(int n) {
        if (n < 0) {
            Kit.codeBug();
        }
        return 0 <= this.findIndex(n);
    }

    public Object getObject(int n) {
        int n2;
        if (n < 0) {
            Kit.codeBug();
        }
        if (this.values != null && 0 <= (n2 = this.findIndex(n))) {
            return this.values[n2];
        }
        return null;
    }

    public int getInt(int n, int n2) {
        int n3;
        if (n < 0) {
            Kit.codeBug();
        }
        if (0 <= (n3 = this.findIndex(n))) {
            if (this.ivaluesShift != 0) {
                return this.keys[this.ivaluesShift + n3];
            }
            return 0;
        }
        return n2;
    }

    public int getExistingInt(int n) {
        int n2;
        if (n < 0) {
            Kit.codeBug();
        }
        if (0 <= (n2 = this.findIndex(n))) {
            if (this.ivaluesShift != 0) {
                return this.keys[this.ivaluesShift + n2];
            }
            return 0;
        }
        Kit.codeBug();
        return 0;
    }

    public void put(int n, Object object) {
        if (n < 0) {
            Kit.codeBug();
        }
        int n2 = this.ensureIndex(n, false);
        if (this.values == null) {
            this.values = new Object[1 << this.power];
        }
        this.values[n2] = object;
    }

    public void put(int n, int n2) {
        if (n < 0) {
            Kit.codeBug();
        }
        int n3 = this.ensureIndex(n, true);
        if (this.ivaluesShift == 0) {
            int n4 = 1 << this.power;
            if (this.keys.length != n4 * 2) {
                int[] nArray = new int[n4 * 2];
                System.arraycopy(this.keys, 0, nArray, 0, n4);
                this.keys = nArray;
            }
            this.ivaluesShift = n4;
        }
        this.keys[this.ivaluesShift + n3] = n2;
    }

    public void remove(int n) {
        int n2;
        if (n < 0) {
            Kit.codeBug();
        }
        if (0 <= (n2 = this.findIndex(n))) {
            this.keys[n2] = -2;
            --this.keyCount;
            if (this.values != null) {
                this.values[n2] = null;
            }
            if (this.ivaluesShift != 0) {
                this.keys[this.ivaluesShift + n2] = 0;
            }
        }
    }

    public void clear() {
        int n = 1 << this.power;
        if (this.keys != null) {
            int n2;
            for (n2 = 0; n2 != n; ++n2) {
                this.keys[n2] = -1;
            }
            if (this.values != null) {
                for (n2 = 0; n2 != n; ++n2) {
                    this.values[n2] = null;
                }
            }
        }
        this.ivaluesShift = 0;
        this.keyCount = 0;
        this.occupiedCount = 0;
    }

    public int[] getKeys() {
        int[] nArray = this.keys;
        int n = this.keyCount;
        int[] nArray2 = new int[n];
        int n2 = 0;
        while (n != 0) {
            int n3 = nArray[n2];
            if (n3 != -1 && n3 != -2) {
                nArray2[--n] = n3;
            }
            ++n2;
        }
        return nArray2;
    }

    private static int tableLookupStep(int n, int n2, int n3) {
        int n4 = 32 - 2 * n3;
        if (n4 >= 0) {
            return n >>> n4 & n2 | 1;
        }
        return n & n2 >>> -n4 | 1;
    }

    private int findIndex(int n) {
        int[] nArray = this.keys;
        if (nArray != null) {
            int n2 = n * -1640531527;
            int n3 = n2 >>> 32 - this.power;
            int n4 = nArray[n3];
            if (n4 == n) {
                return n3;
            }
            if (n4 != -1) {
                int n5 = (1 << this.power) - 1;
                int n6 = UintMap.tableLookupStep(n2, n5, this.power);
                boolean bl = false;
                do {
                    if ((n4 = nArray[n3 = n3 + n6 & n5]) != n) continue;
                    return n3;
                } while (n4 != -1);
            }
        }
        return -1;
    }

    private int insertNewKey(int n) {
        int[] nArray = this.keys;
        int n2 = n * -1640531527;
        int n3 = n2 >>> 32 - this.power;
        if (nArray[n3] != -1) {
            int n4 = (1 << this.power) - 1;
            int n5 = UintMap.tableLookupStep(n2, n4, this.power);
            int n6 = n3;
            while (nArray[n3 = n3 + n5 & n4] != -1) {
            }
        }
        nArray[n3] = n;
        ++this.occupiedCount;
        ++this.keyCount;
        return n3;
    }

    private void rehashTable(boolean bl) {
        if (this.keys != null && this.keyCount * 2 >= this.occupiedCount) {
            ++this.power;
        }
        int n = 1 << this.power;
        int[] nArray = this.keys;
        int n2 = this.ivaluesShift;
        if (n2 == 0 && !bl) {
            this.keys = new int[n];
        } else {
            this.ivaluesShift = n;
            this.keys = new int[n * 2];
        }
        for (int i = 0; i != n; ++i) {
            this.keys[i] = -1;
        }
        Object[] objectArray = this.values;
        if (objectArray != null) {
            this.values = new Object[n];
        }
        int n3 = this.keyCount;
        this.occupiedCount = 0;
        if (n3 != 0) {
            this.keyCount = 0;
            int n4 = 0;
            int n5 = n3;
            while (n5 != 0) {
                int n6 = nArray[n4];
                if (n6 != -1 && n6 != -2) {
                    int n7 = this.insertNewKey(n6);
                    if (objectArray != null) {
                        this.values[n7] = objectArray[n4];
                    }
                    if (n2 != 0) {
                        this.keys[this.ivaluesShift + n7] = nArray[n2 + n4];
                    }
                    --n5;
                }
                ++n4;
            }
        }
    }

    private int ensureIndex(int n, boolean bl) {
        int n2 = -1;
        int n3 = -1;
        int[] nArray = this.keys;
        if (nArray != null) {
            int n4 = n * -1640531527;
            n2 = n4 >>> 32 - this.power;
            int n5 = nArray[n2];
            if (n5 == n) {
                return n2;
            }
            if (n5 != -1) {
                if (n5 == -2) {
                    n3 = n2;
                }
                int n6 = (1 << this.power) - 1;
                int n7 = UintMap.tableLookupStep(n4, n6, this.power);
                boolean bl2 = false;
                do {
                    if ((n5 = nArray[n2 = n2 + n7 & n6]) == n) {
                        return n2;
                    }
                    if (n5 != -2 || n3 >= 0) continue;
                    n3 = n2;
                } while (n5 != -1);
            }
        }
        if (n3 >= 0) {
            n2 = n3;
        } else {
            if (nArray == null || this.occupiedCount * 4 >= (1 << this.power) * 3) {
                this.rehashTable(bl);
                return this.insertNewKey(n);
            }
            ++this.occupiedCount;
        }
        nArray[n2] = n;
        ++this.keyCount;
        return n2;
    }
}

