/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.pointers.memory;

import java.lang.reflect.Constructor;
import org.xvolks.jnative.JNative;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.logging.JNativeLogger;
import org.xvolks.jnative.pointers.memory.HeapMemoryBlock;
import org.xvolks.jnative.pointers.memory.MemoryBlock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryBlockFactory {
    private static Constructor<? extends MemoryBlock> preferredConstructor;

    private MemoryBlockFactory() {
    }

    public static void setPreferredMemoryType(Class<? extends MemoryBlock> type) throws NoSuchMethodException {
        try {
            preferredConstructor = type.getDeclaredConstructor(Integer.TYPE);
            MemoryBlock mem = preferredConstructor.newInstance(1);
            mem.dispose();
            JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, "Using " + type.getName() + " memory reservation strategy");
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new NoSuchMethodException(type.toString() + " not found");
            }
            catch (NullPointerException ex) {
                throw new NoSuchMethodException("Class not found");
            }
        }
    }

    public static MemoryBlock createMemoryBlock(int size) throws NativeException {
        try {
            if (preferredConstructor == null) {
                MemoryBlockFactory.setPreferredMemoryType(HeapMemoryBlock.class);
            }
            return preferredConstructor.newInstance(size);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NativeException(e.toString());
        }
    }
}

